<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Ranking de Pedido</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.22.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.261.22.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.22.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.22.1" />
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.22.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.22.1">

  <style>
    #btnOpcoesFiltros {
      margin-left: 15px;
    }

    .form-check {
      margin-left: 25px;
      margin-bottom: 10px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      /* padding: 0 1.0em 1.0em 1.0em !important; */
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    #tabelaRanking_filter {
      display: none;
    }

    .table.dataTable tbody td {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .estilo-data-de {
      border-top-right-radius: 0 !important;
      border-bottom-right-radius: 0 !important;
    }

    .estilo-data-ate {
      border-top-left-radius: 0 !important;
      border-bottom-left-radius: 0 !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Relatório de Ranking de Pedido</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltrosRelPedidoRank" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimirRelPedidoRank" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="row d-flex justify-content-center" style="margin-top: 20px;">
                  <div class="col-11" id="chart">
                  </div>
                </div>
                <div class="card-body">
                  <div class="card">
                    <div class="col-sm-12 table-responsive card-body pt-0">
                      <table id="tabelaRankingRelPedidoRank" class="table table-sm table-select table-hover" width="100%">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <div class="card-body">
                  <!-- <h5 class="m-0 text-dark" id="label">Grade Cor/Tamanhos</h5> -->
                  <!-- <label class="labelCheck d-none" id="labelTabelaCorTamRelPedidoRank" for="tabelaCorTamRelPedidoRank">Grade Cor/Tamanhos</label> -->
                  <div class="card">
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaCorTamRelPedidoRank" class="table table-sm table-select table-hover" width="100%">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modalFiltrosRelPedidoRank" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0 pt-1">
            <div class="card">
              <div class="form-row" id="divRelPedRank">
                <div class="row mt-2">
                  <div class="col-lg-4 col-sm-12 col-12 mt-2 pt-2">
                    <div class="form">
                      <fieldset class="form border-Field">
                        <legend class="textoBorda mb-0 pb-0">Tipo de Pedido</legend>
                        <div class="form-row ml-auto">
                          <div class="icheck-primary form-group form-check col-2">
                            <input type="radio" id="radioTodosTipoPedido" checked name="tipoPedido" value="TODOS">
                            <label class="labelCheck" for="radioTodosTipoPedido">Todos</label>
                          </div>
                          <div class="icheck-primary form-group form-check col-2">
                            <input type="radio" id="radioPedidosPai" name="tipoPedido" value="P">
                            <label class="labelCheck" for="radioPedidosPai">Pai</label>
                          </div>
                          <div class="icheck-primary form-group form-check col-2">
                            <input type="radio" id="radioPedidosFilho" name="tipoPedido" value="F">
                            <label class="labelCheck" for="radioPedidosFilho">Filho</label>
                          </div>
                      </fieldset>
                    </div>
                  </div>
                  <div class="col-lg-3 col-sm-6 col-12">
                    <label data-error="wrong" data-success="right" for="labelStatusPedido">Status de Pedido:</label>
                    <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtStatusPedido" aria-invalid="false">
                      <option value="TODOS_SEM_CANCELADOS">Todos (Sem Cancelados)</option>
                      <option value="TODOS_COM_CANCELADOS">Todos (Com Cancelados)</option>
                      <option value="PENDENTES">Pendentes</option>
                      <option value="FATURADOS">Faturados</option>
                      <option value="CANCELADOS">Cancelados</option>
                      <option value="NOTAS_FATURADAS">Notas Faturadas</option>
                    </select>
                  </div>

                  <div class="col-lg-3 col-sm-6 col-12">
                    <label data-error="wrong" data-success="right" for="labelLiberacaoPedido">Liberação de Pedido:</label>
                    <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtLiberacaoPedido" aria-invalid="false">
                      <option value="TODOS">Todos</option>
                      <option value="LIBERADOS_VENDAS">Liberados Vendas</option>
                      <option value="LIBERADOS_FINANCEIRO">Liberados Financeiro</option>
                      <option value="BLOQUEADOS_VENDAS">Bloquados Vendas</option>
                      <option value="BLOQUEADOS_FINANCEIRO">Bloqueados Financeiro</option>
                      <option value="LIBERADO_VF">Liberado (V. F.)</option>
                    </select>
                  </div>

                  <div class="form-group col-lg mt-3 pt-1 mb-0">
                    <div class="pl-0 pt-0 mt-2">
                      <button id="btnSelecionarEmpresas" type='button' class="btn btn-danger ml-0 mr-0">Selecionar empresas</button>
                    </div>
                  </div>

                  <div class="form-group col-12 col-lg-4">
                    <div class="">
                      <label for="txtDataEmissaoPedidoI">Emissão Pedido de/até:</label>
                      <div class="d-flex">
                        <input type="date" max="2500-12-31" value="1200-01-01" max="2500-12-31" class="input-default focus form-control mr-1 estilo-data-de" id="txtDataEmissaoPedidoI">
                        <input type="date" max="2500-12-31" value="2500-12-31" max="2500-12-31" class="input-default focus form-control estilo-data-ate" id="txtDataEmissaoPedidoF">
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-4">
                    <div class="">
                      <label for="txtDataFaturaPedidoI">Fatura Pedido de/até:</label>
                      <div class="d-flex">
                        <input type="date" max="2500-12-31" value="1200-01-01" max="2500-12-31" class="input-default focus form-control mr-1 estilo-data-de" id="txtDataFaturaPedidoI">
                        <input type="date" max="2500-12-31" value="2500-12-31" max="2500-12-31" class="input-default focus form-control estilo-data-ate" id="txtDataFaturaPedidoF">
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-4">
                    <div class="">
                      <label for="txtDataEntregaPedidoI">Entrega Pedido de/até:</label>
                      <div class="d-flex">
                        <input type="date" max="2500-12-31" value="1200-01-01" max="2500-12-31" class="input-default focus form-control mr-1 estilo-data-de" id="txtDataEntregaPedidoI">
                        <input type="date" max="2500-12-31" value="2500-12-31" max="2500-12-31" class="input-default focus form-control estilo-data-ate" id="txtDataEntregaPedidoF">
                      </div>
                    </div>
                  </div>

                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtPeriodoDeRelPedidoRank">Período De:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtPeriodoDeRelPedidoRank" name="txtPeriodoDeRelPedidoRank" placeholder="0">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnPeriodoDeRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaPeriodoDeRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtPeriodoAteRelPedidoRank">Período Até:</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control validate" id="txtPeriodoAteRelPedidoRank" name="txtPeriodoAteRelPedidoRank" placeholder="9999">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnPeriodoAteRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaPeriodoAteRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtEmpresaPedRelPedidoRank">Empresa Ped: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtEmpresaPedRelPedidoRank" name="txtEmpresaPedRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtEmpresaPedRelPedidoRank" name="txtEmpresaPedRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnEmpresaPedRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaEmpresaPedRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtProdutoRelPedidoRank">Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtProdutoRelPedidoRank" name="txtProdutoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtProdutoRelPedidoRank" name="txtProdutoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnProdutoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaProdutoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtCorProdRelPedidoRank">Cor Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtCorProdRelPedidoRank" name="txtCorProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtCorProdRelPedidoRank" name="txtCorProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnCorProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaCorProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtGrupoProdRelPedidoRank">Grupo Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtGrupoProdRelPedidoRank" name="txtGrupoProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtGrupoProdRelPedidoRank" name="txtGrupoProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnGrupoProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaGrupoProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtColecaoProdRelPedidoRank">Coleção Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtColecaoProdRelPedidoRank" name="txtColecaoProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtColecaoProdRelPedidoRank" name="txtColecaoProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnColecaoProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaColecaoProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtLinhaProdRelPedidoRank">Linha Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtLinhaProdRelPedidoRank" name="txtLinhaProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtLinhaProdRelPedidoRank" name="txtLinhaProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnLinhaProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaLinhaProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtMarcaProdRelPedidoRank">Marca Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtMarcaProdRelPedidoRank" name="txtMarcaProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtMarcaProdRelPedidoRank" name="txtMarcaProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnMarcaProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaMarcaProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtEtiquetaProdRelPedidoRank">Etiqueta Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtEtiquetaProdRelPedidoRank" name="txtEtiquetaProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtEtiquetaProdRelPedidoRank" name="txtEtiquetaProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnEtiquetaProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaEtiquetaProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtCategoriaProdRelPedidoRank">Categoria Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtCategoriaProdRelPedidoRank" name="txtCategoriaProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtCategoriaProdRelPedidoRank" name="txtCategoriaProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnCategoriaProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaCategoriaProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <div class="icheck-primary d-inline" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os clientes selecionados na pesquisa, se desmarcado, desconsidera os clientes selecionados na pesquisa e filtra por todos os outros clientes.">
                      <input type="checkbox" class="icheck-primary" id="cbConsideraClienteProd" checked><label for="cbConsideraClienteProd"></label>
                    </div>
                    <label data-error="wrong" data-success="right" for="txtClienteProdRelPedidoRank">Cliente Produto: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtClienteProdRelPedidoRank" name="txtClienteProdRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtClienteProdRelPedidoRank" name="txtClienteProdRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnClienteProdRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaClienteProdRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtDepositoRelPedidoRank">Deposito: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtDepositoRelPedidoRank" name="txtDepositoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtDepositoRelPedidoRank" name="txtDepositoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnDepositoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaDepositoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtPedidoRelPedidoRank">Pedido: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtPedidoRelPedidoRank" name="txtPedidoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtPedidoRelPedidoRank" name="txtPedidoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnPedidoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaPedidoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <div class="icheck-primary d-inline" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os status selecionados na pesquisa, se desmarcado, desconsidera os status selecionados na pesquisa e filtra por todos os outros status.">
                      <input type="checkbox" class="icheck-primary" id="cbConsideraStatusPedido" checked><label for="cbConsideraStatusPedido"></label>
                    </div>
                    <label data-error="wrong" data-success="right" for="txtStatusPedidoRelPedidoRank">Status Pedido: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtStatusPedidoRelPedidoRank" name="txtStatusPedidoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtStatusPedidoRelPedidoRank" name="txtStatusPedidoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnStatusPedidoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaStatusPedidoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtTipoVendaRelPedidoRank">Tipo Venda: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtTipoVendaRelPedidoRank" name="txtTipoVendaRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtTipoVendaRelPedidoRank" name="txtTipoVendaRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnTipoVendaRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaTipoVendaRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtGrupoPedidoRelPedidoRank">Grupo Pedido: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtGrupoPedidoRelPedidoRank" name="txtGrupoPedidoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtGrupoPedidoRelPedidoRank" name="txtGrupoPedidoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnGrupoPedidoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaGrupoPedidoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtColecaoPedidoRelPedidoRank">Coleção Pedido: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtColecaoPedidoRelPedidoRank" name="txtColecaoPedidoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtColecaoPedidoRelPedidoRank" name="txtColecaoPedidoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnColecaoPedidoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaColecaoPedidoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <div class="icheck-primary d-inline" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os clientes selecionados na pesquisa, se desmarcado, desconsidera os clientes selecionados na pesquisa e filtra por todos os outros clientes.">
                      <input type="checkbox" class="icheck-primary" id="cbConsideraCliente" checked><label for="cbConsideraCliente"></label>
                    </div>
                    <label data-error="wrong" data-success="right" for="txtClienteRelPedidoRank">Cliente: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtClienteRelPedidoRank" name="txtClienteRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtClienteRelPedidoRank" name="txtClienteRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnClienteRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaClienteRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <div class="icheck-primary d-inline" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os grupos de clientes selecionados na pesquisa, se desmarcado, desconsidera os grupos de clientes selecionados na pesquisa e filtra por todos os outros grupos de clientes.">
                      <input type="checkbox" class="icheck-primary" id="cbConsideraGrupoCliente" checked><label for="cbConsideraGrupoCliente"></label>
                    </div>
                    <label data-error="wrong" data-success="right" for="txtGrupoClienteRelPedidoRank">Grupo Cliente: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtGrupoClienteRelPedidoRank" name="txtGrupoClienteRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtGrupoClienteRelPedidoRank" name="txtGrupoClienteRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnGrupoClienteRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaGrupoClienteRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <div class="icheck-primary d-inline" data-toggle="tooltip" data-placement="top" title="Se marcado, considera apenas os representantes selecionados na pesquisa, se desmarcado, desconsidera os representantes selecionados na pesquisa e filtra por todos os outros representantes.">
                      <input type="checkbox" class="icheck-primary" id="cbConsideraRepresentante" checked><label for="cbConsideraRepresentante"></label>
                    </div>
                    <label data-error="wrong" data-success="right" for="txtRepresentanteRelPedidoRank">Representante: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtRepresentanteRelPedidoRank" name="txtRepresentanteRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtRepresentanteRelPedidoRank" name="txtRepresentanteRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnRepresentanteRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaRepresentanteRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtTabelaPrecoRelPedidoRank">Tabela Preço: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtTabelaPrecoRelPedidoRank" name="txtTabelaPrecoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtTabelaPrecoRelPedidoRank" name="txtTabelaPrecoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnTabelaPrecoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaTabelaPrecoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtCidadeRelPedidoRank">Cidade: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtCidadeRelPedidoRank" name="txtCidadeRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtCidadeRelPedidoRank" name="txtCidadeRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnCidadeRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaCidadeRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtEstadoRelPedidoRank">Estado: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtEstadoRelPedidoRank" name="txtEstadoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtEstadoRelPedidoRank" name="txtEstadoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnEstadoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaEstadoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtRegiaoRelPedidoRank">Região: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtRegiaoRelPedidoRank" name="txtRegiaoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtRegiaoRelPedidoRank" name="txtRegiaoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnRegiaoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaRegiaoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group col-12 col-lg-3">
                    <label data-error="wrong" data-success="right" for="txtTipoPedidoRelPedidoRank">Tipo Venda: </label>
                    <div class="relative">
                      <div class="input-group">
                        <!-- <input type="text" class="input-default focus form-control" id="txtTipoPedidoRelPedidoRank" name="txtTipoPedidoRelPedidoRank" class="form-control" placeholder="Vendedor"> -->
                        <select class="js-example-programmatic js-states form-control" id="txtTipoPedidoRelPedidoRank" name="txtTipoPedidoRelPedidoRank" multiple="multiple">
                        </select>
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btnTipoPedidoRelPedidoRank" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btnLimpaTipoPedidoRelPedidoRank" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-start">
            <div class="form-row col-lg-12 col-12 col-sm-12 pl-0 ml-0">
              <div class="col-lg-4 col-4 col-sm-6">
                <label for="selectOrdenacao">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="selectOrdenacao" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltrosRelPedidoRank" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultarRelPedidoRank" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div id="modalRadiosStatusPedido" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Status de Pedido</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0">
            <div class="card">
              <div class="row">
                <div class="col-lg-12 col-12 row">
                  <div class="col-12 row d-flex">
                    <div class="col-md-auto col-12 form" id="tipos">
                      <fieldset class="form border-Field p-0" style="margin-bottom: 0.7em !important;">
                        <legend class="textoBorda pb-0 mb-0">Tipo</legend>
                        <div class="form-row">
                          <div class="d-flex">
                            <div class="radio-group form-radio icheck-primary"><input type="radio" checked="" id="radioProduto" name="tipoFat"><label for="radioProduto" class="container escondeRadio">Produto</label></div>
                            <div class="radio-group form-radio icheck-primary"><input type="radio" id="radioMaterial" name="tipoFat"><label for="radioMaterial" class="container escondeRadio">Material</label></div>
                          </div>
                        </div>
                      </fieldset>
                    </div>
                    <div class="col-md-3 col-sm-3 col-6 form-group">
                      <div style="margin-top: 12px;">
                        <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>   
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-start pl-0">
            <div class="row col-12 ml-0">
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Fechar
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    <?php include_once('../../modais.php'); ?>
  </main>

  <script src="plugins/jquery/jquery.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.261.22.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.22.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.261.22.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.22.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.22.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.261.22.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.261.22.1"></script>
  <script src="dist/js/sisplan.js?versao=3.261.22.1"></script>
  <script src="utils/funcoes.js?versao=3.261.22.1"></script>
  <script src="utils/cookies.js?versao=3.261.22.1"></script>
  <script src="dist/js/driver.min.js?versao=3.261.22.1"></script>
  <script src="config.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.261.22.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.261.22.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="dist/js/apexcharts.js?versao=3.261.22.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      // const temAcesso = await temAcessoTela('RELLOJARANK');
      // if (!temAcesso.resultado) {
      // toastrAcesso(temAcesso, BASE_URI);
      // return;
      // }

      sArquivo = `${BASE_URI}/pages/relpedidorank/relpedidorank.js?versao=3.261.22.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      nomeTela


      await insereJavaScriptPagina(sArquivo);

      // habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>