$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoPreco',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de preço por cor e tamanho.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaPreco',
                popover: {
                    title: 'Tabela Preços',
                    description: 'Aqui estarão os preços cadastrados de acordo com o seu filtro.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("PRECOCORTAM");

    componenteFiltro("produto", false, false, "RecalcularProdutoMaterial")
    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
    $('#txtTabPreco-dup').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
    $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#btnTabPreco').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela de Preço', 'regiao');
    $('#btnTabPreco-dup').pesquisa('#txtTabPreco-dup', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela de Preço', 'regiao');
    $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'produto');
    $('#btnMaterial').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'material');

    $('#btnExcluiTabPreco').on('click', function () {
        $('#txtTabPreco').val('');
    });
    $('#btnExcluiTabPreco-dup').on('click', function () {
        $('#txtTabPreco-dup').val('');
    });
    $('#btnExcluiProduto').on('click', function () {
        $('#txtProduto').val('');
    });
    $('#btnExcluiMaterial').on('click', function () {
        $('#txtMaterial').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });


    //IMPORTAR INICIO

    $('#mdModalUpload').on('change', async function () {
        let nomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
        $('#txtArquivoImportar').val(nomeAnexo);

        let file = document.getElementById('mdModalUpload').files[0];
        let reader = new FileReader();
        dados = leArquivoExcel(reader, file, nomeAnexo);
    });

    function leArquivoExcel(reader, file, name) {
        try {
            const extension = (name.split('.')[name.split('.').length - 1]);
            if (extension == 'csv') {
                reader.onload = function (e) {
                    $('#fileContent').text(e.target.result);
                }
                reader.readAsText(file);
            } else if (extension == 'xls' || extension == 'xlsx' || extension == 'xlsm' || extension == 'xlt') {
                reader.onload = function (e) {
                    const data = new Uint8Array(e.target.result);
                    const workbook = XLSX.read(data, { type: 'array' });
                    const sheetName = workbook.SheetNames[0];
                    const sheet = workbook.Sheets[sheetName];

                    // Get the range of the sheet
                    const range = XLSX.utils.decode_range(sheet['!ref']);
                    let resultString = '';

                    for (let R = range.s.r; R <= range.e.r; ++R) {
                        for (let C = range.s.c; C <= range.e.c; ++C) {
                            const cellAddress = { c: C, r: R };
                            const cellRef = XLSX.utils.encode_cell(cellAddress);
                            const cell = sheet[cellRef];
                            let cellValue = cell ? cell.v : null;

                            if (cell && cell.t === 'n' && cell.z === 'm/d/yy') {
                                const serialDate = cellValue;
                                const jsDate = excelSerialToJSDate(serialDate);
                                cellValue = formatDate(jsDate);
                            }

                            resultString += `${cellValue},`;
                        }
                        resultString = resultString.slice(0, -1); // Remove the trailing comma
                        resultString += ';';
                    }

                    $('#fileContent').text(resultString);
                }
                reader.readAsArrayBuffer(file);

            }
        } catch (e) {
            msgErro(`Não foi possível ler o arquivo: ${e}`)
            return;
        }
    }

    function formataDadosExcel(info, ext) {
        let char1, char2;
        if (ext == 'csv') {
            char1 = '\n';
            char2 = ';';
        } else {
            char1 = ';';
            char2 = ',';
        }

        let data = (info.split(char1)).filter(item => item != '');
        let arrayRetorno = [];

        let firstLine = data[0].split(char2);

        firstLine = firstLine.map(e => {
            return e.normalize("NFD").replaceAll('R$', '').replace(/[\u0300-\u036f]/g, '').replace(/[^\w\s]/gi, '').replaceAll('.', '').replaceAll(',', '').toUpperCase().trim();
        })

        data.map((e, i) => {
            let d
            if (e.indexOf('\r') != -1) {
                d = e.replace('\r', '').split(char2);
            } else {
                d = e.split(char2);
            }
            if (d[0] == 'null' && d[1] == 'null' && d[2] == 'null' && d[3] == 'null' && d[4] == 'null' && d[5] == 'null' && d[6] == 'null' && d[7] == 'null' && d[8] == 'null' && d[9] == 'null') {
                return;
            }

            arrayRetorno.push({
                TABELA: d[0] == 'null' || !d[0] ? '' : d[0],
                CODIGO: d[1] == 'null' || !d[1] ? '' : d[1],
                CODIGO2: d[2] == 'null' || !d[2] ? 0 : d[2],
                COR: d[3] == 'null' || !d[3] ? 0 : d[3],
                TAM: d[4] == 'null' || !d[4] ? 0 : d[4],
                PRECO: d[5] == 'null' || !d[5] ? 0 : d[5],
                PRECO_PROMO: d[6] == 'null' || !d[6] ? 0 : d[6],
                PRECO_TABELA_PADRAO: d[7] == 'null' || !d[7] ? 0 : d[7],
            });
        });

        return arrayRetorno;
    }

    function retornaDadosImportar() {
        let info = $('#fileContent').text();
        let arquivo = $('#txtArquivoImportar').val();
        let ext = (arquivo.split('.'))[(arquivo.split('.')).length - 1];
        let dados = '';
        dados = formataDadosExcel(info, ext);
        return dados;
    }

    $('#btnCarregarImportar').on('click', async function () {
        await carregaDadosImportacao()
    })

    async function carregaDadosImportacao() {
        $.LoadingOverlay('show')
        try {
            const dadosImportacao = retornaDadosImportar()

            if (!dadosImportacao || !dadosImportacao.length) {
                msgErro('Nenhum dado para importar.');
                return;
            }

            const response = await requisicao(
                "POST",
                "/Sisplan/cadastros/v1/carregarimportacaoprecocortamitens?",
                "",
                JSON.stringify({ itens: dadosImportacao }),
                36000000
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            criaTabelaImportar(jsonStr)
        } catch (e) {
            msgErro('Não foi possível realizar a importação.')
            console.log(e)
        } finally {
            $.LoadingOverlay('hide')
            $('#btnCarregarImportar').prop('disabled', false)
        }
    }


    function retornaDataImportar() {
        const itens = $('#tabelaImportar').DataTable().data().toArray()
        return itens.map((e, i) => {
            return {
                tabela: e.TABELA,
                codigo: e.CODIGO,
                codigo2: e.CODIGO2,
                cor: e.COR,
                tam: e.TAM,
                preco_arquivo: e.PRECO,
                preco_promo: e.PRECO_PROMO,
            }
        })

    }

    $('#btnConfirmarImportar').on('click', async function () {
        const data = retornaDataImportar()
        msgAlerta('Deseja realmente importar os preços?',
            () => { },
            () => { },
            async () => {
                await importaPrecos(data)
            }
        )
    })

    async function importaPrecos(data) {
        $('#btnConfirmarImportar').prop('disabled', true)
        $.LoadingOverlay('show')
        try {
            const filtros = retornaFiltrosImportar()

            const response = await requisicao(
                "POST",
                "/sisplan/cadastros/v1/importaprecoctitens?",
                "",
                JSON.stringify({ itens: data, filtros }),
                36000000
            );

            if (!response) {
                return;
            }

            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }

            toastr.success("Preço(s) importado(s) com sucesso!", "Confirmação", {
                toastClass: "success",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    $('#modal-importar-preco').modal('hide')
                    $('#dtPromocaoIniImportar').val('')
                    $('#dtPromocaoFimImportar').val('')
                    $('#txtArquivoImportar').val('')
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });

        } catch (e) {
            msgErro('Não foi possível importar os dados.')
            console.log(e)
        } finally {
            $('#btnConfirmarImportar').prop('disabled', false)
            $.LoadingOverlay('hide')
            $('#btnConsultar').trigger('click')
        }
    }

    function retornaFiltrosImportar() {
        return {
            tipo: $('#selectTipoImportar').val(),
            dt_promo_ini: $('#dtPromocaoIniImportar').val() !== '' ? $('#dtPromocaoIniImportar').val() : null,
            dt_promo_fim: $('#dtPromocaoFimImportar').val() !== '' ? $('#dtPromocaoFimImportar').val() : null
        }
    }



    function criaTabelaImportar(info = []) {
        function carregaInputPreco(valor, indices) {
            return `<div class="d-flex justify-content-end">
                <input type="text" style="float:left; text-align:left !important;" "id="txtPreco_${indices.row}"
                class="input-default focus form-control apenasFloat text-right classPreco"
                style="min-width: 15ch; max-width: 20ch" value="${valor}">
              </div>`;
        }
        function carregaInputPrecoPromo(valor, indices) {
            return `<div class="d-flex justify-content-end pr-4">
                <input type="text" style="float:left; text-align:left !important;" id="txtPrecoPromo_${indices.row}"
                class="input-default focus form-control apenasFloat text-right classPrecoPromo"
                style="min-width: 15ch; max-width: 20ch" value="${valor}">
              </div>`;
        }

        if ($.fn.DataTable.isDataTable('#tabelaImportar')) {
            $('#tabelaImportar').DataTable().destroy();
            $('#tabelaImportar').empty();
        }

        const cols = [
            {
                data: 'TABELA',
                title: 'TABELA'
            },
            {
                data: 'CODIGO',
                title: 'CODIGO'
            },
            {
                data: 'CODIGO2',
                title: 'CODIGO2'
            },
            {
                data: 'COR',
                title: 'COR'
            },
            {
                data: 'TAM',
                title: 'TAM'
            },
            {
                data: 'PRECO',
                title: 'PRECO'
            },
            {
                data: 'PRECO_PROMO',
                title: 'PRECO_PROMO'
            },
            {
                data: 'PRECO_TABELA_PADRAO',
                title: 'PRECO_TABELA_PADRAO'
            }
        ];

        $("#tabelaImportar").DataTable({
            sort: true,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            columnDefs: [
                {
                    targets: [5, 6, 7],
                    render: function (data) {
                        if (!data) {
                            return parseFloat(0).toFixed(2)
                        }
                        return parseFloat(data).toFixed(2)
                    },
                    className: 'text-right pr-4'
                },
                {
                    targets: [5],
                    render: function (data, _type, _row, meta) {
                        return carregaInputPreco(data, meta)
                    }
                },
                {
                    targets: [6],
                    render: function (data, _type, _row, meta) {
                        return carregaInputPrecoPromo(data, meta)
                    }
                },
            ],
            autoWidth: true,
            data: info,
            columns: cols
        }).draw(false);

        if (info.length > 0) {
            $('#btnConfirmarImportar').prop('disabled', false);
        } else {
            $('#btnConfirmarImportar').prop('disabled', true);
        }

    }

    $("#btnAddArquivo").on("click", function () {
        $("#mdModalUpload").trigger("click");
    })

    $("#btnImportarPreco").on('click', async function () {
        modalImportarPreco()
    });


    async function modalImportarPreco() {
        $.LoadingOverlay("show");
        $("#modal-importar-preco").modal("show");
        const dados = $('#tabelaIMportar').DataTable().data().toArray();
        if (dados.length > 0) {
            criaTabelaImportar(dados);
        } else {
            criaTabelaImportar([]);
        }
        $.LoadingOverlay("hide");
    }



    //IMPORTAR FIM

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaPreco(true);
    });

    $("#btnRecalcularPreco").on("click", function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            senhaSupervisor('', modalRecalcularPreco);
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtTabPreco').val('');
        $('#txtProduto').val('');
        $('#txtMaterial').val('');
        $("#txtTipo").val("");
    });

    let dadosProdutoDuplicar = [];
    $("#tabelaPreco").on("click", '#btn-duplicar', function () {
        dadosProdutoDuplicar = [];
        const data = $("#tabelaPreco").DataTable().rows($(this).closest('tr').index()).data().toArray();

        $("#modal-duplicar").modal("show");
        $("#modal-duplicar-produto").html(` - [${data[0].CODIGO}] - ${data[0].DESCRICAO}`);
        dadosProdutoDuplicar = {
            produtos: data.map(produto => ({
                CODIGO: produto.CODIGO,
                DESCPROD: produto.DESCRICAO,
                REGIAO: produto.REGIAO
            }))
        };
    });

    $("#btnDuplicar").on("click", function () {
        if ($("#txtTabPreco").val() === '') {
            msgAlerta("Para duplicação em massa, é necessário ter uma tabela de preço filtrada!");
            $("#modal-duplicar").modal("hide");
            return;
        };

        const data = $("#tabelaPreco").DataTable().rows('.selected').data().toArray();
        dadosProdutoDuplicar = [];

        $("#modal-duplicar").modal("show");
        $("#modal-duplicar-produto").html(` - Duplicação em Massa`);

        let produtos = [];
        for (let x = 0; x < data.length; x++) {
            if (produtos.some(item => item.CODIGO === data[x].CODIGO)) {
                msgAlerta(`Produto [${data[x].CODIGO}] - ${data[x].DESCRICAO} está selecionado mais de uma vez! Para duplicação em massa, é necessário ter uma tabela de preço filtrada!`);
                produtos = [];
                $("#modal-duplicar").modal("hide");
                break;
            } else {
                produtos.push({
                    CODIGO: data[x].CODIGO,
                    DESCPROD: data[x].DESCRICAO,
                    REGIAO: data[x].REGIAO
                });
            };
        };

        const array = { produtos };
        dadosProdutoDuplicar = array;
    });

    $("#btnConfirmarDuplicar").on("click", async function () {
        $.LoadingOverlay('show');
        try {
            const tabPreco = $('#txtTabPreco-dup').val();

            if (tabPreco === '')
                throw new Error("necessário informar o campo tabela de preço!");

            if (dadosProdutoDuplicar.produtos.length > 0)
                await duplicarPrecoCorTam(dadosProdutoDuplicar, tabPreco);

        } catch (error) {
            msgAlerta(`Não foi possível duplicar o preço por cor e tamanho do produto: ${error.message}`);
        } finally {
            $.LoadingOverlay('hide');
            $("#modal-duplicar").modal("hide");
        };
    });

    $("#btnCancelarDuplicar").on("click", function () {
        $("#modal-duplicar").modal("hide");
    });

    $('#modal-duplicar').on('hide.bs.modal', function () {
        $('#txtTabPreco-dup').val('');
    });

    async function duplicarPrecoCorTam(duplicarVarios = [], tabPrecoNova) {
        const filtros = `JSON=${JSON.stringify(duplicarVarios)}&TABELA_NOVA=${pegaChave(tabPrecoNova)}&DESC_TABELA_NOVA=${pegaDescricao(tabPrecoNova)}`;

        const response = await requisicao('POST', '/sisplan/cadastros/v1/precocortamduplicar?', filtros, null);

        if (!response)
            throw new Error("tente novamente mais tarde.");

        const jsonResponse = await response.json();

        if (response.status !== 200)
            throw new Error(jsonResponse.mensagem);

        criaMensagemSucesso(jsonResponse.mensagem, () => { window.location.href = `${BASE_URI}/precocortam`; });
    };


    function retornaBotaoOpcoesCodigo(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Duplicar" id="btn-duplicar">Duplicar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    const btnsSel = [];
    async function consultaPreco() {
        try {
            $.LoadingOverlay("show");
            let tipo = $("#txtTipo").val() != '' ? `AND PRECO_COR_TAM.TIPO = '${$('#txtTipo').val()}'` : '';
            let codigoProduto = pegaChave('#txtProduto') != '' ? `AND PRECO_COR_TAM.CODIGO = '${pegaChave('#txtProduto')}'` : '';
            let codigoMaterial = pegaChave('#txtMaterial') != '' ? `AND PRECO_COR_TAM.CODIGO = '${pegaChave('#txtMaterial')}'` : '';
            let tabelapreco = pegaChave('#txtTabPreco') != '' ? `AND PRECO_COR_TAM.REGIAO = '${pegaChave('#txtTabPreco')}'` : '';
            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PRECO_COR_TAM", "camposSelect":["'' AS SEL", "PRECO_COR_TAM.CODIGO", "PRECO_COR_TAM.TIPO", "CASE WHEN PRECO_COR_TAM.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO", "PRECO_COR_TAM.REGIAO", "REGIAO.DESCRICAO DESC_REGIAO"], 
                "leftjoin": [{"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = PRECO_COR_TAM.CODIGO AND PRECO_COR_TAM.TIPO = 'P'"}, {"tabela" : "MATERIAL", "condicao" : "MATERIAL.CODIGO = PRECO_COR_TAM.CODIGO AND PRECO_COR_TAM.TIPO = 'M'"}, {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = PRECO_COR_TAM.REGIAO"}],
                "groupby": ["PRECO_COR_TAM.CODIGO", "PRECO_COR_TAM.REGIAO", "CASE WHEN PRECO_COR_TAM.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END", "REGIAO.DESCRICAO", "PRECO_COR_TAM.TIPO"],
                "where": ["1=1 ${codigoProduto} ${codigoMaterial} ${tabelapreco} ${tipo}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadPrecoCorTam == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadPrecoCorTam: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaPreco').DataTable({
                destroy: true,
                lengthChange: true,
                paging: true,
                searching: true,
                scrollX: true,
                scrollY: '350px',
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [
                    { data: "SEL", title: "Sel" },
                    { data: "CODIGO", title: "Código" },
                    { data: "DESCRICAO", title: "Descrição" },
                    { data: "REGIAO", title: "Região" },
                    { data: "DESC_REGIAO", title: "Desc. Região" },
                    { data: "TIPO", title: "Tipo" },
                ],
                "columnDefs": [
                    {
                        targets: [0], render: function (_data, _type, row, _meta) {
                            const id = `check_${row.CODIGO}_${row.REGIAO}_${row.TIPO}`
                            if (!btnsSel.includes(id))
                                btnsSel.push(id);
                            return `<div class="icheck-primary d-inline">
                                <input type="checkbox" id="${id}" class="checkSel">
                                <label for="${id}"></label>
                                </div>`;
                        },
                    },
                    {
                        targets: [1], render: function (data, type, row) {
                            return retornaBotaoOpcoesCodigo(data);
                        }
                    }
                ],
                "initComplete": function () {
                    $('#tabelaPreco').on('change', '.checkSel', function () {
                        const tr = $(this).closest('tr');
                        if (this.checked) {
                            tr.addClass('selected');
                        } else {
                            tr.removeClass('selected');
                        }
                    });
                }
            });

            for (let x = 0; x < btnsSel.length; x++) {
                $(`#${btnsSel[x]}`).on("click", function () {
                    const peloMenosUmMarcado = btnsSel.some(id => $(`#${id}`).is(':checked'));
                    const tabelaDePrecoFiltrada = $("#txtTabPreco").val() !== '';

                    if (peloMenosUmMarcado && tabelaDePrecoFiltrada) {
                        $("#btnDuplicar").prop("disabled", false);
                        $("#btnDuplicar").prop("title", "");
                    } else {
                        $("#btnDuplicar").prop("disabled", true);
                        $("#btnDuplicar").prop("title", "Necessário ter uma tabela de preço filtrada e um produto selecionado!");
                    };
                });
            };

            if ($.fn.DataTable.isDataTable('#tabelaPreco')) {
                $("#tabelaPreco").DataTable().columns.adjust().draw(false);
            };

            $('#tabelaPreco_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaPreco_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaPreco").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Preço por Cor e Tamanho', '', '', 999, false, false, dados);
            });

            $('#tabelaPreco').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadPrecoCorTam).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPreco').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadPrecoCorTam ?? ['EMPRESA'], ['Código', 'Sel']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["CODIGO"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadPrecoCorTam: novasColunas }));

            $('#tabelaPreco').DataTable().columns().visible(true);

            $('#tabelaPreco').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaPreco').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaPreco').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('PRECOCORTAM', String(data.REGIAO) + String(data.CODIGO + String(data.TIPO)));
            if (registroLiberado) {
                window.location.href = `precocortam/${btoa(`${data.REGIAO}/${data.CODIGO}/${data.TIPO}`)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaPreco').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaPreco').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('PRECOCORTAM', String(data.REGIAO) + String(data.CODIGO) + String(data.TIPO));
            if (registroLiberado) {
                window.location.href = `precocortam/${btoa(`${data.REGIAO}/${data.CODIGO}/${data.TIPO}`)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaPreco').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaPreco").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    //Recalcular-1



    $("#txtRecalcularTabelaPreco").autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
    $("#btnRecalcularTabelaPreco").pesquisa("#txtRecalcularTabelaPreco", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, "Pesquisa Tabela de Preço", "regiao");
    $("#btnRecalcularLimpaTabelaPreco").on("click", function () {
        $("#txtRecalcularTabelaPreco").val("");
    });
    $("#btnRecalcularLimpaProdutoMaterial").on("click", function () {
        $("#txtRecalcularProdutoMaterial").val("");
    });

    $("#btnNovoPreco").on("click", function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "precocortam/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    $('#btnRecalcularAplicarDesconto').on('click', async function () {
        const dados = $('#tabelaRecalcularPreco').DataTable().data().toArray();
        for (let i = 0; i < dados.length; i++) {
            const valorDesconto = dados[i].PRECO_ANTIGO * Number($('#txtRecalcularDescontoPreco').val()) / 100;
            const novoValor = dados[i].PRECO_ANTIGO + valorDesconto;
            $($('.campoRecalcularPrecoFinal')[i]).val(ArredondarValor(novoValor, 2));
        }
    });

    $('#txtRecalcularDescontoPrecoFixo').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2,
        allowNegative: true,
        alowZero: true
    });


    $('#btnRecalcularAplicarDescontoFixo').on('click', async function () {
        const dados = $('#tabelaRecalcularPreco').DataTable().data().toArray();
        const valorDigitado = Number($('#txtRecalcularDescontoPrecoFixo').val()) || 0;

        for (let i = 0; i < dados.length; i++) {
            const novoValorFixo = dados[i].PRECO_ANTIGO + valorDigitado;
            $($('.campoRecalcularPrecoFinal')[i]).val(ArredondarValor(novoValorFixo, 2));
        }
    });

    $("#btnRecalcularConsultar").on("click", async function () {
        if ($("#txtRecalcularTabelaPreco").val() == "") {
            msgAlerta("Tabela de preço não informada, favor verificar.");
            return;
        }
        $("#tabelaRecalcularPreco").DataTable().clear().draw(false);
        await consultaRecalcularPreco();
    });

    $("#btnRecalcularGravar").on("click", async function () {
        const rows = $("#tabelaRecalcularPreco").DataTable().rows();
        const arrayItensRecalcularPreco = [];

        try {
            $.LoadingOverlay("show");
            try {
                for (let i = 0; i < $('.capoRecalcularPrecoFinal').length; i++) {
                    const campo = $('.capoRecalcularPrecoFinal')[i];
                    if ($(campo).val() == '') {
                        msgAlerta('Necessário informar preço para todos os registros.');
                        return;
                    }
                }

                for (let i = 0; i < rows[0].length; i++) {
                    const tabela = $("#tabelaRecalcularPreco").DataTable().row(i).data();
                    let obj = {
                        REGIAO: tabela.REGIAO,
                        CODIGO: tabela.CODIGO,
                        PRECO_00: Number($($('.campoRecalcularPrecoFinal')[i]).val())
                    };
                    arrayItensRecalcularPreco.push(obj);
                }

                const preco = {
                    itensPreco: arrayItensRecalcularPreco
                };
                console.log(preco);
                const response = await requisicao(
                    "PUT",
                    "/Sisplan/Cadastros/v1/recalcularpreco?",
                    "",
                    JSON.stringify(preco),
                    null
                );

                if (!response) {
                    return;
                }

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                $("#tabelaRecalcularPreco").DataTable().clear().draw(false);
                $("#modal-recalcular-preco").modal("hide");
                msgSucesso("Preços alterados com sucesso!");
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados : ${error}`);
            }
        } finally {
            $.LoadingOverlay("hide");
        }

    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/cadastros/v1/precocortam?", `CODIGO=${(valorLinha.CODIGO)}&REGIAO=${(valorLinha.REGIAO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function ajustaTipoRecalcularCampoBusca() {
        if ($("#rgTipoItemRecalcularPreco").val() != 0) {
            $("#labelRecalcularProdutoMaterial").html("Material");
            $("#txtRecalcularProdutoMaterial").attr("placeholder", "Material");
            $("#txtRecalcularProdutoMaterial").val("");
        } else {
            $("#labelRecalcularProdutoMaterial").html("Produto");
            $("#txtRecalcularProdutoMaterial").attr("placeholder", "Produto");
            $("#txtRecalcularProdutoMaterial").val("");
        }
    }

    $("#rgTipoItemRecalcularPreco").on("change", function () {
        ajustaTipoRecalcularCampoBusca();
        alteraTipoRecalcularPesquisa($("#rgTipoItemRecalcularPreco").val());
    });

    $("#rgTipoItemRecalcularPreco").trigger("change");

    function alteraTipoRecalcularPesquisa(tipo) {
        // componenteFiltro('RecalcularProdutoMaterial', true);
        $("#btnRecalcularProdutoMaterial").off();
        let pesquisaAutoCompleta = '';
        let pesquisa = '';
        let nomePesquisa = '';

        if (tipo == 1) {
            pesquisaAutoCompleta = { "tabela": "material", "camposSelect": ["CODIGO", "DESCRICAO"], "where": null };
            pesquisa = { "tabela": "material", "camposSelect": ["CODIGO", "DESCRICAO"] };
            nomePesquisa = 'Material';
        } else {
            pesquisaAutoCompleta = { "tabela": "produto", "camposSelect": ["CODIGO", "DESCRICAO"], "where": null };
            pesquisa = { "tabela": "produto", "camposSelect": ["CODIGO", "DESCRICAO"] };
            nomePesquisa = 'Produto';
        }

        $("#txtRecalcularProdutoMaterial").pesquisa_variosServerside(1, `${JSON.stringify(pesquisaAutoCompleta)}`, 'CODIGO', 'DESCRICAO');
        $("#btnRecalcularProdutoMaterial").pesquisa_serversideSel("#txtRecalcularProdutoMaterial", `${JSON.stringify(pesquisa)}`, `Pesquisa ${nomePesquisa}`);
        $('#txtRecalcularProdutoMaterial').addClass('camposFiltros');
        $('#btnRecalcularLimpaProdutoMaterial').on('click', function () {
            $('#txtRecalcularProdutoMaterial').empty().trigger('change');
            $('#txtRecalcularProdutoMaterial').val('');
            $('#txtRecalcularProdutoMaterial').attr('data-chave', '');
            $('#txtRecalcularProdutoMaterial').attr('data-desc', '');
        });
    }


    $('#btnConsultar').trigger('click');



    // Recalcular 2

    async function consultaRecalcularPreco() {
        try {
            $.LoadingOverlay("show");
            const tabelapreco =
                pegaChave("#txtRecalcularTabelaPreco") != ""
                    ? ` AND TABPRECO.REGIAO = '${pegaChave("#txtRecalcularTabelaPreco")}'`
                    : "";
            const tipoitem = $("#rgTipoItemPreco").val() == 0 ? `PRODUTO` : `MATERIAL`;
            const listaCodigos = await formataListas($('#txtRecalcularProdutoMaterial').val().toString());
            const codigo = listaCodigos != "" ? ` AND TABPRECO.CODIGO IN  (${listaCodigos})` : "";



            let pesquisaParam = {
                tabela: "TABPRECO",
                where: [`1=1 ${tabelapreco} ${codigo} `],
            };

            if ($("#rgTipoItemRecalcularPreco").val() == 0) {
                pesquisaParam.camposSelect = [
                    "TABPRECO.REGIAO",
                    "TABPRECO.DESCRICAO",
                    "TABPRECO.CODIGO",
                    "TABPRECO.DESC_PRODUTO",
                    "TABPRECO.PRECO_00 PRECO_ANTIGO",
                    "0 PRECO_NOVO"
                ],
                    pesquisaParam.leftJoin = [
                        { tabela: "PRODUTO", condicao: "PRODUTO.CODIGO = TABPRECO.CODIGO" },
                    ];
            } else {
                pesquisaParam.camposSelect = [
                    "TABPRECO.REGIAO",
                    "TABPRECO.DESCRICAO",
                    "TABPRECO.CODIGO",
                    "TABPRECO.DESC_PRODUTO",
                    "TABPRECO.PRECO_00 PRECO_ANTIGO",
                    "0 PRECO_NOVO"
                ],
                    pesquisaParam.leftJoin = [
                        { tabela: "MATERIAL", condicao: "MATERIAL.CODIGO = TABPRECO.CODIGO" },
                    ];
            }

            const jsonStr = await retornaJsonPesquisaPadrao(
                JSON.stringify(pesquisaParam)
            );

            if (jsonStr.length == 0) {
                msgAlerta("Item não encontrado na tabela de preço");
                return;
            }

            const jsonFormatado = [{}];

            jsonStr.map((item, i) => {
                jsonFormatado[i] = {
                    REGIAO: jsonStr[i].REGIAO,
                    DESCRICAO: jsonStr[i].DESCRICAO,
                    CODIGO: jsonStr[i].CODIGO,
                    DESC_PRODUTO: jsonStr[i].DESC_PRODUTO,
                    PRECO_ANTIGO: jsonStr[i].PRECO_ANTIGO,
                    PRECO_NOVO: `<input type="number" class="input-default focus form-control campoRecalcularPrecoFinal" value="${jsonStr[i].PRECO_ANTIGO}">`
                };
            });


            const dataSetCols = [];
            const keys = Object.keys(jsonFormatado[0]);
            for (let k in keys) {
                dataSetCols.push({
                    data: keys[k],
                });
            }

            $('#tabelaRecalcularPreco').DataTable({
                paging: false,
                filter: false,
                info: false,
                order: false,
                destroy: true,
                scrollX: true,
                scrollY: "350px",
                data: jsonFormatado,
                columns: dataSetCols,
                // columnDefs: [
                //   {
                //     targets: 10,
                //     className: "ajustePrecoPromocional",
                //   }
                // ],
            });

        } finally {
            $.LoadingOverlay("hide");
            $('#tabelaRecalcularPreco').DataTable().columns.adjust().draw(false);
        }
    }

    async function modalRecalcularPreco() {
        $.LoadingOverlay("show");
        $("#modal-recalcular-preco").modal("show");
        $('#txtRecalcularTabelaPreco').val('');
        $('#txtRecalcularProdutoMaterial').empty().trigger('change');
        if ($.fn.DataTable.isDataTable('#tabelarecalcularpreco')) {
            $('#tabelarecalcularpreco').DataTable().destroy();
            $('#tabelarecalcularpreco').empty();
        }
        $.LoadingOverlay("hide");
    }
});