
const columnsPrecoItens = [
    {
        title: 'TABELA',
        data: 'TABELA',
    },
    {
        title: 'DESC_TABELA',
        data: 'DESC_TABELA',
    },
    {
        title: 'CODIGO',
        data: 'CODIGO',
    },
    {
        title: 'DESCRICAO',
        data: 'DESCRICAO',
    },
    {
        title: 'PREÇO',
        data: 'PRECO_00',
    },
    {
        title: 'PREÇO_G',
        data: 'PRECO_84',
    },
    {
        title: 'PREÇO_D',
        data: 'PRECO_91',
    },
    {
        title: 'UNIDADE',
        data: 'UNIDADE',
    },
    {
        title: 'GRUPO',
        data: 'GRUPO',
    },
    {
        title: 'DESC. GRUPO',
        data: 'DESC_GRUPO',
    },
    {
        title: 'SUB. GRUPO',
        data: 'SUB_GRUPO',
    },
    {
        title: 'DESC. SUBGRUPO',
        data: 'DESC_SUBGRUPO',
    },
    {
        title: 'CLASSE',
        data: 'CLASSE',
    },
    {
        title: 'DESC. CLASSE',
        data: 'DESC_CLASSE',
    },
    {
        title: 'CARACTERÍSTICA',
        data: 'EP',
    },
    {
        title: 'DESC. CARACTERISTICA',
        data: 'DESC_EP',
    },
    {
        title: 'ESTAÇÃO',
        data: 'COLECAO',
    },
    {
        title: 'DESC. COLECAO',
        data: 'DESC_COLECAO',
    },
    {
        title: 'ETIQUETA',
        data: 'ETIQUETA',
    },
    {
        title: 'DESC. ETIQUETA',
        data: 'DESC_ETIQUETA',
    },
];


const dataSetColsPrecoItens = [];

columnsPrecoItens.forEach((column) => {
    dataSetColsPrecoItens.push({
        title: column.title,
        data: column.data,
    });
});

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoTemplate',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma nova Aplicação do PCP.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaPrecosb2b',
                popover: {
                    title: 'Tabela Aplicação do PCP',
                    description: 'Aqui estão os dados das Aplicações do PCP cadastrados.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
//Grid Acesso//,
$(document).ready(async function () {

    $('#btnLimparFiltros').on('click', function () {
        $('#txtConsultaTipo, #txtConsultaAplicacao').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    componenteFiltro('material', true, true, 'Material');
    componenteFiltro('tabPrecoRepresentante', true, true, 'TabPreco', [`REP_REGIAO.CODREP = '${retornaRepresentanteUsuario()}'`]);
    componenteFiltro('grupoMA', true, true, 'GrupoMA');
    componenteFiltro('subGrupo', true, true, 'SubGrupo');
    componenteFiltro('colecao', true, true, 'Colecao');
    componenteFiltro('unidade', true, true, 'Unidade');
    componenteFiltro('etiqueta', true, true, 'Etiqueta');
    componenteFiltro('classeMat', true, true, 'Classe');

    async function retornaFiltroTabPreco() {
        const filtro = await formataListas($('#txtTabPreco').val().toString())

        if (filtro === '') {
            const pesquisaTabelas = {
                tabela: 'REP_REGIAO',
                camposSelect: ['REP_REGIAO.REGIAO', 'REGIAO.DESCRICAO'],
                leftJoin: [{ tabela: 'REGIAO', condicao: 'REGIAO.REGIAO = REP_REGIAO.REGIAO' }],
                where: [`REP_REGIAO.CODREP = '${retornaRepresentanteUsuario()}'`]
            }

            const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaTabelas));

            const tabelas = json.map((regiao) => regiao.REGIAO)

            return await formataListas(tabelas.toString())
        }

        return
    }


    async function retornaFiltros() {
        const Material = await formataListas($('#txtMaterial').val().toString());
        const Tabpreco = await retornaFiltroTabPreco();
        const Grupoma = await formataListas($('#txtGrupoMA').val().toString());
        const Subgrupo = await formataListas($('#txtSubGrupo').val().toString());
        const Colecao = await formataListas($('#txtColecao').val().toString());
        const Unidade = await formataListas($('#txtUnidade').val().toString());
        const Etiqueta = await formataListas($('#txtEtiqueta').val().toString());
        const Classe = await formataListas($('#txtClasse').val().toString());
        const Ativo = $('#cbMatAtivo').prop('checked') ? 'S' : 'N';
        return {
            Material,
            Tabpreco,
            Grupoma,
            Subgrupo,
            Colecao,
            Unidade,
            Etiqueta,
            Classe,
            Ativo,
        }
    };

    async function retornaTipoRepresentante() {
        const pesquisaTabelas = {
            tabela: 'REPRESEN',
            camposSelect: ['GRUPO_REP'],
            where: [`CODREP = '${retornaRepresentanteUsuario()}'`]
        }

        const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaTabelas));

        if (json.length == 0) {
            return ''
        }

        return json[0].GRUPO_REP
    }

    $('#btnConsultar').on('click', async function () {
        const url = '/sisplan/pedidob2b/v1/precoitensb2b?'
        const filtros = await retornaFiltros();
        const response = await requisicao('POST', url, ``, JSON.stringify(filtros), 30000);

        if (!response) {
            return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
            msgAlerta('Nenhum registro encontrado!');
            if ($.fn.DataTable.isDataTable('#tabelaPrecosb2b')) {
                $('#tabelaPrecosb2b').DataTable().clear().draw(false);
            }
            return;
        }

        if (response.status != 200) {
            console.error(jsonStr.mensagem);
            return;
        }

        if ($.fn.DataTable.isDataTable('#tabelaPrecosb2b')) {
            $("#tabelaPrecosb2b").DataTable().destroy();
            $("#tabelaPrecosb2b").empty();
        }
        const colunasInvisiveis = []
        const tipoUsuario = await retornaTipoRepresentante(retornaRepresentanteUsuario());
        if (tipoUsuario !== 'I') {
            if (tipoUsuario == '' || tipoUsuario == 'R' || tipoUsuario == 'V' || tipoUsuario == 'S' || tipoUsuario == 'D') {
                colunasInvisiveis.push(5, 6)
            } else if (tipoUsuario == 'U' || tipoUsuario == 'G') {
                colunasInvisiveis.push(6)
            }
        }

        console.log(colunasInvisiveis)



        criaDataTablePadrao('#tabelaPrecosb2b', true, true, false, true, true, true, true, jsonStr, dataSetColsPrecoItens, tipoUsuario === 2 ? [] : colunasInvisiveis)
        // $('#tabelaPrecosb2b').DataTable({
        //     paging: true,
        //     lengthChange: false,
        //     filter: true,
        //     info: true,
        //     order: true,
        //     autoWidth: true,
        //     destroy: true,
        //     language: {
        //         sEmptyTable: 'Nenhum registro encontrado',
        //         sInfo: '_TOTAL_ registros',
        //         sInfoEmpty: ' 0 registros',
        //         sInfoFiltered: '(Filtrados de _MAX_ registros)',
        //         sInfoPostFix: '',
        //         sInfoThousands: '.',
        //         sLengthMenu: '_MENU_ resultados',
        //         sLoadingRecords: 'Carregando...',
        //         sProcessing: 'Processando...',
        //         sZeroRecords: 'Nenhum registro encontrado',
        //         sSearch: 'Pesquisar',
        //         oPaginate: {
        //             sNext: 'Próximo',
        //             sPrevious: 'Anterior',
        //             sFirst: 'Primeiro',
        //             sLast: 'Último',
        //         },
        //         oAria: {
        //             sSortAscending: ': Ordenar colunas de forma ascendente',
        //             sSortDescending: ': Ordenar colunas de forma descendente',
        //         },
        //     },
        //     autoWidth: true,
        //     "colReorder": true,
        //     "data": jsonStr,
        //     "columns": dataSetColsPrecoItens,
        // });


    });

    $('#cbMatAtivo').prop('checked', true);
    $('#btnConsultar').trigger('click');

});
