$(document).ready(async function () {
  const orcamento = $(window.location.href.split('/')).get(-1);
  var parametrosSistema = await BuscaParametrosSistema('S');
  var parametrosVenda = await BuscaParametrosVenda();
  let quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
  const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
  const paramsPedido = await BuscaParametrosPedido()
  const somarFreteCondicoes = paramsPedido[10].VALOR == '1';
  await setarDataAtual('dtDigitacao')
  let capaAtual = null;
  let itens = [];
  let tabelaItens;
  let tabelaSubItens;

  await adicionaEmpresas();
  criaMascaraCampos();
  await addBotoesAvancarVoltar();

  const columnsItens = [
    { "data": "ordem", "title": "Item" },
    { "data": "codigo", "title": "Código" },
    { "data": "cor", "title": "Cor" },
    { "data": "quantidade", "title": "Qtde." },
    { "data": "largura", "title": "Largura" },
    { "data": "altura", "title": "Altura" },
    { "data": "valorUnit", "title": "Valor" },
    { "data": "valorTotal", "title": "Valor Total" },
    { "data": "descUnit", "title": "Desc. Item" },
    { "data": "percDesc", "title": "Perc. Desc" },
    { "data": "valorOriginal", "title": "Valor Original" },
  ]

  const columnsSubItens = [
    { data: 'ordem', title: "Nº" },
    { data: 'codigo', title: "Código" },
    { data: 'tipoLT', title: "Tipo LT" },
    { data: 'tm', title: "TM" },
    { data: 'dimensao', title: "Dimensão" },
    { data: 'partes', title: "Partes" },
    { data: 'quantidade', title: "Qtd" },
    { data: 'un', title: "Un" },
    { data: 'valorOriginal', title: "Val. Orig." },
    { data: 'valor', title: "Valor" },
    { data: 'valorTotal', title: "Val. Tot." },
    { data: 'complemento', title: "Complemento" },
    { data: 'percentualDesconto', title: "Perc. Desc" },
    { data: 'valorDesconto', title: "Val. Desc" }
  ]

  const columnsHistorico = [
    { data: 'ID', title: "Nº" },
    { data: 'OCORRENCIA', title: "Ocorrência" },
    { data: 'USUARIO', title: "Usuário" },
    { data: 'DATA_HORA', title: "Data" }
  ]

  const botaoDinamico = {
    targets: [0],
    funcao: (data, type, row) => { return retornaBotaoOpcoes(data); }
  }

  const botaoDinamicoSubItens = {
    targets: [0],
    funcao: (data, type, row) => { return retornaBotaoOpcoesSubItens(data); }
  }
  criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '250px', null, columnsItens, [8, 9], [], [], [], botaoDinamico);
  criaDataTablePadrao('#tabelaSubItens', false, false, false, [[0, 'asc']], true, true, '250px', null, columnsSubItens, [3, 11, 12, 13], [], [], [], botaoDinamicoSubItens);

  componenteFiltro('vendedor', false, false)
  componenteFiltro('guia', false, false)
  componenteFiltro('cliente', false, false, 'Cliente', ["TIPO_ENTIDADE = 'C'"])
  componenteFiltro('servico', false, false);
  componenteFiltro('cliente', false, false, 'Costureira', ["TIPO_ENTIDADE = 'T'"])
  componenteFiltro('cliente', false, false, 'Instalador', ["TIPO_ENTIDADE = 'F'"])
  componenteFiltro('moeda', false, false);
  componenteFiltro('cor', false, false, 'CorTrilho');
  componenteFiltro('produto', false, false);

  $('#tabelaTaxas').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollY: '205px',
    "columns": [
      {
        'title': 'Ação',
        'data': 'acao'
      },
      {
        'title': 'Ordem',
        'data': 'ordem'
      },
      {
        'title': 'Serviço',
        'data': 'servico'
      },
      {
        'title': 'Quantidade',
        'data': 'quantidade'
      },
      {
        'title': 'Valor',
        'data': 'valor'
      },
      {
        'title': 'Valor Total',
        'data': 'valorTotal'
      },
    ]
  });


  $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO"}], "where": ["GRUPO_PA.DESCRICAO LIKE '[PERCENTUAL]CORTINA[PERCENTUAL]'"]}`, [], [], []);
  $('#btnCodigo').pesquisa_array(['#txtCodigo'], ['CHAVE'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO DESCRICAO" ], "leftJoin": [{"tabela":"GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO"}], "where": ["GRUPO_PA.DESCRICAO LIKE '[PERCENTUAL]CORTINA[PERCENTUAL]'"]}`, 'Pesquisa Código', 'CODIGO');
  $('#btnLimpaCodigo').on('click', function () {
    $('#txtCodigo').val('')
  })

  $("#txtTrilhoFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
  $('#btnTrilhoFrontal').pesquisa_serverside(
    ['#txtTrilhoFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
    'Pesquisa de Trilho Frontal'
  );
  $('#btnLimpaTrilhoFrontal').on('click', function () {
    $('#txtTrilhoFrontal').val('')
  })

  $("#txtTrilhoTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
  $('#btnTrilhoTraseiro').pesquisa_serverside(
    ['#txtTrilhoTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TRILHO[PERCENTUAL]'"]
    'Pesquisa de Trilho Traseiro'
  );
  $('#btnLimpaTrilhoTraseiro').on('click', function () {
    $('#txtTrilhoTraseiro').val('')
  })

  $("#txtDeslizFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
  $('#btnDeslizFrontal').pesquisa_serverside(
    ['#txtDeslizFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
    'Pesquisa de Desliz'
  );
  $('#btnLimpaDeslizFrontal').on('click', function () {
    $('#txtDeslizFrontal').val('')
  })

  $("#txtDeslizTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
  $('#btnDeslizTraseiro').pesquisa_serverside(
    ['#txtDeslizTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]DESLIZ[PERCENTUAL]'"]
    'Pesquisa de Desliz Traseiro'
  );
  $('#btnLimpaDeslizTraseiro').on('click', function () {
    $('#txtDeslizTraseiro').val('')
  })

  $("#txtSuporte").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
  $('#btnSuporte').pesquisa_serverside(
    ['#txtSuporte'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
    'Pesquisa de Suporte'
  );
  $('#btnLimpaSuporte').on('click', function () {
    $('#txtSuporte').val('')
  })

  $("#txtSuporteFlange").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
  $('#btnSuporteFlange').pesquisa_serverside(
    ['#txtSuporteFlange'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]SUPORTE[PERCENTUAL]'"]
    'Pesquisa de Suporte Flange'
  );
  $('#btnLimpaSuporteFlange').on('click', function () {
    $('#txtSuporteFlange').val('')
  })

  $("#txtFinalFrontal").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "where": null}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
  $('#btnFinalFrontal').pesquisa_serverside(
    ['#txtFinalFrontal'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "where": null}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
    'Pesquisa de Final Frontal'
  );
  $('#btnLimpaFinalFrontal').on('click', function () {
    $('#txtFinalFrontal').vl('')
  })

  $("#txtFinalTraseiro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "where": null}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
  $('#btnFinalTraseiro').pesquisa_serverside(
    ['#txtFinalTraseiro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "where": null}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FINAL[PERCENTUAL]'"]
    'Pesquisa de Final Traseiro'
  );
  $('#btnLimpaFinalTraseiro').on('click', function () {
    $('#txtFinalTraseiro').val('')
  })

  $("#txtTecido").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["RUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO GERAL[PERCENTUAL]'"]}`);//, "where": ["RUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]
  $('#btnTecido').pesquisa_serverside(
    ['#txtTecido'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO GERAL[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]TECIDO[PERCENTUAL]'"]
    'Pesquisa de Tecido'
  );
  $('#btnLimpaTecido').on('click', function () {
    $('#txtTecido').val('')
    $('.campoBarraTecido').attr('disabled', true)
    $('.campoDuplaTecido').attr('disabled', true)
    $('.campoFranzTecido').attr('disabled', true)
    // $('.campoInverterTecido').attr('disabled', true)

    $('#selectBarraTecido').val('')
    $('#selectDuplaTecido').val('')
    $('#selectFranzTecido').val('')
    $('#selectInverterTecido').val(1)
  })

  $("#txtForro").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]}`); //, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]
  $('#btnForro').pesquisa_serverside(
    ['#txtForro'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]FORRO[PERCENTUAL]'"]
    'Pesquisa de Forro'
  );

  $('#btnLimpaForro').on('click', function () {
    $('#txtForro').val('')
    $('.campoBarraForro').attr('disabled', true)
    $('.campoDuplaForro').attr('disabled', true)
    $('.campoFranzForro').attr('disabled', true)
    // $('.campoInverterForro').attr('disabled', true)

    $('#selectBarraForro').val('')
    $('#selectDuplaForro').val('')
    $('#selectFranzForro').val('')
    $('#selectInverterForro').val(1)
  })

  $("#txtBlackout").autocompleta(1, `JSON={"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO CHAVE", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]}`);//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]
  $('#btnBlackout').pesquisa_serverside(
    ['#txtBlackout'],
    ['MATERIAL.CODIGO'],
    ['MATERIAL.DESCRICAO'],
    `{"tabela": "MATERIAL", "camposSelect": ["MATERIAL.CODIGO", "MATERIAL.DESCRICAO"], "leftJoin": [{"tabela":"GRUPO_MA", "condicao": "GRUPO_MA.CODIGO = MATERIAL.GRUPO"}], "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]}`,//, "where": ["GRUPO_MA.DESCRICAO LIKE '[PERCENTUAL]BLACKOUT[PERCENTUAL]'"]
    'Pesquisa de Blackout'
  );

  $('#btnLimpaBlackout').on('click', function () {
    $('#txtBlackout').val('')
    $('.campoBarraBlackout').attr('disabled', true)
    $('.campoDuplaBlackout').attr('disabled', true)
    $('.campoFranzBlackout').attr('disabled', true)

    $('.campoTrilhoTraseiro').attr('disabled', true)
    $('.campoDeslizTraseiro').attr('disabled', true)
    $('.campoSuporteFlange').attr('disabled', true)
    $('.campoFinalTraseiro').attr('disabled', true)

    $('#selectBarraBlackout').val('')
    $('#selectDuplaBlackout').val('')
    $('#selectFranzBlackout').val('')
    $('#selectInverterBlackout').val(1)

    $('#txtTrilhoTraseiro').val('')
    $('#txtDeslizTraseiro').val('')
    $('#txtSuporteFlange').val('')
    $('#txtFinalTraseiro').val('')

  })

  function retornaBotaoOpcoes(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnDesconto">Desconto/Acréscimo</button>     ' +
      '</div>';
    return retorno;
  };

  function retornaBotaoOpcoesSubItens(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnDesconto">Desconto</button>     ' +
      '</div>';
    return retorno;
  };

  function retornaBotaoOpcoesResultado(data, row) {
    var retorno = '<div style="text-align:start;" class="mx-1"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu" style="max-height: 250px; overflow: scroll;scrollbar-gutter: stable; overflow-inline: auto;"> ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };

  $("#tabelaItens").on("click", "#btnEditar", async function () {
    $('#modalItem').modal('show')

    setTimeout(() => {
      const item = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      const subItens = $('#tabelaSubItens').DataTable().data()

      $('#txtCodigo').val(`[${item.codigo.split('-')[0].trim()}] - ${item.codigo.split('-')[1].trim()}`);
      $('#txtCorTrilho').val(`[${item.cor.split('-')[0].trim()}] - ${item.cor.split('-')[1].trim()}`);
      $('#txtLargura').val(item.largura);
      $('#txtAltura').val(item.altura);
      $('#selectAbertura').val(item.aberturaEm)
      $('#selectKitTrilho').val(item.kitTrilho)
      $('#selectTipoCostura').val(item.tipoCostura)
      $('#selectTipoTrilho').val(item.tipoTrilho)
      $('#txtObsCostureira').val(item.obsCostureira);
      $('#txtAmbienteOrc').val(item.ambiente)

      $('#selectInstalacaoOrc').val(item.instalacao)
      $('#selectComandoOrc').val(item.comando)
      subItens.map((subItem) => {
        switch (subItem.tipoLT) {
          case 'TECIDO':
            $('#txtTecido').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            $('#selectBarraTecido').val(subItem.barra * 100)
            $('#selectDuplaTecido').val(subItem.dupla)
            $('#selectFranzTecido').val(subItem.franzido)
            $('#selectInverterTecido').val(subItem.inverter)
            break;
          case 'FORRO':
            $('#txtForro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            $('#selectBarraForro').val(subItem.barra * 100)
            $('#selectDuplaForro').val(subItem.dupla)
            $('#selectFranzForro').val(subItem.franzido)
            $('#selectInverterForro').val(subItem.inverter)
            break;

          case 'BLACKOUT':
            $('#txtBlackout').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            $('#selectBarraBlackout').val(subItem.barra * 100)
            $('#selectDuplaBlackout').val(subItem.dupla)
            $('#selectFranzBlackout').val(subItem.franzido)
            $('#selectInverterBlackout').val(subItem.inverter)
            break;

          case 'TRILHO_FRONTAL':
            $('#txtTrilhoFrontal').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'TRILHO_TRASEIRO':
            $('#txtTrilhoTraseiro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'DESLIZ_FRONTAL':
            $('#txtDeslizFrontal').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'DESLIZ_TRASEIRO':
            $('#txtDeslizTraseiro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'SUPORTE':
            $('#txtSuporte').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'SUPORTE_FLANGE':
            $('#txtSuporteFlange').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'FINAL_FRONTAL':
            $('#txtFinalFrontal').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'FINAL_TRASEIRO':
            $('#txtFinalTraseiro').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`)
            break;

          case 'PERSONALIZADO':
            $('#txtProduto').val(`[${subItem.codigo.split('-')[0].trim()}] - ${subItem.codigo.split('-')[1].trim()}`);
            $('#txtPrecoPers').val(subItem.valor);
            $('#txtQuantidadePers').val(subItem.quantidade);
            $('#txtCodigo').val('')
            if (item.largura && item.altura) {
              $('#txtQuantidadePers').val(item.quantidade)
            }
            $('#txtComplementoPers').val(subItem.complemento)
            break;

          default:
            break;
        }
      }, 100)
    })
  });

  $('#txtDescontoEmprenho').on('blur', function () {
    retornaTotal();
  });

  function retornaPercDesc() {
    try {
      let desconto = parseFloat($('#txtDescontoEmprenho').val());
      // let percDesconto = 0//parseFloat($('#txtPercDesconto').val());
      // if (desconto > 0) {
      //   let total = 0;
      //   $('#tabelaItens').DataTable().rows().data().map(item => {
      //     total += (item[7] * item[8]);
      //   });
      //   desconto = (desconto * 100) / total;
      //   return desconto;
      // } else if (percDesconto > 0) {
      //   return percDesconto
      // } else {
      //   return 0
      // }
      return desconto
    } catch (error) {
      console.log(error);
    }
  }

  async function retornaTotal() {
    try {
      let total = 0;
      // let desconto = 0;
      let desc = '';
      // desc = retornaDesconto();
      // desconto = await reqRetornaDesconto(desc);
      const percDesc = retornaPercDesc();
      total = parseFloat($('#txtValLiqBackup').val())
      if (percDesc > total) {
        $('#txtDesconto1').val(0)
        return msgAlerta('Desconto não pode ser maior que o valor líquido, verifique!')
      }
      total = total - percDesc//(total * ((desconto + percDesc) / 100));
      // total = total - desconto;
      // insereValor('#txtValLiqBackup', total.toFixed(2));
      insereValor('#txtValorCondicao', (parseFloat(total).toFixed(2)));
    } catch (error) {
      console.log(error);
    } finally {
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
    }
  };

  $('#btnAbrirModalTaxas').on('click', function () {
    $('#modal-taxas').modal('show')
    buscaCalculoItens()
  })

  $("#tabelaItens").on("click", "#btnExcluir", function () {
    let table = $("#tabelaItens").DataTable();
    let idSelecionado = table.row($(this).parents("tr")).data().ordem;

    let i = itens.findIndex(item => item.ordem === idSelecionado);

    if (i !== -1) {
      itens.splice(i, 1);
    }

    table.row($(this).parents("tr")).remove().draw(false);

    table.rows().every(function (index) {
      let data = this.data();
      data.ordem = index + 1;
      this.data(data);
    });

    table.draw(false);

    let tableSubItens = $("#tabelaSubItens").DataTable();
    tableSubItens.rows().remove().draw(false);

    selecionarItemNoGrid(0)
  });

  $("#tabelaResultado").on("click", "#btnExcluir", function () {
    let table = $("#tabelaResultado").DataTable();

    table.row($(this).parents("tr")).remove().draw(false);

    table.rows().every(function (index) {
      let data = this.data();
      data.ordem = index + 1;
      this.data(data);
    });

    table.draw(false);
  });

  await validaEdicao();

  function TrataItens() {
    return itens.map((item) => {
      item.codigo = item.codigo.split('-')[0].trim();
      item.cor = item.cor.split('-')[0].trim();

      item.subItens = item.subItens.map((subItem) => {
        subItem.codigo = subItem.codigo.split('-')[0].trim();
        return subItem; // garante que cada subItem seja retornado
      });

      return item;
    });
  }

  function retornaCondPagto() {
    let arrCondicoes = [];
    let i = 1;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      arrCondicoes.push({
        DIAS: item[0],
        DT_VENCTO: $('#txtDataRec-' + i).val(),
        MOEDA: item[2],
        CODCOND: item[3],
        VALOR: item[5],
        TIPO: 'P',
        NUMERO: pegaValor('#txtNumero'),
        ORDEM: i++
      })
    });
    return arrCondicoes;
  };

  $('#gravar').on('click', async function (event) {
    event.preventDefault();

    if (!$('#txtVendedor').val()) {
      throw msgAlerta('Necessário informar um vendedor para gravar. Por favor, verifique!')
    }
    if (!$('#txtCliente').val()) {
      throw msgAlerta('Necessário informar um cliente para gravar. Por favor, verifique!')
    }
    if (!$('#dtEntrega').val()) {
      throw msgAlerta('Necessário informar uma data de entrega para gravar. Por favor, verifique!')
    }

    let totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });

    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;

    // if ((totalCondPagto != 0) && (TruncaDecimaisNova(2, totalCondPagto) != TruncaDecimaisNova(2, (parseFloat(pegaValor('#txtValorLiq'))) + parseFloat(frete) + parseFloat(despesas)))) {
    //   msgAlerta('Valor das duplicatas geradas não condiz com o total do pedido.');
    //   return false;
    // }
    $.LoadingOverlay("show");
    try {
      const body = {
        id: parseFloat($('#txtNumero').val()),
        codrep: pegaChave('#txtVendedor'),
        codguia: pegaChave('#txtGuia'),
        codcli: pegaChave('#txtCliente'),
        codStatus: pegaChave('#txtStatus'),
        dataEntrega: $('#dtEntrega').val(),
        dataCadastro: $('#dtDigitação').val(),
        dataAlteracao: $('#dtEntrega').val(),
        moeda: pegaChave('#txtMoeda'),
        percDesconto: 0,
        valDesconto: parseFloat($('#txtDescontoEmprenho').val()),
        obs: $('#txtObservacao').val(),
        valorBruto: 0,
        valorLiquido: 0,
        empId: getCookie('emp_id'),
        Itens: TrataItens(),
        COND_PAGTO: pegaChave('#txtCondicao'),
        COND_PAGTOS: retornaCondPagto(),
      }
      const response = await requisicao('POST', '/sisplan/orcamento_cortina/v1/salvar?', `&ID=${$('#txtNumero').val()}`, JSON.stringify(body), 90000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        throw new Error(jsonStr.mensagem);
      }

      criaMensagemSucesso('Orçamento gravado com sucesso.', () => { window.location.href = `${BASE_URI}/orcamento_cortina`; });

    } catch (error) {
      msgErro(error.message || `Não foi possível gravar os dados do orçamento. Por favor, verifique!`);
    } finally {
      $(this).attr('disabled', false);
      $.LoadingOverlay('hide')
    }
  });

  async function CalculaDesconto(campoAlterado) {
    try {
      const listaCamposValores = [
        "#txtPrecoDesc",
        "#txtPercDesconto",
        "#txtValorDesconto",
      ];

      const qtdeProduto = 1// parseFloat($("#txtQuantidadeDesc").val());
      const precoProduto = parseFloat($("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.'));
      const valBruto = parseFloat($("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.'))//parseFloat($("#txtValBruto").val().replaceAll('.', '').replace(',', '.'));
      const percentualDesconto = parseFloat($("#txtPercDesconto").val().replaceAll('.', '').replace(',', '.'));
      const precoAtual = $("#txtPrecoDesc").val();
      // const valorAtual = $(campoAlterado);
      // { limpar os demais campos para não influenciarem no cálculo }
      for (let i = 0; i < listaCamposValores.length; i++) {
        const campo = listaCamposValores[i];
        if (campo != campoAlterado) {
          $(campo).val(0);
        }
      }

      let precoLiq = 0;
      let percDesc = 0;
      let totalLiq = 0;
      let valDesc = 0;

      switch (campoAlterado) {
        case "#txtPercDesconto":
          $("#txtValorDesconto").val(
            ArredondarValor((percentualDesconto / 100) * precoProduto * qtdeProduto, 2).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            })
          );
          valDesc = parseFloat($("#txtValorDesconto").val().replaceAll('.', '').replace(',', '.'));
          precoLiq = quantidadeCasasDecimaisCampo > 2 ? TruncaDecimaisNova(quantidadeCasasDecimaisCampo, precoProduto - valDesc / qtdeProduto,) : TruncaDecimaisNova(2, precoProduto - valDesc / qtdeProduto);
          $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          $("#txtPrecoDesc").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          // totalLiq = TruncaDecimaisNova(2, TruncaDecimaisNova(2, parseFloat(valBruto)) - TruncaDecimaisNova(2, valDesc));
          totalLiq = TruncaDecimaisNova(2, qtdeProduto * precoLiq);
          $("#txtTotalLiq").val(totalLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          $("#txtValorDesconto").val(TruncaDecimaisNova(2, valBruto - totalLiq).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          break;
        case "#txtPrecoDesc":
          if (parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) != precoProduto) {
            if (parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) > precoProduto) {
              $("#txtPrecoLiqDesconto").val(parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));
              $("#txtTotalLiq").val(parseFloat($("#txtPrecoLiqDesconto").val().replaceAll('.', '').replace(',', '.') * qtdeProduto).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));
              $("#txtValorDesconto").val(0);
              $("#txtPercDesconto").val(0);
            } else {
              $("#txtValorDesconto").val(
                TruncaDecimaisNova(2,
                  precoProduto * qtdeProduto -
                  parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) * qtdeProduto
                ).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                })
              );
              valDesc = parseFloat($("#txtValorDesconto").val().replaceAll('.', '').replace(',', '.'));
              percDesc = TruncaDecimaisNova(2,
                (valDesc /
                  valBruto) *
                100
              ).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
              $("#txtPercDesconto").val(percDesc.toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));

              if (parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) <= precoProduto) {
                precoLiq = TruncaDecimaisNova(quantidadeCasasDecimaisCampo, $("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.'));
                $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
                  maximumFractionDigits: quantidadeCasasDecimaisCampo,
                  minimumFractionDigits: quantidadeCasasDecimaisCampo
                }));
                const soma = + precoLiq * qtdeProduto;
                const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
                const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? TruncaDecimaisNova(3, soma) : TruncaDecimaisNova(2, parseFloat(soma));
                $("#txtTotalLiq").val(parseFloat(calculoTotal).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                }));
              }
            }
          } else {
            const soma = + precoProduto * qtdeProduto;
            const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
            const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? TruncaDecimaisNova(3, soma) : TruncaDecimaisNova(2, parseFloat(soma));
            $("#txtTotalLiq").val(parseFloat(calculoTotal).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }));
          }
          break;

        case "#txtValorDesconto":
          valDesc = TruncaDecimaisNova(2, $("#txtValorDesconto").val().replaceAll('.', '').replace(',', '.'));
          percDesc = TruncaDecimaisNova(2,
            (valDesc /
              valBruto) *
            100
          );
          $("#txtPercDesconto").val(percDesc.toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          precoLiq = quantidadeCasasDecimaisCampo > 2 ? TruncaDecimaisNova(quantidadeCasasDecimaisCampo, precoProduto - valDesc / qtdeProduto)
            : TruncaDecimaisNova(2, precoProduto - valDesc / qtdeProduto);
          $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          $("#txtPrecoDesc").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));

          totalLiq = TruncaDecimaisNova(2, qtdeProduto * precoLiq);
          $("#txtTotalLiq").val(totalLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          $("#txtValorDesconto").val(TruncaDecimaisNova(2, valBruto - totalLiq).toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          break;
        default:
          break;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function CalculaAcrescimo(campoAlterado) {
    try {
      const listaCamposValores = [
        "#txtPrecoDesc",
        "#txtPercAcresc",
        "#txtValorAcresc",
      ];

      const qtdeProduto = 1// parseFloat($("#txtQuantidadeDesc").val());
      const precoProduto = parseFloat($("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.'));
      const valBruto = parseFloat($("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.'))//parseFloat($("#txtValBruto").val().replaceAll('.', '').replace(',', '.'));
      const percentualDesconto = parseFloat($("#txtPercAcresc").val().replaceAll('.', '').replace(',', '.'));
      const precoAtual = $("#txtPrecoDesc").val();
      // const valorAtual = $(campoAlterado);
      // { limpar os demais campos para não influenciarem no cálculo }
      for (let i = 0; i < listaCamposValores.length; i++) {
        const campo = listaCamposValores[i];
        if (campo != campoAlterado) {
          $(campo).val(0);
        }
      }

      let precoLiq = 0;
      let percDesc = 0;
      let totalLiq = 0;
      let valDesc = 0;

      switch (campoAlterado) {
        case "#txtPercAcresc":
          $("#txtValorAcresc").val(
            ArredondarValor((percentualDesconto / 100) * precoProduto * qtdeProduto, 2).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            })
          );
          valDesc = parseFloat($("#txtValorAcresc").val().replaceAll('.', '').replace(',', '.'));
          precoLiq = quantidadeCasasDecimaisCampo > 2 ? TruncaDecimaisNova(quantidadeCasasDecimaisCampo, precoProduto + valDesc / qtdeProduto,) : TruncaDecimaisNova(2, precoProduto + valDesc / qtdeProduto);
          $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          $("#txtPrecoDesc").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          // totalLiq = TruncaDecimaisNova(2, TruncaDecimaisNova(2, parseFloat(valBruto)) - TruncaDecimaisNova(2, valDesc));
          totalLiq = TruncaDecimaisNova(2, qtdeProduto * precoLiq);
          $("#txtTotalLiq").val(totalLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          // $("#txtValorAcresc").val(TruncaDecimaisNova(2, valBruto + totalLiq).toLocaleString("pt-BR", {
          //   maximumFractionDigits: 2,
          //   minimumFractionDigits: 2
          // }));
          break;
        case "#txtPrecoDesc":
          if (parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) != precoProduto) {
            if (parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) > precoProduto) {
              $("#txtPrecoLiqDesconto").val(parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));
              $("#txtTotalLiq").val(parseFloat($("#txtPrecoLiqDesconto").val().replaceAll('.', '').replace(',', '.') * qtdeProduto).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));
              $("#txtValorAcresc").val(0);
              $("#txtPercDesconto").val(0);
            } else {
              $("#txtValorAcresc").val(
                TruncaDecimaisNova(2,
                  precoProduto * qtdeProduto -
                  parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) * qtdeProduto
                ).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                })
              );
              valDesc = parseFloat($("#txtValorAcresc").val().replaceAll('.', '').replace(',', '.'));
              percDesc = TruncaDecimaisNova(2,
                (valDesc /
                  valBruto) *
                100
              ).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
              $("#txtPercDesconto").val(percDesc.toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));

              if (parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) <= precoProduto) {
                precoLiq = TruncaDecimaisNova(quantidadeCasasDecimaisCampo, $("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.'));
                $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
                  maximumFractionDigits: quantidadeCasasDecimaisCampo,
                  minimumFractionDigits: quantidadeCasasDecimaisCampo
                }));
                const soma = + precoLiq * qtdeProduto;
                const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
                const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? TruncaDecimaisNova(3, soma) : TruncaDecimaisNova(2, parseFloat(soma));
                $("#txtTotalLiq").val(parseFloat(calculoTotal).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                }));
              }
            }
          } else {
            const soma = + precoProduto * qtdeProduto;
            const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
            const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? TruncaDecimaisNova(3, soma) : TruncaDecimaisNova(2, parseFloat(soma));
            $("#txtTotalLiq").val(parseFloat(calculoTotal).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }));
          }
          break;

        case "#txtValorAcresc":
          valDesc = TruncaDecimaisNova(2, $("#txtValorAcresc").val().replaceAll('.', '').replace(',', '.'));
          percDesc = TruncaDecimaisNova(2,
            (valDesc /
              valBruto) *
            100
          );
          $("#txtPercAcresc").val(percDesc.toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          precoLiq = quantidadeCasasDecimaisCampo > 2 ? TruncaDecimaisNova(quantidadeCasasDecimaisCampo, precoProduto + valDesc / qtdeProduto)
            : TruncaDecimaisNova(2, precoProduto + valDesc / qtdeProduto);
          $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));
          $("#txtPrecoDesc").val(precoLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: quantidadeCasasDecimaisCampo,
            minimumFractionDigits: quantidadeCasasDecimaisCampo
          }));

          totalLiq = TruncaDecimaisNova(2, qtdeProduto * precoLiq);
          $("#txtTotalLiq").val(totalLiq.toLocaleString("pt-BR", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
          // $("#txtValorAcresc").val(TruncaDecimaisNova(2, valBruto + totalLiq).toLocaleString("pt-BR", {
          //   maximumFractionDigits: 2,
          //   minimumFractionDigits: 2
          // }));
          break;
        default:
          break;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaSubItens').on('click', '#btnDesconto', async function (event) {
    event.preventDefault();
    await abreModalDescontoSubItens(this);
  });

  $('#tabelaItens').on('click', '#btnDesconto', async function (event) {
    event.preventDefault();
    await abreModalDesconto(this);
  });

  async function abreModalDesconto(botao) {
    $('#modal-descontos').modal('show')
    let tabelaItens = $("#tabelaItens").DataTable().row(botao.closest('tr')).data();

    $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
    $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
    $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);

    $("#txtPercDesconto").unbind("blur");
    $("#txtPercDesconto").on("blur", function () {
      if ($(this).val() != "" && parseInt($(this).val()) > 0) {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtPercAcresc").attr("disabled", true).attr("readonly", true);
        $("#txtValorAcresc").attr("disabled", true).attr("readonly", true);
        $("#txtPercAcresc").val(0)
        $("#txtValorAcresc").val(0)
        CalculaDesconto("#txtPercDesconto");
      } else {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPrecoDesc").val(0);
        $("#txtValorDesconto").val(0);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        $("#txtPercAcresc").attr("disabled", false).attr("readonly", false);
        $("#txtValorAcresc").attr("disabled", false).attr("readonly", false);
        $("#txtPercAcresc").val(0)
        $("#txtValorAcresc").val(0)
        const valor = TruncaDecimaisNova(2, $("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.') * 1);
        $("#txtTotalLiq").val(parseFloat(valor).toLocaleString("pt-BR", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
      }
    });

    $("#txtValorDesconto").unbind("blur");
    $("#txtValorDesconto").on("blur", function () {
      if ($(this).val() != "" && parseFloat($(this).val().replace(',', '.')) > 0.01) {
        $("#txtPercDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtPercAcresc").attr("disabled", true).attr("readonly", true);
        $("#txtValorAcresc").attr("disabled", true).attr("readonly", true);
        $("#txtPercAcresc").val(0)
        $("#txtValorAcresc").val(0)
        CalculaDesconto("#txtValorDesconto");
      } else {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPercDesconto").val(0);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        $("#txtPercAcresc").attr("disabled", false).attr("readonly", false);
        $("#txtValorAcresc").attr("disabled", false).attr("readonly", false);
        $("#txtPercAcresc").val(0)
        $("#txtValorAcresc").val(0)
        const valor = TruncaDecimaisNova(2, parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) * 1);
        $("#txtTotalLiq").val(parseFloat(valor).toLocaleString("pt-BR", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
      }
    });

    $("#txtPercAcresc").unbind("blur");
    $("#txtPercAcresc").on("blur", function () {
      if ($(this).val() != "" && parseInt($(this).val()) > 0) {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtValorAcresc").attr("disabled", true).attr("readonly", true);
        $("#txtPercDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtPercDesconto").val(0)
        $("#txtValorDesconto").val(0)
        CalculaAcrescimo("#txtPercAcresc");
      } else {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtValorAcresc").attr("disabled", false).attr("readonly", false);
        $("#txtPrecoDesc").val(0);
        $("#txtValorAcresc").val(0);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPercDesconto").val(0)
        $("#txtValorDesconto").val(0)
        const valor = TruncaDecimaisNova(2, $("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.') * 1);
        $("#txtTotalLiq").val(parseFloat(valor).toLocaleString("pt-BR", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
      }
    });

    $("#txtValorAcresc").unbind("blur");
    $("#txtValorAcresc").on("blur", function () {
      if ($(this).val() != "" && parseFloat($(this).val().replace(',', '.')) > 0.01) {
        $("#txtPercAcresc").attr("disabled", true).attr("readonly", true);
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtPercDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtPercDesconto").val(0)
        $("#txtValorDesconto").val(0)
        CalculaAcrescimo("#txtValorAcresc");
      } else {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtPercAcresc").attr("disabled", false).attr("readonly", false);
        $("#txtPercAcresc").val(0);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPercDesconto").val(0)
        $("#txtValorDesconto").val(0)
        const valor = TruncaDecimaisNova(2, parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) * 1);
        $("#txtTotalLiq").val(parseFloat(valor).toLocaleString("pt-BR", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
      }
    });

    $('.maskDesconto').maskMoney({
      decimal: ",",
      thousands: ".",
      precision: quantidadeCasasDecimaisCampo,
    });

    $("#txtProdutoDesc").val(tabelaItens.codigo);
    $("#txtPrecoDesc").val(parseFloat(tabelaItens.subTotal).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));

    $("#txtPrecoOrig").val(parseFloat(tabelaItens.valorOriginal).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));

    $("#txtQuantidadeDesc").val(parseFloat(tabelaItens.quantidade));

    $("#txtPercDesconto").val(parseFloat(tabelaItens.percDesc || 0).toLocaleString("pt-BR", {//tabelaItens[5]
      maximumFractionDigits: 2,
      minimumFractionDigits: 2
    }));

    $("#txtValorDesconto").val(parseFloat(tabelaItens.descUnit || 0).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));

    $("#txtPercAcresc").val(parseFloat(tabelaItens.percAcresc || 0).toLocaleString("pt-BR", {//tabelaItens[5]
      maximumFractionDigits: 2,
      minimumFractionDigits: 2
    }));

    $("#txtValorAcresc").val(parseFloat(tabelaItens.valorAcresc || 0).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));

    $("#txtTotalLiq").val(TruncaDecimaisNova(2, parseFloat(tabelaItens.valorTotal)).toLocaleString("pt-BR", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2
    }));

    $("#pesquisaDescontoConfirmar").unbind("click");
    $("#pesquisaDescontoConfirmar").on("click", async function () {
      await confirmarItens(botao);
    });
    preencheTotais()
  }

  async function confirmarItens() {
    const valorDescTotalInformado = parseFloat($("#txtValorDesconto").val().replaceAll('.', '').replace(',', '.')) || 0;
    const valorAcrescTotalInformado = parseFloat($("#txtValorAcresc").val().replaceAll('.', '').replace(',', '.')) || 0;

    const tabelaItens = $("#tabelaItens").DataTable();
    const dadosItemPrincipal = tabelaItens.row('.selected').data();

    if (!dadosItemPrincipal) {
      $("#modal-descontos").modal("hide");
      return;
    }

    const idItens = itens.findIndex(item => item.ordem === dadosItemPrincipal.ordem);
    if (idItens === -1) return;

    const subItens = itens[idItens].subItens;
    const subItensParaRateio = subItens.filter(sub => sub.un !== 'SE');

    let valorBrutoProdutos = 0;
    let valorBrutoGeral = 0;

    subItens.forEach(sub => {
      let bruto = parseFloat(sub.valorOriginal) ||
        (parseFloat(sub.valorTotal) - (parseFloat(sub.valorAcresc) || 0) + (parseFloat(sub.valDesconto) || 0));

      valorBrutoGeral += bruto;
      if (sub.un !== 'SE') {
        valorBrutoProdutos += bruto;
      }
    });

    if (subItensParaRateio.length === 0) {
      if (valorDescTotalInformado > 0 || valorAcrescTotalInformado > 0) {
        msgErro("Não há itens de produto para aplicar desconto/acréscimo.");
        return;
      }
    }

    let descontoAcumulado = 0;
    let acrescimoAcumulado = 0;

    subItens.forEach((sub) => {
      let valorBrutoAtual = parseFloat(sub.valorOriginal) ||
        (parseFloat(sub.valorTotal) - (parseFloat(sub.valorAcresc) || 0) + (parseFloat(sub.valDesconto) || 0));

      if (sub.un === 'SE') {
        sub.valDesconto = 0; sub.percDesconto = 0;
        sub.valorAcresc = 0; sub.percAcresc = 0;
        sub.valorTotal = TruncaDecimaisNova(2, valorBrutoAtual);
        return;
      }

      const isUltimoProduto = sub === subItensParaRateio[subItensParaRateio.length - 1];

      if (valorAcrescTotalInformado > 0) {
        let acrescimoDesteItem = 0;
        if (isUltimoProduto) {
          acrescimoDesteItem = valorAcrescTotalInformado - acrescimoAcumulado;
        } else {
          acrescimoDesteItem = (valorBrutoAtual / valorBrutoProdutos) * valorAcrescTotalInformado;
          acrescimoDesteItem = parseFloat(TruncaDecimaisNova(2, acrescimoDesteItem));
        }

        sub.valDesconto = 0;
        sub.percDesconto = 0;
        sub.valorAcresc = TruncaDecimaisNova(2, acrescimoDesteItem);
        sub.valorTotal = TruncaDecimaisNova(2, valorBrutoAtual + acrescimoDesteItem);
        sub.percAcresc = TruncaDecimaisNova(2, (acrescimoDesteItem / valorBrutoAtual) * 100);
        acrescimoAcumulado += acrescimoDesteItem; 

      } else {
        let descontoDesteItem = 0;
        if (isUltimoProduto) {
          descontoDesteItem = valorDescTotalInformado - descontoAcumulado;
        } else {
          descontoDesteItem = (valorBrutoAtual / valorBrutoProdutos) * valorDescTotalInformado;
          descontoDesteItem = parseFloat(TruncaDecimaisNova(2, descontoDesteItem));
        }

        sub.valorAcresc = 0;
        sub.percAcresc = 0;
        sub.valDesconto = TruncaDecimaisNova(2, descontoDesteItem);
        sub.valorTotal = TruncaDecimaisNova(2, valorBrutoAtual - descontoDesteItem);
        sub.percDesconto = TruncaDecimaisNova(2, (descontoDesteItem / valorBrutoAtual) * 100);
        descontoAcumulado += descontoDesteItem;
      }
    });

    const novoTotalConsolidado = subItens.reduce((soma, sub) => soma + parseFloat(sub.valorTotal), 0);
    const percDescFinalPai = valorBrutoGeral > 0 ? (valorDescTotalInformado / valorBrutoGeral) * 100 : 0;
    const percAcrescFinalPai = valorBrutoGeral > 0 ? (valorAcrescTotalInformado / valorBrutoGeral) * 100 : 0;

    const campos = {
      valorTotal: TruncaDecimaisNova(2, novoTotalConsolidado),
      descUnit: TruncaDecimaisNova(2, valorDescTotalInformado),
      percDesc: TruncaDecimaisNova(2, percDescFinalPai),
      valorAcresc: TruncaDecimaisNova(2, valorAcrescTotalInformado),
      percAcresc: TruncaDecimaisNova(2, percAcrescFinalPai)
    };

    Object.assign(itens[idItens], campos);
    Object.assign(dadosItemPrincipal, campos);

    tabelaItens.row('.selected').data(dadosItemPrincipal).draw(false);
    $("#tabelaSubItens").DataTable().rows().invalidate().draw(false);
    $("#modal-descontos").modal("hide");
    preencheTotais();
  }

  async function abreModalDescontoSubItens(botao) {
    $('#modal-descontos').modal('show')
    let tabelaSubItens = $("#tabelaSubItens").DataTable().row(botao.closest('tr')).data();

    $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
    $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
    $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);

    $("#txtPercDesconto").unbind("blur");
    $("#txtPercDesconto").on("blur", function () {
      if ($(this).val() != "" && parseInt($(this).val()) > 0) {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", true).attr("readonly", true);
        CalculaDesconto("#txtPercDesconto");
      } else {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPrecoDesc").val(0);
        $("#txtValorDesconto").val(0);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        const valor = TruncaDecimaisNova(2, $("#txtPrecoOrig").val().replaceAll('.', '').replace(',', '.') * 1);
        $("#txtTotalLiq").val(parseFloat(valor).toLocaleString("pt-BR", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
      }
    });

    $("#txtValorDesconto").unbind("blur");
    $("#txtValorDesconto").on("blur", function () {
      if ($(this).val() != "" && parseFloat($(this).val().replace(',', '.')) > 0.01) {
        $("#txtPercDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        CalculaDesconto("#txtValorDesconto");
      } else {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
        $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPercDesconto").val(0);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        const valor = TruncaDecimaisNova(2, parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.')) * 1);
        $("#txtTotalLiq").val(parseFloat(valor).toLocaleString("pt-BR", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
      }
    });

    $('#txtValorAcresc').val(0)
    $('#txtPercAcresc').val(0)

    $('.maskDesconto').maskMoney({
      decimal: ",",
      thousands: ".",
      precision: quantidadeCasasDecimaisCampo,
    });

    $("#txtProdutoDesc").val(tabelaSubItens.codigo);
    $("#txtPrecoDesc").val(parseFloat(tabelaSubItens.valor).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));
    $("#txtPrecoOrig").val(parseFloat(tabelaSubItens.valorOriginal).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));
    $("#txtQuantidadeDesc").val(parseFloat(tabelaSubItens.quantidade));
    $("#txtPercDesconto").val(parseFloat(tabelaSubItens.percDesconto || 0).toLocaleString("pt-BR", {//tabelaSubItens[5]
      maximumFractionDigits: 2,
      minimumFractionDigits: 2
    }));
    $("#txtValorDesconto").val(parseFloat(tabelaSubItens.valorDesconto || 0).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));
    $("#txtPercDesconto").val(parseFloat(tabelaSubItens.percentualDesconto || 0).toLocaleString("pt-BR", {
      maximumFractionDigits: quantidadeCasasDecimaisCampo,
      minimumFractionDigits: quantidadeCasasDecimaisCampo
    }));
    $("#txtTotalLiq").val(TruncaDecimaisNova(2, parseFloat(tabelaSubItens.valorTotal)).toLocaleString("pt-BR", {
      maximumFractionDigits: 2,
      minimumFractionDigits: 2
    }));

    $("#pesquisaDescontoConfirmar").unbind("click");
    $("#pesquisaDescontoConfirmar").on("click", async function () {
      await confirmarSubItens(botao);
    });
    preencheTotais()
  }

  async function confirmarSubItens(botao) {
    const precoDesc = parseFloat($("#txtPrecoDesc").val().replaceAll('.', '').replace(',', '.'));
    const percDesc = parseFloat($("#txtPercDesconto").val().replaceAll('.', '').replace(',', '.'));
    const valorDesc = parseFloat($("#txtValorDesconto").val().replaceAll('.', '').replace(',', '.'));
    const totalLiq = parseFloat($("#txtTotalLiq").val().replaceAll('.', '').replace(',', '.'));

    if (precoDesc <= 0) {
      msgErro("Preço deve ser maior que 0, verifique.");
      return;
    }
    if (percDesc > 99) {
      msgErro("Perc. de desconto deve ser menor que 99, verifique.");
      return;
    }

    const tabelaSubItens = $("#tabelaSubItens").DataTable();
    const linhaSubItem = tabelaSubItens.row(botao.closest('tr'));
    const dadosSubItem = linhaSubItem.data();

    const tabelaItens = $("#tabelaItens").DataTable();
    const dadosItemPrincipal = tabelaItens.row('.selected').data();

    if (!dadosItemPrincipal) {
      console.error("Nenhum item principal selecionado na #tabelaItens.");
      $("#modal-descontos").modal("hide");
      return;
    }

    const ordemDoItemPrincipal = dadosItemPrincipal.ordem;
    const idItens = itens.findIndex(item => item.ordem === ordemDoItemPrincipal);

    if (idItens === -1) {
      console.error("Item principal não encontrado no array global 'itens'.");
      return;
    }

    dadosSubItem.percDesconto = TruncaDecimaisNova(2, percDesc);
    dadosSubItem.valDesconto = TruncaDecimaisNova(2, valorDesc);
    dadosSubItem.valorTotal = TruncaDecimaisNova(2, totalLiq);
    linhaSubItem.data(dadosSubItem).draw(false);

    const subItemIndex = itens[idItens].subItens.findIndex(sub => sub.codigo === dadosSubItem.codigo);

    itens[idItens].subItens[subItemIndex].percDesconto = TruncaDecimaisNova(2, percDesc);
    itens[idItens].subItens[subItemIndex].valDesconto = TruncaDecimaisNova(2, valorDesc);
    itens[idItens].subItens[subItemIndex].valorTotal = TruncaDecimaisNova(2, totalLiq);

    const totalRecalculado = itens[idItens].subItens.reduce((soma, sub) => soma + (parseFloat(sub.valorTotal) || 0), 0);

    itens[idItens].valorTotal = TruncaDecimaisNova(2, totalRecalculado);

    dadosItemPrincipal.valorTotal = TruncaDecimaisNova(2, totalRecalculado);
    tabelaItens.row('.selected').data(dadosItemPrincipal).draw(false);

    $("#modal-descontos").modal("hide");
    $('[data-toggle="tooltip"]').tooltip();
    preencheTotais();
  }

  $('#btnOrcamento').on('click', function () {
    $('#modalItem').modal('show');
  });

  $('#txtCorTrilho').on('blur', async function () {

    $.LoadingOverlay('show')
    try {
      const codigo = pegaChave('#txtCorTrilho');
      if (codigo == '') {
        return;
      }

      $("#txtTrilhoFrontal").autocompleta(
        1,
        `JSON={"tabela": "MATERIAL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["CODIGO IN (SELECT DISTINCT CODIGO FROM [MAT_ITEN] WHERE COR='${pegaChave(
          "#txtCorTrilho"
        )}')"]}`,
        [],
        [],
        [],
      );

      $("#btnTrilhoFrontal").pesquisa_array(
        ["#txtTrilhoFrontal"],
        ["CHAVE"],
        ["DESCRICAO"],
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "MATERIAL", "camposSelect": ["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["CODIGO IN (SELECT DISTINCT CODIGO FROM [MAT_ITEN] WHERE COR='${pegaChave(
          "#txtCorTrilho"
        )}')"]}`,
        "Pesquisa Trilho",
        "MATERIAL",
      )

      $('#btnLimpaCor').on('click', function () {
        $('#txtTrilhoFrontal').val('')
      })

    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  adicionaEventosCampos()
  function adicionaEventosCampos() {
    $('#txtCodigo').on('blur', function () {
      if ($(this).val()) {
        $('.campoProduto').prop('disabled', true)
        $('.campoMaterial').prop('disabled', true)
        $('#txtQuantidadePers').prop('disabled', true)
        $('#txtPrecoPers').prop('disabled', true)

        $('#txtProduto').val('')
        $('#txtMaterial').val('')
        $('#txtQuantidadePers').val('')
        $('#txtPrecoPers').val()
      }
    })

    $('#btnLimpaCodigo').on('click', function () {
      $('.campoProduto').prop('disabled', false)
      $('.campoMaterial').prop('disabled', false)
      $('#txtQuantidadePers').prop('disabled', false)
      $('#txtPrecoPers').prop('disabled', false)
    })

    $('#btnLimpaProduto').on('click', function () {
      $('.campoCodigo').prop('disabled', false)
      $('.campoCorTrilho').prop('disabled', false)
      $('.campoProduto').val('')
      $('.campoCorTrilho').val('')
    })

    $('#btnLimpaMaterial').on('click', function () {
      $('.campoCodigo').prop('disabled', false)
      $('.campoCorTrilho').prop('disabled', false)
      $('.campoProduto').val('')
      $('.campoCorTrilho').val('')
    })

    $('.campoProduto').on('blur', function () {
      if ($(this).val()) {
        $('.campoCodigo').prop('disabled', true)
        $('.campoCorTrilho').prop('disabled', true)
      }
    })
  }

  function retornaCodigo() {
    if ($('#txtProduto').val()) {
      return `${pegaChave('#txtProduto')} - ${pegaDescricao('#txtProduto')}`
    }
    return `${pegaChave('#txtCodigo')} - ${pegaDescricao('#txtCodigo')}`
  }

  function retornaCor() {
    if ($('#txtProduto').val()) {
      return `0 - 0`
    }
    return `${pegaChave('#txtCorTrilho')} - ${pegaDescricao('#txtCorTrilho')}`
  }

  $('#btnConfirmarOrcamento').on('click', function () {
    const tabela = $('#tabelaResultado').DataTable();

    const valorTotal = tabela.rows().data().toArray().reduce((acc, item) => acc + (parseFloat(item.valorTotal) || 0), 0);
    const subTotal = tabela.rows().data().toArray().reduce((acc, item) => acc + (parseFloat(item.valor) || 0), 0);
    const valorUnit = tabela.rows().data().toArray().reduce((acc, item) => acc + (parseFloat(item.valorTotal) || 0), 0);

    let objItens = {};
    objItens.codigo = retornaCodigo();
    objItens.cor = retornaCor();
    objItens.quantidade = $('#txtProduto').val() ? parseFloat($('#txtQuantidadePers').val()) : 1;
    objItens.largura = $('#txtLargura').val();
    objItens.altura = $('#txtAltura').val();
    objItens.aberturaEm = $('#selectAbertura').val();
    objItens.idOrcaDecor = pegaChave('#txtNumero');
    objItens.kitTrilho = $('#selectKitTrilho').val();
    objItens.tipoCostura = $('#selectTipoCostura').val();
    objItens.tipoTrilho = $('#selectTipoTrilho').val();
    objItens.un = "M2";
    objItens.empId = getCookie('emp_id');
    objItens.subTotal = subTotal;
    objItens.valorTotal = TruncaDecimaisNova(2, valorTotal);
    objItens.valorUnit = valorUnit;
    objItens.ambiente = $('#txtAmbienteOrc').val()
    objItens.instalacao = $('#selectInstalacaoOrc').val()
    objItens.comando = $('#selectComandoOrc').val()
    objItens.obsCostureira = $('#txtObsCostureira').val()
    objItens.valorOriginal = TruncaDecimaisNova(2, valorTotal);

    let objSubItens = $('#tabelaResultado').DataTable().data().toArray();
    objItens.subItens = objSubItens;

    let tabelaItens = $('#tabelaItens').DataTable();
    let itensExistentes = tabelaItens.data().toArray();

    let indiceExistente = itensExistentes.findIndex(item =>
      item.codigo === objItens.codigo &&
      item.cor === objItens.cor &&
      item.quantidade == objItens.quantidade &&
      item.altura == objItens.altura &&
      item.largura == objItens.largura &&
      item.kitTrilho == objItens.kitTrilho
    );

    if (indiceExistente >= 0) {
      itens[indiceExistente] = { ...itens[indiceExistente], ...objItens };
    } else {
      objItens.ordem = $('#tabelaItens').DataTable().data().count() + 1;
      itens.push({ ...objItens });
    }

    carregarItensNoGrid(itens);
    preencheTotais();
    $('#modalResultado').modal('hide');
    $('#modalItem').modal('hide');
  });


  async function validaEdicao() {
    if (orcamento != 'create') {
      capaAtual = await buscarOrcamento(orcamento);

      preencherCamposCapa(capaAtual);
      buscaHistoricoOrcamento()
      itens = capaAtual.itens || [];
      carregarItensNoGrid(itens);
      const condicao = await retornaCondicoes(capaAtual.id);
      condicao.map(item => { addCondicao(item) });
    } else {
      $('#txtNumero').val(parseFloat(await RetornaProximo('ORCADECOR', 'ORCADECOR', 'ID', 6)))
      setarDataAtual('dtEntrega');
    }
  }

  async function retornaCondicoes(sNumero) {
    const dadosSelect = {
      tabela: 'COND_PAGTO',
      camposSelect: ['COND_PAGTO.DIAS', 'COND_PAGTO.DT_VENCTO', 'COND_PAGTO.MOEDA', 'COND_PAGTO.VALOR', 'COND_PAGTO.CODCOND', 'CONDICAO.DESCRICAO DESCCOND'],
      leftJoin: [{ tabela: "CONDICAO", condicao: "COND_PAGTO.CODCOND = CONDICAO.CODCOND" }],
      where: [`COND_PAGTO.NUMERO = '${sNumero}' AND TIPO = 'P'`],
      orderBy: [`COND_PAGTO.ORDEM`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar as condições de pagamento.');
      return;
    }
    return retornoSelect;
  };

  function addCondicao(sItem) {
    const inputData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${$('#tabelaCondicao').DataTable().rows().count() + 1}" name="txtDataRec-${$('#tabelaCondicao').DataTable().rows().count() + 1}" value="${sItem.DT_VENCTO}"></input>`;
    $('#tabelaCondicao').DataTable().row.add(
      [
        sItem.DIAS,
        inputData,
        sItem.MOEDA,
        sItem.CODCOND,
        sItem.DESCCOND,
        sItem.VALOR
      ]).draw(false);
  };

  function preencherCamposCapa(capa) {
    $('#txtNumero').val(orcamento);
    $('#txtEmpresa').val(capa.empId);
    setTimeout(() => {
      insereValor('#txtVendedor', capa.codrep, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: capa.codrep })
      insereValor('#txtCliente', capa.codcli, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: capa.codcli })
      if (capa.codguia) {
        insereValor('#txtGuia', capa.codguia, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: capa.codguia })
      }
    }, 200)
    $('#dtEntrega').val(capa.dataEntrega.slice('0', '10'));
    $('#dtDigitacao').val(capa.dataCadastro.slice('0', '10'));
    $('#txtObservacao').val(capa.obs);
    $('#txtDescontoEmprenho').val(capa.valDesconto)
  }

  function carregarItensNoGrid(itens) {
    tabelaItens = $('#tabelaItens').DataTable();
    tabelaItens.clear();

    const arrItens = Array.isArray(itens) ? itens : [itens];

    arrItens.forEach((item) => {
      tabelaItens.row.add(item);
    });
    tabelaItens.draw();

    if (arrItens.length > 0) {
      selecionarItemNoGrid(0);
    }
  }

  function selecionarItemNoGrid(index) {

    tabelaItens.$('tr.selected').removeClass('selected');

    const row = tabelaItens.row(index).node();
    $(row).addClass('selected');

    const itemSelecionado = itens[index];

    $('#txtAmbiente').val(itemSelecionado.ambiente)
    $('#selectInstalacao').val(itemSelecionado.instalacao)
    $('#selectComando').val(itemSelecionado.comando)
    carregarSubItensNoGrid(itemSelecionado.subItens || []);
  }

  function carregarSubItensNoGrid(subItens) {
    tabelaSubItens = $('#tabelaSubItens').DataTable();
    tabelaSubItens.clear();

    (subItens || []).forEach((subitem) => {
      tabelaSubItens.row.add(subitem);
    });
    tabelaSubItens.draw();
  }

  $(document).on('click', '#tabelaItens tbody tr', function () {
    const table = $('#tabelaItens').DataTable().row($(this)).data()
    $('#txtAmbiente').val(table.ambiente)
    $('#selectInstalacao').val(table.instalacao)
    $('#selectComando').val(table.comando)
    const idx = tabelaItens.row(this).index();
    selecionarItemNoGrid(idx);
  });

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  function adicionaDias() {
    $('#txtDiasValidade').on('blur', function () {
      const dias = pegaValor('#txtDiasValidade');

      if (dias == '') {
        return;
      }

      setarDataAtual('dtValidade', false, parseFloat(dias));
    });

    $('#txtDias').on('blur', function () {
      const dias = pegaValor('#txtDias');

      if (dias == '') {
        return;
      }

      if ($('#rdSumDiasCorridos').is(':checked')) {
        consideraDiasCorridos(dias)
      }

      if ($('#rdSumDiasUteis').is(':checked')) {
        consideraDiasUteis(dias)
      }
    });
  }

  function aplicaMascara() {
    $(".camposMascara").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $(".camposMascara").on('blur', function () {
      if (($(this).val() == '0.00') || ($(this).val() == '')) {
        $(this).val('0.00');
      }
    });

    $('.camposMascaraQtde').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    })

    $(".camposMascaraQtde").on('blur', function () {
      if (($(this).val() == '0') || ($(this).val() == '')) {
        $(this).val('0');
      }
    });

    $("#txtDias").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
    $("#txtDiasValidade").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });
  }

  function criaMascaraCampos() {
    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskInteiro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 0,
    });

    $('.maskInteiro').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0');
      }
    });

    $('.blurEnter').on('keydown', function () {
      if (event.key == "Enter") {
        $(this).trigger("blur");
      }
    })
  };

  async function addBotoesAvancarVoltar() {
    $(".next").click(async function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();
      let validator = $("#msform").validate();
      let liberado = true;
      $('#txtValorLiq').val($('#txtTotal').val())
      $('#txtValLiqBackup').val($('#txtTotal').val())
      $('#txtValorCondicao').val($('#txtTotal').val())

      $('#txtDescontoEmprenho').trigger('blur')

      if (liberado) {
        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
        nextFs.show();
        currentFs.animate(
          {
            opacity: 0,
          },
          {
            step(now) {
              opacity = 1 - now;
              currentFs.css({
                display: "none",
                position: "relative",
              });
              nextFs.css({
                opacity,
              });
            },
            duration: 600,
          }
        );
        $("#tabelaItens").DataTable().columns.adjust().draw(false);
        $("#tabelaSubItens").DataTable().columns.adjust().draw(false);
        $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
      }
    });

    $(".previous").click(async function () {
      let currentFs = $(this).parent();
      let previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({ display: "none", position: "relative" });
            previousFs.css({ opacity });
          },
          duration: 600,
        }
      );
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
      $("#tabelaSubItens").DataTable().columns.adjust().draw(false);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    });
  };

  $('#btnDesistir').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      limpaValoresItens()
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  async function buscarOrcamento(orcamento) {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/orcamento_cortina?', `ID=${orcamento}&`, 15000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

      const jsonStr = await response.json();

      return jsonStr

    } catch (error) {
      console.error(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function aplicaInteracoesCampos() {
    $('#modalItem').on('show.bs.modal', function () {
      $('.campoCorTrilho').attr('disabled', false)
      $('.campoTipoCostura').attr('disabled', false)
      $('.campoCostureira').attr('disabled', false)
      $('.campoInstalador').attr('disabled', false)
      $('.campoOpcional').attr('disabled', false)
      $('.campoQuantidade').attr('disabled', false)
      $('.campoObsCostureira').attr('disabled', false)
      $('.campoProduto ').attr('disabled', false)
    })

    $('#txtCorTrilho').on('blur', function () {
      if ($(this).val()) {
        $('.campoLargura').attr('disabled', false)
        $('.campoAltura').attr('disabled', false)
        $('.campoTipoTrilho').attr('disabled', false)
        $('.campoKitTrilho').attr('disabled', false)
        $('.campoAbertura').attr('disabled', false)
      }
    })

    $('#selectTipoTrilho').on('change', function () {
      if ($(this).val() == '0') {
        $('.campoTrilhoFrontal').attr('disabled', false)
        $('.campoTecido').attr('disabled', false)
        // $('.campoInverterTecido').attr('disabled', true)
        $('.campoForro').attr('disabled', true)
        // $('.campoInverterForro').attr('disabled', true)
        $('.campoBlackout').attr('disabled', true)
        // $('.campoInverterBlackout').attr('disabled', true)
      } else {
        $('.campoTrilhoFrontal').attr('disabled', false)
        $('.campoTecido').attr('disabled', false)
        // $('.campoInverterTecido').attr('disabled', true)
        $('.campoForro').attr('disabled', false)
        // $('.campoInverterForro').attr('disabled', true)
        $('.campoBlackout').attr('disabled', false)
        // $('.campoInverterBlackout').attr('disabled', true)
      }
    })

    $('#selectKitTrilho').on('change', function () {
      if ($(this).val() == '1') {
        $('.campoTrilhoTraseiro').attr('disabled', false)
        $('.campoDeslizFrontal').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', false)
        $('.campoSuporte').attr('disabled', false)
        $('.campoSuporteFlange').attr('disabled', false)
        $('.campoFinalFrontal').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', false)
      } else if ($('#selectTipoTrilho').val() != '0' && $('#selectTipoTrilho').val() != '') {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizFrontal').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoSuporte').attr('disabled', false)
        $('.campoSuporteFlange').attr('disabled', true)
        $('.campoFinalFrontal').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', true)
      } else {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizFrontal').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoSuporte').attr('disabled', true)
        $('.campoSuporteFlange').attr('disabled', true)
        $('.campoFinalFrontal').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
      }
    })

    $('#selectTipoCostura').on('change', function () {
      if ($(this).val() == '0') {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
        $('.campoTecido').attr('disabled', false)
        // $('.campoInverterTecido').attr('disabled', false)
        $('.campoForro').attr('disabled', false)
        // $('.campoInverterForro').attr('disabled', false)
        $('.campoBlackout').attr('disabled', false)
        // $('.campoInverterBlackout').attr('disabled', false)
      } else if ($(this).val() == '1') {
        $('.campoTrilhoTraseiro').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', false)
        $('.campoTecido').attr('disabled', false)
        // $('.campoInverterTecido').attr('disabled', false)
        $('.campoForro').attr('disabled', false)
        // $('.campoInverterForro').attr('disabled', false)
        $('.campoBlackout').attr('disabled', false)
        // $('.campoInverterBlackout').attr('disabled', false)
      } else {
        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
        $('.campoTecido').attr('disabled', true)
        // $('.campoInverterTecido').attr('disabled', true)
        $('.campoForro').attr('disabled', true)
        // $('.campoInverterForro').attr('disabled', true)
        $('.campoBlackout').attr('disabled', true)
        // $('.campoInverterBlackout').attr('disabled', true)
      }
    })

    $('#txtTecido').on('blur', function () {
      if ($(this).val()) {
        $('.campoBarraTecido').attr('disabled', false)
        $('.campoDuplaTecido').attr('disabled', false)
        $('.campoFranzTecido').attr('disabled', false)
        // $('.campoInverterTecido').attr('disabled', false)
      } else {
        $('.campoBarraTecido').attr('disabled', true)
        $('.campoDuplaTecido').attr('disabled', true)
        $('.campoFranzTecido').attr('disabled', true)
        // $('.campoInverterTecido').attr('disabled', true)
      }
    })

    $('#txtForro').on('blur', function () {
      if ($(this).val()) {
        $('.campoBarraForro').attr('disabled', false)
        $('.campoDuplaForro').attr('disabled', false)
        $('.campoFranzForro').attr('disabled', false)
        // $('.campoInverterForro').attr('disabled', false)
      } else {
        $('.campoBarraForro').attr('disabled', true)
        $('.campoDuplaForro').attr('disabled', true)
        $('.campoFranzForro').attr('disabled', true)
        // $('.campoInverterForro').attr('disabled', true)
      }
    })

    $('#txtBlackout').on('blur', function () {
      if ($(this).val()) {
        $('.campoBarraBlackout').attr('disabled', false)
        $('.campoDuplaBlackout').attr('disabled', false)
        $('.campoFranzBlackout').attr('disabled', false)
        // $('.campoInverterBlackout').attr('disabled', false)

        $('.campoTrilhoTraseiro').attr('disabled', false)
        $('.campoDeslizTraseiro').attr('disabled', false)
        $('.campoSuporteFlange').attr('disabled', false)
        $('.campoFinalTraseiro').attr('disabled', false)
      } else {
        $('.campoBarraBlackout').attr('disabled', true)
        $('.campoDuplaBlackout').attr('disabled', true)
        $('.campoFranzBlackout').attr('disabled', true)
        // $('.campoInverterBlackout').attr('disabled', true)

        $('.campoTrilhoTraseiro').attr('disabled', true)
        $('.campoDeslizTraseiro').attr('disabled', true)
        $('.campoSuporteFlange').attr('disabled', true)
        $('.campoFinalTraseiro').attr('disabled', true)
      }
    })
  }

  aplicaInteracoesCampos()

  function limpaValoresItens() {
    $('#txtCodigo').val('')
    $('#txtCorTrilho').val('')
    $('#txtLargura').val('')
    $('#txtAltura').val('')
    $('#selectTipoTrilho').val('')
    $('#selectKitTrilho').val('')
    $('#selectAbertura').val('')
    $('#selectTipoCobertura').val('')
    $('#txtTrilhoFrontal').val('')
    $('#txtTrilhoTraseiro').val('')
    $('#txtDeslizFrontal').val('')
    $('#txtDeslizTraseiro').val('')
    $('#txtSuporte').val('')
    $('#txtSuporteFlange').val('')
    $('#txtFinalFrontal').val('')
    $('#txtFinalTraseiro').val('')
    $('#txtTecido').val('')
    $('#selectBarraTecido').val('')
    $('#selectDuplaTecido').val('')
    $('#selectFranzTecido').val('')
    $('#selectInverterTecido').val(1)
    $('#txtForro').val('')
    $('#selectBarraForro').val('')
    $('#selectDuplaForro').val('')
    $('#selectFranzForro').val('')
    $('#selectInverterForro').val(1)
    $('#txtBlackout').val('')
    $('#selectBarraBlackout').val('')
    $('#selectDuplaBlackout').val('')
    $('#selectFranzBlackout').val('')
    $('#selectInverterBlackout').val(1)
    $('#txtCostureira').val('')
    $('#txtInstalador').val('')
    $('#btnLimpaOpcional').trigger('click')
    $('#txtQuantidade').val('')
    $('#txtObsCostureira').val('')

    $('#selectAmbiente').val('')
    $('#selectInstalacao').val('')
    $('#selectComando').val('')

    $('#txtProduto').val('')
    $('#txtQuantidadePers').val('')
    $('#txtPrecoPers').val('')

    selecionarItemNoGrid(0)
  }

  $('#modalItem').on('hidden.bs.modal', function () {
    $('#tabelaItens').DataTable().columns.adjust().draw(false)
    itensAlteracao = []
    limpaValoresItens()
  })

  $('#txtQtde').on('keydown', function (e) {
    if (e.key == ',' || e.key == '.') {
      e.preventDefault();
    }
  });

  $('#txtQtde').on('input', function () {
    this.value = this.value.replace(/[^\d-]/g, '');
    this.value = this.value.replace(/(\d+)[.,](\d+)/, '$1');
  });

  $('#voltarAcesso').on('click', async function () {
    await deletaRegistro('ORCAMENTO_CORTINA', getCookie('usuario'), orcamento);
    window.location.href = `${BASE_URI}/orcamento_cortina`;
  })

  async function informacoesCliente(sChave) {
    const pesquisaParam = {
      tabela: "ENTIDADE",
      camposSelect: [
        "ENTIDADE.CODCLI",
        "ENTIDADE.NOME",
        "ENTIDADE.CNPJ",
        "ENTIDADE.EMAIL",
        "ENTIDADE.DDD_FONE",
        "ENTIDADE.TELEFONE",
        "ENTIDADE.COD_PAIS",
        "ENTIDADE.CEP",
        "CIDADE.NOME CIDADE",
        "CIDADE.COD_UF ESTADO",
        "ENTIDADE.BAIRRO",
        "ENTIDADE.ENDERECO",
        "ENTIDADE.NUMERO",
        "ENTIDADE.COMPLEMENTO",
        "ENTIDADE.OBS",
        "ENTIDADE.INSCRICAO",
        "ENTIDADE.DATA_CAD",
        "ENTIDADE.CLASSIFICA",
        "ENTIDADE.PERFIL",
        "PERFIL.DESCRICAO AS DESC_PERFIL",
        "ENTIDADE.GRUPO",
        "GRUPO_CLI.DESCRICAO AS DESC_GRUPO",
        "ENTIDADE.DESCONTO",
        "ENTIDADE.DT_NASC"
      ],
      leftjoin: [{
        tabela: "CADCEP",
        condicao: "ENTIDADE.CEP = CADCEP.CEP"
      },
      {
        tabela: "CIDADE",
        condicao: "CADCEP.CODMUN = CIDADE.CODIGO"
      },
      {
        tabela: "GRUPO_CLI",
        condicao: "ENTIDADE.GRUPO = GRUPO_CLI.CODIGO"
      },
      {
        tabela: "PERFIL",
        condicao: "ENTIDADE.PERFIL = PERFIL.CODIGO"
      }
      ],
      where: [`ENTIDADE.CODCLI = '${sChave}'`],
      camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "CIDADE.NOME", "CADCEP.ESTCEP"]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    $('#txtCpfInfoCliente').val(jsonStr[0].CNPJ);
    $('#txtEmailInfoCliente').val(jsonStr[0].EMAIL);
    $('#txtDddInfoCliente').val(jsonStr[0].DDD_FONE);
    $('#txtTelefoneInfoCliente').val(jsonStr[0].TELEFONE);
    await concatenaPais(jsonStr[0].COD_PAIS);
    $('#txtCepInfoCliente').val(jsonStr[0].CEP);
    $('#txtMunicipioInfoCliente').val(jsonStr[0].CIDADE);
    $('#txtEstadoInfoCliente').val(jsonStr[0].ESTADO);
    $('#txtBairroInfoCliente').val(jsonStr[0].BAIRRO);
    $('#txtEnderecoInfoCliente').val(jsonStr[0].ENDERECO);
    $('#txtNumeroInfoCliente').val(jsonStr[0].NUMERO);
    $('#txtComplementoInfoCliente').val(jsonStr[0].COMPLEMENTO);
    $('#txtObsInfoCliente').val(jsonStr[0].OBS);
    $('#txtInscricaoInfoCliente').val(jsonStr[0].INSCRICAO);
    const classificacaoEntidadeInfo = jsonStr[0].CLASSIFICA.replace('    ', '');
    if (classificacaoEntidadeInfo != '' && classificacaoEntidadeInfo != 'null' && classificacaoEntidadeInfo != null) {
      $('#txtClassificacaoInfoCliente').val(classificacaoEntidadeInfo);
    }
    if (jsonStr[0].GRUPO != '' && jsonStr[0].GRUPO != null) {
      $('#txtGrupoInfoCliente').val(`[${jsonStr[0].GRUPO}] - ${jsonStr[0].DESC_GRUPO}`);
    };
    if (jsonStr[0].PERFIL != '' && jsonStr[0].PERFIL != null) {
      $('#txtPerfilInfoCliente').val(`[${jsonStr[0].PERFIL}] - ${jsonStr[0].DESC_PERFIL}`);
    };
    $('#txtPercDescontoInfoCliente').val(jsonStr[0].DESCONTO);
  }

  $('#txtCondicao').on('focusout', async function () {
    // geraCondicoes();

    let habilita = pegaChave('#txtCondicao') != '';
    if (habilita) {
      await buscaCondicao(pegaChave('#txtCondicao'));
    };
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtIntervaloDias').prop('disabled', habilita);
    atualizaData();
    // $('#btnAtualizar').trigger('click');
  });

  async function buscaCondicao(sNumero) {
    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['CONDICAO.NRPAR', 'CONDICAO.NRDIA'],
      where: [`CONDICAO.CODCOND = '${sNumero}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados da condição.');
      return;
    };
    insereValor('#txtNrParcelas', retornoSelect[0].NRPAR);
    insereValor('#txtIntervaloDias', retornoSelect[0].NRDIA);
  }

  $('#txtMoeda').on('blur', async function () {
    if (!$(this).val()) {
      return
    }
    $('#txtCondicao').val('');
    $('#txtNrParcelas').val('0');
    $('#txtIntervaloDias').val('0');
    await atualizaData();
    $('#txtCondicao').unbind('autocompleta');
    $('#txtCondicao').autocompleta(1, `JSON={ "tabela":"COND_MOEDA", "camposSelect":["COND_MOEDA.CODCOND CHAVE, CONDICAO.DESCRICAO DESCRICAO"], "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }],"where": [] }`, [], [], []);
    $('#btnCondicao').off();
    $('#btnCondicao').unbind('pesquisa');
    $('#btnCondicao').pesquisa_array(['#txtCondicao'], ['CODCOND'], ['DESCRICAO'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COND_MOEDA", 
                                    "camposSelect":[ "COND_MOEDA.CODCOND", "CONDICAO.DESCRICAO" ],
                                    "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }], 
                                    "where": ["COND_MOEDA.MOEDA = '${pegaChave('#txtMoeda')}'"]}`, 'Pesquisa Condição', 'COND_MOEDA');
    habilitaCondicoes();

    $.LoadingOverlay('show')
    try {
      const dadosSelect = {
        tabela: 'MOEDA',
        camposSelect: ['HISTORICO', 'CODSIT', 'CLASSE'],
        where: [`CODMOE = ${pegaChave('#txtMoeda')}`]
      };
      const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
      if (!retornoSelect) {
        return;
      }
      if (retornoSelect.length == 0) {
        return;
      }

      setTimeout(() => {
        retornaTotal()
      }, 100)
      insereValor('#txtSitDup', retornoSelect[0].CODSIT, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: retornoSelect[0].CODSIT });
      insereValor('#txtHistorico', retornoSelect[0].HISTORICO, { tabela: 'HISTCP', campoBusca: 'DESCRICAO', campoWhere: 'HISTORICO', valorWhere: retornoSelect[0].HISTORICO });
      insereValor('#txtClasseGer', retornoSelect[0].CLASSE, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: retornoSelect[0].CLASSE });
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function habilitaCondicoes() {
    let habilita = await contemCondicao();
    $('#txtCondicao').prop('disabled', habilita);
    $('#btnCondicao').prop('disabled', habilita);
    $('#btnLimpaCondicao').prop('disabled', habilita);
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtIntervaloDias').prop('disabled', habilita);
    $('#dtPrimeiroVencto').prop('disabled', habilita);
    $('#btnLimpar').prop('disabled', habilita);
    $('#btnAtualizar').prop('disabled', habilita);
    $('#txtValorCondicao').val($('#txtValorLiq').val())

    if (habilita) {
      limparTabelaCondicoes();
    }
  };

  async function atualizaData() {
    if ($('#txtIntervaloDias').val() !== '0' || $('#txtIntervaloDias').val() !== '') {
      let intervaloDias;
      let condicao;
      if ($('#txtCondicao').val() != '') {
        condicao = pegaChave('#txtCondicao');

        intervaloDias = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);

        if (intervaloDias != undefined) {
          intervaloDias = intervaloDias.PRAZOINI;
        }
      } else {
        intervaloDias = parseInt($('#txtIntervaloDias').val());
      }

      const dataAtual = new Date();
      const dataVencimento = new Date(dataAtual.setDate(dataAtual.getDate() + intervaloDias));
      $('#dtPrimeiroVencto').val(dataVencimento.toISOString().substr(0, 10));
    } else {
      await setarDataAtual('dtPrimeiroVencto')
    };
  }

  async function contemCondicao() {
    const moeda = pegaChave('#txtMoeda');

    if ((moeda == '') || (moeda == 'null')) {
      return true;
    };

    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['COND_MOEDA.CODCOND'],
      innerJoin: [{ tabela: 'COND_MOEDA', condicao: 'COND_MOEDA.CODCOND = CONDICAO.CODCOND' }],
      where: [`COND_MOEDA.MOEDA = '${moeda}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return true;
    }
    if (retornoSelect.length == 0) {
      return true;
    }
    return false;
  };

  function limparTabelaCondicoes() {
    if ($('#tabelaCondicao').DataTable().rows().count() > 0) {
      $('#tabelaCondicao').empty();
      criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    };
    // $("#dtPrimeiroVencto").val(ne)
  };

  $('#btnAtualizar').on('click', function () {
    const numeroParcelas = $('#txtNrParcelas').val();
    const intervaloDias = $('#txtIntervaloDias').val();
    const dtPrimeiroVencto = $('#dtPrimeiroVencto').val();

    if (numeroParcelas == '') {
      msgAlerta('O número de parcelas não foi preenchido. Não é possível continuar!')
      return
    }
    if (intervaloDias == '') {
      msgAlerta('Intervalo de dias não foi preenchido. Não é possível continuar!')
      return
    }
    if (dtPrimeiroVencto == '') {
      msgAlerta('O primeiro dia de vencimento da parcela não foi preenchido. Não é possível continuar!')
      return
    }

    geraCondicoes();
  });

  $('#btnLimpar').on('click', function () {
    limparTabelaCondicoes();
    limparCamposDias();
    $('#dtPrimeiroVencto').val(new Date().toISOString().slice(0, 10));
    $('#txtCondicao').val('');
    $('#txtNrParcelas').prop('disabled', false);
    $('#txtIntervaloDias').prop('disabled', false);

    $('#txtMoeda').trigger('blur');
  });

  function limparCamposDias() {
    $("#txtNrParcelas, #txtIntervaloDias").val("")
  };

  function limparTabelaCondicoes() {
    if ($('#tabelaCondicao').DataTable().rows().count() > 0) {
      $('#tabelaCondicao').empty();
      criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [5]);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    };
    // $("#dtPrimeiroVencto").val(ne)
  };

  async function geraCondicoes() {
    const dtVencto = pegaValor('#dtPrimeiroVencto').split('-');
    let dataCondicoes = (new Date().toISOString().slice(0, 10)).split('-');
    let venctoTabela = new Date(dataCondicoes[0], dataCondicoes[1] - 1, dataCondicoes[2], 23, 59, 59);
    let vencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    if (vencto < new Date()) {
      msgAlerta('Campo "1º Vencimento" menor que a data atual, impossível continuar!');
      return;
    };
    limparTabelaCondicoes()
    let totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });

    if (totalCondPagto >= (parseFloat(pegaValor('#txtValorLiq'))) + parseFloat($('#txtDescontoEmprenho').val())) {
      msgAlerta('Pagamento total do pedido já preenchido, para alterar necessário limpar as condições.');
      return;
    }

    let data = new Date();
    let dias;
    let total = 0;
    let valor = 0;
    let novoVencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    let novoVenctoTabela = new Date();
    data.setDate(novoVencto.getDate());
    data.setDate(novoVenctoTabela.getDate());
    const parcelas = pegaValor('#txtNrParcelas') == 0 ? 1 : pegaValor('#txtNrParcelas');
    const moeda = pegaChave('#txtMoeda');
    const condicao = pegaChave('#txtCondicao');
    const descCondicao = pegaDescricao('#txtCondicao');
    const intervalo = pegaValor('#txtIntervaloDias');
    const valorPed = pegaValor('#txtValorCondicao');
    let prazoini = parseFloat($('#txtIntervaloDias').val());
    if ($('#txtCondicao').val() != '') {
      prazoini = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);
      if (!!prazoini) {
        prazoini = prazoini.PRAZOINI;
      }
    }
    for (let i = 1; i <= parcelas;) {
      // Nesta primeira parte são calculados os dias dos inputs das condições de pagamento (parte superior)
      dias = diferencaDias(venctoTabela, data);
      dias += prazoini;
      valor = TruncaDecimaisNova(2, valorPed / parcelas);
      total += valor;
      if (i == parcelas) {
        valor = TruncaDecimaisNova(2, valor + (valorPed - total));
      };
      const id = '#txtCondPagto' + i;
      i == 1 && --dias;
      $(id).val(dias);
      // Nesta segunda parte são calculados as datas de vencimento a partir do que estiver informado nos campos intervalo de dias, nr. parcelas e 1º vencimento
      // Estas informações são adicionadas na tabela
      const inputData = `<input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataRec-${i}" name="txtDataRec-${i}" value="${formataData(vencto)}"></input>`
      $('#tabelaCondicao').DataTable().row.add([
        dias,
        inputData,
        moeda,
        condicao,
        descCondicao,
        valor
      ]).draw(false);
      novoVenctoTabela.setDate(venctoTabela.getDate() + parseInt(intervalo));
      venctoTabela = novoVenctoTabela;
      novoVencto.setDate(vencto.getDate() + parseInt(intervalo));
      vencto = novoVencto;
      i++
    }
    atualizaValorCondicao();
    totalCondPagto = 0;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      totalCondPagto += item[5];
    });
    $('#txtValorCondicao').val((parseFloat(pegaValor('#txtValorLiq')) - totalCondPagto - parseFloat($('#txtDescontoEmprenho').val())).toFixed(2));
  };

  function atualizaValorCondicao() {
    let valParcelas = 0;
    const valCondicao = parseFloat(pegaValor('#txtValorCondicao'));
    let frete = somarFreteCondicoes ? pegaValor('#txtFrete') ? parseFloat(pegaValor('#txtFrete')) : 0 : 0;
    frete += somarFreteCondicoes ? pegaValor('#txtFreteTrans') ? parseFloat(pegaValor('#txtFreteTrans')) : 0 : 0;
    const despesas = pegaValor('#txtDespesas') ? parseFloat(pegaValor('#txtDespesas')) : 0;
    const valTotal = parseFloat(pegaValor('#txtValorLiq')) + parseFloat(frete) + parseFloat(despesas);
    // const valTotal = parseFloat(pegaValor('#txtValorLiq'));

    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      valParcelas += item[5];
    });

    if ((valCondicao + valParcelas) > valTotal) {
      insereValor('#txtValorCondicao', (valTotal - valParcelas).toFixed(2));
    }
  }

  function diferencaDias(data1, data2) {
    const diferenca = Math.abs(data1.getTime() - data2.getTime());
    const result = Math.ceil(diferenca / (1000 * 60 * 60 * 24));
    return result;
  };

  async function concatenaPais(sPais) {
    let retorno = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"CADPAIS",
        "camposSelect":["NOME"],
        "where": ["CODIGO = '${sPais}'"]}`,
      null
    );
    let jsonString = await retorno.json();
    if (jsonString.RESULT[0] != 0) {
      insereValor($("#txtPaisInfoCliente"), sPais, jsonString.RESULT[0][0].NOME);
    }
    return
  }

  $('#btn-info-cliente').on('click', async function () {
    const clienteTitulo = $('#txtCliente').val().replace('[', '').replace(']', '').split('-');
    await informacoesCliente(pegaChave("#txtCliente"));
    $('#modal-info-cliente').modal('show');
    $('#txtCodigoTittle').html(`${clienteTitulo[0]}-${clienteTitulo[1]}`);
  });

  aplicaMascara();
  $('#carregaHistoricoStatus').on('click', function () {
    if (orcamento == 'create') {
      return msgAlerta('Não é possível verificar o histórico de um orçamento em criação.')
    }
    $('#modalHistorico').modal('show')
  })

  $('#modalHistorico').on('show.bs.modal', async function () {
    await buscaHistoricoOrcamento()
  })

  const objAbertura = {
    '0': () => 0.20,
    '1': () => 0.30,
    '2': () => 0.40,
    '3': () => 0.50,
    '4': () => 0.60,
    '5': () => 0.70,
    '6': () => 0.80,
    '': () => 0.10
  }

  function calcularMetroLinear(dados) {
    const { larguraTec, franzido, barra, isDupla, inverter, idSeletor } = dados

    const largura = parseFloat($('#txtLargura').val())//inverter != 0 ? parseFloat($('#txtAltura').val()) : parseFloat($('#txtLargura').val())
    const altura = parseFloat($('#txtAltura').val())//inverter != 0 ? parseFloat($('#txtLargura').val()) : parseFloat($('#txtAltura').val())
    const valoAbertura = $('#selectAbertura').val();
    const abertura = (objAbertura[valoAbertura] || objAbertura[''])();
    // const abertura = objAbertura[$('#selectAbertura').val()]() ?? (() => 0.10)()
    let entretela = idSeletor != '#txtBlackout' ? $('#selectTipoCostura').val() == 0 ? 0.15 : 0.25 : 0.25; // esse valor é fixo sempre

    let barras = isDupla ? barra * 2 : barra; // Se for dupla, dobra a barra
    let comprimento = altura + barras + entretela;

    if (comprimento <= larguraTec) {
      // Sem inversão: largura x franzido
      return { metroLinear: ((largura + abertura) * franzido).toFixed(2), largura: largura };
    } else {
      // Com inversão: calcular número de larguras

      let resultado = ((largura + abertura) * franzido) / larguraTec //aqui fiz pra sempre calcular abertura, se não preenche nada por padrão entra 0.10
      let inteiro = Math.floor(resultado);
      let decimal = resultado - inteiro;

      // Arredondamento: >0.15 arredonda para cima, <=0.15 para baixo
      let numLarguras = (decimal > 0.15) ? inteiro + 1 : inteiro;

      return { metroLinear: (comprimento * numLarguras).toFixed(2), largura: numLarguras };
    }
  }

  class DataManager {
    constructor() {
      this.items = [];
    }

    normalizeItem(item, tipo) {
      if (!item) return null;

      if (Array.isArray(item)) {
        return item.map(subItem => ({
          ordem: null,
          tipo: tipo || subItem.tipoLT,
          preco: subItem.preco || subItem.valor || 0,
          ...subItem
        }));
      }

      return [{
        ordem: null,
        tipo: tipo || item.tipoLT,
        nome: item.nome || item.descricao || '',
        preco: item.preco || item.valor || 0,
        ...item
      }];
    }

    adicionaItem(dados, tipo) {
      const normalizedData = this.normalizeItem(dados, tipo);
      if (normalizedData && normalizedData.length > 0) {
        this.items.push(...normalizedData);
      }
    }

    adicionaIds() {
      this.items.forEach((item, index) => {
        item.ordem = index + 1;
      });
    }

    formatarPreco(preco) {
      return new Intl.NumberFormat('pt-BR', {
        style: 'currency',
        currency: 'BRL'
      }).format(preco);
    }

    getItems() {
      return this.items;
    }
  }

  async function retornaItemGenerico({
    idSeletor,
    tipoLT,
    barraSeletor,
    duplaSeletor,
    franzSeletor,
    inverterSeletor,
    quantidade = 1,
    isOpcional = false
  }) {
    try {
      const valorInput = $(idSeletor).val();
      if (!valorInput) return null;

      const barra = parseFloat($(barraSeletor).val() / 100) || 0;
      const isDupla = $(duplaSeletor).val() == 1;
      const franzido = parseFloat($(franzSeletor).val()) || 0;
      const inverter = $(inverterSeletor).val() == 1

      const [larguraTec, un, valor] = await Promise.all([
        buscaValor('MATERIAL', 'LARGURA', 'CODIGO', pegaChave(idSeletor)).then(res => res.LARGURA),
        buscaValor('MATERIAL', 'UNIDADE', 'CODIGO', pegaChave(idSeletor)).then(res => res.UNIDADE),
        buscaValor('TABPRECO', 'PRECO_00', 'CODIGO', `${pegaChave(idSeletor)}' AND REGIAO='00003`).then(res => res.PRECO_00)
      ]);

      if (!larguraTec) {
        throw new Error(`${tipoLT} está sem largura informada para o item: ${$(idSeletor).val()}`)
      }
      if (!valor) {
        throw new Error(`${tipoLT} está sem valor informado na tabela de preço: [00003] - TABELA PREÇO MATERIAL para o item: ${$(idSeletor).val()}`)
      }

      const { metroLinear, largura } = calcularMetroLinear({ larguraTec, franzido, barra, isDupla, inverter, idSeletor });
      const valorTotal = TruncaDecimaisNova(2, valor * metroLinear * quantidade);

      return {
        codigo: `${pegaChave(idSeletor)} - ${pegaDescricao(idSeletor)}`,
        tipoLT,
        tm: 'MP',
        dimensao: `${parseFloat(larguraTec).toFixed(2)}M`,
        partes: `${parseFloat(largura).toFixed(2)} X ${parseFloat(metroLinear / largura).toFixed(2)}`,
        quantidade: metroLinear,
        un,
        valorOriginal: valorTotal,
        valor,
        valorTotal,
        barra: barra.toFixed(2),
        dupla: isDupla ? 1 : 0,
        franzido: franzido.toFixed(2),
        inverter: inverter ? '1' : '0',
        complemento: '',
        percentualDesconto: 0,
        valorDesconto: 0
      };
    } catch (error) {
      msgAlerta(error.message || 'Não foi possível encontrar largura ou preço para o item!')
    }
  }

  async function retornaComposicaoGenerico({
    idSeletor,
    tipoLT,
    barraSeletor,
    duplaSeletor,
    franzSeletor,
    inverterSeletor,
    isOpcional = false
  }) {
    try {
      const valorInput = $(idSeletor).val();
      if (!valorInput) return [];

      const barra = parseFloat($(barraSeletor).val()) / 100 || 0;
      const isDupla = $(duplaSeletor).val() === "1";
      const franzido = parseFloat($(franzSeletor).val()) || 0;
      const inverter = $(inverterSeletor).val() === "1";
      const larguraUsuario = parseFloat($("#txtLargura").val()) || 0;

      let tipoCostura = parseInt($('#selectTipoCostura').val()) || 0;
      if (idSeletor === "#txtBlackout") {
        tipoCostura = 0;
      }

      const composicao = await buscaCaracteristicaTecidos(idSeletor);

      const retornoFinal = [];

      for (const item of composicao) {
        const descricao = item.DESCRICAO?.toUpperCase() || "";
        const isEntretela = descricao.includes("ENTRETELA");
        const isFitaWave = descricao.includes("FITA WAVE");

        const quantidadeItem = TruncaDecimaisNova(2, franzido * larguraUsuario);

        const valorTotal = TruncaDecimaisNova(2, item.CUSTO * quantidadeItem);

        const composicaoBase = {
          codigo: `${item.CODIGO} - ${item.DESCRICAO}`,
          tipoLT,
          tm: "MP",
          dimensao: `${larguraUsuario.toFixed(2)}M`,
          partes: `${larguraUsuario.toFixed(2)} X ${franzido.toFixed(2)}`,
          un: item.UNIDADE,
          quantidade: quantidadeItem,
          valor: item.CUSTO,
          valorOriginal: valorTotal,
          valorTotal,
          complemento: '',
          percentualDesconto: 0,
          valorDesconto: 0,
        };

        if ((isEntretela || isFitaWave) && tipoCostura === 1) {
          retornoFinal.push({ ...composicaoBase });
          retornoFinal.push({ ...composicaoBase });
        } else {
          retornoFinal.push(composicaoBase);
        }
      }

      return retornoFinal;

    } catch (error) {
      console.error("Erro em retornaComposicaoGenerico:", error.message);
      return null;
    }
  }

  async function retornaAdicional(idSeletor, tipoLT) {
    try {
      const valorInput = $(idSeletor).val();
      if (!valorInput) return null;

      // const quantidade = idSeletor == 'txtTrilhoFrontal' || idSeletor == 'txtTrilhoTraseiro' ? calcularTrilhos() : 1;
      const quantidade = await calcularTrilhos(idSeletor)


      let [un, valor] = await Promise.all([
        buscaValor('MATERIAL', 'UNIDADE', 'CODIGO', pegaChave(idSeletor)).then(res => res.UNIDADE),
        buscaValor('TABPRECO', 'PRECO_00', 'CODIGO', `${pegaChave(idSeletor)}' AND REGIAO='00003`).then(res => res.PRECO_00)
      ]);

      if (!valor) valor = 0

      const valorTotal = TruncaDecimaisNova(2, valor * quantidade);

      return {
        codigo: `${pegaChave(idSeletor)} - ${pegaDescricao(idSeletor)}`,
        tipoLT,
        tm: 'MP',
        dimensao: 'INDEFINIDO',
        partes: '',
        quantidade,
        un,
        valor,
        valorTotal,
        valorOriginal: valorTotal,
        complemento: '',
        percentualDesconto: 0,
        valorDesconto: 0,
      };
    } catch (error) {
      console.log(error)
    }
  }

  async function buscaCaracteristicaTrilho(idSeletor) {
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: [
        'CARACT_CONS.COD_MAT CODIGO', 'MATERIAL.DESCRICAO', `CARACT_CONS.QTDE QUANTIDADE`, 'CARACT_CONS.CUSTO', 'MATERIAL.UNIDADE',
      ],
      leftJoin: [
        { tabela: 'CARACT_CONS', condicao: 'CARACT.ID = CARACT_CONS.ID_CARACT' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.ID = CARACT.ID_MAT' },
        { tabela: 'TABLIN', condicao: 'TABLIN.CODIGO = CARACT.COD_LINHA' },
      ],
      where: [`MATERIAL.CODIGO = '${pegaChave(idSeletor)}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    return jsonStr
  }

  async function buscaCaracteristicaTecidos(idSeletor) {
    let jsonStr = ''
    const grupo = (await buscaValor('MATERIAL', 'GRUPO', 'CODIGO', pegaChave(idSeletor))).GRUPO
    const idGrupo = (await buscaValor('GRUPO_MA', 'ID', 'CODIGO', grupo)).ID
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: [
        'CARACT_CONS.COD_MAT CODIGO', 'MATERIAL_CONSUMO.DESCRICAO', `CARACT_CONS.QTDE QUANTIDADE`, 'CARACT_CONS.CUSTO', 'MATERIAL.UNIDADE',
      ],
      leftJoin: [
        { tabela: 'CARACT_CONS', condicao: 'CARACT.ID = CARACT_CONS.ID_CARACT' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.ID = CARACT.ID_MAT' },
        { tabela: 'TABLIN', condicao: 'TABLIN.CODIGO = CARACT.COD_LINHA' },
        { tabela: 'MATERIAL', alias: 'MATERIAL_CONSUMO', condicao: 'MATERIAL_CONSUMO.CODIGO = CARACT_CONS.COD_MAT' },
      ],
      // where: [`MATERIAL.CODIGO = '${pegaChave(idSeletor)}'`],
      where: [`CARACT.ID_GRUPO_MA = '${idGrupo}'`]
    };

    jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    // if (jsonStr.length) {
    //   return jsonStr
    // }

    // const grupo = (buscaValor('MATERIAL', 'GRUPO', 'CODIGO', pegaChave(idSeletor))).GRUPO
    // const idGrupo = (buscaValor('GRUPO_MA', 'ID', 'CODIGO', grupo)).ID

    // delete pesquisaParam.where

    // pesquisaParam.where = [`CARACT.ID_GRUPO_MA = '${idGrupo}'`]
    // jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr
  }

  async function retornaComposicaoTrilhoFrontal() {
    const idSeletor = '#txtTrilhoFrontal';
    if (!$(idSeletor).val()) return [];

    const jsonStr = await buscaCaracteristicaTrilho(idSeletor)

    if (!jsonStr || jsonStr.length == 0) return []
    return jsonStr.map((item) => ({
      codigo: `${item.CODIGO} - ${item.DESCRICAO}`,
      tipoLT: 'COMPOSICAO_TRILHO_FRONTAL',
      tm: 'MP',
      dimensao: 'INDEFINIDO',
      partes: '',
      quantidade: item.QUANTIDADE,
      un: item.UNIDADE,
      valor: item.CUSTO,
      valorTotal: TruncaDecimaisNova(2, item.CUSTO * item.QUANTIDADE),
      valorOriginal: TruncaDecimaisNova(2, item.CUSTO * item.QUANTIDADE),
    }));
  }

  async function retornaConsumosProduto() {
    // Busca o grupo do produto
    const grupo = (await buscaValor('PRODUTO', 'GRUPO', 'CODIGO', pegaChave('#txtCodigo'))).GRUPO;

    // Parâmetros da consulta
    const pesquisaParam = {
      tabela: 'CARACT',
      camposSelect: [
        'CARACT_CONS.COD_MAT CODIGO',
        'MATERIAL_CONSUMO.DESCRICAO',
        'CARACT_CONS.QTDE QUANTIDADE',
        'CARACT_CONS.CUSTO',
        'MATERIAL_CONSUMO.UNIDADE',
      ],
      leftJoin: [
        { tabela: 'CARACT_CONS', condicao: 'CARACT.ID = CARACT_CONS.ID_CARACT' },
        { tabela: 'MATERIAL', alias: 'MATERIAL_CONSUMO', condicao: 'MATERIAL_CONSUMO.CODIGO = CARACT_CONS.COD_MAT' },
      ],
      where: [`CARACT.COD_GRUPO = '${grupo}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    if (!jsonStr || !Array.isArray(jsonStr)) return [];

    const largura = parseFloat($("#txtLargura").val()) || 0;
    const tipoCostura = $('#selectTipoCostura').val();
    const possuiForro = $('#txtForro').val() !== '';
    const possuiBlackout = $('#txtBlackout').val() !== '';

    const calculos = [];
    if (tipoCostura == '1') {
      // Aqui vai calcular separado o tecido e o forro
      calculos.push({ seletor: '#selectFranzTecido', tipo: 'COMPOSICAO_CORTINA' });
      if (possuiForro) calculos.push({ seletor: '#selectFranzForro', tipo: 'COMPOSICAO_CORTINA' });
    } else if (tipoCostura == '0') {
      // Já aqui vai calcular tudo junto, no caso como é junto, meio que o forro sempre segue o que o tecido manda
      calculos.push({ seletor: '#selectFranzTecido', tipo: 'COMPOSICAO_CORTINA' });
    }

    // Blackout: esse cálculo sempre é independente dos outros dois
    if (possuiBlackout) {
      calculos.push({ seletor: '#selectFranzBlackout', tipo: 'COMPOSICAO_CORTINA_BLACKOUT' });
    }

    const retornoFinal = [];

    for (const calc of calculos) {
      const franzido = parseFloat($(calc.seletor).val()) || 0;
      const quantidadeItem = TruncaDecimaisNova(2, franzido * largura);

      const retornoAtual = jsonStr.map((item) => ({
        codigo: `${item.CODIGO} - ${item.DESCRICAO}`,
        tipoLT: calc.tipo,
        tm: 'MP',
        dimensao: 'INDEFINIDO',
        partes: '',
        quantidade: quantidadeItem,
        un: item.UNIDADE,
        valor: item.CUSTO,
        valorTotal: TruncaDecimaisNova(2, item.CUSTO * quantidadeItem),
        valorOriginal: TruncaDecimaisNova(2, item.CUSTO * quantidadeItem),
        complemento: '',
        percentualDesconto: 0,
        valorDesconto: 0,
      }));

      retornoFinal.push(...retornoAtual);
    }

    return retornoFinal;
  }

  async function retornaTaxaConfeccao() {
    const largura = parseFloat($('#txtLargura').val());
    const altura = parseFloat($('#txtAltura').val());
    const taxasConfeccao = [];

    const fetchTaxa = async (grupo, whereExtra) => {
      const pesquisaParam = {
        tabela: 'REGRA_CONSUMO',
        camposSelect: [
          'REGRA_CALCULO.RESULTADO CODIGO, SERVICO.DESCRICAO, SERVICO.PRECO',
        ],
        leftJoin: [
          { tabela: 'REGRA_TABELA', condicao: 'REGRA_CONSUMO.CODIGO = REGRA_TABELA.REGRA' },
          { tabela: 'REGRA_CALCULO', condicao: 'REGRA_CALCULO.REGRA = REGRA_CONSUMO.CODIGO AND REGRA_TABELA.TABELA = REGRA_CALCULO.TABELA' },
          { tabela: 'SERVICO', condicao: 'SERVICO.CODIGO = REGRA_CALCULO.RESULTADO' },
        ],
        // where: [`REGRA_TABELA.PARAMETRO = '(ALTURA_ITEM)' ${whereExtra}`],
        where: [`REGRA_CONSUMO.GRUPO = '${grupo}' AND REGRA_TABELA.PARAMETRO = '(ALTURA_ITEM)' ${whereExtra}`],
        // where: [`REGRA_TABELA.PARAMETRO = '(LARGURA_ITEM)'`],
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (!jsonStr.length) {
        return []
      }
      return {
        codigo: `${jsonStr[0].CODIGO} - ${jsonStr[0].DESCRICAO}`,
        tipoLT: 'TAXA_CONFECCAO',
        tm: 'SE',
        dimensao: 'INDEFINIDO',
        partes: '',
        quantidade: largura,
        un: 'SE',
        valor: jsonStr[0].PRECO,
        valorTotal: TruncaDecimaisNova(2, jsonStr[0].PRECO * largura),
        valorOriginal: TruncaDecimaisNova(2, jsonStr[0].PRECO * largura),
        complemento: '',
        percentualDesconto: 0,
        valorDesconto: 0,
      }

    };

    if ($('#txtTecido').val()) {
      const grupo = (await buscaValor('MATERIAL', 'GRUPO', 'CODIGO', pegaChave('#txtTecido'))).GRUPO;
      taxasConfeccao.push(await fetchTaxa(grupo, `AND ${altura} BETWEEN PARAM_INICIAL AND PARAM_FINAL`));
    }

    if ($('#txtForro').val()) {
      const grupo = (await buscaValor('MATERIAL', 'GRUPO', 'CODIGO', pegaChave('#txtForro'))).GRUPO;
      taxasConfeccao.push(await fetchTaxa(grupo, `AND ${altura} BETWEEN PARAM_INICIAL AND PARAM_FINAL`));
      // taxasConfeccao.push(await fetchTaxa(grupo, `AND PARAM_INICIAL >= ${altura}`));
    }

    return taxasConfeccao;
  }

  async function retornaTaxaInstalacao() {
    const table = $('#tabelaTaxas').DataTable().data()
    if (!table.count()) return

    return table.toArray().map((item) => ({
      codigo: `${pegaChave(item.servico)} - ${pegaDescricao(item.servico)}`,
      tipoLT: 'OPCIONAL',
      tm: 'SE',
      dimensao: 'INDEFINIDO',
      partes: '',
      quantidade: item.quantidade,
      un: 'SE',
      valor: item.valor,
      valorTotal: item.valorTotal,
      valorOriginal: item.valorTotal,
      complemento: '',
      percentualDesconto: 0,
      valorDesconto: 0,
    }));
  }

  $('#txtProduto, #txtMaterial').on('blur', async function () {
    if (!$(this).val()) {
      return
    }
    const preco = await buscaValor('TABPRECO', 'PRECO_00', 'CODIGO', `${pegaChave(this)}' AND REGIAO='00003`).then(res => res.PRECO_00)
    $('#txtPrecoPers').val(preco)
  })

  async function retornaPersonalizacao() {
    if (pegaChave('#txtProduto')) {
      const preco = $('#txtPrecoPers').val()
      const quantidade = parseFloat($('#txtLargura').val()) && parseFloat($('#txtAltura').val()) ? ($('#txtLargura').val() * $('#txtAltura').val()) : parseFloat($('#txtQuantidadePers').val())
      return ({
        codigo: `${pegaChave('#txtProduto')} - ${pegaDescricao('#txtProduto')}`,
        tipoLT: 'PERSONALIZADO',
        tm: 'PO',
        dimensao: 'INDEFINIDO',
        partes: '',
        quantidade: quantidade,
        un: 'PO',
        valor: preco,
        valorTotal: preco * quantidade,
        complemento: $('#txtComplementoPers').val(),
        valorOriginal: preco * quantidade,
        valorDesconto: 0,
        percentualDesconto: 0,
      });
    }
  }

  $('#txtPrecoPers').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  $('#txtPrecoPers').on('blur', function () {
    if ($(this).val() === '0.00' || $(this).val() === '') {
      setTimeout(() => { $(this).val('0.00') }, 0)
    }
  })

  $('#radioProduto, #radioMaterial').on('change', async function () {
    $('#btnProduto').unbind();
    $('#btnMaterial').unbind();
    $('#txtProduto').val('');
    $('#txtMaterial').val('');
    $('#txtQuantidadePers').val('');
    $('#txtPrecoPers').val('');
    if ($('#radioMaterial').is(':checked')) {
      $('#divMaterial').removeClass('d-none')
      $('#divProduto').addClass('d-none')
      $('#txtMaterial').val('');
      $('#txtMaterial').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
      $('#btnMaterial').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ 
        "tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'material');
    } else {
      $('#divMaterial').addClass('d-none')
      $('#divProduto').removeClass('d-none')
      $('#txtProduto').val('');
      $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
      $('#btnProduto').pesquisa_serverside(['#txtProduto'], ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['DESCRICAO', 'CODIGO'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2" ], "where": null}', 'Pesquisa de Produto');
    }

    $('#txtProduto, #txtMaterial').on('blur', async function () {
      if (!$(this).val()) {
        return
      }
      const preco = await buscaValor('TABPRECO', 'PRECO_00', 'CODIGO', `${pegaChave(this)}' AND REGIAO='00003`).then(res => res.PRECO_00)
      $('#txtPrecoPers').val(preco)
    })
    adicionaEventosCampos()
  });

  async function calcularTrilhos(idSeletor) {
    const unidade = (await buscaValor('MATERIAL', 'UNIDADE', 'CODIGO', pegaChave(idSeletor))).UNIDADE;
    if ($('#selectKitTrilho').val() == 1 && unidade == 'MT') {
      return parseFloat($('#txtLargura').val())
    } else {
      return 1
    }
    // const tecido = $('#txtTecido').val().trim() !== '';
    // const forro = $('#txtForro').val().trim() !== '';
    // const blackout = $('#txtBlackout').val().trim() !== '';
    // const tipoCostura = $('#selectTipoCostura').val();

    // //só tecido
    // if (tecido && !forro && !blackout) {
    //   return 1;
    // }

    // //tecido + forro juntos
    // if (tecido && forro && !blackout && tipoCostura === 0) {
    //   return 1;
    // }

    // // tecido + forro separados
    // if (tecido && forro && !blackout && tipoCostura === 1) {
    //   return 2;
    // }

    // // tecido + blackout separados
    // if (tecido && blackout && !forro && tipoCostura === 1) {
    //   return 2;
    // }

    // // tecido + forro juntos + blackout separado
    // if (tecido && forro && blackout && tipoCostura === 0) {
    //   return 2;
    // }

    // // se não bater nenhuma regra, é 1 por padrão
    // return 1;
  }

  async function retornaOrcamento() {
    try {
      const dataManager = new DataManager();

      const [
        tecidos,
        forro,
        blackout,
        // composicaoTecido,
        // composicaoForro,
        // composicaoBlackout,
        trilhoFrontal,
        trilhoTraseiro,
        deslizFrontal,
        deslizTraseiro,
        suporte,
        suporteFlange,
        finalFrontal,
        finalTraseiro,
        composicaoTrilhoFrontal,
        consumosProduto,
        taxasConfeccao,
        taxaInstalacao,
        personalizacao
      ] = await Promise.all([
        retornaItemGenerico({
          idSeletor: '#txtTecido',
          tipoLT: 'TECIDO',
          barraSeletor: '#selectBarraTecido',
          duplaSeletor: '#selectDuplaTecido',
          franzSeletor: '#selectFranzTecido',
          inverterSeletor: '#selectInverterTecido'
        }),
        retornaItemGenerico({
          idSeletor: '#txtForro',
          tipoLT: 'FORRO',
          barraSeletor: '#selectBarraForro',
          duplaSeletor: '#selectDuplaForro',
          franzSeletor: '#selectFranzForro',
          inverterSeletor: '#selectInverterTecido'
        }),
        retornaItemGenerico({
          idSeletor: '#txtBlackout',
          tipoLT: 'BLACKOUT',
          barraSeletor: '#selectBarraBlackout',
          duplaSeletor: '#selectDuplaBlackout',
          franzSeletor: '#selectFranzBlackout',
          inverterSeletor: '#selectInverterTecido',
        }),
        // retornaComposicaoGenerico({
        //   idSeletor: '#txtTecido',
        //   tipoLT: 'COMPOSICAO_TECIDO',
        //   barraSeletor: '#selectBarraTecido',
        //   duplaSeletor: '#selectDuplaTecido',
        //   franzSeletor: '#selectFranzTecido',
        //   inverterSeletor: '#selectInverterTecido'
        // }),
        // retornaComposicaoGenerico({
        //   idSeletor: '#txtForro',
        //   tipoLT: 'COMPOSICAO_FORRO',
        //   barraSeletor: '#selectBarraForro',
        //   duplaSeletor: '#selectDuplaForro',
        //   franzSeletor: '#selectFranzForro',
        //   inverterSeletor: '#selectInverterTecido'
        // }),
        // retornaComposicaoGenerico({
        //   idSeletor: '#txtBlackout',
        //   tipoLT: 'COMPOSICAO_BLACKOUT',
        //   barraSeletor: '#selectBarraBlackout',
        //   duplaSeletor: '#selectDuplaBlackout',
        //   franzSeletor: '#selectFranzBlackout',
        //   inverterSeletor: '#selectInverterTecido',
        // }),
        retornaAdicional('#txtTrilhoFrontal', 'TRILHO_FRONTAL'),
        retornaAdicional('#txtTrilhoTraseiro', 'TRILHO_TRASEIRO'),
        retornaAdicional('#txtDeslizFrontal', 'DESLIZ_FRONTAL'),
        retornaAdicional('#txtDeslizTraseiro', 'DESLIZ_TRASEIRO'),
        retornaAdicional('#txtSuporte', 'SUPORTE'),
        retornaAdicional('#txtSuporteFlange', 'SUPORTE_FLANGE'),
        retornaAdicional('#txtFinalFrontal', 'FINAL_FRONTAL'),
        retornaAdicional('#txtFinalTraseiro', 'FINAL_TRASEIRO'),
        retornaComposicaoTrilhoFrontal(),
        retornaConsumosProduto(),
        retornaTaxaConfeccao(),
        retornaTaxaInstalacao(),
        retornaPersonalizacao()
      ]);

      dataManager.adicionaItem(tecidos, 'Tecidos');
      dataManager.adicionaItem(forro, 'Forro');
      dataManager.adicionaItem(blackout, 'Blackout');

      // composicaoTecido.forEach(item => {
      //   dataManager.adicionaItem(item, 'ComposicaoTecido');
      // });
      // composicaoForro.forEach(item => {
      //   dataManager.adicionaItem(item, 'ComposicaoForro');
      // });
      // composicaoBlackout.forEach(item => {
      //   dataManager.adicionaItem(item, 'ComposicaoBlackout');
      // });

      dataManager.adicionaItem(trilhoFrontal, 'TrilhoFrontal');
      dataManager.adicionaItem(trilhoTraseiro, 'TrilhoTraseiro,');
      dataManager.adicionaItem(deslizFrontal, 'DeslizFrontal,');
      dataManager.adicionaItem(deslizTraseiro, 'DeslizTraseiro,');
      dataManager.adicionaItem(suporte, 'Suporte,');
      dataManager.adicionaItem(suporteFlange, 'SuporteFlange,');
      dataManager.adicionaItem(finalFrontal, 'FinalFrontal,');
      dataManager.adicionaItem(finalTraseiro, 'FinalTraseiro,');

      if (composicaoTrilhoFrontal) {
        composicaoTrilhoFrontal.forEach(item => {
          dataManager.adicionaItem(item, 'ComposicaoTrilhoFrontal');
        });
      }

      if (consumosProduto) {
        consumosProduto.forEach(item => {
          dataManager.adicionaItem(item, 'ConsumosProduto');
        });
      }

      if (taxasConfeccao) {
        taxasConfeccao.forEach(item => {
          dataManager.adicionaItem(item, 'TaxasConfeccao');
        });
      }

      dataManager.adicionaItem(taxaInstalacao, 'TaxaInstalacao');
      dataManager.adicionaItem(personalizacao, 'personalizacao');

      dataManager.adicionaIds();

      $('#modalResultado').modal('show');
      return dataManager.getItems();

    } catch (error) {
      console.log(error)
      msgAlerta(error.message || 'Não foi possível calcular o orçamento dos itens. Por favor, verifique!');
      return [];
    }
  }

  function validaCamposCalculo() {
    if (!$('#txtAmbienteOrc').val()) {
      throw new Error('É necessário inserir um ambiente para prosseguir com o orçamento. Por favor, verifique!')
    }
    if (!$('#selectInstalacaoOrc').val()) {
      throw new Error('É necessário inserir a instalação para prosseguir com o orçamento. Por favor, verifique!')
    }
    if (!$('#selectComandoOrc').val()) {
      throw new Error('É necessário inserir um comando para prosseguir com o orçamento. Por favor, verifique!')
    }
    if (!$('#txtProduto').val() && !$('#txtMaterial').val()) {
      if (!$('#txtCodigo').val()) {
        throw new Error('Necessário informar uma cortina para continuar. Por favor, verifique!')
      }
      if (!$('#txtCorTrilho').val()) {
        throw new Error('Necessário informar uma cor do trilho. Por favor, verifique!')
      }
      if (!$('#txtLargura').val() || $('#txtLargura').val() == '0.00') {
        throw new Error('Necessário informar a largura da cortina. Por favor, verifique!')
      }
      if (!$('#txtAltura').val() || $('#txtAltura').val() == '0.00') {
        throw new Error('Necessário informar a altura da cortina. Por favor, verifique!')
      }
      if (!$('#selectTipoTrilho').val()) {
        throw new Error('Necessário informar um tipo de trilho para continuar. Por favor, verifique!')
      }
      if (!$('#selectKitTrilho').val()) {
        throw new Error('Necessário informar um kit de trilho para continuar. Por favor, verifique!')
      }
      if (!$('#selectAbertura').val()) {
        throw new Error('Necessário informar uma abertura para continuar. Por favor, verifique!')
      }
      if (!$('#selectTipoCostura').val()) {
        throw new Error('Necessário informar um tipo de costura para continuar. Por favor, verifique!')
      }
      if (!$('#txtTrilhoFrontal').val()) {
        throw new Error('Necessário informar um trilho frontal para continuar. Por favor, verifique!')
      }
      // if (!$('#txtTecido').val()) {
      //   throw new Error('Necessário informar um tecido para continuar. Por favor, verifique!')
      // }
      // if (!$('#selectBarraTecido').val()) {
      //   throw new Error('Necessário informar uma barra para o tecido. Por favor, verifique!')
      // }
      // if (!$('#selectDuplaTecido').val()) {
      //   throw new Error('Necessário informar se a barra do tecido é dupla ou não. Por favor, verifique!')
      // }
      // if (!$('#selectFranzTecido').val()) {
      //   throw new Error('Necessário informar o franzido. Por favor, verifique!')
      // }
      // if (!$('#selectInverterTecido').val()) {
      //   throw new Error('Necessário informar se vai vai inverter ou não. Por favor, verifique!')
      // }
    } else {
      if (!$('#txtPrecoPers').val()) {
        throw new Error('Preço para o produto de Personalização não foi informado. Por favor, verifique!')
      }
      if (!$('#txtQuantidadePers').val()) {
        throw new Error('Quantidade para o produto de Personalização não foi informado. Por favor, verifique!')
      }
    }
  }

  $('#calcular').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      validaCamposCalculo()
      const items = await retornaOrcamento();

      if ($.fn.DataTable.isDataTable('#tabelaResultado')) {
        $('#tabelaResultado').DataTable().destroy();
        $('#tabelaResultado').empty();
      }

      $('#tabelaResultado').DataTable({
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        lengthChange: false,
        searching: false,
        paging: false,
        info: false,
        data: items,
        columns: columnsSubItens,
        columnDefs: [
          {
            targets: 0,
            render(data, type, row) {
              return retornaBotaoOpcoesResultado(data, row);
            },
          },
          {
            targets: 0,
            type: "num"
          },
          {
            targets: [3, 11, 12, 13],
            visible: false
          }
        ]
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível calcular o orçamento, verifique!');
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  // $('#txtCodigo').val('[11] - CORTINA WAVE 3.4')
  // $('#txtCorTrilho').val('[0] - UNICA')
  // $('#txtTecido').val('[1002] - RUSTICO PESADO COR 02 290M')
  // $('#txtForro').val('[34832] - MICROFIBRA CLASSICA COR CINZA TAPECARIA 3.00M')
  // $('#selectBarraTecido').val('20')
  // $('#selectBarraForro').val('20')
  // $('#selectDuplaTecido').val(0)
  // $('#selectDuplaForro').val(0)
  // $('#selectFranzTecido').val('2.80')
  // $('#selectFranzForro').val('2.80')
  // $('#selectInverterTecido').val(0)
  // $('#selectInverterForro').val(0)
  // $('#txtLargura').val('2.00')
  // $('#txtAltura').val('2.80')
  // $('#txtTrilhoFrontal').val('[33964] - TC LINHO ROMA COR 04 140M')
  // $('#txtVendedor').val('[62903] - ROSA EUNICE FERREIRA MACARIO')
  // $('#txtCliente').val('[63771] - DANIELA BEZERA FRANCO')
  // $('#selectTipoTrilho').val(1)
  // $('#selectKitTrilho').val(1)
  // $('#selectAbertura').val(1)
  // $('#selectTipoCostura').val(0)
  // $('#txtAmbienteOrc').val('teste')
  // $('#selectInstalacaoOrc').val('Teto')
  // $('#selectComandoOrc').val('Direito')

  async function retornaTotais() {
    const tabelaItens = $('#tabelaItens').DataTable().data().toArray();

    let totais = { totalServico: 0, totalMaterial: 0, total: 0 };

    tabelaItens.forEach(item => {
      const valor = parseFloat(item.valorTotal) || 0;
      totais.total += valor;

      if (item.subItens && item.subItens.length > 0) {
        item.subItens.forEach(sub => {
          const v = parseFloat(sub.valorTotal) || 0;
          if (sub.tm === 'SE') {
            totais.totalServico += v;
          } else {
            totais.totalMaterial += v;
          }
        });
      } else {
        totais.totalMaterial += valor;
      }
    });
    return totais;
  }

  function preencheTotais() {
    retornaTotais().then((result) => {
      $('#txtTotalServico').val(TruncaDecimaisNova(2, result.totalServico))
      $('#txtTotalMaterial').val(TruncaDecimaisNova(2, result.totalMaterial))
      $('#txtTotal').val(TruncaDecimaisNova(2, result.total))
    })
  }

  async function buscaHistoricoOrcamento() {
    if ($.fn.DataTable.isDataTable('#tabelaHistoricoOrcamento')) {
      $('#tabelaHistoricoOrcamento').DataTable().destroy();
      $('#tabelaHistoricoOrcamento').empty();
    };

    const response = await requisicao('GET', '/sisplan/orcamento_cortina/v1/historico?', `ID=${orcamento}&`);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgAlerta(jsonStr.mensagem);
      return;
    }

    const jsonStr = await response.json();

    $('#txtStatus').val(jsonStr[0].OCORRENCIA)

    try {
      $('#tabelaHistoricoOrcamento').DataTable({
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        lengthChange: false,
        searching: false,
        paging: false,
        info: false,
        data: jsonStr,
        columns: columnsHistorico,
        columnDefs: [
          {
            type: 'date-br',
            targets: [3],
            render: function (data) {
              if (data != undefined && data != '') {
                const x = data.slice(0, 10).split('-');
                const hora = data.split(' ')[1];
                if (x[2]) {
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return `${x} ${hora}`;
                }
              } else {
                return '';
              }
            }
          },
        ]
      });

    } catch (error) {
      msgAlerta(error.message || 'Não foi possível encontrar o histórico do orçamento')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  preencheTotais()

  $(".collapse")
    .on("shown.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-right")
        .removeClass("fa-angle-right")
        .addClass("fa-angle-down");
    })
    .on("hidden.bs.collapse", function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });


  function retornaBotaoOpcoesItem() {
    return '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:white"></span></button>  ' +
      '   </div>';
  };

  $('#tabelaTaxas').on('click', '.btn-excluir', async function () {
    const dataTable = $('#tabelaTaxas').DataTable();

    dataTable.rows($(this).closest('tr')).remove();

    const tabela = dataTable.data().toArray();

    tabela.forEach((item, i) => {
      item.ordem = i + 1;
    });

    dataTable.clear().rows.add(tabela).draw(false);
  });

  $('#btnIncluir').on('click', async function () {
    if (!$('#txtServico').val()) {
      return msgAlerta('Necessário informar um serviço. Por favor, verifique!')
    }

    if (!$('#txtQuantidadeTaxa').val()) {
      return msgAlerta('Necessário informar uma quantidade. Por favor, verifique!')
    }
    const valor = await buscaValor('SERVICO', 'PRECO', 'CODIGO', pegaChave('#txtServico')).then(res => res.PRECO);
    const ordem = $('#tabelaTaxas').DataTable().rows().count() + 1
    adicionaTabelaTaxas(
      ordem,
      $('#txtServico').val(),
      $('#txtQuantidadeTaxa').val(),
      valor,
      valor * parseFloat($('#txtQuantidadeTaxa').val())
    );

    $('#txtServico').val('')
    $('#txtQuantidadeTaxa').val('')
  });

  function adicionaTabelaTaxas(ordem, servico, quantidade, valor, valorQuantidade) {
    const item = {
      acao: retornaBotaoOpcoesItem(),
      ordem: ordem,
      servico: servico,
      quantidade: quantidade,
      valor: valor,
      valorTotal: valor * quantidade
    }
    $('#tabelaTaxas').DataTable().row.add(item).draw(false);
  }

  async function buscaCalculoItens(ordem) {
    //   if ($.fn.DataTable.isDataTable('#tabelaTaxas')) {
    //     $('#tabelaTaxas').DataTable().destroy();
    //     $('#tabelaTaxas').empty();
    //   };

    try {
      const table = $('#tabelaSubItens').DataTable()
      const item = table.data().toArray().map((item, i) => {
        if (item.tipoLT == 'OPCIONAL') {
          return {
            ordem: i,
            servico: `[${item.codigo.split('-')[0].trim()}] - ${item.codigo.split('-')[1].trim()}`,
            quantidade: item.quantidade,
            valor: item.valor,
            valorTotal: item.valorTotal
          }
        }
      }).filter(item => item != null)

      $('#tabelaTaxas').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollY: '205px',
        data: item,
        "columns": [
          {
            'title': 'Ação',
            'data': 'acao'
          },
          {
            'title': 'Ordem',
            'data': 'ordem'
          },
          {
            'title': 'Serviço',
            'data': 'servico'
          },
          {
            'title': 'Quantidade',
            'data': 'quantidade'
          },
          {
            'title': 'Valor',
            'data': 'valor'
          },
          {
            'title': 'Valor Total',
            'data': 'valorTotal'
          },
        ],
        columnDefs: [
          {
            render(data, type, row) {
              return retornaBotaoOpcoesItem(data, row);
            },
            targets: 0,
          },
        ]
      });

      setTimeout(() => {
        $("#tabelaTaxas").DataTable().columns.adjust().draw(false);
      }, 200)

    } catch (error) {
      console.error('Erro ao buscar cálculos:', error);
    }
  }

});

