<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Cotações</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.22.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.22.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.22.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.22.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.261.22.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.22.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.22.1" />
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.6.0/css/select.dataTables.min.css">
  <style>
    .table.dataTable tbody td,
    .table.dataTable thead {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .table.dataTable tr td,
    .table.dataTable tr td,
    .table.dataTable th {
      padding: 4px 12px;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Cotações</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">

            </div>
          </div>
        </div>
        <div class="container-fluid d-flex justify-content-center">
          <div class="card">
            <div class="px-2 py-0 col-12">
              <div class="col-sm-12 mt-3">
                <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
                <button class="btn btn-danger btn-sisp" id="btnModalSolicitacao"><span class="fas fa-plus"></span> Solicitação</button>
              </div>
              <div class="form-row col-12">
                <div class="flex flex-column col-12">
                  <h5 class="my-2">Lista de Cotações</h5>
                  <div class="table-responsive">
                    <table id="tabelaItens" class="table table-select table-hover" width="100%">
                      <thead>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="modalFiltros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="form-row col-12">
                <div class="form-group col-xl-2 col-6">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCotacaoDe">Cotação de:</label>
                  <input type="text" class="input-default focus form-control" id="txtCotacaoDe" name="txtCotacaoDe" placeholder="000000000" maxlength="9">
                </div>
                <div class="form-group col-xl-2 col-6">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCotacaoAte">Cotação até:</label>
                  <input type="text" class="input-default focus form-control" id="txtCotacaoAte" name="txtCotacaoAte" placeholder="999999999" maxlength="9">
                </div>
                <div class="form-group col-xl-2 col-6">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPeriodoDe">Período de:</label>
                  <input type="date" value="1200-01-01" max="2500-12-31" class="input-default focus form-control validate" id="txtPeriodoDe" name="DataAte">
                </div>
                <div class="form-group col-xl-2 col-6">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPeriodoAte">Período até:</label>
                  <input type="date" value="2500-12-31" max="2500-12-31" class="input-default focus form-control validate" id="txtPeriodoAte" name="DataAte">
                </div>
                <div class="form-group col-xl-4 col-6">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="selectSituacao">Situação:</label>
                  <div class="input-group">
                    <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectSituacao" aria-describedby="tipoError" class="custom-select focus">
                      <option value="">Todas</option>
                      <option value="A">Pendentes</option>
                      <option value="C">Cotadas</option>
                    </select>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtFornecedor">Fornecedor:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtFornecedor" name="txtFornecedor" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFornecedor" name="btnFornecedor" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaFornecedor" name="btnLimpaFornecedor" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtMaterial">Material:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMaterial" name="txtMaterial" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMaterial" name="btnMaterial" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaMaterial" name="btnLimpaMaterial" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtProduto">Produto:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtServico">Serviço:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtServico" name="txtServico" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnServico" name="btnServico" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaServico" name="btnLimpaServico" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtComprador">Comprador:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtComprador" name="txtComprador" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnComprador" name="btnComprador" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaComprador" name="btnLimpaComprador" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtUsuario">Usuário:</label>
                  <input type="text" class="input-default focus form-control" id="txtUsuario" name="txtUsuario" placeholder="Usuário">
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitacao">Solicitação:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtSolicitacao" name="txtSolicitacao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnSolicitacao" name="btnSolicitacao" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaSolicitacao" name="btnLimpaSolicitacao" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtSolicitante">Solicitante (Solicitação):</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtSolicitante" name="txtSolicitante" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnSolicitante" name="btnSolicitante" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaSolicitante" name="btnLimpaSolicitante" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCentroCusto">Centro de Custo (Solicitação):</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtCentroCusto" name="txtCentroCusto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCentroCusto" name="btnCentroCusto" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaCentroCusto" name="btnLimpaCentroCusto" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-xl-6 col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtTipo">Tipo (Solicitação):</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtTipo" name="txtTipo" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTipo" name="btnTipo" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaTipo" name="btnLimpaTipo" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div
        class="modal fade"
        data-backdrop="static"
        id="modalSolicitacao"
        tabindex="-1"
        role="dialog"
        aria-labelledby="modalSolicitacao"
        aria-hidden="true">
        <div class="modal-dialog" style="min-width: 85%; min-height: 100%">
          <div class="modal-content">
            <div class="modal-header">
              <h4 class="modal-title">Cotação</h4>
              <button
                type="button"
                class="close"
                data-dismiss="modal"
                aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body pb-0">
              <div class="form-row">
                <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtNumeroConsultaSolicitacao">Solicitação:</label>
                  <div class="input-group">
                    <input
                      autocomplete="off"
                      type="text"
                      class="input-default focus form-control campoModalSolicitacao"
                      id="txtNumeroConsultaSolicitacao"
                      name="NumeroConsulta"
                      placeholder="Solicitação" />
                    <div class="input-group-append">
                      <button
                        class="btn bg-danger"
                        id="btnNumeroConsultaSolicitacao"
                        name="btnNumeroConsultaSolicitacao"
                        data-button="absolute"
                        type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button
                        class="btn bg-danger"
                        id="btnLimpaNumeroConsultaSolicitacao"
                        name="btnLimpaNumeroConsultaSolicitacao"
                        type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-xl-3 col-12 form-group px-0 mx-0">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtFornecedorSolicitacao">Fornecedores:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtFornecedorSolicitacao" name="FornecedorSolicitacao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFornecedorSolicitacao" name="btnFornecedorSolicitacao" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnLimpaFornecedorSolicitacao" name="btnLimpaFornecedorSolicitacao" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtValidadeSolicitacao">Validade:</label>
                  <input
                    autocomplete="off"
                    type="date"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtValidadeSolicitacao"
                    name="dataValidade" />
                </div>
              </div>
              <div class="form-row">
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtNumeroSolicitacao">Número:</label>
                  <input
                    autocomplete="off"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtNumeroSolicitacao"
                    placeholder="Número"
                    name="numero"
                    readonly />
                </div>
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtUsuarioSolicitacao">Usuário:</label>
                  <input
                    autocomplete="off"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtUsuarioSolicitacao"
                    placeholder="Usuário"
                    name="usuario"
                    readonly />
                </div>
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtCadastroSolicitacao">Cadastro:</label>
                  <input
                    autocomplete="off"
                    type="date"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtCadastroSolicitacao"
                    name="dataCadastro"
                    readonly />
                </div>
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtEmissaoSolicitacao">Emissão:</label>
                  <input
                    autocomplete="off"
                    type="date"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtEmissaoSolicitacao"
                    placeholder="Especificação"
                    name="dataEmissao"
                    disabled />
                </div>
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtEntregaSolicitacao">Entrega:</label>
                  <input
                    autocomplete="off"
                    type="date"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtEntregaSolicitacao"
                    placeholder="Especificação"
                    name="dataEntrega"
                    disabled />
                </div>
                <div class="col-xl-1 col-md-2 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtBaixaSolicitacao">Baixa:</label>
                  <input
                    type="date"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtBaixaSolicitacao"
                    placeholder="Especificação"
                    name="dataBaixa"
                    disabled />
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtSolicitanteSolicitacao">Solicitante:</label>
                  <input
                    autocomplete="off"
                    type="text"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtSolicitanteSolicitacao"
                    name="solicitante"
                    placeholder="Solicitante"
                    disabled />
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtPrazoSolicitacao">Prazo:</label>
                  <input
                    autocomplete="off"
                    type="text"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtPrazoSolicitacao"
                    name="prazo"
                    placeholder="Prazo"
                    disabled />
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtMotivoSolicitacao">Motivo:</label>
                  <input
                    autocomplete="off"
                    type="text"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtMotivoSolicitacao"
                    name="motivo"
                    placeholder="Motivo"
                    disabled />
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtTipoSolicitacao">Tipo:</label>
                  <input
                    autocomplete="off"
                    type="text"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtTipoSolicitacao"
                    name="tipo"
                    placeholder="Tipo"
                    disabled />
                </div>
                <div class="col-xl-6 col-lg-4 col-md-6 col-12 form-group">
                  <label
                    data-error="wrong"
                    class="labelGeral"
                    data-success="right"
                    for="txtObservacaoSolicitacao">Observação:</label>
                  <input
                    autocomplete="off"
                    class="input-default focus form-control campoModalSolicitacao"
                    id="txtObservacaoSolicitacao"
                    placeholder="Observação"
                    name="observacao"
                    disabled />
                </div>
              </div>
              <div class="form-row col-12">
                <div class="table-responsive">
                  <table id="tabelaItensSolicitacao" class="table table-select table-hover" width="100%">
                    <thead>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button
                type="button"
                class="btn btn-primary btn-sisp"
                id="btnConfirmarSolicitacao">
                Confirmar
              </button>
              <button
                class="btn btn-danger btn-sisp"
                class="close"
                data-dismiss="modal"
                aria-label="Close"
                id="btnCancelarSolicitacao">
                Cancelar
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../../modais.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.22.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.22.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/sisplan.js?versao=3.261.22.1"></script>
  <script src="utils/funcoes.js?versao=3.261.22.1"></script>
  <script src="utils/cookies.js?versao=3.261.22.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.22.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.261.22.1"></script>
  <script src="dist/js/driver.min.js?versao=3.261.22.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.22.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.261.22.1"></script>
  <script type="text/javascript" src="config.js?versao=3.261.22.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.261.22.1"></script>
  <script src="https://cdn.datatables.net/select/1.6.0/js/dataTables.select.min.js"></script>

  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('COTACAO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/cotacao/acesso_cotacao/acesso_cotacao.js?versao=3.261.22.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>