$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtras as cores cadastradas.",
          position: "right",
        },
      },
      {
        element: "#btnNovaCor",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de uma cor.",
          position: "right",
        },
      },
      {
        element: "#tabelaCor",
        popover: {
          title: "Tabela Cores",
          description: "Aqui estão todas as cores cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("COR");
  let caminhoFoto = 'dist/img/prod-1.png';
  let encontrouFoto = 0;
  let registrosSelecionados = []

  componenteFiltro('entidade', false, false, 'Cliente')
  componenteFiltro('entidade', false, false, 'ClienteAlterarDados')
  componenteFiltro('produto', true, false, 'ProdutoUtilizacao')
  componenteFiltro('material', true, false, 'MaterialUtilizacao')

  // autocompleta
  $("#txtGrupoCorConsulta").autocompleta(1, `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#txtCorConsulta").autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":[ "cor chave", "descricao descricao"], "where": null}`);
  $("#txtClasseComercial").autocompleta(1, `JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#txtSubGrupoCor").autocompleta(1, `JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  // pesquisa
  $("#btn-ClasseComercial").pesquisa("#txtClasseComercialConsulta", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Classe Comercial", "CLASSE_COR");
  $("#btn-GrupoCor").pesquisa("#txtGrupoCorConsulta", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Grupo Cor", "GRUPO_COR");
  $("#btn-SubGrupoCor").pesquisa("#txtSubGrupoCorConsulta", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Grupo Cor", "SUBGRUPO_COR");
  $("#btn-Cor").pesquisa("#txtCorConsulta", "COR", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":[ "cor", "descricao", "codigo2"]}`, "Pesquisa Cor", "cadcor");


  $("#txtGrupoAlterarDados").autocompleta(1, `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#txtSubGrupoAlterarDados").autocompleta(1, `JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#txtClasseComercialAlterarDados").autocompleta(1, `JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  $("#btnGrupoAlterarDados").pesquisa("#txtGrupoAlterarDados", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Grupo Cor", "GRUPO_COR");
  $("#btnSubGrupoAlterarDados").pesquisa("#txtSubGrupoAlterarDados", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Grupo Cor", "SUBGRUPO_COR");
  $("#btnClasseComercialAlterarDados").pesquisa("#txtClasseComercialAlterarDados", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Classe Comercial", "CLASSE_COR");

  $("#txtUtilizacao").autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":[ "cor chave", "descricao descricao"], "where": null}`);
  $("#txtGrupoUtilizacao").autocompleta(1, `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

  $("#btnGrupoUtilizacao").pesquisa("#txtGrupoUtilizacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Grupo Cor", "GRUPO_COR");
  $("#btnSubGrupoUtilizacao").pesquisa("#txtSubGrupoUtilizacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SUBGRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Grupo Cor", "SUBGRUPO_COR");

  // limpacampo
  $("#btn-limpa-ClasseComercial").on("click", function () {
    $("#txtClasseComercialConsulta").val("");
  });
  $("#btn-limpa-GrupoCor").on("click", function () {
    $("#txtGrupoCorConsulta").val("");
  });
  $("#btn-limpa-SubGrupoCor").on("click", function () {
    $("#txtSubGrupoCorConsulta").val("");
  });
  $("#btn-limpa-Cor").on("click", function () {
    $("#txtCorConsulta").val("");
  });
  $("#btnLimpaGrupoAlterarDados").on("click", function () {
    $("#txtGrupoAlterarDados").val("");
  });
  $("#btnLimpaSubGrupoAlterarDados").on("click", function () {
    $("#txtSubGrupoAlterarDados").val("");
  });
  $("#btnLimpaClasseComercialAlterarDados").on("click", function () {
    $("#txtClasseComercialAlterarDados").val("");
  });


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  function retornaCampoRGB(rgb) {
    const r = rgb.substring(0, 3);
    const g = rgb.substring(3, 6);
    const b = rgb.substring(6, 9);

    const hexR = ("0" + parseInt(r, 10).toString(16)).slice(-2);
    const hexG = ("0" + parseInt(g, 10).toString(16)).slice(-2);
    const hexB = ("0" + parseInt(b, 10).toString(16)).slice(-2);

    const hex = '#' + hexR + hexG + hexB;

    var retorno = '<div class="form-group" style="margin-bottom: 0.2rem !important; margin-top: 0.2rem !important"> ' +
      `     <input type="color" disabled class="input-default" value="${hex}" id="inputColorRGBAcesso"></input>` +
      '</div>';

    return retorno;
  };

  await ConsultaCor();

  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovaCor").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cor/Y3JlYXRl";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaCor(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtCorConsulta").val("");
    $("#txtGrupoCorConsulta").val("");
    $("#txtSubGrupoCorConsulta").val("");
    $("#txtGrupoCorConsulta").val("");
    $("#txtClasseComercialConsulta").val("");
    $("#txtCliente").val("");
  });

  async function retornaFaixaTamanho(codigos) {
    const codigo = codigos.map((item) => {
      return `'${item}'`;
    }).join();
    const dadosSelect = {
      tabela: 'FAIXA_ITEN',
      camposSelect: [
        'PRODUTO.CODIGO',
        'FAIXA_ITEN.TAMANHO',
      ],
      leftJoin: [{ tabela: 'PRODUTO', condicao: 'FAIXA_ITEN.FAIXA = PRODUTO.FAIXA' }],
      where: [`PRODUTO.CODIGO IN (${codigo.toString()}) `],
    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

    return data
  }

  $('#btnIncluirCorProduto').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      const produtos = $('#txtProdutoUtilizacao').val();

      if (produtos.length == 0) {
        msgAlerta('Informe um código de produto para adicionar a cor!')
        return;
      }
      const cores = []
      const data = $('#tabelaProdutosUtilizacao').DataTable().rows().data().toArray().map(item => item.CODIGO);
      const produtosCadastrar = produtos.filter(codigo => !data.includes(codigo));
      if (produtosCadastrar.length === 0) {
        msgAlerta('Os códigos informados já existem para esta cor. Por favor, insira códigos diferentes para continuar!')
        return
      }
      const faixas = await retornaFaixaTamanho(produtosCadastrar)

      registrosSelecionados.forEach((e) => {
        faixas.forEach((faixa) => {
          cores.push({
            Codigo: faixa.CODIGO,
            Cor: e.cor,
            Tam: faixa.TAMANHO,
          });
        });
      });

      const obj = { cores }
      if (cores.length == 0) {
        msgAlerta('Produtos informados já utilizam essa cor!')
        return;
      }
      const response = await requisicao('POST', `/sisplan/produto/v1/grava_cor_produto?`, '', JSON.stringify(obj));
      if (!response) {
        return;
      };

      if (response.status != 200) {
        msgErro('Erro ao vincular a cor ao produto.');
        return;
      }

      const filtros = {
        cor: registrosSelecionados.map((e) => `'${e.cor}'`).join(',')
      }

      await retornaInfosProduto(filtros.cor)

      toastr.success("A cor foi adicionada ao produto com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });


    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#btnIncluirCorMaterial').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      const materiais = $('#txtMaterialUtilizacao').val();
      if (materiais.length == 0) {
        msgAlerta('Informe um código de material para adicionar a cor!')
        return;
      }
      const cores = []
      const data = $('#tabelaMateriaisUtilizacao').DataTable().rows().data().toArray().map(item => item.CODIGO);

      const materiaisCadastrar = materiais.filter(codigo => !data.includes(codigo));

      if (materiaisCadastrar.length === 0) {
        msgAlerta('Os códigos informados já existem para esta cor. Por favor, insira códigos diferentes para continuar!')
        return
      }
      registrosSelecionados.forEach((e) => {
        for (let j = 0; j < materiaisCadastrar.length; j++) {
          cores.push({
            Codigo: materiaisCadastrar[j],
            Cor: e.cor,
          })
        }
      })

      const obj = { cores }

      if (cores.length == 0) {
        msgAlerta('Materiais informados já utilizam essa cor!')
        return;
      }
      const response = await requisicao('POST', `/sisplan/material/v1/grava_cor_material?`, '', JSON.stringify(obj));
      if (!response) {
        return;
      };

      if (response.status != 200) {
        msgErro('Erro ao vincular a cor ao material.');
        return;
      }

      const filtros = {
        cor: registrosSelecionados.map((e) => `'${e.cor}'`).join(',')
      }

      await retornaInfosMateriais(filtros.cor)

      toastr.success("A cor foi adicionada ao material com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function buscaFotoCor(corBusca) {
    const responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!responsej) {
      return;
    };
    const jsonStr = await responsej.json();
    const pastaFoto = jsonStr.mensagem;
    const pastaCor = pastaFoto + '\\COR\\';
    try {
      const urlRequisicao = '/Sisplan/Funcoes/v1/fotocor?';
      const response = await requisicao('GET', urlRequisicao, `CODIGO=${corBusca}&PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${corBusca}.jpg`, null);

      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        $(`#imgFoto${corBusca}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        return;
      }

      const sBase64 = jsonStr;
      $(`#imgFoto${corBusca}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
      console.error(error);
      $(`#imgFoto${corBusca}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  };

  async function ConsultaCor(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      const cor = pegaChave("#txtCorConsulta") != "" ? ` AND COR = '${pegaChave("#txtCorConsulta")}'` : "";
      const grupoCor = pegaChave("#txtGrupoCorConsulta") != "" ? ` AND GRUPO = '${pegaChave("#txtGrupoCorConsulta")}'` : "";
      const subgrupoCor = pegaChave("#txtSubGrupoCorConsulta") != "" ? ` AND SUBGRUPO = '${pegaChave("#txtSubGrupoCorConsulta")}'` : "";
      const classecomercial = pegaChave("#txtClasseComercialConsulta") != "" ? ` AND CLASSE_COR = '${pegaChave("#txtClasseComercialConsulta")}'` : "";
      const cliente = pegaChave("#txtCliente") != "" ? ` AND TINTURARIA = '${pegaChave("#txtCliente")}'` : "";
      const status = $('.cbStatusCor:checked').val() != '' ? ` AND INATIVO = '${$('.cbStatusCor:checked').val()}'` : '';

      $("#tabelaCor").DataTable({
        paging: true,
        lengthChange: true,
        serverSide: true,
        filter: true,
        destroy: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{"tabela":"CADCOR",`+
            `"camposSelect":[ "'' SEL", "CADCOR.COR", "CADCOR.DESCRICAO", "CADCOR.CODIGO2", "CADCOR.RGB", "CADCOR.SEQ", "CADCOR.INATIVO"],`+
            `"camposWhereServerSide": ["CADCOR.COR", "CADCOR.DESCRICAO", "CADCOR.CODIGO2"],`+
            `"where": ["1=1 ${cor} ${grupoCor} ${subgrupoCor} ${classecomercial} ${cliente} ${status} "]}`,
            CLIENTE: "N",
          },
        },
        autoWidth: true,
        columnDefs: [
          {
            targets: [0], render: function (_data, _type, row, meta) {
              return `<div class="icheck-primary d-inline">
                      <input type="checkbox" ${registrosSelecionados.find(e => e.cor === row[1]) && 'checked'} id="check_col_${meta.row}_row_${meta.col}" class="checkSel">
                      <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
            },
          },
          {
            targets: [1], render: function (data, type, row) {
              return retornaBotaoOpcoes(row[1]);
            }
          },
          {
            targets: [4], render: function (data, type, row) {
              return retornaCampoRGB(row[4]);
            }
          },
          {
            targets: [5], render: function (data, type, row) {
              buscaFotoCor(row[1]);
              return `<div class="form-group" style="display: flex; justify-content: center; align-items: center;">` + `<img class="pop img img-fluid imagem" height="50" width="50" id="imgFoto${row[1]}" src="dist/img/prod-1.png" style="max-width: 50px; max-height: 50px;">` + `</div>`;
            }
          },
        ],
        rowCallback: function (row, data) {
          const isChecked = registrosSelecionados.some(e => e.cor === data[1])
          $(row).toggleClass('selected', isChecked)
        }
      });

      $('#cbSelAll').prop('checked', false)
      adicionarEventoSelecionarTodos()

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaCor").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaCor").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("COR", data[1]);
      if (registroLiberado) {
        window.location.href = `cor/${btoa(data[1])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaCor").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaCor").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("COR", data[1]);
      if (registroLiberado) {
        window.location.href = `cor/${btoa(data[1])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCor').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCor").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadcor?", `CODIGOCADCOR=${encodeURIComponent(data.data()[1])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaCor").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const data = $('#tabelaCor').DataTable().rows(linha).data()
    const isChecked = this.checked
    $(linha.toggleClass('selected', isChecked))

    if (!isChecked)
      registrosSelecionados = registrosSelecionados.filter(e => e.cor !== data[0][1])
    else
      registrosSelecionados.push({
        cor: data[0][1]
      })
  })

  const retornarFiltrosSelecionarTodos = () => {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    let filtros = {
      ativo: '',
      grupo: '',
      subgrupo: '',
      cliente: '',
      classeComercial: '',
    }

    if (filtrosSessionStorage) {
      const { produto: filtrosProduto } = JSON.parse(filtrosSessionStorage)
      if (filtrosProduto)
        filtros = filtrosProduto
    }
    return filtros
  }

  function adicionarEventoSelecionarTodos() {
    $('#cbSelAll').off('change')
    $('#cbSelAll').on('change', function () {
      const isChecked = this.checked
      if (!isChecked) {
        registrosSelecionados.length = 0
        $('#tabelaCor').DataTable().draw(false)
        return
      }
      const filtros = retornarFiltrosSelecionarTodos()

      $.LoadingOverlay('show')
      requisicao(
        'POST',
        `/sisplan/cor/v1/retornar_cor_selecionar_todos_acesso?`,
        '',
        JSON.stringify(filtros),
        3600000
      ).then(async (response) => {
        const data = await response.json()
        if (data) {
          const { resultado, mensagem } = data
          if (mensagem?.codigo !== 200) {
            throw mensagem?.mensagem
          }

          if (resultado) {
            const { itens } = resultado
            registrosSelecionados = itens || []
            $('#tabelaCor').DataTable().draw(false)
            return
          }
        }
      }).catch((error) => {
        console.error(error)
        msgErro('Ocorreu um erro ao selecionar os registros, tente novamente.')
      }).finally(() => $.LoadingOverlay('hide'))
    })
  }


  $('#btnConfirmarAlterarDados').on('click', () => msgAlerta(
    'Deseja atualizar os dados de todos os registros selecionados?',
    () => null,
    () => null,
    () => confirmarAlterarDados(),
  ))

  const confirmarAlterarDados = async () => {
    const dadosAlteracao = retornarDadosAlteracao()
    if (!dadosAlteracao) return
    alterarDados(dadosAlteracao).then((resultado) => {
      if (!resultado || resultado !== 'OK') return
      $('#btnConsultar').trigger('click')

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onHidden() {
          $('#modalAlterarDadosEmMassa').modal('hide')
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao gravar os dados, tente novamente.')
    })
  }

  const retornarDadosAlteracao = () => {
    const descricao = $('#txtDescricaoAlterarDados').val()
    const regex = /^[a-zA-ZÀ-ÿ0-9&@#\.,\(\)\-\s]+$/;
    const valido = regex.test(descricao)
    if (descricao && !valido) {
      msgErro(
        'Descrição não pode conter caracteres especiais, impossível continuar.',
        () => $('#txtDescricaoAlterarDados').focus(),
        () => $('#txtDescricaoAlterarDados').focus(),
      )
      return
    }
    const classeComercial = pegaChave('#txtClasseComercialAlterarDados')
    const grupo = pegaChave('#txtGrupoAlterarDados')
    const subgrupo = pegaChave('#txtSubGrupoAlterarDados')
    const cliente = pegaChave('#txtClienteAlterarDados')

    const dadosAlteracao = {
      classeComercial,
      grupo,
      subgrupo,
      cliente
    }

    const coresAlteracao = registrosSelecionados

    return {
      dadosAlteracao,
      coresAlteracao,
    }
  }

  const alterarDados = async (dados) => {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao(
        'POST',
        `/sisplan/cor/v1/alterar_dados_cores_em_massa?`,
        '',
        JSON.stringify(dados),
        3600000
      )

      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        return resultado
      }
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnAlterarDadosEmMassa').on('click', () => {
    console.log(registrosSelecionados)
    if (registrosSelecionados?.length > 0)
      $('#modalAlterarDadosEmMassa').modal('show')
    else
      msgErro('Nenhum registro selecionado, impossível continuar.')
  })
  $('#modalAlterarDadosEmMassa').on('hide.bs.modal', () => $('.campoAlterarDadosEmMassa').val(''))
  $('#btnLimparCamposAlterarDados').on('click', () => $('.campoAlterarDadosEmMassa').val(''))



  $('#btnUtilizacao').on('click', () => carregarModalUtilizacao())
  $(".cbStatusCorUtilizacao").on('click', async function () {

    const filtros = {
      cor: registrosSelecionados.map((e) => `'${e.cor}'`).join(',')
    }
    await retornaInfosProduto(filtros.cor)
    await retornaInfosMateriais(filtros.cor)
  })

  async function retornaInfosProduto(sCores) {
    const status = $('.cbStatusCorUtilizacao:checked').val()
    const dadosSelect = {
      tabela: 'PA_ITEN',
      camposSelect: [
        'PRODUTO.CODIGO',
        'PRODUTO.DESCRICAO',
        'CADCOR.COR',
        'CADCOR.DESCRICAO DESC_COR',
        'PA_ITEN.ATIVO'
      ],
      innerJoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = PA_ITEN.COR' }],
      leftJoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PA_ITEN.CODIGO' }],
      where: [`CADCOR.COR IN (${sCores.toString()})`, `${status != '' ? `PA_ITEN.ATIVO = '${status}'` : ''}`],
      groupBy: [
        'PRODUTO.CODIGO',
        'PRODUTO.DESCRICAO',
        'CADCOR.COR',
        'CADCOR.DESCRICAO',
        'PA_ITEN.ATIVO']

    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
        $('#tabelaProdutosUtilizacao').DataTable().clear().draw(false);
        $("#tabelaProdutosUtilizacao").DataTable().destroy();
        $("#tabelaProdutosUtilizacao").empty();
      }

      return undefined;
    }
    if (data.length == 0) {
      if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
        $('#tabelaProdutosUtilizacao').DataTable().clear().draw(false);
        $("#tabelaProdutosUtilizacao").DataTable().destroy();
        $("#tabelaProdutosUtilizacao").empty();
      }

      return undefined;
    }


    criarTabelaProdutosUtilizacao(data)

    return data;
  }


  async function retornaInfosMateriais(sCores) {
    const status = $('.cbStatusCorUtilizacao:checked').val()
    console.log(status)
    const dadosSelect = {
      tabela: 'MAT_ITEN',
      camposSelect: [
        'MATERIAL.CODIGO',
        'MATERIAL.DESCRICAO',
        'CADCOR.COR',
        'CADCOR.DESCRICAO DESC_COR',
        'MAT_ITEN.ATIVO'
      ],
      innerJoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = MAT_ITEN.COR' }],
      leftJoin: [{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = MAT_ITEN.CODIGO' }],
      where: [`CADCOR.COR IN (${sCores.toString()})`, `${status != '' ? `MAT_ITEN.ATIVO = '${status}'` : ''}`],
      groupBy: [
        'MATERIAL.CODIGO',
        'MATERIAL.DESCRICAO',
        'CADCOR.COR',
        'CADCOR.DESCRICAO',
        'MAT_ITEN.ATIVO']

    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      if ($.fn.DataTable.isDataTable('#tabelaMateriaisUtilizacao')) {
        $('#tabelaMateriaisUtilizacao').DataTable().clear().draw(false);
        $("#tabelaMateriaisUtilizacao").DataTable().destroy();
        $("#tabelaMateriaisUtilizacao").empty();
      }

      return undefined;
    }
    if (data.length == 0) {
      if ($.fn.DataTable.isDataTable('#tabelaMateriaisUtilizacao')) {
        $('#tabelaMateriaisUtilizacao').DataTable().clear().draw(false);
        $("#tabelaMateriaisUtilizacao").DataTable().destroy();
        $("#tabelaMateriaisUtilizacao").empty();
      }

      return undefined;
    }


    criarTabelaMaterialUtilizacao(data)

    return data;
  }

  const carregarModalUtilizacao = async () => {
    $('#modalUtilizacao').modal('show')
    if (registrosSelecionados.length > 0) {
      $('#modalUtilizacao').on('shown.bs.modal', function () {
        if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) $('#tabelaProdutosUtilizacao').DataTable().columns.adjust().draw()
        if ($.fn.DataTable.isDataTable('#tabelaMateriaisUtilizacao')) $('#tabelaMateriaisUtilizacao').DataTable().columns.adjust().draw()
      })
      const filtros = {
        cor: registrosSelecionados.map((e) => `'${e.cor}'`).join(',')
      }
      await retornaInfosProduto(filtros.cor)
      await retornaInfosMateriais(filtros.cor)
    }
  }

  $('#modalUtilizacao').on('hide.bs.modal', () => {
    if ($.fn.DataTable.isDataTable('#tabelaItensUtilizacao')) {
      $('#tabelaItensUtilizacao').DataTable().destroy()
      $('#tabelaItensUtilizacao').empty()
    }

    if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
      $('#tabelaProdutosUtilizacao').DataTable().destroy()
      $('#tabelaProdutosUtilizacao').empty()
    }

    if ($.fn.DataTable.isDataTable('#tabelaCoresUtilizacao')) {
      $('#tabelaCoresUtilizacao').DataTable().destroy()
      $('#tabelaCoresUtilizacao').empty()
    }
    limparFiltrosUtilizacao()
    $('#modalUtilizacao').off('shown.bs.modal')
  })

  $('#btnConsultarUtilizacao').on('click', () => consultarUtilizacao())

  const consultarUtilizacao = () => {
    retornarFiltrosUtilizacao().then((filtros) => filtros && retornarDadosUtilizacao(filtros))
  }

  const retornarFiltrosUtilizacao = async () => {
    const filtros = {
      produtos: await formataListas($('#txtProdutoUtilizacao').val().toString()),
      colecoes: await formataListas($('#txtColecaoUtilizacao').val().toString()),
      marcas: await formataListas($('#txtMarcaUtilizacao').val().toString()),
      grupos: await formataListas($('#txtGrupoUtilizacao').val().toString()),
      linhas: await formataListas($('#txtLinhaUtilizacao').val().toString()),
      status: await formataListas($('#txtStatusUtilizacao').val().toString()),
      etiquetas: await formataListas($('#txtEtiquetaUtilizacao').val().toString()),
      modelos: await formataListas($('#txtModeloUtilizacao').val().toString()),
      cores: await formataListas($('#txtCorUtilizacao').val().toString()),
      situacao: $('#selectSituacaoUtilizacao').val(),
      situacaoCor: $('#selectSituacaoCorUtilizacao').val(),
    }

    return filtros
  }

  const retornarDadosUtilizacao = (filtros) => {
    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/cor/v1/retornar_dados_utilizacao?`,
      '',
      JSON.stringify(filtros),
      3600000
    ).then(async (response) => {
      const dados = await response.json()
      if (dados) {
        const { resultado, mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!resultado) return
        const { itens, produtos, cores } = resultado

        if (!itens || !itens.length) {
          msgErro('Nenhum item encontrado.')
        }

        criarTabelaItensUtilizacao(itens ?? [])
        criarTabelaProdutosUtilizacao(produtos ?? [])
        criarTabelaCoresUtilizacao(cores ?? [])
      }
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const retornarDadosItemUtilizacao = (insumo, situacaoCor) => {
    $.LoadingOverlay('show')
    requisicao(
      'GET',
      `/sisplan/produto/v1/retornar_dados_item_utilizacao?`,
      `INSUMO=${encodeURIComponent(insumo)}&SITUACAO_COR=${encodeURIComponent(situacaoCor)}`,
      '',
      3600000
    ).then(async (response) => {
      const dados = await response.json()
      if (dados) {
        const { resultado, mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        if (!resultado) return
        const { produtos, cores } = resultado

        if (!produtos || !produtos.length) {
          msgErro('Nenhum produto encontrado.')
        }

        criarTabelaProdutosUtilizacao(produtos ?? [])
        criarTabelaCoresUtilizacao(cores ?? [])
      }
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao buscar os dados.')
    }).finally(() => $.LoadingOverlay('hide'))
  }

  const criarTabelaItensUtilizacao = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaItensUtilizacao')) {
      $('#tabelaItensUtilizacao').DataTable().destroy()
      $('#tabelaItensUtilizacao').empty()
    }

    const columns = [
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'descricao',
        title: 'Descrição',
      },
    ]

    const table = $('#tabelaItensUtilizacao').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      select: {
        style: 'single',
        toggleable: false,
      },
    })
    table.off('select')
    $('#tabelaItensUtilizacao').DataTable().row(':first').select()

    table.on('select', function (_e, _dt, type, indexes) {
      if (type === 'row') {
        const data = table.rows(indexes[0]).data().toArray()
        const situacaoCor = $('#selectSituacaoCorUtilizacao').val()
        retornarDadosItemUtilizacao(data[0]?.codigo, situacaoCor)
      }
    })
  }

  const criarTabelaMaterialUtilizacao = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaMateriaisUtilizacao')) {
      $('#tabelaMateriaisUtilizacao').DataTable().destroy()
      $('#tabelaMateriaisUtilizacao').empty()
    }

    const columns = [
      {
        data: 'CODIGO',
        title: 'Código',
      },
      {
        data: 'DESCRICAO',
        title: 'Descrição',
      },
      {
        data: 'COR',
        title: 'Cor',
      },
      {
        data: 'DESC_COR',
        title: 'Descrição Cor',
      },
      {
        data: 'ATIVO',
        title: 'Ativo',
      },
    ]

    $('#tabelaMateriaisUtilizacao').DataTable({
      order: [],
      sort: true,
      paging: true,
      destroy: true,
      scrollX: true,
      order: false,
      colReorder: true,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '120px',
    })
  }

  const criarTabelaProdutosUtilizacao = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
      $('#tabelaProdutosUtilizacao').DataTable().destroy()
      $('#tabelaProdutosUtilizacao').empty()
    }

    const columns = [
      {
        data: 'CODIGO',
        title: 'Código',
      },
      {
        data: 'DESCRICAO',
        title: 'Descrição',
      },
      {
        data: 'COR',
        title: 'Cor',
      },
      {
        data: 'DESC_COR',
        title: 'Descrição Cor',
      },
      {
        data: 'ATIVO',
        title: 'Ativo',
      },
    ]

    $('#tabelaProdutosUtilizacao').DataTable({
      order: [],
      sort: true,
      paging: true,
      destroy: true,
      scrollX: true,
      order: false,
      colReorder: true,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
      scrollY: '120px',
    })
  }

  const criarTabelaCoresUtilizacao = (data) => {
    if ($.fn.DataTable.isDataTable('#tabelaCoresUtilizacao')) {
      $('#tabelaCoresUtilizacao').DataTable().destroy()
      $('#tabelaCoresUtilizacao').empty()
    }

    const columns = [
      {
        data: 'codigo',
        title: 'Código',
      },
      {
        data: 'cor',
        title: 'Cor',
      },
      {
        data: 'descricaoCor',
        title: 'Descrição Cor',
      },
    ]

    $('#tabelaCoresUtilizacao').DataTable({
      sort: false,
      paging: false,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      autoWidth: true,
      data,
      columns,
      scrollX: true,
    })
  }

  $('#btnLimparFiltrosUtilizacao').on('click', () => {
    limparFiltrosUtilizacao()
  })

  const limparFiltrosUtilizacao = () => {
    $('#txtProdutoUtilizacao').empty().trigger('change')
    $('#txtColecaoUtilizacao').empty().trigger('change')
    $('#txtMarcaUtilizacao').empty().trigger('change')
    $('#txtGrupoUtilizacao').empty().trigger('change')
    $('#txtLinhaUtilizacao').empty().trigger('change')
    $('#txtStatusUtilizacao').empty().trigger('change')
    $('#txtEtiquetaUtilizacao').empty().trigger('change')
    $('#txtModeloUtilizacao').empty().trigger('change')
    $('#txtCorUtilizacao').empty().trigger('change')
    $('#selectSituacaoUtilizacao').val('')
    $('#selectSituacaoCorUtilizacao').val('')
  }

});
