/* eslint-disable camelcase */
/* eslint-disable no-lonely-if */
function validarCaracteres(value) {
    if (value === "") return 0; // Permite que o valor vazio passe na validação
    const regex = /^[a-zA-ZÀ-ÿ0-9&@#\*\.,'"\-()!\s]+$/;
    const valido = regex.test(value);
    return valido ? 0 : 1;
}

$(document).ready(async function () {
    let parametrosEntidade = await BuscaParametrosEntidade();
    document.getElementById('txtPercDesconto').addEventListener('input', function () {
        let max = parseInt(this.max, 10);
        if (parseInt(this.value, 10) > max) {
            this.value = max;
        }
    });


    const bTipoUsuarioMasterOuSupervisor = await usuarioehMasterOuSupervisor();

    let jsonCaptcha;
    let grid;

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    $('.maskDecimais').maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
    });

    const paramCadastraSemCPF = await CopiaParametro('VENDA', 40);
    const alterarLimiteCredito = await CopiaParametro('ENTIDADE', 0);
    const alterarGrupo = await CopiaParametro('ENTIDADE', 6);
    const alterarLimiteFidelidade = await CopiaParametro('ENTIDADE', 1);
    const cadastraEntidadeBloqueada = await CopiaParametro('ENTIDADE', 2);
    const bloqueiaEditarEntidade = await CopiaParametro('ENTIDADE', 3);
    const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2);
    const buscaRegiao = await CopiaParametro('VENDA', 77);
    const usuarioMasterSupervisor = await UsuarioMasterOuSupervisor();
    const naoPermiteRecarregarEntidade = ((await apenasClientesVinculadosAoRepresentante()) && (retornaRepresentanteUsuario() != ''));
    const controleLimiteCredito = await CopiaParametro('ENTIDADE', 4);
    const camposObrigatorios = await retornaCamposObrigatorios('entidade');
    const semPorteBloqueiaCadastroPessoaJuridica = await CopiaParametro('ENTIDADE', 5);
    const paramFinan = await BuscaParametrosReceber();
    const paramContaContabil = paramFinan[14]?.VALOR;
    const alterarTipoCnpjCpf = await CopiaParametro('ENTIDADE', 7);

    function validarPorteCadastroPessoaJuridica() {
        const tipoEnt = $('#rgTipoEnt').val();
        const porteEmpresa = $('#rgPorteEmpresa').val();

        const tipoEntValido = (tipoEnt === 'Jurídica' || tipoEnt === '##.###.###/####-##');
        const porteInvalido = (!porteEmpresa);

        if (semPorteBloqueiaCadastroPessoaJuridica === '1' && tipoEntValido && porteInvalido) {
            msgAlerta("Informe o porte da empresa, na aba 'Documentos'");
            if (!$('#multiCollapseExample2').hasClass('show')) {
                $('#documentoaba').trigger('click');
            }
            return true;
        }
        return false;
    }

    await adicionaTipos();
    await adicionaClassificacao();

    if (controleLimiteCredito == '1') {
        let label = $('#txtLimiteCredito').prev('label');
        label.text('Limite Crédito Consignado');

        label = $('#txtLimiteFidelidade').prev('label');
        label.text('Limite Crédito Venda');
        $('#txtLimiteCredito').prop('disabled', true);
        $('#txtLimiteFidelidade').prop('disabled', true);
    };

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
    $('#txtPais').autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`, [], [], [], preencheDDI);
    $('#txtTabela').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
    $('#txtRamoAtividade').autocompleta(1, `JSON={ "tabela":"SITCLI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtRegiao').autocompleta(1, `JSON={ "tabela":"reg_estado", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $("#txtCanalContato").autocompleta(1, `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ["TIPO = 'O'"]}`);
    $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#txtConfXML').autocompleta(1, `JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaCliente').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaCAdiantamento').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaCDevolucao').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaFornecedor').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaFAdiantamento').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaFDevolucao').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtCondicaoPagto').autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtMoeda').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');
    $('#txtSetor').pesquisa_variosServerside(1, '{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
    $('#txtAddSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $("#txtConta").autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "Conta CHAVE", "DESCRICAO"], "where": null}`);
    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#txtSitDup").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#txtAddMoeda").autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE CHAVE, DESCRICAO"], "where": [] }`);
    $("#txtAddRepresentante").autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": [] }`);
    $('#txtPerfil').autocompleta(1, `JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    componenteFiltro('cnae', false, false)
    componenteFiltro('entidadeAux', false, false)

    $('#btnPerfil').pesquisa('#txtPerfil', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Perfil', 'PERFIL');
    $("#btn-representante").pesquisa("#txtRepresentante", "CODREP", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`, "Pesquisa Representante", "represen");
    $("#btn-pais-entidade").pesquisa_array(["#txtPais"], ["CODIGO"], ["NOME"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADPAIS", "camposSelect":[ "CODIGO", "NOME" ], "where": null}`, "Pesquisa País", "CADPAIS", preencheDDI);
    $("#btn-tabela").pesquisa("#txtTabela", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, "Pesquisa Tabela", "regiao");
    $("#btn-RamoAtividade").pesquisa("#txtRamoAtividade", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITCLI", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Ramo de Atividade", "sitcli");
    $("#btn-Regiao").pesquisa("#txtRegiao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"reg_estado", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Região", "reg_estado");
    $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Grupo", "GRUPO_CLI");
    $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
    $("#btn-CanalContato").pesquisa("#txtCanalContato", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo", "descricao"], "where": ["TIPO = 'O'"]}`, "Pesquisa Canal Contato", "TIPO_CONTATO");
    $('#btnPesquisaTransportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
    $('#btnConfXML').pesquisa('#txtConfXML', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conf XML', 'FATCONF_XML');
    $('#btn-contacliente').pesquisa('#txtContaCliente', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-Cadiantamento').pesquisa('#txtContaCAdiantamento', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-Cdevolucao').pesquisa('#txtContaCDevolucao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-contafornecedor').pesquisa('#txtContaFornecedor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Fornecedor', 'CONTA_CONT');
    $('#btn-Fadiantamento').pesquisa('#txtContaFAdiantamento', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-Fdevolucao').pesquisa('#txtContaFDevolucao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, "Pesquisa Conta", "CADCONTA");
    $("#btn-Banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-SitDup").pesquisa("#txtSitDup", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btnAddMoeda").pesquisa("#txtAddMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', "Pesquisa Moeda", "MOEDA");
    $("#btnAddRepresentante").pesquisa("#txtAddRepresentante", "CODREP", "NOME", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', "Pesquisa Representante", "REPRESEN");

    $(`#btnCep`).pesquisa_serverside(
        [`#txtCep`, `#txtCepInv`],
        ["CADCEP.CEP", "CIDADE.NOME"],
        ["CADCEP.CEP", "CIDADE.NOME"],
        '{' +
        `  "tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CADCEP.NOMCEP", "CADCEP.BAIRRO", "CADCEP.CODMUN", "CIDADE.NOME", "CIDADE.POPULACAO", "CIDADE.COD_UF", "TABUF.DESCRICAO", "CADPAIS.CODIGO", "COALESCE(CADPAIS.NOME,'')", "CADCEP.COD_INTERNO"],` +
        '  "leftJoin": [' +
        '     {"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO AND CIDADE.COD_UF = CADCEP.ESTCEP"}, ' +
        '     {"tabela": "TABUF", "condicao": "TABUF.CODIGO = CADCEP.ESTCEP AND TABUF.PAIS = CADCEP.COD_PAIS"}, ' +
        '     {"tabela": "CADPAIS", "condicao": "CADPAIS.CODIGO = CADCEP.COD_PAIS"}' +
        '   ]' +
        ', "where": null}',
        'Pesquisa de CEP',
        '',
        [true, true]
    );

    $(`#btnCepEntrega`).pesquisa_serverside(
        [`#txtCepEntrega`, `#txtCepInv`],
        ["CADCEP.CEP", "CIDADE.NOME"],
        ["CADCEP.CEP", "CIDADE.NOME"],
        '{' +
        `  "tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CADCEP.NOMCEP", "CADCEP.BAIRRO", "CADCEP.CODMUN", "CIDADE.NOME", "CIDADE.POPULACAO", "CIDADE.COD_UF", "TABUF.DESCRICAO", "CADPAIS.CODIGO", "COALESCE(CADPAIS.NOME,'')", "CADCEP.COD_INTERNO"],` +
        '  "leftJoin": [' +
        '     {"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO AND CIDADE.COD_UF = CADCEP.ESTCEP"}, ' +
        '     {"tabela": "TABUF", "condicao": "TABUF.CODIGO = CADCEP.ESTCEP AND TABUF.PAIS = CADCEP.COD_PAIS"}, ' +
        '     {"tabela": "CADPAIS", "condicao": "CADPAIS.CODIGO = CADCEP.COD_PAIS"}' +
        '   ]' +
        ', "where": null}',
        'Pesquisa de CEP',
        '',
        [true, true]
    );

    $(`#btnCepCobranca`).pesquisa_serverside(
        [`#txtCepCobranca`, `#txtCepInv`],
        ["CADCEP.CEP", "CIDADE.NOME"],
        ["CADCEP.CEP", "CIDADE.NOME"],
        '{' +
        `  "tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CADCEP.NOMCEP", "CADCEP.BAIRRO", "CADCEP.CODMUN", "CIDADE.NOME", "CIDADE.POPULACAO", "CIDADE.COD_UF", "TABUF.DESCRICAO", "CADPAIS.CODIGO", "COALESCE(CADPAIS.NOME,'')", "CADCEP.COD_INTERNO"],` +
        '  "leftJoin": [' +
        '     {"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO AND CIDADE.COD_UF = CADCEP.ESTCEP"}, ' +
        '     {"tabela": "TABUF", "condicao": "TABUF.CODIGO = CADCEP.ESTCEP AND TABUF.PAIS = CADCEP.COD_PAIS"}, ' +
        '     {"tabela": "CADPAIS", "condicao": "CADPAIS.CODIGO = CADCEP.COD_PAIS"}' +
        '   ]' +
        ', "where": null}',
        'Pesquisa de CEP',
        '',
        [true, true]
    );

    $("#btnTabelaModal").pesquisa("#txtTabelaModal", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, "Pesquisa Tabela", "regiao");
    $('#btnMoeda').pesquisa_serversideSel('#txtMoeda', `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}`, 'Pesquisa de Moeda');
    $('#btnSetor').pesquisa_serversideSel('#txtSetor', `{ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Setor');
    $('#btnAddSetor').pesquisa('#txtAddSetor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Setor', 'CADFLUXO');
    $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"]}`, 'Pesquisa Histórico', 'HISTCP');
    $('#btn-CondicaoPagto').pesquisa('#txtCondicaoPagto', 'CODCOND', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO"]}`, 'Pesquisa Condição de Pagamento', 'CONDICAO');

    $('#btnContaChave').pesquisa_serverside(['#txtContaChave', '#txtAgenciaChave'],
        ['CONTA', 'AGENCIA'],
        ['DESCRICAO', 'AGENCIA'],
        '{"tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO", "AGENCIA"], "camposWhereServerSide":["CONTA", "DESCRICAO", "AGENCIA"], "where": null}',
        'Pesquisa Conta',
        undefined,
        [false, true]);

    $('#txtContaChave').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":["CONTA CHAVE, DESCRICAO, AGENCIA"], "where": [] }`, ['#txtAgenciaChave'], ['AGENCIA'], ['AGENCIA'], undefined, [true]);
    $('#btnLimpaContaChave').on('click', function () {
        $('#txtContaChave').val('');
        $('#txtAgenciaChave').val('');
    });

    componenteFiltro('banco', false, false, 'BancoChave');
    componenteFiltro('tipoPag', false, false, 'TipoTransChave');

    $("#btn-limpa-CanalContato").on("click", function () {
        $("#txtCanalContato").val("");
    });

    $('#btn-limpa-Classe').on('click', function () {
        $('#txtClasse').val('');
    });

    $('#btn-limpar-pais-entidade').on('click', function () {
        $('#txtPais').val('');
    });

    $('#btn-Arepresentante').on('click', function () {
        $('#txtRepresentante').val('');
    });

    $("#btn-Atabela").on('click', function () {
        $('#txtTabela').val('');
    });

    $("#btn-ARamoAtividade").on('click', function () {
        $('#txtRamoAtividade').val('');
    });

    $("#btn-ARegiao").on('click', function () {
        $('#txtRegiao').val('');
    });

    $("#btn-AGrupo").on('click', function () {
        $('#txtGrupo').val('');
    });

    $("#btn-limpa-contacliente").on('click', function () {
        $('#txtContaCliente').val('');
    });

    $("#btn-limpa-Cadiantamento").on('click', function () {
        $('#txtContaCAdiantamento').val('');
    });

    $("#btn-limpa-Cdevolucao").on('click', function () {
        $('#txtContaCDevolucao').val('');
    });

    $("#btn-limpa-contafornecedor").on('click', function () {
        $('#txtContaFornecedor').val('');
    });

    $("#btn-limpa-Fadiantamento").on('click', function () {
        $('#txtContaFAdiantamento').val('');
    });

    $("#btn-limpa-Fdevolucao").on('click', function () {
        $('#txtContaFDevolucao').val('');
    });

    $("#btnLimpaTransportadora").on('click', function () {
        $('#txtTransportadora').val('');
    });

    $("#btnLimpaPerfil").on('click', function () {
        $('#txtPerfil').val('');
    });

    $("#btnLimpaConfXML").on('click', function () {
        $('#txtConfXML').val('');
    });

    $("#btn-AHistorico").on('click', function () {
        $('#txtHistorico').val('');
    });

    $("#btn-limpa-ACondicaoPagto").on('click', function () {
        $('#txtCondicaoPagto').val('');
    });

    $("#btn-AConta").on('click', function () {
        $('#txtConta').val('');
    });

    $("#btn-ABanco").on('click', function () {
        $('#txtBanco').val('');
    });

    $("#btn-ASitDup").on('click', function () {
        $('#txtSitDup').val('');
    });

    $("#btnLimpaCep").on('click', function () {
        limpaCep()
        $('#txtCep').val('');
    });

    $("#btnLimpaCepEntrega").on('click', function () {
        limpaCepEntrega()
        $('#txtCepEntrega').val('');
    });

    $("#btnLimpaCepCobranca").on('click', function () {
        limpaCepCobranca()
        $('#txtCepCobranca').val('');
    });

    $("#btn-limpa-moeda").on('click', function () {
        $('#txtMoeda').empty().trigger('change');
    });

    $("#btnLimpaAddRepresentante").on('click', function () {
        $('#txtAddRepresentante').val('');
    });

    $("#btnLimpaAddSetor").on('click', function () {
        $('#txtAddSetor').val('');
    });

    $('#tabelaSetor').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
    });
    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };
    $('#txtAdicionarSetor').on('click', async function () {
        $('#tabelaSetor').DataTable().rows().data().toArray().filter((item) => {
            let codigoTabela = item[0].match(/\d+/)[0];
            let codigoInput = pegaChave('#txtAddSetor');
            if (codigoTabela == codigoInput) {
                throw msgAlerta(`Não pode inserir duas vezes o mesmo código de setor (${codigoInput}), verifique!`);
            }
        })
        if (!$('#txtAddSetor').val()) {
            throw msgAlerta('Código de setor não preenchido, impossível continuar!')
        }
        $('#tabelaSetor')
            .DataTable()
            .row
            .add([
                retornaBotaoOpcoes(pegaChave('#txtAddSetor')),
                pegaDescricao('#txtAddSetor'),
                $('#txtPerc100').val(),
                $('#txtPercPontualidade').val(),
                $('#txtPercQual').val(),
            ]).draw(false);

        $('#txtAddSetor').val('')
        $('#txtPerc100').val('')
        $('#txtPercPontualidade').val('')
        $('#txtPercQual').val('')
    });

    function buscaDadosSetores() {
        const tabelaSetor = $('#tabelaSetor').DataTable().rows().data().toArray();

        const dados = tabelaSetor.map((item) => ({
            codCli: $('#txtCodCli').val(),
            setor: item[0].match(/\d+/)[0],
            percentual100: item[2],
            percentualPontualidade: item[3],
            percentualQualidade: item[4],
        }))

        return dados
    }

    $('#btnEstatisticasSelecionarEmpresasVendas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $('#txtGravarAddSetor').on('click', async function () {
        if ($('#tabelaSetor').DataTable().rows().data().toArray().length == 0) {
            throw msgAlerta('Nenhum registro na tabela, impossível continuar!')
        }
        try {
            $.LoadingOverlay('show');
            const dados = buscaDadosSetores();

            const body = {
                setores: dados
            }

            const response = await requisicao('POST', `/sisplan/cliente/v1/gravasetores?`, '', JSON.stringify(body), 15000);

            if (!response) {
                return
            }

            if (response.status != 200) {
                throw msgAlerta('Setores não cadastrados, verifique!')
            }

            toastr.success(
                `Cadastro efetuado com sucesso!`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });

        } catch (err) {
            console.log(err)
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#tabelaSetor').on('click', '#btn-excluir', async function () {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            const data = $("#tabelaSetor").DataTable().row($(this).parents("tr"));
            await excluirSetor(data);
            data.remove().draw(false);
            let newInput = atualizaInputSetor();
            $('#txtSetor').empty().trigger('change');
            await insereValorPesquisaVarios('txtSetor', 'CODIGO', 'DESCRICAO', newInput);
        });
    });

    async function excluirSetor(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let codSetor = data.data()[0].match(/\d+/)[0];
                let response = await requisicao("DELETE", "/sisplan/cliente/v1/excluirsetor?", `SETOR=${encodeURIComponent(codSetor)}&CODCLI=${$('#txtCodCli').val()}`, null);
                if (!response) {
                    return;
                }

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function atualizaInputSetor() {
        let array = []
        $('#tabelaSetor').DataTable().rows().data().toArray().filter((item) => {
            const codigo = item[0].match(/\d+/)[0];
            const descricao = item[1];

            array.push({ CODIGO: codigo, DESCRICAO: descricao });
        })

        return array
    }

    async function criaTabelaChavePix() {

        if ($.fn.DataTable.isDataTable('#tabelaChavePix')) {
            $('#tabelaChavePix').DataTable().destroy();
            $('#tabelaChavePix').empty();
        }

        let jsonStr;
        if (cliente != 'create') {
            const pesquisaParam = {
                tabela: 'CLI_BANCO',
                camposSelect: ['BANCO', 'CONTA', 'DAC', 'AGENCIA', 'TIPO_PIX', 'CHAVE_PIX', 'PADRAO', 'TIPO_TRANSF','TITULARIDADE','OBSERVACAO'],
                where: [`CODCLI = '${cliente}'`]
            }

            jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        } else {
            jsonStr = [];
        }

        $('#tabelaChavePix').DataTable({
            paging: false,
            filter: false,
            info: false,
            order: true,
            destroy: true,
            data: jsonStr,
            columns: [
                { title: 'Banco', data: 'BANCO' },
                { title: 'Conta', data: 'CONTA' },
                { title: 'Dac', data: 'DAC' },
                { title: 'Agência', data: 'AGENCIA' },
                { title: 'Tipo Pix', data: 'TIPO_PIX' },
                { title: 'Chave Pix', data: 'CHAVE_PIX' },
                { title: 'Padrão', data: 'PADRAO' },
                { title: 'Tipo Trans', data: 'TIPO_TRANSF' },
                { title: 'Titularidade', data: 'TITULARIDADE' },
                { title: 'Observação', data: 'OBSERVACAO' }
            ],
            columnDefs: [{
                targets: [0],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                }
            }]
        });
    }

    $('#btnAdicionarChavePix').on('click', function () {
        const banco = pegaChave('#txtBancoChave');
        const tipo_trans = pegaChave('#txtTipoTransChave');

        if (banco == '' || !banco) {
            msgErro('Banco inválido. Impossível continuar.');
            return;
        }

        if (tipo_trans == '' || !tipo_trans) {
            msgErro('Tipo de transferência inválido. Impossível continuar.');
            return;
        }

        const novoRegistro = {
            BANCO: banco,
            CONTA: pegaChave('#txtContaChave'),
            DAC: $('#txtDacChave').val(),
            AGENCIA: $('#txtAgenciaChave').val(),
            TIPO_PIX: $('#txtTipoPixChave').val(),
            CHAVE_PIX: $('#txtChavePixChave').val(),
            PADRAO: $('#txtPadraoChave').val(),
            TIPO_TRANSF: tipo_trans,
            TITULARIDADE: $('#txtPIXTitularidade').val(),
            OBSERVACAO: $('#txtPIXObservacao').val()
        };

        $('#tabelaChavePix').DataTable().row.add(novoRegistro).draw(false);
        $('.modalChavePix').val('');
        $('#txtPadraoChave').val('N');
    });

    $('#modalChavePix').on('hide.bs.modal', function () {
        validaDadosChavePix();
    });

    $('#tabelaChavePix').on('click', '#btn-excluir', async function () {
        $("#tabelaChavePix").DataTable().row($(this).parents('tr')).remove().draw(false);
        $('.modalChavePix').val('');
        $('#txtPadraoChave').val('S');
    });

    function validaDadosChavePix() {
        try {
            const data = $('#tabelaChavePix').DataTable().data().toArray();
            const qtdePadrao = data.filter(e => e.PADRAO == 'S');

            if (data.length > 0) {
                if (qtdePadrao.length == 0) {
                    msgErro('Nenhuma chave pix foi informada como padrão. Impossível continuar.', () => {
                        $('#modalChavePix').modal('show');
                    });
                    return;
                }
                if (qtdePadrao.length > 1) {
                    msgErro('Mais de uma chave pix foi informada como padrão. Impossível continuar.', () => {
                        $('#modalChavePix').modal('show');
                    });
                    $('#modalChavePix').modal('show');
                    return;
                }

                const uniqueSet = new Set();

                data.forEach(obj => {
                    const key = obj.BANCO + '-' + obj.AGENCIA + '-' + obj.CONTA + '-' + obj.TIPO_PIX;

                    if (uniqueSet.has(key)) {
                        msgErro('Existem registros com banco, agência, conta e tipo pix iguais. Impossível continuar.', () => {
                            $('#modalChavePix').modal('show');
                        });
                        $('#modalChavePix').modal('show');
                        return;
                    }
                    uniqueSet.add(key);
                });
            }
        } catch (e) {
            $('#modalChavePix').modal('hide');
        }
    }

    function buscaDadosChavePix() {
        const data = $('#tabelaChavePix').DataTable().data().toArray();

        const retorno = data.map((e) => {
            return {
                AGENCIA: e.AGENCIA,
                BANCO: e.BANCO,
                CHAVE_PIX: e.CHAVE_PIX,
                CODCLI: cliente,
                CONTA: e.CONTA,
                TIPO_PIX: e.TIPO_PIX,
                PADRAO: e.PADRAO,
                TIPO_TRANSF: e.TIPO_TRANSF,
                DAC: e.DAC,
                TITULARIDADE: e.TITULARIDADE,
                OBSERVACAO: e.OBSERVACAO
            };
        })

        return retorno;
    }

    $('#tabelaMoedas').on('click', '#btn-excluir', async function () {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            const data = $("#tabelaMoedas").DataTable().row($(this).parents("tr"));
            await excluirMoeda(data);
            data.remove().draw(false);
            let newInput = atualizaInputMoeda();
            $('#txtMoeda').empty().trigger('change');
            await insereValorPesquisaVarios('txtMoeda', 'CODMOE', 'DESCRICAO', newInput);
        });
    });

    $('#tabelaRepresentantes').on('click', '#btn-excluir', async function () {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            const data = $("#tabelaRepresentantes").DataTable().row($(this).parents("tr"));
            data.remove().draw(false);
        });
    });

    async function excluirMoeda(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let codMoe = data.data()[0].match(/\d+/)[0];
                let response = await requisicao("DELETE", "/sisplan/cliente/v1/excluirmoeda?", `CODMOE=${encodeURIComponent(codMoe)}&CODCLI=${$('#txtCodCli').val()}`, null);
                if (!response) {
                    return;
                }

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function atualizaInputMoeda() {
        let array = []
        $('#tabelaMoedas').DataTable().rows().data().toArray().filter((item) => {
            const codmoe = item[0].match(/\d+/)[0];
            const descricao = item[1];
            array.push({ CODMOE: codmoe, DESCRICAO: descricao });
        })
        return array
    }

    $('#tabelaMoedas').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
    });

    $('#txtAdicionarMoeda').on('click', async function () {
        $('#tabelaMoedas').DataTable().rows().data().toArray().filter((item) => {
            let codigoTabela = item[0].match(/\d+/)[0];
            let codigoInput = pegaChave('#txtAddMoeda');
            if (codigoTabela == codigoInput) {
                throw msgAlerta(`Não pode inserir duas vezes o mesmo código de Moeda (${codigoInput}), verifique!`);
            }
        })
        if (!$('#txtAddMoeda').val()) {
            throw msgAlerta('Código de moeda não preenchido, impossível continuar!')
        }
        $('#tabelaMoedas')
            .DataTable()
            .row
            .add([
                retornaBotaoOpcoes(pegaChave('#txtAddMoeda')),
                pegaDescricao('#txtAddMoeda'),
            ]).draw(false);

        $('#txtAddMoeda').val('')
    });

    $('#btnAdicionarRepresentante').on('click', async function () {
        const obj = {
            CODREP: pegaChave('#txtAddRepresentante'),
            NOME: pegaDescricao('#txtAddRepresentante'),
            COM1: pegaValor('#txtAddComFat'),
            COM2: pegaValor('#txtAddComRec')
        }
        if (($.fn.DataTable.isDataTable('#tabelaRepresentantes')) && ($("#tabelaRepresentantes").DataTable().data().count() > 0)) {
            $('#tabelaRepresentantes').DataTable().rows().data().toArray().filter((item) => {
                let codigoTabela = item.CODREP ? item.CODREP.match(/\d+/)[0] : null;
                let codigoInput = pegaChave('#txtAddRepresentante');
                if (codigoTabela == codigoInput) {
                    throw msgAlerta(`Não pode inserir duas vezes o mesmo representante (${codigoInput}), verifique!`);
                }
            });

            if (!$('#txtAddRepresentante').val()) {
                throw msgAlerta('Código do representante não preenchido, impossível continuar!')
            }

            $('#tabelaRepresentantes')
                .DataTable()
                .row
                .add(obj).draw(false);

            $('#txtAddRepresentante').val('');
            $('#txtAddComFat').val(0.00);
            $('#txtAddComRec').val(0.00);

            return;
        };


        const titulosRepresentantes = [
            { title: "Codigo", data: "CODREP" },
            { title: "Nome", data: "NOME" },
            { title: "Com. Fat.", data: "COM1" },
            { title: "Com. Rec.", data: "COM2" }
        ];

        $("#tabelaRepresentantes").DataTable({
            destroy: true,
            filter: false,
            paging: false,
            scrollX: true,
            autoWidth: true,
            columns: titulosRepresentantes,
            data: [obj],
            columnDefs: [
                {
                    "render": function (data) {
                        return parseFloat(data).toLocaleString("pt-BR", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        })
                    },
                    "targets": [2, 3],
                    "className": 'pr-4 text-right'
                },
                {
                    targets: [0],
                    render: function (data, type, row) {
                        return '<div style="text-align:start;"> ' +
                            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
                            '      ' + data + ' ' +
                            '    </button> ' +
                            '    <div class="dropdown-menu"> ' +
                            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
                            '</div>';
                    },
                },
            ]
        });

        $('#txtAddRepresentante').val('');
        $('#txtAddComFat').val(0.00);
        $('#txtAddComRec').val(0.00);
    });

    function buscaDadosMoedas() {
        const tabelaMoedas = $('#tabelaMoedas').DataTable().rows().data().toArray();

        const dados = tabelaMoedas.map((item) => ({
            codCli: $('#txtCodCli').val(),
            codMoe: item[0].match(/\d+/)[0],
        }))

        return dados
    }

    function buscaDadosRepresentantes() {
        let dados;
        if ($.fn.DataTable.isDataTable('#tabelaRepresentantes')) {
            const tabelaRepresentantes = $('#tabelaRepresentantes').DataTable().rows().data().toArray();

            dados = tabelaRepresentantes.map((item) => ({
                codCli: $('#txtCodCli').val(),
                codRep: item.CODREP ? item.CODREP.match(/\d+/)[0] : '',
                com1: parseFloat(item.COM1),
                com2: parseFloat(item.COM2)
            }))
        } else {
            dados = []
        }

        return dados
    }

    async function limpaCep() {
        $('#txtCidade').val('');
        // $('#txtCep').val('');
        $('#txtUF').val('');
        $('#txtRua').val('');
        $('#txtNumero').val('');
        $('#txtBairro').val('');
    }

    async function limpaCepEntrega() {
        $('#txtCidadeEntrega').val('');
        $('#txtUFEntrega').val('');
        $('#txtRuaEntrega').val('');
        $('#txtNumeroEntrega').val('');
        $('#txtBairroEntrega').val('');
    }

    async function limpaCepCobranca() {
        $('#txtCidadeCobranca').val('');
        $('#txtUFCobranca').val('');
        $('#txtRuaCobranca').val('');
        $('#txtNumeroCobranca').val('');
        $('#txtBairroCobranca').val('');
    }

    async function adicionaTipos() {
        const pesquisaParam = {
            tabela: 'TPDOCPESSOA',
            camposSelect: ['DESCRICAO', 'MASCARA'],
            where: ["ATIVO = 'S'"],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        jsonStr.map((item, index) => {
            $("#rgTipoEnt").append(new Option(item.DESCRICAO, item.MASCARA, null, index == 0));
        });

        if (jsonStr.length > 0) {
            ajustaMaskCpfCnpj();
        }
    };

    async function adicionaClassificacao() {
        const pesquisaParam = {
            tabela: 'SOLUCAO',
            camposSelect: ['DESCRICAO5'],
            where: ["VARIAVEL = 'ENTIDADE2CBCLASSIFICACAO'"],
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (!jsonStr || jsonStr.length === 0) {
            return;
        }

        $("#rgClassificacao").empty();

        $("#rgClassificacao").append('<option value="" selected disabled>Selecione uma opção</option>');

        jsonStr.forEach(item => {
            if (!item.DESCRICAO5) return;

            const partes = item.DESCRICAO5.trim().split(" ");

            partes.forEach(p => {
                const valor = p.trim();

                if (valor != "") {
                    $("#rgClassificacao").append(new Option(valor, valor));
                }
            });
        });
    }

    $("#btnConsultaReceita").on('click', function () {
        $.LoadingOverlay("show");
        try {
            const cnpj = $('#txtCNPJ').val();
            $("#txtCNPJConsulta").val(cnpj);
            $("#modalConsultaReceita").modal("show");
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let cliente = parametros[parametros.length - 1];

    $("#txtRG").on("input", function () {
        let c = this.selectionStart;
        let r = /[^a-z0-9]/gi;
        let v = $(this).val();
        if (r.test(v)) {
            $(this).val(v.replace(r, ""));
            c--;
        }
        this.setSelectionRange(c, c);
    });

    await criaTabelaChavePix();

    $('#btnFuncionario').on('click', async function () {
        if ($('#txtCNPJ').val().length > 14) {
            msgAlerta('Não é possível cadastrar pessoa jurídica como funcionário.')
            return;
        }

        await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
        parent.abrirEmNovaAbaIFrame('Funcionário', `${BASE_URI}/funcionario/${cliente}`);
        await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
        // parent.$(`#tab--sisplan_web-cliente`).parent().children()[0].click();
    });

    $("#btnRepresentante").on("click", async function () {
        if (cliente != "create") {
            await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
            parent.abrirEmNovaAbaIFrame('Representante', `${BASE_URI}/representante/${cliente}`);
            await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
            // parent.$(`#tab--sisplan_web-cliente`).parent().children()[0].click();
        } else {
            msgAlerta("Nenhuma entidade para cadastrar como representante.");
        }
    });

    $("#btnTransportadora").on("click", async function () {
        if (cliente != "create") {
            await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
            parent.abrirEmNovaAbaIFrame('Transportadora', `${BASE_URI}/transportadora/${cliente}`);
            await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
            // parent.$(`#tab--sisplan_web-cliente`).parent().children()[0].click();
        } else {
            msgAlerta("Nenhuma entidade para cadastrar como transportadora.");
        }
    });

    $('#txtRenda').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtPercRetencao').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtDDD').on('keypress', function (event) {
        let regex = new RegExp("^[0-9]+$");
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });
    $('#txtPercDesconto').on('keypress', function (event) {
        let regex = new RegExp("^[0-9]+$");
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
        window.location.href = `${BASE_URI}/cliente`;
    });

    $('#btnEstatisticas').on('click', async function () {
        await abreEstatisticasCliente($('#txtCodCli').val(), $('#txtNome').val());
    });

    $("#endereco").on("click", async function () {
        $("#enderecoGeral").collapse("show");
    });

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    async function usuarioehMasterOuSupervisor() {
        try {
            const usuario = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie('cod_usuario')}'"] }`) ?? 0;

            return usuario[0].TIPO != 0;

        } catch (error) {
            console.error(error);
        }
    }


    // if ($("#txtCNPJ").length > 11) {
    //     $("#txtCNPJ").mask("00.000.000/0000-00", options);
    // } else {
    //     $("#txtCNPJ").mask("000.000.000-00#", options);
    // }

    function ajustaMaskCpfCnpj() {
        const naoPermiteAlterarTipoCNPJ = ((alterarTipoCnpjCpf == '0') || ((alterarTipoCnpjCpf == '2') && (!bTipoUsuarioMasterOuSupervisor)));
        if (($(window.location.href.split('/')).get(-1) != 'create') && (naoPermiteAlterarTipoCNPJ)) {
            $('#rgTipoEnt').prop('disabled', true);
            return;
        }

        const options = {
            onKeyPress(cpf, ev, el, op) {
                let mask = pegaValor('#rgTipoEnt').replaceAll('#', '0');
                $("#txtCNPJ").mask(mask, op);
            },
        };

        if ($(window.location.href.split('/')).get(-1) == 'create') {
            $("#txtCNPJ").val('');
        }

        const caracteresMask = filtrarCaracteres(pegaValor('#rgTipoEnt'), ["A", "a", "L", "#", "C", "c"]);
        limitaCaracteresInput("txtCNPJ", caracteresMask.length);

        // $("#txtCNPJ").mask("000.000.000-00#", options);
    }

    $('#rgTipoEnt').on('change', function () {
        ajustaMaskCpfCnpj();
    });

    const naoPermiteAlterarTipoCNPJ = ((alterarTipoCnpjCpf == '0') || ((alterarTipoCnpjCpf == '2') && (!bTipoUsuarioMasterOuSupervisor)));
    $("#txtCNPJ").prop("disabled", ((cliente != "create") && (naoPermiteAlterarTipoCNPJ)));

    let SPMaskBehavior = function (val) {
        return val.replace(/\D/g, "").length === 9 ? "00000-0000" : "0000-00009";
    };
    let spOptions = {
        // eslint-disable-next-line no-shadow
        onKeyPress(val, e, field, options) {
            // eslint-disable-next-line prefer-rest-params
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        },
    };

    $('#txtDDI').on('input', function () {
        var value = $(this).val();
        value = value.replace(/\D/g, '');
        if (value.length > 0) {
            value = '+' + value;
        }
        $(this).val(value);
    });

    $("#txtTelefone").mask(SPMaskBehavior, spOptions);

    $("#txtCNPJ").change(async function () {
        try {
            $.LoadingOverlay("show");
            try {

                if ($(this).val() == '') {
                    return;
                }

                let bAbort = false;
                aplicaMascaraCNPJ();
                const mascara = $("#rgTipoEnt").val();
                const cpfCnpjFormatado = $("#txtCNPJ").val();
                const parametroBloquearCPFCNPJInvalido = parametrosEntidade[8].VALOR ?? 0;

                const callback = () => {
                    $('#txtCNPJ').val('');
                    $('#txtCNPJ').focus();
                };

                if (parametroBloquearCPFCNPJInvalido == '1') {
                    if ((mascara == "###.###.###-##") && (!valida_cpf(cpfCnpjFormatado))) {
                        msgAlerta('CPF inválido, impossível continuar.', callback, undefined, undefined, callback, false, true);
                        return;
                    }
                    if ((mascara == "##.###.###/####-##") && (!valida_cnpj(cpfCnpjFormatado))) {
                        msgAlerta('CNPJ inválido, impossível continuar.', callback, undefined, undefined, callback, false, true);
                        return;
                    }
                } else {
                    if (mascara == "###.###.###-##") {
                        if (!valida_cpf(cpfCnpjFormatado)) {
                            await msgAguardaConfirmacao("CPF inválido, deseja continuar?",
                                () => { },
                                () => {
                                    $(this).val("");
                                    bAbort = true;
                                });
                            if (bAbort) {
                                return;
                            }
                        }
                    } else if (mascara == "##.###.###/####-##") {
                        if (!valida_cnpj(cpfCnpjFormatado)) {
                            await msgAguardaConfirmacao("CNPJ inválido, deseja continuar?",
                                () => { },
                                () => {
                                    $(this).val("");
                                    bAbort = true;
                                });
                            if (bAbort) {
                                return;
                            }
                        }
                    }
                }

                // let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                // if (validaCNPJ != false) {
                //     $("#txtCNPJ").val(validaCNPJ);
                // }

                let response = await requisicao("GET", "/Sisplan/Cliente/V1/Entidade?", `CNPJ=${$("#txtCNPJ").val()}`);

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                if (jsonStr.length > 0) {

                    $.LoadingOverlay("hide");
                    toastr
                        .warning("CNPJ/CPF informado já existe!", "Atenção", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                if (!naoPermiteRecarregarEntidade) {
                                    window.location.href = `${BASE_URI}/cliente/${jsonStr[0].CODCLI}`;
                                } else {
                                    $('#txtCNPJ').val('');
                                }
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                            color: "black",
                        });
                    return;
                }
            } catch (error) {
                console.log(error);
            }

            // if (!valida_cpf_cnpj($("#txtCNPJ").val()) && (paramCadastraSemCPF != 1 ?? 0)) {
            //     $("#txtCNPJ").rules("add", "valida_cpf_cnpj");
            //     $("#txtCNPJ").focus();
            // }

            const verifica_CPF_CNPJ = verifica_cpf_cnpj($("#txtCNPJ").val()) == "CNPJ";
            if (verifica_CPF_CNPJ && cliente == "create" && $("#txtNome").val() == "") {
                await buscaDadosCliente(cliente, $("#txtCNPJ").val().replace(/[^0-9]/g, ""));
            }

            if (!verifica_CPF_CNPJ) {
                $('#btnConsultaReceita').attr('disabled', true);
            } else {
                $('#btnConsultaReceita').attr('disabled', false);
            }

        } finally {
            $.LoadingOverlay("hide");
            $("#rgTributacao").val($('#txtCNPJ').val().length == 14 ? 'S' : 'A').change();
        }
    });

    async function cadastroEntidadeContabil(codcli) {
        try {

            const entidadecontabil = {
                CODCLI: codcli,
                CON_CLI: pegaChave('#txtContaCliente'),
                ADI_CLI: pegaChave('#txtContaCAdiantamento'),
                DEV_CLI: pegaChave('#txtContaCDevolucao'),
                CON_FOR: pegaChave('#txtContaFornecedor'),
                ADI_FOR: pegaChave('#txtContaFAdiantamento'),
                DEV_FOR: pegaChave('#txtContaFDevolucao')
            };

            let response = await requisicao("POST", "/sisplan/cliente/V1/entidadecontabil?", `JSON=${encodeURIComponent(JSON.stringify(entidadecontabil))}&CODUSUARIO=${getCookie('cod_usuario')}`);

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta("Erro ao gravar dados da conta");
                console.log(jsonStr.mensagem);
                return;
            }

        } catch (error) {
            console.log(error);
        }
    }

    async function verificaCheckBox() {
        if ($('#cbTipoCliente').is(':checked') == false &
            $('#cbTipoFornecedor').is(':checked') == false &
            $('#cbTipoTerceiros').is(':checked') == false &
            $('#cbTipoRepresentante').is(':checked') == false &
            $('#cbTipoProspecto').is(':checked') == false &
            $('#cbTipoFuncionario').is(':checked') == false) {
            return false;
        }
    }

    $('#rgSemanaMes').change(async function () {
        await desabilitaDiasConformeSelect();
    });

    async function desabilitaDiasConformeSelect() {
        if ($('#rgSemanaMes').val() === 'SEMANA') {
            $('.cbsSemana').attr('disabled', false);
            $('.cbsMes').attr('disabled', true);
        } else if ($('#rgSemanaMes').val() === 'MES') {
            $('.cbsSemana').attr('disabled', true);
            $('.cbsMes').attr('disabled', false);
        } else {
            $('.cbsSemana').attr('disabled', false);
            $('.cbsMes').attr('disabled', false);
        }
    }

    jQuery.validator.addMethod("validarCaracteres", function (value) {
        return validarCaracteres(value) === 0;
    });

    jQuery.validator.addMethod("valida_cpf_cnpj", function (value) {
        return valida_cpf_cnpj(value);
    });

    $("#msform").validate({
        debug: false,
        ignore: "",
        rules: {
            txtCNPJ: {
                required: paramCadastraSemCPF != '1',
                // valida_cpf_cnpj: paramCadastraSemCPF != '1',
            },
            txtNome: {
                required: true,
                validarCaracteres: true,
            },
            txtFantasia: {
                validarCaracteres: true,
            },
            txtCep: {
                required: true,
            },
            txtPais: {
                required: true,
            },
            txtRua: {
                required: true,
            },
            txtNumero: {
                required: true,
            },
            txtBairro: {
                required: true,
            },
            txtDDD: {
                required: true,
            },
            txtTelefone: {
                required: true,
            },
        },
        messages: {
            txtCNPJ: {
                required: paramCadastraSemCPF != '1' ? "Informe um CNPJ/CPF válido." : '',
                valida_cpf_cnpj: paramCadastraSemCPF != '1' ? "Informe um CNPJ/CPF válido." : '',
            },
            txtNome: {
                required: "Informe um nome válido.",
                validarCaracteres: "Nome não pode conter caracteres especiais",
            },
            txtFantasia: {
                validarCaracteres: "Fantasia não pode conter caracteres especiais",
            },
            txtCep: {
                required: "Informe um CEP válido.",
            },
            txtPais: {
                required: "Informe um País válido.",
            },
            txtRua: {
                required: "Informe uma Rua válida.",
            },
            txtNumero: {
                required: "Informe um Número válido.",
            },
            txtBairro: {
                required: "Informe um Bairro válido.",
            },
            txtDDD: {
                required: "Informe um DDD válido",
            },
            txtTelefone: {
                required: "Informe um Telefone válido",
            },
        },
        errorElement: "span",
        errorPlacement(error, element) {
            error.addClass("invalid-feedback");
            element.closest(".form-group").append(error);
        },
        highlight(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight(element) {
            $(element).removeClass("is-invalid");
        },
        invalidHandler(e, validator) {
            if (validator.errorList.length) {
                console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
                if (validator.errorList[0].element.id == "txtCep" || validator.errorList[0].element.id == "txtPais") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#enderecoGeral").collapse("show");
                    }
                }
                if (validator.errorList[0].element.id == "txtRua") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                }
                if (validator.errorList[0].element.id == "txtNumero") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                }
                if (validator.errorList[0].element.id == "txtBairro") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                }


                let id = $(
                    $(`#${$(validator.errorList[0].element).prop("id")}`)
                        .closest(".card-body")
                        .closest(".collapse")
                ).prop("id");
                if ((!$(`#${id}`).hasClass('show')) && id != "multiCollapseExample1") {
                    $(`a[href='#${id}']`).trigger("click");
                }
            }
        },

        async submitHandler(form, event) {
            event.preventDefault();
            try {
                if (camposObrigatorios) {
                    if (camposObrigatorios.length > 0) {
                        for (let i = 0; i < camposObrigatorios.length; i++) {
                            const campo = $(`#${camposObrigatorios[i]}`);
                            if (campo.prop('type') == 'date') {
                                if (campo.val() == '' || campo.val() == '1899-01-01' || campo.val().includes('1899')) {
                                    const nomeCampo = campo.prev('label').text().substring(0, campo.prev('label').text().indexOf(':')).toLowerCase();
                                    msgErro('O campo "' + nomeCampo + '" não pode estar vazio ou com a data padrão! Tente novamente.');
                                    return;
                                };
                            };

                            if (campo.prop('type') == 'number') {
                                const nomeCampo = campo.prev('label').text().toLowerCase();
                                if (campo.val() == '' || campo.val() == null || campo.val() == undefined || campo.val() == 0) {
                                    if (cliente == "create") {
                                        msgErro('O campo "' + nomeCampo + '" não pode estar vazio ou com o valor padrão! Tente novamente.');
                                        return;
                                    }
                                }
                            }

                            if (campo.prop('tagName').toLowerCase() == 'select') {
                                if (campo.val() == '' || campo.val() == null || campo.val() == undefined) {
                                    const nomeCampo = campo.prev('label').text().substring(0, campo.prev('label').text().indexOf(':')).toLowerCase();

                                    msgErro('O campo "' + nomeCampo + '" não pode estar vazio! Tente novamente.');
                                    return;
                                };
                            };
                        };
                    };
                }
                $.LoadingOverlay("show");
                if (cliente == "create") {
                    try {
                        if (paramCadastraSemCPF != '1') {
                            let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                            if (validaCNPJ != false) {
                                $("#txtCNPJ").val(validaCNPJ);
                            }
                            let response = await requisicao("GET", "/Sisplan/Cliente/V1/Entidade?", `CNPJ=${$("#txtCNPJ").val()}`);

                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                msgAlerta(jsonStr.mensagem);
                                return;
                            }

                            if (jsonStr.length > 0) {
                                msgAlerta("CNPJ/CPF informado já existe");
                                window.location.href = `${BASE_URI}/cliente/${jsonStr[0].CODCLI}`;
                                return;
                            }
                        }
                    } catch (error) {
                        console.log(error);
                    }
                }

                try {
                    // replace nos cep
                    let cep = $("#txtCep").val().replace(/\D/g, "");

                    let response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela":"CADCEP", "camposSelect":["CEP"], "where": ["CEP = '${cep}'"]}`, null);

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgAlerta(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    if (jsonStr.RESULT[0].length <= 0) {
                        msgAlerta("Cep não informado ou inválido.");
                        $("#txtCep").focus();
                        return;
                    }

                } catch (error) {
                    console.log(error);
                }

                try {
                    if (isChecked('#cbConsumidorFinal') && $("#rgIE").val() == '1') {
                        await msgAguardaConfirmacao(`Cliente é contribuinte de ICMS, deseja manter a opção consumidor final ativo?`,
                            () => { $('#cbConsumidorFinal').prop('checked', true); rotinaGeraLog('CLIENTE', $("#txtCNPJ").val(), `Usuário optou por manter o cliente como consumidor final.`, 'Alteração'); },
                            () => { $('#cbConsumidorFinal').prop('checked', false); rotinaGeraLog('CLIENTE', $("#txtCNPJ").val(), `Usuário optou por não manter o cliente como consumidor final.`, 'Alteração'); }
                        );
                    }

                    let codrep = $("#txtRepresentante").val().substring(1, $("#txtRepresentante").val().indexOf("] - "));
                    let tabela = $("#txtTabela").val().substring(1, $("#txtTabela").val().indexOf("] - "));

                    let entidade = {};

                    let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                    if (validaCNPJ != false) {
                        $("#txtCNPJ").val(validaCNPJ);
                    }

                    const temCaracteresEspeciais = validarCaracteres($("#txtNome").val()) > 0;
                    if (temCaracteresEspeciais) {
                        msgAlerta("Nome não pode conter caracteres especiais");
                        return;
                    }

                    const fantasiaTemCaracteresEspeciais = validarCaracteres($("#txtFantasia").val()) > 0;
                    if (fantasiaTemCaracteresEspeciais) {
                        msgAlerta("Fantasia não pode conter caracteres especiais");
                        return;
                    }

                    if (validarPorteCadastroPessoaJuridica()) {
                        return
                    }

                    if (await validaContaContabil()) {
                        return
                    }

                    if (($("#rgIE").val() == '1') && ($('#txtIE').val() == '')) {
                        msgAlerta('Cliente configurado como Contribuinte ICMS, necessário informar a IE na aba Documento.');
                        return;
                    }

                    entidade.CNPJ = $("#txtCNPJ").val();
                    entidade.CNPJ_ENT = $("#txtCNPJEnt").val();
                    entidade.CNPJ_COB = $("#txtCNPJCob").val();
                    entidade.DATA_CAD = $("#txtDataCadastro").val() != '' ? `${$("#txtDataCadastro").val()}T00:00:00Z` : `1899-01-01T00:00:00Z`;
                    entidade.DATA_BUSCA = `${new Date().toJSON().slice(0, 10)}T00:00:00Z`;
                    entidade.NOME = $("#txtNome").val().toUpperCase();
                    entidade.FANTASIA = $("#txtFantasia").val().toUpperCase();
                    entidade.OBS = $("#txtObs").val();
                    entidade.ATIVO = $("#cbAtivo").is(":checked") ? "S" : "N";
                    entidade.BLOQUEIO = $("#cbBloqueado").is(":checked") ? "S" : "N";
                    entidade.CONS_FINAL = $("#cbConsumidorFinal").is(":checked") ? "Sim" : "Nao";
                    entidade.INTEGRA_SHOPP = $("#cbIntegraShop").is(":checked") ? "N" : "S";
                    entidade.GERA_CASHBACK = $("#cbGeraCashback").is(":checked") ? "N" : "S";
                    entidade.NUM_RG = $("#txtRG").val();
                    entidade.EMI_RG = $("#txtEmissor").val();
                    entidade.INSCRICAO = $("#txtIE").val();
                    entidade.SEXO = $("#rgSexo").val();
                    entidade.PORTE_EMPRESA = $("#rgPorteEmpresa").val();
                    entidade.DT_NASC = $("#txtDataNascimento").val() != '' ? $("#txtDataNascimento").val() : '1899-01-01';
                    entidade.COD_PAIS = pegaChave('#txtPais');
                    entidade.CEP = $("#txtCep").val().replace(/\D/g, "");
                    entidade.ENDERECO = $("#txtRua").val();
                    entidade.NUMERO = $("#txtNumero").val();
                    entidade.COMPLEMENTO = $("#txtComplemento").val();
                    entidade.BAIRRO = $("#txtBairro").val();
                    entidade.TIPO = verifica_cpf_cnpj($("#txtCNPJ").val()) == "CNPJ" ? "2" : "1";
                    entidade.IE_DESTINATARIO = $("#rgIE").val();
                    entidade.DDI = $("#txtDDI").val().replace(/\+/g, '');
                    entidade.DDD_FONE = $("#txtDDD").val();
                    entidade.TELEFONE = $("#txtTelefone").val();
                    entidade.EMAIL = $("#txtEmail").val();
                    validaCNPJ = verifica_cpf_cnpj(entidade.CNPJ);
                    entidade.SIMPLES = $("#rgTributacao").val() != '' ? $("#rgTributacao").val() : ($('#txtCNPJ').val().length == 14 ? 'S' : 'A');
                    entidade.CEP_COB = $("#txtCepCobranca").val().replace(/\D/g, "");
                    entidade.END_COB = $("#txtRuaCobranca").val();
                    entidade.NUM_COB = $("#txtNumeroCobranca").val();
                    entidade.COMP_COB = $("#txtComplementoCobranca").val();
                    entidade.BAIRRO_COB = $("#txtBairroCobranca").val();
                    entidade.CEP_ENT = $("#txtCepEntrega").val().replace(/\D/g, "");
                    entidade.END_ENT = $("#txtRuaEntrega").val();
                    entidade.NUM_ENT = $("#txtNumeroEntrega").val();
                    entidade.COMP_ENT = $("#txtComplementoEntrega").val();
                    entidade.BAIRRO_ENT = $("#txtBairroEntrega").val();
                    entidade.CREDITO = $("#txtLimiteCredito").val();
                    entidade.CREDITO_UTILIZADO = $("#txtLimiteUsado").val();
                    entidade.LIMITE_FID = $("#txtLimiteFidelidade").val();
                    entidade.LIMITE_UTIL_FID = $("#txtLimiteFidelidadeUsado").val();
                    entidade.CODREP = codrep;
                    entidade.TABELA = tabela;
                    entidade.SIT_CLI = $("#txtRamoAtividade").val() != '' ? pegaChave('#txtRamoAtividade') : '';
                    entidade.REG_ESTADO = $("#txtRegiao").val() != '' ? pegaChave('#txtRegiao') : '';
                    entidade.LOCAL_TRAB = $("#txtLocalTrab").val();
                    entidade.ESTADO_CIVIL = $("#txtEstadoCivil").val();
                    entidade.NOME_PAI = $("#txtNomePai").val();
                    entidade.NOME_MAE = $("#txtNomeMae").val();
                    entidade.RENDA = $("#txtRenda").val();
                    entidade.DT_ADMISSAO = $("#txtDtAdmissao").val() != '' ? $("#txtDtAdmissao").val() : '1899-01-01';
                    entidade.GRUPO = pegaChave("#txtGrupo");
                    entidade.CLASSE = pegaChave("#txtClasse");
                    entidade.MIDIAS_SOCIAIS = $('#txtMidiaSocial').val();
                    entidade.INSC_COB = $('#txtInscCob').val();
                    entidade.INSC_ENT = $('#txtInscEnt').val();
                    entidade.INSC_EST = $('#txtInscricaoMunicipal').val();
                    entidade.CANAL_CONTATO = pegaChave('#txtCanalContato');
                    entidade.TP_FRETE = $('#rgTipoFrete').val();
                    entidade.TRANSPORTE = pegaChave('#txtTransportadora');
                    entidade.TIPO_ENTIDADE = '';
                    entidade.COD_CONF_XML = pegaChave('#txtConfXML');
                    entidade.CRED_CONSIGNADO = $('#txtCreditoGrupo').val();
                    entidade.TIPO_DIAS_VENCTO = $('#rgSemanaMes').val();
                    entidade.MOEDA = parseInt($('#txtMoeda').val()[0]);
                    entidade.HISTORICO = pegaChave('#txtHistorico');
                    entidade.CONDICAO_PAGAMENTO = pegaChave('#txtCondicaoPagto');
                    entidade.SINTEGRA = $('#txtSintegra').val();
                    entidade.CNAE = pegaChave('#txtCnae');
                    entidade.ENTID_AUX = pegaChave('#txtEntidadeAux');
                    entidade.COD_IMPORTADO = $("#txtCodImportado").val();
                    entidade.TRIBUTACAO = pegaChave('#rgTributacao');
                    entidade.CNPJ_FAVOR = $("#txtCNPJFavorecido").val();
                    entidade.NOME_FAVOR = $("#txtNomeFavorecido").val();
                    entidade.DT_NASC_FAVOR = $("#txtDataNascimentoFavorecido").val();
                    //CERTIFICAÇÔES
                    entidade.ABVTEX = $('#txtABVTEX').val();
                    entidade.DISNEY = $('#txtDisney').val();
                    entidade.VALIDA_ABVTEX = !$('#dtABVTEX').val() ? '1899-01-01' : $('#dtABVTEX').val();
                    entidade.LICENCIADO = !$('#dtLicenciado').val() ? '1899-01-01' : $('#dtLicenciado').val();
                    //SUFRAMA
                    entidade.SUFRAMA = $('#txtSuframa').val();
                    entidade.VALIDA_SUFRAMA = $('#txtValidadeSuframa').val() != '' ? $('#txtValidadeSuframa').val() : '1899-12-31';
                    entidade.SUFRAMA_CONF = $('#cbBenefIcms').prop('checked') ? 'I' : '';
                    entidade.SUFRAMA_CONF += $('#cbBenefPis').prop('checked') ? 'P' : '';
                    entidade.SUFRAMA_CONF += $('#cbBenefCofins').prop('checked') ? 'C' : '';
                    //DADOS SPC
                    entidade.DT_CONSULTA_SPC = !$('#dtUltimaConsultaSPC').val() ? '1899-01-01' : $('#dtUltimaConsultaSPC').val();
                    entidade.DT_ENTRADA_SPC = !$('#dtEntradaSPC').val() ? '1899-01-01' : $('#dtEntradaSPC').val();
                    entidade.DT_SAIDA_SPC = !$('#dtSaidaSPC').val() ? '1899-01-01' : $('#dtSaidaSPC').val();
                    entidade.DUPLICATA_SPC = $('#txtDuplicataSPC').val();
                    entidade.REGISTRO_SPC = $('#cbClienteSPC').is(':checked') ? 'S' : 'N';
                    entidade.COLOCADO_SPC = $('#cbColocadoSPC').is(':checked') ? 'S' : 'N';
                    entidade.REGISTRADO_SPC = $('#cbCientePassouSPC').is(':checked') ? 'S' : 'N';
                    entidade.REQUER_ANALISE = $('#cbClienteRequerAnalise').is(':checked') ? 'S' : 'N';
                    entidade.ANALISADO_SERASA = $('#cbClienteAnalisado').is(':checked') ? 'S' : 'N';
                    entidade.RENEG_ATRASADA = $('#cbPossuiRenegociacaoAtrasadaSPC').is(':checked') ? 'S' : 'N';
                    entidade.VALIDA_CONS_SPC = $('#txtValidadeUltimaConsulta').val();
                    entidade.SCORE_SERASA = $('#txtScoreSerasa').val();
                    entidade.AGENCIA = $('#txtAgencia').val();
                    entidade.EMP_ID = getCookie('emp_id')
                    entidade.DESCONTO = $('#txtPercDesconto').val()
                    entidade.PERC_IR_RET = $('#txtPercRetencao').val()
                    entidade.PERFIL = pegaChave('#txtPerfil')
                    entidade.STATUS = $('#selectStatus').val();
                    entidade.DT_VALID_LIMITE = $("#txtValidadeLimiteSuspenso").val();
                    entidade.LIMITE_SUSPENSO = $('#cbLimiteSuspenso').is(':checked') ? 'S' : 'N';

                    let tamanhoVazio = ''
                    while ($('#txtClassificacao').val().length < 4) {
                        tamanhoVazio += ' ';
                        $('#txtClassificacao').val(tamanhoVazio);
                    }
                    let classificacaoAtual = $('#rgClassificacao').val() != null ? $('#txtClassificacao').val() + $('#rgClassificacao').val() : '';
                    $('#txtClassifica').val(classificacaoAtual);
                    entidade.CLASSIFICA = classificacaoAtual
                    ///////////////
                    entidade.BANCO = pegaChave('#txtBanco');
                    entidade.CONTA = pegaChave('#txtConta');
                    entidade.SIT_DUP = pegaChave('#txtSitDup');
                    // const moedas = await formataListas($('#txtMoeda').val().toString());

                    let arrDiasVencto = [];
                    if (entidade.TIPO_DIAS_VENCTO == 'SEMANA') {
                        for (let i = 0; i <= 6; i++) {
                            if (isChecked(`#cbSemana${i}`)) {
                                arrDiasVencto.push(i);
                            }
                        }
                    } else {
                        for (let i = 1; i <= 31; i++) {
                            if (isChecked(`#cbDia${i}`)) {
                                arrDiasVencto.push(i);
                            }
                        }
                    }

                    if ($("#cbTipoCliente").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'C';
                    }
                    if ($("#cbTipoFornecedor").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'F';
                    }
                    if ($("#cbTipoTerceiros").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'T';
                    }
                    if ($("#cbTipoRepresentante").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'R';
                    }
                    if ($("#cbTipoProspecto").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'P';
                    }
                    if ($("#cbTipoFuncionario").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'E';
                    }

                    let checkBox = await verificaCheckBox();

                    if (checkBox == false) {
                        try {
                            msgErro('É preciso selecionar pelo menos um tipo de entidade')
                            $('#tabelaEmbarque').DataTable().context[0](0, ($('.selected')[0].offsetTop));
                        } catch (error) {
                            return;
                        }
                    }

                    const dadosSetores = buscaDadosSetores();
                    const dadosMoedas = buscaDadosMoedas();
                    const dadosRepresentantes = buscaDadosRepresentantes();
                    const dadosChavePix = buscaDadosChavePix();

                    const setores = {
                        setores: dadosSetores
                    }

                    const moedas = {
                        moedas: dadosMoedas
                    }

                    const representantes = {
                        cliComClientes: dadosRepresentantes
                    }

                    const chavePix = {
                        cliBancoClientes: dadosChavePix
                    }


                    if (cliente != "create" && cliente.length < 30) {
                        entidade.CODCLI = cliente;
                        entidade.USUARIO = await buscaUsuarioEntidade(cliente)
                    } else {
                        cliente = "create";
                        entidade.USUARIO = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
                    }

                    const entidadeContabil = {
                        CODCLI: cliente,
                        CON_CLI: pegaChave('#txtContaCliente'),
                        ADI_CLI: pegaChave('#txtContaCAdiantamento'),
                        DEV_CLI: pegaChave('#txtContaCDevolucao'),
                        CON_FOR: pegaChave('#txtContaFornecedor'),
                        ADI_FOR: pegaChave('#txtContaFAdiantamento'),
                        DEV_FOR: pegaChave('#txtContaFDevolucao')
                    };

                    const header =
                        `LISTADIAS=${encodeURIComponent(JSON.stringify({ ARR_DIAS_VENCTO: arrDiasVencto }))}` +
                        `&MOEDAS=${JSON.stringify(moedas)}` +
                        `&SETORES=${JSON.stringify(setores)}` +
                        `&CLICOM=${JSON.stringify(representantes)}` +
                        `&CLIBANCO=${JSON.stringify(chavePix)}` +
                        `&CODUSUARIO=${getCookie('cod_usuario')}`;

                    const body =
                        `JSON=${JSON.stringify(entidade)}` +
                        `&CONTABIL=${JSON.stringify(entidadeContabil)}`;

                    let response = await requisicao(cliente != "create" ? "PUT" : "POST",
                        `/Sisplan/Cliente/V1/Entidade?`,
                        header,
                        body
                    );

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgAlerta(jsonStr.mensagem);
                        return;
                    }

                    const arrTabelas = $('#gridTabelasModal').DataTable()
                        .rows()
                        .data()
                        .toArray()
                        .map((tabela) => tabela[0]);

                    await vinculaTabelasAoCliente(jsonStr[0].CODCLI, arrTabelas.toString());

                    // await cadastroEntidadeContabil(jsonStr[0].CODCLI);

                    toastr
                        .success("Cadastro efetuado com sucesso!", "Confirmação", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/cliente`;
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                        });
                } catch (error) {
                    console.error(error);
                    msgAlerta('Não foi possível gravar os dados do cliente!');
                }

            } finally {
                $.LoadingOverlay("hide");
            }
        },
    });

    $('#txtNome').on('input', function () {
        $('#txtNome').val($('#txtNome').val().toUpperCase());
        if (validarCaracteres($("#txtNome").val()) > 0) {
            $("#txtNome").rules("add", "validarCaracteres");
            $("#txtNome").focus();
        }
    });

    $('#lblSetor').on('click', function () {
        $('#modalVinculaSetor').modal('show');
    });

    $('#lblBanco').on('click', function () {
        $('#modalChavePix').modal('show');
    })

    $('#lblMoeda').on('click', function () {
        $('#modalVinculaMoeda').modal('show');
    });

    $('#lblRepresentantes').on('click', async function () {
        $('#modalVinculaRepresentante').modal('show');
        if ($.fn.DataTable.isDataTable('#tabelaRepresentantes')) {
            await sleep(200);
            $("#tabelaRepresentantes").DataTable().columns.adjust().draw(false);
        }
    });


    $('#txtValidadeUltimaConsulta').on('blur', function () {
        let validadeConsulta = parseInt($('#txtValidadeUltimaConsulta').val());
        let dataHoje = formataData(new Date());

        let dataAtual = new Date($('#dtUltimaConsultaSPC').val());
        dataAtual.setDate(dataAtual.getDate() + 10);
        let newData = dataAtual.toISOString().slice(0, validadeConsulta);

        $('#lblConsultaVencida').removeClass('d-block');
        $('#lblConsultaVencida').addClass('d-none');
        if (newData < dataHoje) {
            $('#lblConsultaVencida').removeClass('d-none');
            $('#lblConsultaVencida').addClass('d-block');
        }
    })

    $('#txtFantasia').on('input', function () {
        $('#txtFantasia').val($('#txtFantasia').val().toUpperCase());
    });

    infoCep = '';

    $("#txtCep").blur(async function () {
        await limpaCep()
        infoCep = $("#txtCep");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidade").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUF").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtRua").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairro").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    $("#txtCepEntrega").blur(async function () {
        await limpaCepEntrega();
        infoCep = $("#txtCepEntrega");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidadeEntrega").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUFEntrega").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtRuaEntrega").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairroEntrega").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    $("#txtCepCobranca").blur(async function () {
        await limpaCepCobranca()
        infoCep = $("#txtCepCobranca");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidadeCobranca").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUFCobranca").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtRuaCobranca").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairroCobranca").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    async function preencheDDI() {
        setTimeout(async () => {
            const pais = pegaChave('#txtPais')
            if (!pais) {
                return
            }
            const ddi = (await buscaValor('CADPAIS', 'DDI', 'CODIGO', pais)).DDI
            if (ddi) $('#txtDDI').val(ddi)
        }, 500)
    }

    if (cliente != "" && cliente != "create") {
        $('#txtLimiteCredito').attr('readonly', ['0', '2'].includes(alterarLimiteCredito));
        $('#txtLimiteFidelidade').attr('readonly', ['0', '2'].includes(alterarLimiteFidelidade));
        $('#txtGrupo').attr('disabled', ['0', '2'].includes(alterarGrupo));
        $('#btn-Grupo').attr('disabled', ['0', '2'].includes(alterarGrupo));
        $('#btn-AGrupo').attr('disabled', ['0', '2'].includes(alterarGrupo));
    } else {
        $('#txtLimiteCredito').attr('readonly', alterarLimiteCredito == '2');
        $('#txtLimiteFidelidade').attr('readonly', alterarLimiteFidelidade == '2');
        $('#txtGrupo').attr('disabled', alterarGrupo == '2');
        $('#btn-Grupo').attr('disabled', alterarGrupo == '2');
        $('#btn-AGrupo').attr('disabled', alterarGrupo == '2');
    }

    if (cliente != "" && cliente != "create" && cliente.length < 30) {
        // busca cliente no banco ou webservice se for cnpj...
        await recalCredCliente(cliente, controleLimiteCredito == '1')
        await buscaDadosCliente(cliente, "");

        if ($("#txtCep").val() == '') {

        }
        insereValor('#txtEstatisticaCliente', $('#txtCodCli').val(), $('#txtNome').val());
        if (bloqueiaEditarEntidade == 1) {
            if (usuarioMasterSupervisor[0].TIPO == '0') {
                await bloqueiaEdicaoEntidade();
            };
        };

        if ($("#txtCep").val() == '') {
            const jsonStr = await buscaValoresPadroes('ENTIDADE')

            if (jsonStr[35].VALOR !== '') {
                $('#txtCep').val(jsonStr[35].VALOR)
                $('#txtCep').trigger('blur')
                $('#txtNumero').val(jsonStr[36].VALOR)
            }
        }
    } else {
        // seta valores padrões
        $("#cbAtivo").prop("checked", true);
        $("#cbConsumidorFinal").prop("checked", true);
        $("#rgIE").val("9").change();
        const paisPadrao = await retornaPaisPadraoEntidade();
        const pais = paisPadrao ? paisPadrao : '[1058] - BRASIL';
        $('#txtPais').val(pais);
        await preencheDDI()
        $("#txtDataCadastro").val(new Date().toISOString().slice(0, 10));
        $("#txtDataAlteracao").val(new Date().toISOString().slice(0, 10));
        $("#txtDataNascimento").val(
            new Date("1980-01-01").toISOString().slice(0, 10)
        );
        $("#rgSexo").val("M").change();
        $("#btnTransportadora").addClass('d-none');
        $("#btnRepresentante").addClass('d-none');
        $("#btnFuncionario").addClass('d-none');

        if (cadastraEntidadeBloqueada == 1) {
            $('#cbBloqueado').prop('checked', true);
            if (usuarioMasterSupervisor[0].TIPO == '0') {
                $('#cbBloqueado').prop('checked', true);
                $('#cbBloqueado').on('change', function () {
                    if (!$(this).is(':checked')) {
                        msgErro("Usuário do tipo 'USUÁRIO' não tem permissão para cadastrar uma entidade desbloqueada! Impossível desmarcar essa opção.");
                        $('#cbBloqueado').prop('checked', true);
                        return;
                    };
                });
            };
        };

        await carregaValoresPadroes();

        let usuarioLogado = getCookie('cod_usuario');
        let repCadastrado = await buscaValor('ACESSO_USUARIOS', 'CODREP', 'CODIGO', usuarioLogado); // 266946 - Insere valor do representante conforme tela Cadastro Usuário

        if (repCadastrado !== undefined && typeof repCadastrado === 'object') {
            insereValor('#txtRepresentante', repCadastrado.CODREP, {
                tabela: 'REPRESEN',
                campoBusca: 'NOME',
                campoWhere: 'CODREP',
                valorWhere: repCadastrado.CODREP
            });

            if (buscaRegiao == '1') {
                const regiao = await buscaDepositoUltimoMovimento(repCadastrado.CODREP);
                insereValor('#txtRegiao', regiao.REGIAO, regiao.DESC_REGIAO);
            }
        }
    }

    async function bloqueiaEdicaoEntidade() {
        try {
            $('.input-default').prop('disabled', true);
            $('#txtCep').prop('disabled', true);
            $('.btn, .select-ent').prop('disabled', true);
            $('input[type="checkbox"]').prop('disabled', true);
            $('#txtCepEntrega').prop('disabled', false);
            $('#txtCidadeEntrega').prop('disabled', false);
            $('#txtUFEntrega').prop('disabled', false);
            $('#btnCepEntrega').prop('disabled', false);
            $('#btnLimpaCepEntrega').prop('disabled', false);
            $('#txtRuaEntrega').prop('disabled', false);
            $('#txtNumeroEntrega').prop('disabled', false);
            $('#txtBairroEntrega').prop('disabled', false);
            $('#txtInscEnt').prop('disabled', false);
            $('#txtComplementoEntrega').prop('disabled', false);
            $('#txtCepCobranca').prop('disabled', false);
            $('#txtCidadeCobranca').prop('disabled', false);
            $('#txtUFCobranca').prop('disabled', false);
            $('#btnCepCobranca').prop('disabled', false);
            $('#btnLimpaCepCobranca').prop('disabled', false);
            $('#txtRuaCobranca').prop('disabled', false);
            $('#txtNumeroCobranca').prop('disabled', false);
            $('#txtBairroCobranca').prop('disabled', false);
            $('#txtInscCob').prop('disabled', false);
            $('#txtCNPJCob').prop('disabled', false);
            $('#txtCNPJEnt').prop('disabled', false);
            $('#txtComplementoCobranca').prop('disabled', false);
            $('#btnAlteraContatoDentroModal').prop('disabled', false);
            $('#btnIncluiContato').prop('disabled', false);
            $('#btnAlteraContato').prop('disabled', false);
            $('#btnDuplicarContato').prop('disabled', false);
            $('#btnGravaContato').prop('disabled', false);
            $('#btnCancelarAlteracao').prop('disabled', false);
            $('#btnExcluir').prop('disabled', false);
            $('#btnFechar').prop('disabled', false);
            $('#btnVoltar').prop('disabled', false);
            $('#btnGravar').prop('disabled', false);
            $('#txtMoeda').prop('disabled', true);
            $('input.select2-search__field').parent().addClass('backgroundTransparent');
            $('input.select2-search__field').parent().parent().addClass('backgroundTransparent');
            $('input.select2-search__field').parent().parent().parent().addClass('backgroundTransparent');
            $('input[type="checkbox"]:checked').prop('disabled', false);
            $('input[type="checkbox"]:checked').on('change', function () {
                if (!$(this).is(':checked') && this.id != 'cbMaladireta' && this.id != 'cbContatoAtivo') {
                    msgErro('Você não tem permissão pra alterar essa opção! Impossível continuar.');
                    $(this).prop('checked', true);
                    return;
                };
            });

            $('#btnAlteraOcorrencias').prop('disabled', false);
            $('#btnIncluirOcorrencias').prop('disabled', false);
            $('#btnImprimirOcorrencias').prop('disabled', false);
            $('#btnFecharOcorrencias').prop('disabled', false);
            $('#btnGravarOcorrencias').prop('disabled', false);
            $('#btnCancelarOcorrencias').prop('disabled', false);
            $('#radioFiltroOcorrencias').prop('disabled', false);
            $('#txtObsOcorrencias').prop('readonly', false);

            $('#txtNomeContato').prop('readonly', false);
            $('#txtCPFCNPJContato').prop('readonly', false);
            $('#txtCelularContato').prop('readonly', false);
            $('#btnFormataNumero').prop('disabled', false);
            $('#txtTelefoneContato').prop('readonly', false);
            $('#txtDoContato').prop('readonly', false);
            $('#txtInscricaoIEContato').prop('readonly', false);
            $('#selectModificacao2').prop('disabled', false);
            $('#zezinho').prop('readonly', false);
            $('#txtDataNascContato').prop('readonly', false);
            $('#txtFuncaoContatoEntidade').prop('readonly', false);
            $('#btnConsultaFuncaoContato').prop('disabled', false);
            $('#btnLimpaFuncaoContato').prop('disabled', false);
            $('#txtCargoContatoEntidade').prop('readonly', false);
            $('#btnConsultaCargoEntidade').prop('disabled', false);
            $('#btnLimpaCargoEntidade').prop('disabled', false);
            $('#txtSetorContatoEntidade').prop('readonly', false);
            $('#btnConsultaSetorEntidade').prop('disabled', false);
            $('#btnLimpaSetorEntidade').prop('disabled', false);
            $('#txtObsContatoEntidade').prop('readonly', false);
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível fazer o bloqueio dos campos ao editar a entidade. Verifique!');
            return;
        };
    };

    async function carregaValoresPadroes() {
        const jsonStr = await buscaValoresPadroes('ENTIDADE')

        for (const item of jsonStr) {
            switch (item.CAMPO) {
                case 'GRUPO_CLI': {
                    insereValor('#txtGrupo', item.VALOR, { tabela: 'GRUPO_CLI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'SIT_DUP': {
                    insereValor('#txtSitDup', item.VALOR, { tabela: 'TABSIT', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'IE_DESTINATARIO': {
                    $('#rgIE').val(item.VALOR).change();
                    break;
                }
                case 'CODREP': {
                    insereValor('#txtRepresentante', item.VALOR, { tabela: 'REPRESEN', campoBusca: 'NOME', campoWhere: 'CODREP', valorWhere: item.VALOR });
                    break;
                }
                case 'CONS_FINAL': {
                    $('#cbConsumidorFinal').prop('checked', item.VALOR != 'Nao');
                    break;
                }
                case 'TRANSPORTE': {
                    insereValor('#txtTransportadora', item.VALOR, { tabela: 'TABTRAN', campoBusca: 'NOME', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'TP_FRETE': {
                    $('#rgTipoFrete').val(item.VALOR).change();
                    break;
                }
                case 'TRIBUTACAO': {
                    $('#rgTributacao').val(item.VALOR).change();
                    break;
                }
                case 'CLASSE': {
                    insereValor('#txtClasse', item.VALOR, { tabela: 'CLASSE_GER', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'COD_CONF_XML': {
                    insereValor('#txtConfXML', item.VALOR, { tabela: 'FATCONF_XML', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
                    break;
                }
                case 'EMAIL': {
                    insereValor('#txtEmail', item.VALOR);
                    break;
                }
                case 'CEP_PADRAO': {
                    if (item.VALOR !== '') {
                        insereValor('#txtCep', item.VALOR);
                        $('#txtCep').trigger('blur')
                    }
                    break;
                }
                case 'NUMERO_PADRAO': {
                    if (item.VALOR !== '') {
                        insereValor('#txtNumero', item.VALOR);
                    }
                    break;
                }
                case 'MOEDAS': {
                    if (item.VALOR != '') {
                        try {
                            const pesquisaMoeda = {
                                camposSelect: ['CODMOE', 'DESCRICAO'],
                                tabela: 'MOEDA',
                                where: [`CODMOE IN (${item.VALOR})`]
                            };
                            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaMoeda));
                            // await insereValorPesquisaVarios('txtMoeda', 'CODMOE', 'DESCRICAO', jsonStr);
                            jsonStr.map((item) => {
                                $('#tabelaMoedas').DataTable().row.add([
                                    '<div style="text-align:start;"> ' +
                                    '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
                                    '      ' + item.CODMOE + ' ' +
                                    '    </button> ' +
                                    '    <div class="dropdown-menu"> ' +
                                    '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
                                    '</div>',
                                    item.DESCRICAO,
                                ]).draw(false)
                            })

                        } catch (error) {
                            console.error(error);
                        }
                    }
                    break;
                }
                case 'TIPO_ENTIDADE': {
                    switch (item.VALOR) {
                        case "CLIENTE":
                            $("#cbTipoCliente").prop("checked", true);                            
                            break;
                        case "FORNECEDOR":
                            $("#cbTipoFornecedor").prop("checked", true);
                            break;
                        case "TERCEIROS":
                            $("#cbTipoTerceiros").prop("checked", true);
                            break;
                        case "REPRESENTANTE":
                            $("#cbTipoRepresentante").prop("checked", true);
                            break;
                        case "PROSPECTO":
                            $("#cbTipoProspecto").prop("checked", true);
                            break;
                        case "FUNCIONARIO":
                            $("#cbTipoFuncionario").prop("checked", true);
                            break;
                        default:
                            break;
                    }
                    break;
                }
                case 'VAL_LIMIT_CONSIGNADO': {
                    if (controleLimiteCredito == '1') {
                        $('#txtLimiteCredito').val(item.VALOR.replace('.', '').replace(',', '.'));
                    }
                    break;
                }
                case 'VAL_LIMIT_VENDA': {
                    if (controleLimiteCredito == '1') {
                        $('#txtLimiteFidelidade').val(item.VALOR.replace('.', '').replace(',', '.'));
                    }
                    break;
                }
                case 'CC_CLIENTE': {
                    if ((item.VALOR != '') && (paramContaContabil == 'P')) {
                        const contaContabilCliente = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                        insereValor('#txtContaCliente', item.VALOR, contaContabilCliente.DESCRICAO);
                    }
                    break;
                }
                case 'CC_FORNECEDOR': {
                    if ((item.VALOR != '') && (paramContaContabil == 'P')) {
                        const contaContabilFornecedor = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                        insereValor('#txtContaFornecedor', item.VALOR, contaContabilFornecedor.DESCRICAO);
                    }
                    break;
                }
                case 'CC_ADIANTAMENTO': {
                    if ((item.VALOR != '') && (paramContaContabil == 'P')) {
                        const contaContabilAdiantamento = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                        insereValor('#txtContaCAdiantamento', item.VALOR, contaContabilAdiantamento.DESCRICAO);
                    }
                    break;
                }
                case 'CC_DEVOLUCAO': {
                    if ((item.VALOR != '') && (paramContaContabil == 'P')) {
                        const contaContabilDevolucao = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                        insereValor('#txtContaCDevolucao', item.VALOR, contaContabilDevolucao.DESCRICAO);
                    }
                    break;
                }
                case 'CF_ADIANTAMENTO': {
                    if ((item.VALOR != '') && (paramContaContabil == 'P')) {
                        const contaFornecedorAdiantamento = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                        insereValor('#txtContaFAdiantamento', item.VALOR, contaFornecedorAdiantamento.DESCRICAO);
                    }
                    break;
                }
                case 'CF_DEVOLUCAO': {
                    if ((item.VALOR != '') && (paramContaContabil == 'P')) {
                        const contaFornecedorDevolucao = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                        insereValor('#txtContaFDevolucao', item.VALOR, contaFornecedorDevolucao.DESCRICAO);
                    }
                    break;
                }
                case 'TIPO_PESSOA': {
                    if (item.VALOR != '') {
                        $('#rgTipoEnt').val(item.VALOR).change()
                    }
                    break;
                }
                case 'TABELA_PRECO': {
                    if (item.VALOR != '') {
                        const descricao = await buscaValor('REGIAO', 'DESCRICAO', 'REGIAO', item.VALOR);
                        insereValor('#txtTabela', item.VALOR, descricao.DESCRICAO);
                    }
                    break;
                }
                case 'REQUER_ANALISE': {
                    if (item.VALOR == 'S') {
                        $("#cbClienteRequerAnalise").prop("checked", true);
                    }
                    break;
                }
                case 'DDI': {
                    if (item.VALOR != '') {
                        $('#txtDDI').val(item.VALOR.includes('+') ? item.VALOR : `+${item.VALOR}`);
                    }
                    break;
                }
                case 'DDD': {
                    if (item.VALOR != '') {
                        insereValor('#txtDDD', item.VALOR);
                    }
                    break;
                }
                case 'TELEFONE': {
                    if (item.VALOR != '') {
                        insereValor('#txtTelefone', item.VALOR);
                    }
                    break;
                }
            }
        };
        
        if (isChecked('#cbTipoCliente')) {
            await rotinaTipoEntidade(false); //paramentro false para limpar os campos de fornecedor conforme erp
        } else if (isChecked('#cbTipoFornecedor')) {
            await rotinaTipoEntidade(true); //paramentro true para limpar os campos de cliente conforme erp
        }
    }

    if (cliente != "" && cliente != "create" && cliente.length > 30) {
        let arrayXml = atob(cliente).split(",");

        let cnpj = arrayXml[0];
        let ie = arrayXml[1];
        let nome = arrayXml[2];
        let fantasia = arrayXml[3];
        let cep = arrayXml[4];
        let cidade = arrayXml[5];
        let uf = arrayXml[6];
        let numero = arrayXml[7];
        let bairro = arrayXml[8];
        let telefone = arrayXml[9];
        let rua = arrayXml[10];

        $("#txtCNPJ").val(cnpj);
        $("#txtNome").val(nome);
        $("#txtFantasia").val(fantasia);
        $("#txtIE").val(ie);
        $("#txtDDD").val(telefone.slice(0, 2));
        $("#txtTelefone").val(telefone.slice(2));
        $("#txtCep").val(cep);
        $("#txtCidade").val(cidade);
        $("#txtUF").val(uf);
        $("#txtNumero").val(numero);
        $("#txtBairro").val(bairro);
        $("#txtRua").val(rua);

    }
    if (cliente != "" && cliente != "create" && cliente.length < 30) {
        await buscaDadosEntidadeContabil(cliente);
    }

    $('#txtLimiteCredito').on('blur', async function () {
        $('#txtLimiteDisponivel').val(TruncaDecimaisNova(2, +$('#txtLimiteCredito').val() - $('#txtLimiteUsado').val()));
    });

    $('#txtLimiteFidelidade').on('blur', async function () {
        $('#txtLimiteFidelidadeDisponivel').val(TruncaDecimaisNova(2, +$('#txtLimiteFidelidade').val() - $('#txtLimiteFidelidadeUsado').val()));
    });

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    async function abreCadastroCep(cepField) {
        $('#modal-CEP').attr('cepField', cepField[0].id)
        $('#modal-CEP').modal('show');
        $('#txt_Cep').val('');
        $('#txtEndereco').val('');
        $('#txtBairroCEP').val('');
        $('#txtUfCEPCadastro').val('');
        $('#txtCidadeCEPCadastro').val('');
        $('#txtPaisCEPCadastro').val('');
        if ((cepField.val() != '') || (cepField.val() != undefined) || (cepField.val() != null)) {
            $('#txt_Cep').val(`${cepField.val().substr(0, 5)}-${cepField.val().substr(-3)}`);
        }
    }


    async function BuscaECadastraCep(cepInput) {
        try {
            $.LoadingOverlay("show");
            try {
                const cep = cepInput.val().replace('-', '').trim();
                const response = await requisicao('GET', '/sisplan/cep/v1/CEP?', `CEP=${cep}`, null);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem, () => { abreCadastroCep(cepInput) }, undefined, undefined);
                    return;
                }

                return [jsonStr.nOMCIDADE, jsonStr.eSTCEP, jsonStr.nOMCEP, jsonStr.bAIRRO];

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };
    async function habilitaCampoCidade() {
        let uf;
        $.LoadingOverlay('show');
        setTimeout(() => {

            if ($("#txtUfCEPCadastro").val() != "") {
                uf = pegaChave("#txtUfCEPCadastro", uf);

                $("#txtCidadeCEPCadastro").prop("readonly", false);
                $("#btnCidade").removeClass("d-none");
                $("#btnACidade").removeClass("d-none");
                $("#txtCidadeCEPCadastro").prop("disabled", false);

                $("#txtCidadeCEPCadastro").off();
                $("#txtCidadeCEPCadastro").autocompleta(1, `JSON={ "tabela":"cidade", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["cod_uf = '${uf}'"]}`);
                $("#btnCidade").pesquisa("#txtCidadeCEPCadastro", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cidade", "camposSelect":[ "CODIGO", "NOME"], "where": ["cod_uf = '${uf}'"]}`, "Pesquisa Cidade", "cidade");
            } else {
                $("#txtCidadeCEPCadastro").prop("readonly", true);
                $("#btnCidade").addClass("d-none");
                $("#btnACidade").addClass("d-none");
                $("#txtCidadeCEPCadastro").prop("disabled", true);
                $("#txtCidadeCEPCadastro").off();
            }
        }, 2000);
        $.LoadingOverlay('hide');
    }


    $('#txtUfCEPCadastro').change(async function () {
        await habilitaCampoCidade();
    });

    $("#txtPaisCEPCadastro").autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
    $("#txtUfCEPCadastro").autocompleta(1, `JSON={ "tabela":"tabuf", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, '', '', '', habilitaCampoCidade);

    $("#btnPais").pesquisa("#txtPaisCEPCadastro", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cadpais", "camposSelect":[ "CODIGO", "NOME"]}`, "Pesquisa País", "cadpais");
    $("#btnUf").pesquisa("#txtUfCEPCadastro", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"tabuf", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa UF", "tabuf", '', habilitaCampoCidade);

    $("#btnACidade").on("click", function () {
        $("#txtCidadeCEPCadastro").val("");
    });
    $("#btnAPais").on("click", function () {
        $("#txtPaisCEPCadastro").val("");
    });
    $("#btnAUf").on("click", async function () {
        $("#txtUfCEPCadastro").val("");
        $("#txtCidadeCEPCadastro").val("");
        $("#txtCidadeCEPCadastro").prop("readonly", true);
        $("#btnCidade").addClass("d-none");
        $("#btnACidade").addClass("d-none");
        $("#txtCidadeCEPCadastro").prop("disabled", true);
        $("#txtCidadeCEPCadastro").off();
    });

    $('#gridTabelasModal').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
    });

    $('#btnAbreModalTabelas').on('click', function () {
        abreModalTabela();
    })

    async function abreModalTabela() {
        $('#modal-tabelas').modal('show');
    }

    $('#btnAdicionarTabela').on('click', async function () {
        await feedTableGrid();
    })

    async function feedTableGrid() {
        const sCodigo = pegaChave('#txtTabelaModal');
        const sDescription = pegaDescricao('#txtTabelaModal');
        const sTable = $('#gridTabelasModal').DataTable().rows().count();
        let adicionaRegistro = true;
        if (sCodigo != '') {
            if (sTable <= 0) {
                $('#gridTabelasModal').DataTable().row.add([sCodigo, sDescription, retornaBotaoOpcoesModalTabelas()]).draw(false);
            } else {
                for (let i = 0; i < sTable; i++) {
                    if ($('#gridTabelasModal').DataTable().data()[i][0] == sCodigo) {
                        adicionaRegistro = false;
                    }
                }
                if (adicionaRegistro) {
                    $('#gridTabelasModal').DataTable().row.add([sCodigo, sDescription, retornaBotaoOpcoesModalTabelas()]).draw(false);
                } else {
                    msgAlerta('Tabela já adicionada ao grid.');
                }
            }
            $('#txtTabelaModal').val('');
        }
    }

    $('#gridTabelasModal').on('click', '.btn-excluir', async function () {
        $('#gridTabelasModal').DataTable().row($(this).parents('tr')).remove().draw(false);
    });

    function retornaBotaoOpcoesModalTabelas() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    $('#btnFecharModalTabela').on('click', async function () {
        $('#modal-tabelas').modal('hide')
    })

    // function montaJsonTabelas(Codigo) {
    //     const objeto = {
    //         Codigo
    //     };
    //     return objeto;
    // }

    async function vinculaTabelasAoCliente(sCodCli, sTabelas) {
        try {

            let response = await requisicao("POST", "/sisplan/cliente/V1/tabelascliente?", `TABELAS=${sTabelas}&CODCLI=${sCodCli}`, 3000);

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta("Erro ao gravar dados da conta");
                console.log(jsonStr.mensagem);
                return;
            }

        } catch (error) {
            console.log(error);
        }
    }

    $('#txtCNPJ').focus();

    async function trazContatos() {

        if ($.fn.DataTable.isDataTable('#tabelaContatosEntidade')) {
            $('#tabelaContatosEntidade').DataTable().destroy();
            $('#tabelaContatosEntidade').empty();
        };

        const codcliContatos = $('#txtCodCli').val() == '' || $('#txtCodCli').val() == undefined ? '99999999' : $('#txtCodCli').val();

        if (codcliContatos == '99999999') {
            $('#btnAlteraContato').prop('disabled', true);
        };

        const PesquisaContatoCliente = {
            tabela: "CONTATO",
            camposSelect: ["CONTATO.NUMERO",
                "CONTATO.CODCLI",
                "CONTATO.NOME",
                "CONTATO.DT_NASC AS DATA_NASC",
                "CONTATO.FONE AS TELEFONE",
                "CONTATO.CELULAR",
                "CONTATO.EMAIL",
                "CONTATO.TIPO",
                "CONTATO.TEXTO",
                "CONTATO.OBS AS OBSERVACAO",
                "CONTATO.CPF_CNPJ",
                "CONTATO.INSCRICAO",
                "CONTATO.TIPO_CONTATO",
                "CONTATO.MALA_DIRETA",
                "CONTATO.FUNCAO",
                "FUNCAO.DESCRICAO DESC_FUNCAO",
                "CONTATO.CARGO",
                "CARGO.DESCRICAO DESC_CARGO",
                "CONTATO.SOMENTE_XML",
                "CONTATO.ID_SETOR",
                "SETOR.DESCRICAO AS DESC_SETOR",
                "CONTATO.ID_ENT",
                "CONTATO.ATIVO"
            ],
            leftJoin: [
                { tabela: "FUNCAO", alias: "FUNCAO", "condicao": "FUNCAO.CODIGO = CONTATO.FUNCAO" },
                { tabela: "CARGO", alias: "CARGO", "condicao": "CARGO.CODIGO = CONTATO.CARGO" },
                { tabela: "CADFLUXO", alias: "SETOR", "condicao": "SETOR.ID = CONTATO.ID_SETOR" },
            ],
            where: [
                `1=1 AND CONTATO.CODCLI = '${codcliContatos}'`,
            ],
            orderBy: [
                "CONTATO.NUMERO",
            ]

        };

        const jsonStrContato = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaContatoCliente));

        const dataSetCols = [];

        dataSetCols.push({
            title: 'Número',
            data: 'NUMERO',
        });

        dataSetCols.push({
            title: 'Nome',
            data: 'NOME',
        });

        dataSetCols.push({
            title: 'Data Nasc.',
            data: 'DATA_NASC',
        });

        dataSetCols.push({
            title: 'Telefone',
            data: 'TELEFONE',
        });

        dataSetCols.push({
            title: 'E-mail',
            data: 'EMAIL',
        });

        dataSetCols.push({
            title: 'Tipo',
            data: 'TIPO',
        });

        dataSetCols.push({
            title: 'Observações',
            data: 'OBSERVACAO',
        });

        dataSetCols.push({
            title: 'CPF/CNPJ',
            data: 'CPF_CNPJ',
        });

        dataSetCols.push({
            title: 'Inscrição',
            data: 'INSCRICAO',
        });

        dataSetCols.push({
            title: 'Celular',
            data: 'CELULAR',
        });


        $('#tabelaContatosEntidade').DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            info: true,
            order: false,
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStrContato,
            columnDefs: [{
                type: 'date-br',
                targets: [2],
                render(data) {
                    if (data) {
                        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                    } else {
                        return '';
                    }

                },
            }]
        });
    };


    await trazContatos();

    async function buscaOcorrencias() {
        try {
            $.LoadingOverlay('show');
            try {
                if (cliente != 'create') {
                    if ($.fn.DataTable.isDataTable('#tabelaHistoricoOcorrencias')) {
                        $('#tabelaHistoricoOcorrencias').DataTable().destroy();
                        $('#tabelaHistoricoOcorrencias').empty();
                    };


                    const pesquisa = {
                        tabela: "CLI_HISTORICO",
                        camposSelect: ["*"
                        ],
                        where: [
                            `1=1 AND CODCLI = '${cliente}'`,
                        ],
                        orderBy: [
                            "NUMERO",
                        ]

                    };

                    const ocorrencias = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

                    const dataSetCols = [
                        {
                            data: 'NUMERO',
                            title: 'Número'
                        },
                        {
                            data: 'ATIVO',
                            title: 'Ativo'
                        },
                        {
                            data: 'DATA',
                            title: 'Data'
                        },
                        {
                            data: 'DT_PREV_RETORNO',
                            title: 'Previsão de Retorno'
                        },
                        {
                            data: 'USUARIO',
                            title: 'Usuário'
                        },
                        {
                            data: 'OBS',
                            title: 'Observação'
                        }
                    ];

                    $('#tabelaHistoricoOcorrencias').DataTable({
                        bPaginate: false,
                        destroy: true,
                        search: false,
                        filter: false,
                        lengthChange: false,
                        info: true,
                        order: false,
                        autoWidth: true,
                        columns: dataSetCols,
                        data: ocorrencias,
                        columnDefs: [{
                            type: 'date-br',
                            targets: [2, 3],
                            render(data) {
                                if (data) {
                                    return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                                } else {
                                    return '';
                                }
                            }
                        }]
                    });
                }
            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };
    if (cliente != 'create') {
        await buscaOcorrencias();
    } else {
        $('#btnAlteraOcorrencias').prop('disabled', true);
    }

    $('#btnAlteraOcorrencias').on('click', function () {
        $('#modal-ocorrencias').modal('show');
        $('#tituloOcorrencias').html(`Cadastro de Histórico/Ocorrências | ${cliente} - ${$('#txtNome').val()}`);
        $('#txtClienteOcorrencias').val(cliente);
    });

    $('#modal-ocorrencias').on('hide.bs.modal', async function () {
        await buscaOcorrencias();
    })

    $('#btnAlteraContato').on('click', async function () {
        const codcliContatosEntidade = $('#txtCodCli').val();
        const nomeContatosEntidade = $('#txtNome').val();
        $('#txtTituloContato').html(`${codcliContatosEntidade} - ${nomeContatosEntidade}`);
        $('#modal-cadcontato').modal('show');
    });

    $('#modal-cadcontato').on('hide.bs.modal', async function () {
        await trazContatos();
    });

    // Informações e Estastísticas
    if (cliente == "create") {
        $('#abaInfosEstatisticas').addClass('d-none')
    }

    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $("#btnTitulo").on("click", async function () {
        await fazConsultaInfoEstatistica();
    });

    retornaHintRelatorio('btnImprimirRelInfEst', 'RelInformacaoEstatistica')

    $('#btnImprimirRelInfEst').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimititulorelinfest?`;
                // const ordem = `&TELA_ORDENACAO=RelPosCtasPag&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelInformacaoEstatistica');
                const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'POST', 100000, false, 'RelInformacaoEstatistica');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    retornaHintRelatorio('btnEstatisticasImprimir', 'RelEstatisticasCliente')

    $("#btnEstatisticasImprimir").on("click", async function () {
        try {
            $.LoadingOverlay("show");
            try {
                if ($('#tabelaEstatisticaVendasEntidade').DataTable().rows().count() != 0) {
                    const sPendente = $('#cbPendente').prop('checked');
                    const sDevolvido = $('#cbDevolvido').prop('checked');
                    const sEmitido = $('#cbEmitido').prop('checked');
                    const sAgrupada = $('#cbAgrupada').prop('checked');
                    const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0
                        ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
                        : [getCookie('emp_id')];
                    const dataIni = $('#txtEstatisticasVendaDe').val();
                    const dataFim = $('#txtEstatisticasVendaAte').val();
                    const tipoVenda = pegaChave('#txtEstatisticasTipoVenda');
                    const Filtros = await retornaFiltros();
                    const url = `/sisplan/impressao/v1/imprimeestatisticas?EMITIDO=${sEmitido}
                                &DEVOLVIDO=${sDevolvido}&PENDENTE=${sPendente}&AGRUPADA=${sAgrupada}
                                &EMP_IDS=${listaEmpIds}&DATAINI=${dataIni}&DATAFIM=${dataFim}&TIPO_VENDA=${tipoVenda}&`;
                    const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstatisticasCliente');
                    const arquivo = await GeraRelatorio(`${url}${Filtros}`, "GET", 100000, false, 'RelEstatisticasCliente');

                    if (arquivo != undefined) {
                        if (!bImprimeAutomatico) {
                            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                        }
                        await limparRelatorios();
                    }
                } else {
                    msgAlerta('Não há dados a serem impressos')
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.informacoesEstatisticas == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, informacoesEstatisticas: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    if (colunas == null || colunas.informacoesEstatisticaVendas == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, informacoesEstatisticaVendas: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            if (grid == 'titulos') {
                const novasColunas = retornaNovasColunasInvisiveis();
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, informacoesEstatisticas: novasColunas }))

                $('#tabelaInfonrmacaoEstatistica').DataTable().columns().visible(true);
                // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

                $('#tabelaInfonrmacaoEstatistica').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                )
            } else {
                const novasColunas = retornaNovasColunasInvisiveis();
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, informacoesEstatisticaVendas: novasColunas }))

                $('#tabelaEstatisticaVendasEntidade').DataTable().columns().visible(true);
                // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

                $('#tabelaEstatisticaVendasEntidade').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    }
                )
            }

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    async function fazConsultaInfoEstatistica() {
        if ($.fn.DataTable.isDataTable('#tabelaInfonrmacaoEstatistica')) {
            $("#tabelaInfonrmacaoEstatistica").DataTable().destroy();
            $("#tabelaInfonrmacaoEstatistica").empty();
        }
        try {
            dataSetCols = [];
            $.LoadingOverlay('show');

            const url = "/sisplan/impressao/v1/conultatitulorelinfest?";
            const filtros = await retornaFiltros();
            const response = await requisicao("GET", url, `${filtros}&COD_USUARIO=${getCookie("cod_usuario")}`, "", 360000);

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (jsonStr.length == 0) {
                msgAlerta("Nenhum registro encontrado!");
                $("#txtMeta").val();
                if ($.fn.DataTable.isDataTable('#tabelaInfonrmacaoEstatistica')) {
                    $('#tabelaInfonrmacaoEstatistica').DataTable().destroy();
                    $('#tabelaInfonrmacaoEstatistica').empty();
                }
                // $('#ImprimirRelInfEst').addClass('d-none')
                return;
            } else {
                // $('#ImprimirRelInfEst').removeClass('d-none')
            }

            if (response.status != 200) {
                console.error(jsonStr.mensagem);
                msgAlerta("Nenhum registro encontrado!");
                return;
            }

            let keys = Object.keys(jsonStr[0]);

            keys.forEach((k) => {
                dataSetCols.push({
                    title: k,
                    data: k,
                });
            });

            let indiceValor;

            for (let i = 0; i < keys.length; i++) {
                if (keys[i] == 'VALOR') {
                    indiceValor = i;
                }
            }

            $('#tabelaInfonrmacaoEstatistica').DataTable({
                bPaginate: true,
                destroy: true,
                colReorder: true,
                autoWidth: true,
                scrollX: true,
                scrollY: "280px",
                columns: [
                    {
                        title: "Identifica",
                        data: "IDENTIFICA",
                    },
                    {
                        title: "Número",
                        data: "NUMERO",
                    },
                    {
                        title: "Fatura",
                        data: "FATURA",
                    },
                    {
                        title: "Cod Cli.",
                        data: "CODCLI",
                    },
                    {
                        title: "Cliente",
                        data: "CLIENTE",
                    },
                    {
                        title: "Data Emissão",
                        data: "DT_EMISSAO",
                    },
                    {
                        title: "Data Vencimento",
                        data: "DT_VENCTO",
                    },
                    {
                        title: "Valor Total",
                        data: "VALOR",
                    },
                    {
                        title: "Valor",
                        data: "VALOR2",
                    },
                    {
                        title: "Valor Pago",
                        data: "VALOR_PAGO",
                    },
                    {
                        title: "Desconto",
                        data: "DESCONTO",
                    },
                    {
                        title: "Saldo",
                        data: "SALDO",
                    },
                    {
                        title: "Status",
                        data: "STATUS",
                    },
                    {
                        title: "Empresa",
                        data: "EMP_PAT",
                    },
                    {
                        title: "Caixa",
                        data: "CAIXA",
                    },
                    {
                        title: "Moeda",
                        data: "MOEDA",
                    },
                    {
                        title: "Desc. Moeda",
                        data: "DESC_MOEDA",
                    },
                    {
                        title: "Lançamento",
                        data: "LANCAMENTO",
                    },
                    {
                        title: "Obs",
                        data: "OBS",
                    },
                ],
                // columns: dataSetCols,
                searching: false,
                data: jsonStr,
                columnDefs: [
                    {
                        "type": 'date-br',
                        render(data, type, row) {
                            x = data.slice(0, 10).split("-");
                            let icone = "";
                            const dataVencimento = new Date(`${row.DT_VENCTO} 23:59:59`);
                            if (dataVencimento < new Date()) {
                                icone =
                                    '<i class="fas fa-history iconeVencido" style="color: red" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
                            } else {
                                icone =
                                    '<i class="fas fa-history" style="display: none" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
                            }
                            const retornaData = new Intl.DateTimeFormat("pt-BR").format(
                                new Date(`${data.split(" ")[0]} 23:59:59`)
                            );
                            return (dataMesAtual(retornaData)) ? `<span title="Vencimento dentro do mês atual" style="color: red">${retornaData}</span> ${icone}`
                                : `<span>${retornaData}</span> ${icone}`;
                        },
                        targets: 6,
                    },
                    {
                        //Mascara Dinheiro
                        "render": function (data) {
                            return parseFloat(data).toLocaleString('pt-BR', {
                                maximumFractionDigits: 2,
                                minimumFractionDigits: 2
                            });

                        },
                        "targets": [7, 8, 9, 10, 11]
                    },
                    {
                        //Mascara Data
                        "type": 'date-br',
                        "targets": [6, 7],
                        "render": function (data) {
                            if (data != undefined && data != '') {
                                x = data.slice(0, 10).split('-');
                                return `${x[2]}/${x[1]}/${x[0]}`;
                            } else {
                                return ''
                            }
                        },
                        "targets": 5
                    },
                    {
                        className: "ColunaVermelha",
                        targets: 11,
                    },
                ],
            });
            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#tabelaInfonrmacaoEstatistica_length').prepend('<span class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></span>');
            $('#tabelaInfonrmacaoEstatistica_length').prepend('<span class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></span>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                grid = 'titulos';
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const url = '/sisplan/impressao/v1/conultatitulorelinfest?';
                const filtros = await retornaFiltros();
                await exportaCSV(url, filtros, false, null, 'Relatório de Informações e Estatísticas', '#tabelaInfonrmacaoEstatistica');
            })

            $('#tabelaInfonrmacaoEstatistica').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.informacoesEstatisticas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                }
            )

        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        if (grid == 'titulos') {
            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

            $('#tabelaInfonrmacaoEstatistica').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });

            const colunasVisiveis = cols.slice(2)
            adicionaColunas(colunasVisiveis, colunasInvisiveis.informacoesEstatisticas ?? [''])
        } else {
            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

            $('#tabelaEstatisticaVendasEntidade').DataTable().columns().every(function () {
                cols.push({
                    'title': $(this.header()).text(),
                    'data': this.dataSrc()
                })
            });

            const colunasVisiveis = cols.slice(2)
            adicionaColunas(colunasVisiveis, colunasInvisiveis.informacoesEstatisticaVendas ?? [''])
        }
    })

    function dataMesAtual(dateString) {
        const dateParts = dateString.split("/");
        const day = parseInt(dateParts[0], 10);
        const month = parseInt(dateParts[1], 10) - 1;
        const year = parseInt(dateParts[2], 10);
        const dateToCheck = new Date(year, month, day);

        const currentDate = new Date();
        return (
            dateToCheck.getMonth() === currentDate.getMonth() &&
            dateToCheck.getFullYear() === currentDate.getFullYear()
        );
    }

    async function retornaFiltros() {
        const pCodCli = $("#txtCodCli").val();
        const pSituacao = $('input[name="rdListar"]:checked').val();
        const pOrdem = $('input[name="rdOrdem"]:checked').val();
        const pTitulo = $('input[name="rdTitulo"]:checked').val();
        const pDataPesquisaDe = $("#txtDataPesquisaDe").val();
        const pDataPesquisaAte = $("#txtDataPesquisaAte").val();
        const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
        // const pOpBtnEstatistica = $("#cbBuscarCheque").is(":checked") ? 1 : 0;
        // const pGrupoEntidade = $("#cbGrupoEntidade").is(":checked") ? 1 : 0;
        // const pRgDataVencto = $('input[name="rdDataVencto"]:checked').val();
        // const pUltimaAnalise = $("#txtUltAnalise").val();
        // const pProximaAnalise = $("#txtProxAnalise").val();


        const filtros =
            `SITUACAO=${pSituacao}` +
            `&ORDEM=${pOrdem}` +
            `&TITULO=${pTitulo}` +
            `&PESQUISADE=${pDataPesquisaDe}` +
            `&PESQUISAATE=${pDataPesquisaAte}` +
            `&EMPRESASFILTRADAS=${empresasFiltradas}` +
            // `&BUSCACHEQUE=${pOpBtnEstatistica}` +
            // `&GRUPOENTIDADE=${pGrupoEntidade}` +
            // `&ULTIMAANALISE=${pUltimaAnalise}` +
            // `&PROXIMAANALISE=${pProximaAnalise}` +
            // `&RGDATAVENCIMENTO=${pRgDataVencto}` +
            `&CODCLI=${pCodCli}`;

        return filtros;
    }

    $('#tabelaObsSerasa').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
    });

    async function buscaDadosObsSerasa() {
        const pesquisaParam = {
            tabela: "ENTID_OBS",
            camposSelect: ["ID",
                "OBSERVACAO",
                "CODCLI",
                "DATA"
            ],
            where: [
                `CODCLI = '${$('#txtCodCli').val()}'`,
            ]
        };

        const jsonStr = await retornaJsonPesquisaPadraoComBlob(JSON.stringify(pesquisaParam));

        return jsonStr;
    }

    async function validaContaContabil() {
        if (paramContaContabil == 'M') {
            let resultado = false;
            if ((isChecked('#cbTipoCliente')) && (pegaChave('#txtContaCliente') == '')) {
                await msgAguardaConfirmacao(`Entidade com o tipo Cliente, e Conta Cliente não preenchida. Deseja continuar?`, () => { resultado = false }, () => { resultado = true });
                if (resultado) return resultado;
            }

            if ((isChecked('#cbTipoFornecedor')) && (pegaChave('#txtContaFornecedor') == '')) {
                await msgAguardaConfirmacao(`Entidade com o tipo Fornecedor, e Conta Fornecedor não preenchida. Deseja continuar?`, () => { resultado = false }, () => { resultado = true });
                if (resultado) return resultado;
            }
        } else if (paramContaContabil == 'B') {
            if ((isChecked('#cbTipoCliente')) && (pegaChave('#txtContaCliente') == '')) {
                await aguardaMsgAlerta(`Entidade com o Tipo Cliente, e Conta Cliente não preenchida. Impossível continuar.`, () => { });
                $('#txtContaCliente').focus();
                return true;
            }

            if ((isChecked('#cbTipoFornecedor')) && (pegaChave('#txtContaFornecedor') == '')) {
                await aguardaMsgAlerta(`Entidade com o Tipo Fornecedor, e Conta Fornecedor não preenchida. Impossível Continuar.`, () => { });
                $('#txtContaFornecedor').focus();
                return true;
            }
        }

        return false;
    }

    $('#abaObsSerasa').on('click', async function () {
        $('#tabelaObsSerasa').DataTable().clear().draw(false);
        const dadosObsSerasa = await buscaDadosObsSerasa();
        dadosObsSerasa?.map(item => {
            $('#tabelaObsSerasa').DataTable().row.add([
                item.ID,
                item.OBSERVACAO.slice(0, 160) + '...',
            ]).draw(false);
        })
    });

    $('#cbTipoCliente').on('click', async function () {
        await rotinaTipoEntidade(true);
    });

    $('#cbTipoFornecedor').on('click', async function () {
        await rotinaTipoEntidade(false);   
    });

    async function rotinaTipoEntidade(bCliente) {
        if (cliente == 'create') {
            if (bCliente) {
                if (isChecked('#cbTipoCliente')) {
                    await buscaValoresPadroesContabil();
                } else {
                    $('#txtContaCliente').val('');    
                    $('#txtContaCAdiantamento').val('');    
                    $('#txtContaCDevolucao').val('');    
                }
            } else {
                if (isChecked('#cbTipoFornecedor')) {
                    await buscaValoresPadroesContabil(bCliente);
                } else {
                    $('#txtContaFornecedor').val('');    
                    $('#txtContaFAdiantamento').val('');    
                    $('#txtContaFDevolucao').val('');    
                }
            }
        }
    }

    async function pesquisaObsSerasa(numero) {
        const pesquisaParam = {
            tabela: "ENTID_OBS",
            camposSelect: [
                "ID",
                "CODCLI",
                "DATA",
                "OBSERVACAO"
            ],
            orderBy: [`DATA`],
            where: [` 1=1 AND ID = '${numero}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadraoComBlob(JSON.stringify(pesquisaParam));

        return jsonStr[0];
    }

    async function buscaValoresPadroesContabil(bCliente = true) {
        try {
            const jsonStr = await buscaValoresPadroes('ENTIDADE')

            for (const item of jsonStr) {
                switch (item.CAMPO) {
                    case 'CC_CLIENTE': {
                        if ((item.VALOR != '') && (paramContaContabil == 'P') && (bCliente)) {
                            const contaContabilCliente = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                            insereValor('#txtContaCliente', item.VALOR, contaContabilCliente.DESCRICAO);
                        }
                        break;
                    }
                    case 'CC_FORNECEDOR': {
                        if ((item.VALOR != '') && (paramContaContabil == 'P') && (!bCliente)) {
                            const contaContabilFornecedor = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                            insereValor('#txtContaFornecedor', item.VALOR, contaContabilFornecedor.DESCRICAO);
                        }
                        break;
                    }
                    case 'CC_ADIANTAMENTO': {
                        if ((item.VALOR != '') && (paramContaContabil == 'P') && (bCliente)) {
                            const contaContabilAdiantamento = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                            insereValor('#txtContaCAdiantamento', item.VALOR, contaContabilAdiantamento.DESCRICAO);
                        }
                        break;
                    }
                    case 'CC_DEVOLUCAO': {
                        if ((item.VALOR != '') && (paramContaContabil == 'P') && (bCliente)) {
                            const contaContabilDevolucao = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                            insereValor('#txtContaCDevolucao', item.VALOR, contaContabilDevolucao.DESCRICAO);
                        }
                        break;
                    }
                    case 'CF_ADIANTAMENTO': {
                        if ((item.VALOR != '') && (paramContaContabil == 'P') && (!bCliente)) {
                            const contaFornecedorAdiantamento = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                            insereValor('#txtContaFAdiantamento', item.VALOR, contaFornecedorAdiantamento.DESCRICAO);
                        }
                        break;
                    }
                    case 'CF_DEVOLUCAO': {
                        if ((item.VALOR != '') && (paramContaContabil == 'P') && (!bCliente)) {
                            const contaFornecedorDevolucao = await buscaValor("CONTA_CONT", "DESCRICAO", "CODIGO", item.VALOR);
                            insereValor('#txtContaFDevolucao', item.VALOR, contaFornecedorDevolucao.DESCRICAO);
                        }
                        break;
                    }
                }
            };
        } catch (error) {
            console.log(error);
        }
    }

    $("#tabelaObsSerasa tbody").on("click", "tr", async function () {
        let sNumero = $('#tabelaObsSerasa').DataTable().row($(this)).data()[0];
        const data = await pesquisaObsSerasa(sNumero)
        $('#txtNumeroObsSerasa').val(sNumero);
        $('#txtObsSerasa').val(data.OBSERVACAO);
        $('#txtDataObsSerasa').val(data.DATA);
        insereValor('#txtClienteObsSerasa', $('#txtCodCli').val(), $('#txtNome').val())
        $('#modal_obs_serasa').modal('show');
    });

    $('#btnIncluiObsSerasaCert').on('click', async function () {
        $('#txtNumeroObsSerasa').val(0);
        insereValor('#txtClienteObsSerasa', $('#txtCodCli').val(), $('#txtNome').val())
        $('#modal_obs_serasa').modal('show');
        // $('#btnIncluirObsSerasa').trigger('click');
    });

    $('#modal_obs_serasa').on('hide.bs.modal', function () {
        insereValor('#txtClienteObsSerasa', $('#txtCodCli').val(), $('#txtNome').val());
        $('#txtObsSerasa').val('');
        $('#txtDataObsSerasa').val('');
    });

    $('#btnEstatisticaConsultarEntidade').on('click', async function () {
        $.LoadingOverlay('show')
        try {
            await BuscarVendasCliente(pegaChave('#txtEstatisticaCliente'));
        } finally {
            $.LoadingOverlay('hide')
        }
    });

    async function BuscarVendasCliente(codcli) {
        const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        const dataIni = `'${$('#txtEstatisticasVendaDe').val()}'`;
        const dataFim = `'${$('#txtEstatisticasVendaAte').val()}'`;
        const tipoVenda = pegaChave('#txtEstatisticasTipoVenda');
        const sPendente = $('#cbPendente').prop('checked');
        const sDevolvido = $('#cbDevolvido').prop('checked');
        const sEmitido = $('#cbEmitido').prop('checked');
        const sAgrupada = $('#cbAgrupada').prop('checked');

        const sCancelada = $('#cbCancelada').is(':checked') ? 1 : 0;
        const todos = sCancelada == '1' && sEmitido && sDevolvido && sPendente && sAgrupada;
        var opcao = '';
        let whereStatus = `AND ( `;
        if (sEmitido) {
            if (sAgrupada) {
                whereStatus += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1))`;
            } else {
                whereStatus += `((VENDA.CANCELADA = 0 AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0) OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) = 0))`;
            }
        }
        if (sDevolvido) {
            if (whereStatus != `AND ( `) {
                whereStatus += ' OR ';
            }
            whereStatus += `(VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND (((VENDA.TROCA = 1) OR (VENDA.DEVOLUCAO = 1)) AND VENDA.ORCAMENTO = 0))`;
        }
        if (sPendente) {
            if (whereStatus != `AND ( `) {
                whereStatus += ' OR ';
            }
            whereStatus += `(VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0)`;
        }

        if (sCancelada == 1) {
            if (whereStatus != `AND ( `) {
                whereStatus += ' OR ';
            }
            whereStatus += `((VENDA.CANCELADA = 1) AND (VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S') OR (((VENDA.CANCELADA = 1) AND (VENDA.CONSIG_FINALIZADO = 'S') AND COALESCE(VENDA.CDAGRUPADA, 0) > 0)))`;
        }
        if (sAgrupada) {
            if (whereStatus != `AND ( `) {
                whereStatus += ' OR ';
            }
            if (sCancelada == 0) {
                whereStatus += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0 AND ((SELECT CANCELADA FROM [VENDA] WHERE CODVEN = VENDA.CDAGRUPADA) = 0))`
            } else {
                whereStatus += `(VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0)`;
            }
        }
        whereStatus += ') ';

        if (todos) {
            whereStatus = '';
        }

        if (whereStatus != 'AND ( ) ') {
            opcao = whereStatus;
        }

        const pesquisaParam = {
            tabela: "VENDA",
            camposSelect: [
                "VENDA.CODVEN",
                "VENDA.TIPO_VENDA",
                "CASE WHEN (VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0) THEN 'PENDENTE'" +
                "WHEN ((SELECT CANCELADA FROM VENDA_001 WHERE CODVEN = VENDA.CDAGRUPADA) = 1) THEN 'CANCELADA'" +
                "WHEN (VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND COALESCE(VENDA.CDAGRUPADA, 0) > 0) THEN 'AGRUPADA'" +
                "WHEN ((VENDA.CANCELADA = 1) AND ((VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S'))) THEN 'CANCELADA'" +
                "WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0 OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S')) THEN 'FECHADA'" +
                "WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 0 AND (VENDA.TROCA = 1 OR VENDA.DEVOLUCAO = 1 AND VENDA.ORCAMENTO = 0)) THEN 'DEVOLUCAO/TROCA'" +
                "ELSE 'Orcamento' END STATUS",
                "VENDA_TIPO.DESCRICAO DESC_TIPO",
                "VENDA.DATA",
                "SUM(ITVENDA.QUANTIDADE) QTDE",
                "SUM(ITVENDA.TOTAL_LIQ) VALOR",
                "CASE WHEN (VENDA.DEVOLUCAO = 0) THEN 0 WHEN (VENDA.DEVOLUCAO <> 0) THEN VENDA.VALOR END VAL_DEVOL",
                // "(SELECT SUM(ITV_DEV.VALOR) VALOR_DEV FROM ITVENDA_001 ITV_DEV WHERE ITV_DEV.CODVEN = VENDA.CODVEN AND ITV_DEV.EMP_ID = VENDA.EMP_ID AND ITV_DEV.TROCA='S') VAL_DEVOL",
                "CASE WHEN (VENDA.CANCELADA = 0) THEN 0 WHEN (VENDA.CANCELADA <> 0) THEN VENDA.VALOR END VAL_CANC",
                "VENDA.EMP_ID",
                "EMPRESA.EMP_NOME LOJA",
                "(SELECT MAX(FATURA) FATURA FROM [NOTA] NOTA WHERE NOTA.CODVEN = VENDA.CODVEN AND NOTA.EMP_ID = VENDA.EMP_ID) FATURA"
            ],
            leftJoin: [
                { tabela: 'VENDA_TIPO', condicao: 'VENDA_TIPO.ID = VENDA.TIPO_VENDA' },
                { tabela: 'ITVENDA', condicao: 'ITVENDA.CODVEN = VENDA.CODVEN AND ITVENDA.EMP_ID = VENDA.EMP_ID' },
                { tabela: 'EMPRESA', condicao: 'VENDA.EMP_ID = EMPRESA.EMP_ID' }
            ],
            where: [`VENDA.CODCLI = '${codcli}' AND VENDA.EMP_ID IN (${listaEmpIds})`,
            `VENDA.DATA BETWEEN ${dataIni} AND ${dataFim} ${whereStatus}`],
            groupBy: ['VENDA.CODVEN'
                , 'VENDA.TIPO_VENDA'
                , 'VENDA.CANCELADA'
                , 'VENDA.FECHADA'
                , 'VENDA.DEVOLUCAO'
                , 'VENDA.AGRUPADA'
                , 'VENDA.CDAGRUPADA'
                , 'VENDA.TROCA'
                , 'VENDA.VALOR'
                , 'VENDA.ORCAMENTO'
                , 'VENDA.CONSIG_FINALIZADO'
                , 'VENDA.IMPRESSO'
                , 'VENDA_TIPO.DESCRICAO'
                , 'VENDA.DATA'
                , 'VENDA.EMP_ID'
                , 'EMPRESA.EMP_NOME'],
            orderBy: ['VENDA.DATA DESC']
        };
        if (tipoVenda !== '') {
            pesquisaParam.where.push(`VENDA.TIPO_VENDA = ${tipoVenda}`);
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        $("#tabelaEstatisticaVendasEntidade").DataTable({
            bPaginate: true,
            destroy: true,
            colReorder: true,
            autoWidth: true,
            scrollX: true,
            searching: false,
            autoWidth: true,
            data: jsonStr,
            columns: [
                {
                    data: "CODVEN",
                    title: "CODVEN"
                },
                {
                    data: "DESC_TIPO",
                    title: "DESC_TIPO"
                },
                {
                    data: "STATUS",
                    title: "STATUS"
                },
                {
                    data: "DATA",
                    title: "DATA"
                },
                {
                    data: "QTDE",
                    title: "QTDE"
                },
                {
                    data: "VALOR",
                    title: "VALOR"
                },
                {
                    data: "VAL_DEVOL",
                    title: "VAL_DEVOL"
                },
                {
                    data: "VAL_CANC",
                    title: "VAL_CANC"
                },
                {
                    data: "EMP_ID",
                    title: "EMP_ID"
                },
                {
                    data: "LOJA",
                    title: "LOJA"
                },
                {
                    data: "FATURA",
                    title: "FATURA"
                },
            ],
            columnDefs: [
                {
                    "type": 'date-br',
                    "targets": 3,
                    "render": function (data) {
                        if (data != undefined) {
                            x = data.slice(0, 10).split('-');
                            return `${x[2]}/${x[1]}/${x[0]}`;
                        } else {
                            return ''
                        }
                    }
                },
                {
                    render(data) {
                        return parseFloat(data).toLocaleString("pt-BR", {
                            maximumFractionDigits: 2,
                            minimumFractionDigits: 2
                        });
                    },
                    targets: [5, 6, 7],
                }
            ]
        });

        const totalQtde = $("#tabelaEstatisticaVendasEntidade").DataTable().data().toArray().reduce((total, curr) => curr.QTDE + total, 0);

        const totalValor = $("#tabelaEstatisticaVendasEntidade").DataTable().data().toArray().reduce((total, curr) => curr.VALOR + total, 0);
        $('#txtTotalEstatisticaQuantidade').val(totalQtde);
        $('#txtTotalEstatisticaValor').val(totalValor);
        $("#tabelaEstatisticaVendasEntidade").DataTable().columns.adjust().draw(false);

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaEstatisticaVendasEntidade_length').prepend('<span class="buttonColVis" id="buttonColVisVendas"><i class="fas fa-cogs"></i></span>');
        $('#tabelaEstatisticaVendasEntidade_length').prepend('<span class="buttonExcel" id="buttonExcelVendas"><i class="fas fa-file-excel"></i></span>');

        $('#buttonColVisVendas').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcelVendas').prop('title', 'Exportar')

        $('#buttonColVisVendas').on('click', async function () {
            $.LoadingOverlay('show');
            grid = 'vendas';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
        });

        $('#buttonExcelVendas').on('click', async function () {
            const url = `/Sisplan/Funcoes/v1/pesquisa?`;
            await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisaParam))}`, true, null, 'Relatório de Informações e Estatísticas Vendas', '#tabelaEstatisticaVendasEntidade');
        })

        $('#tabelaEstatisticaVendasEntidade').DataTable().columns().every(
            function () {
                if ((colunasInvisiveis.informacoesEstatisticaVendas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            }
        )

        $('#tabelaEstatisticaVendasEntidade tbody').on('click', 'tr', async function () {
            async function retornaDadosItens(codven, empId) {
                const pesquisaParam = {
                    tabela: 'ITVENDA',
                    camposSelect: ['ITVENDA.CODIGO', `CASE WHEN ITVENDA.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
                        'ITVENDA.COR', 'CADCOR.DESCRICAO DESC_COR', 'ITVENDA.TAM', 'ITVENDA.QUANTIDADE', 'ITVENDA.PRECO_LIQ'],
                    leftJoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
                    { tabela: 'PRODUTO', condicao: `PRODUTO.CODIGO = ITVENDA.CODIGO AND ITVENDA.TIPO =  'P'` },
                    { tabela: 'MATERIAL', condicao: `MATERIAL.CODIGO = ITVENDA.CODIGO AND ITVENDA.TIPO = 'M'` }],
                    where: [`ITVENDA.CODVEN = ${codven} AND ITVENDA.EMP_ID = ${empId} `]
                };
                const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
                return response;
            }
            async function retornaDadosPagamento(codven, empId) {
                const pesquisaParam = {
                    tabela: 'CONDIVENDA',
                    camposSelect: ['CONDIVENDA.CDMOEDA', `MOEDA.DESCRICAO`,
                        'COUNT(ITCONDIVENDA.CDITCONDIVENDA) PARCELAS',
                        'SUM(ITCONDIVENDA.VALOR_PAGO) VALOR_PAGO'],
                    leftJoin: [{ tabela: 'MOEDA', condicao: 'MOEDA.CODMOE = CONDIVENDA.CDMOEDA' },
                    { tabela: 'ITCONDIVENDA', condicao: `CONDIVENDA.CDCONDIVENDA = ITCONDIVENDA.CDCONDIVENDA` }],
                    where: [`CONDIVENDA.CDVENDA = ${codven} AND CONDIVENDA.EMP_ID = ${empId} `],
                    groupBy: ['CONDIVENDA.CDMOEDA', 'MOEDA.DESCRICAO']
                };
                const response = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
                return response;
            }

            $('#tabelaEstatisticaVendasEntidade tbody tr.selected').removeClass('selected');
            $(this).addClass('selected');
            $('#modalEstatisticasVenda').modal('show');
            let data = $('#tabelaEstatisticaVendasEntidade').DataTable().row($(this)).data();
            const itens = await retornaDadosItens(data.CODVEN, data.EMP_ID);
            const pagamentos = await retornaDadosPagamento(data.CODVEN, data.EMP_ID);
            const colunasItens = itens.length > 0 ? Object.entries(itens[0]).map(item => ({
                title: item[0],
                data: item[0]
            })) : [];
            const colunasPagamentos = pagamentos.length > 0 ? Object.entries(pagamentos[0]).map(item => ({
                title: item[0],
                data: item[0]
            })) : [];
            if (colunasItens.length == 0) {
                $('#tabelaEstatisticaItens').DataTable().clear().draw(false);
            } else {
                criaDataTablePadrao('#tabelaEstatisticaItens', false, false, false, false, true, false, false, itens, colunasItens, []);
            }

            if (colunasPagamentos.length == 0) {
                $('#tabelaEstatisticaPagamento').DataTable().clear().draw(false);
            } else {
                criaDataTablePadrao('#tabelaEstatisticaPagamento', false, false, false, false, true, false, false, pagamentos, colunasPagamentos, []);
            }
        });
    }

    async function buscaUsuarioEntidade(codcli) {
        $.LoadingOverlay('show')
        try {
            const pesquisaParam = {
                tabela: "ENTIDADE",
                camposSelect: ["USUARIO"],
                where: [`CODCLI = '${codcli}'`]
            };

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

            return jsonStr[0].USUARIO;
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $("#txtCNPJ").on("focus", function () {
        const cnpj = $(this).val();
        const alfanumericos = cnpj.replace(/[^a-zA-Z0-9]/g, "");
        $(this).val(alfanumericos);
    });

    $('#txtCNPJ').on('blur', async function () {
        if ($('#txtCNPJCob').val() == '') {
            $('#txtCNPJCob').val($('#txtCNPJ').val());
        }
        if ($('#txtCNPJEnt').val() == '') {
            $('#txtCNPJEnt').val($('#txtCNPJ').val());
        }
    });

    $("#txtCNPJ").on("focusout", function () {
        aplicaMascaraCNPJ();
    });

    function aplicaMascaraCNPJ() {
        const mascara = $("#rgTipoEnt").val();
        $("#txtCNPJ").mask(mascara);
        const cpfCnpjFormatado = $("#txtCNPJ").val();
        $("#txtCNPJ").unmask();
        $("#txtCNPJ").val(cpfCnpjFormatado);
    }

    if (cliente == 'create') {
        if (camposObrigatorios) {
            if (camposObrigatorios.length > 0) {
                for (let x = 0; x < camposObrigatorios.length; x++) {
                    const campoObrigatorio = $(`#${camposObrigatorios[x]}`);

                    if (campoObrigatorio.prop('type') == 'date') {
                        $(`#${campoObrigatorio.prop('id')}`).val('1899-01-01');
                    };

                    if (campoObrigatorio.prop('tagName').toLowerCase() == 'select') {
                        for (let t = 0; t < campoObrigatorio.children().length; t++) {
                            if (campoObrigatorio.children()[t].defaultSelected) {
                                campoObrigatorio.val(campoObrigatorio.children()[t].value);
                            };
                        };
                    };
                };
            };
        }
    };

    async function permissoesTela() {
        $.LoadingOverlay('show')
        try {
            let response = await requisicao("GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"PERMISSOES_TELA",
                                                    "camposSelect":["PERMISSAO", "ACAO"], 
                                                    "where": ["USUARIO = '${getCookie("cod_usuario")}' AND EMP_ID = ${getCookie("emp_id")} AND TELA = 'ENTIDADE'"]}`,
                null);

            if (!response || response.status != 200) {
                return;
            }

            let jsonStr = await response.json();

            let permiteAlterarDesconto;
            let desabilitaAlterarBloqueado;
            let desabilitaMoedaContabil;
            let bloqueiaRepresentante;

            if (jsonStr.RESULT[0].length > 0) {
                jsonStr.RESULT[0].map(item => {
                    switch (item.ACAO) {
                        case 'DESCONTO_ENTIDADE':
                            permiteAlterarDesconto = item.PERMISSAO == "S";
                            break;
                        case 'DESABILITA_CHECK_BLOQUEADO':
                            desabilitaAlterarBloqueado = item.PERMISSAO == "S";
                            break;
                        case 'DESABILITA_MOEDA_CONTABIL':
                            desabilitaMoedaContabil = item.PERMISSAO == "S";
                            break;
                        case 'BLOQUEIA_REPRESENTANTE':
                            bloqueiaRepresentante = item.PERMISSAO == "S";
                            break;
                        default:
                            break;
                    }
                })
            } else {
                permiteAlterarDesconto = false;
                desabilitaAlterarBloqueado = false;
                desabilitaMoedaContabil = false;
                bloqueiaRepresentante = false;
            }

            $('#txtPercDesconto').prop('disabled', !permiteAlterarDesconto);
            $('#cbBloqueado').prop('disabled', desabilitaAlterarBloqueado);
            $('#txtMoeda').prop('disabled', desabilitaMoedaContabil);
            if (desabilitaMoedaContabil) {
                $('#lblMoeda').unbind('click');
            }
            if (bloqueiaRepresentante) {
                $('#lblRepresentantes').removeAttr('href');
                $('#lblRepresentantes').off('click');
                $('#lblRepresentantes').css({
                    'pointer-events': 'none',
                    'opacity': '0.6',
                    'cursor': 'default'
                });
            }
            $('#txtRepresentante').prop('disabled', bloqueiaRepresentante);
            $('#btn-representante').prop('disabled', bloqueiaRepresentante);
            $('#btn-Arepresentante').prop('disabled', bloqueiaRepresentante);
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $("#txtCNPJFavorecido").on("input", function () {
        let valor = $(this).val().replace(/\D/g, "");

        if (valor.length <= 11) { // CPF        
            valor = valor
                .replace(/(\d{3})(\d)/, "$1.$2")
                .replace(/(\d{3})(\d)/, "$1.$2")
                .replace(/(\d{3})(\d{1,2})$/, "$1-$2");
        } else { // CNPJ            
            valor = valor
                .replace(/^(\d{2})(\d)/, "$1.$2")
                .replace(/^(\d{2})\.(\d{3})(\d)/, "$1.$2.$3")
                .replace(/\.(\d{3})(\d)/, ".$1/$2")
                .replace(/(\d{4})(\d)/, "$1-$2");
        }

        $(this).val(valor);
    });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "geral") {
                    if (!$("#multiCollapseExample1").hasClass("show"));
                    $("#multiCollapseExample1").collapse("show");
                } else if (Element.node.id == "documentoaba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#documento").collapse("show");
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "endereco") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                        $("#enderecoGeral").collapse("show");
                    }
                } else if (Element.node.id == "geral") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#endereco_geral-tab").trigger("click");
                    }
                } else if (Element.node.id == "endereco_entrega_geral") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#enderecoEntrega").collapse("show");
                    }
                } else if (Element.node.id == "endereco_cobranca_geral") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#enderecoCobranca").collapse("show");
                    }
                } else if (Element.node.id == "venda") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                } else if (Element.node.id == "adicional") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample5").collapse("show");
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "documento-tab" ||
                    Element.node.id == "documentoaba"
                ) {
                    if (!$("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "endereco") {
                    if (!$("#documento>a").hasClass("collapsed")) {
                        $("#documentoaba").collapse("show");
                    }
                } else if (Element.node.id == "endereco_entrega_geral-tab") {
                    if (!$("#endereco_geral").hasClass("active")) {
                        $("#endereco_geral-tab").trigger("click");
                        $("#endereco_geral").addClass("active show");
                    }
                } else if (Element.node.id == "endereco_cobranca_geral-tab") {
                    if (!$("#endereco_entrega_geral").hasClass("active")) {
                        $("#endereco_entrega_geral-tab").trigger("click");
                        $("#endereco_entrega_geral").addClass("active show");
                    }
                }
            },
        });

        driver.defineSteps([{
            element: "#geral-tab",
            popover: {
                title: "Aba Geral",
                description: "Clique aqui para abrir a aba geral.",
                position: "top",
            },
        },
        {
            element: "#geral",
            popover: {
                title: "Cadastro Geral",
                description: "Aqui você pode informar os dados gerais de cadastro dos Clientes/Fornecedores.",
                position: "bottom",
            },
        },
        {
            element: "#multiCollapseExample1",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados gerais de cadastro.",
                position: "bottom",
            },
        },
        {
            element: "#cnpjTour",
            popover: {
                title: "Campo CNPJ",
                description: "Ao alterar esse campo, será feita uma pesquisa ao WebService https://www.receitaws.com.br/ e se houver retorno preencherá os campos básicos do cadastro.",
                position: "bottom",
            },
        },
        {
            element: "#nomeTour",
            popover: {
                title: "Campos Obrigatórios",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "bottom",
            },
        },
        {
            element: "#txtEmail",
            popover: {
                title: "Tornar Campos Obrigatórios",
                description: "Você pode tornar esse campo obrigatório selecionando o mesmo e pressionando CTRL + F8.",
                position: "top",
            },
        },
        {
            element: "#dddTelefoneTour",
            popover: {
                title: "Campos Obrigatórios",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#telefoneTour",
            popover: {
                title: "Campos Obrigatórios",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#documentoaba",
            popover: {
                title: "Aba Documentos",
                description: "Clique aqui para abrir aba documentos.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample2",
            popover: {
                title: "Dados de Documentos",
                description: "Aqui ficam os dados de documentos a serem preenchidos.",
                position: "top",
            },
        },
        {
            element: "#endereco",
            popover: {
                title: "Aba Endereços",
                description: "Clique aqui para abrir os cadastros dos endereços.",
                position: "top",
            },
        },
        {
            element: "#EnderecoGeral",
            popover: {
                title: "Aba Endereço Geral",
                description: "Nessa aba você informa o endereço principal do seu cliente/fornecedor.",
                position: "top",
            },
        },
        {
            element: "#endereco_geral",
            popover: {
                title: "Campos Endereço Geral",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#enderecoGeral",
            popover: {
                title: "Campos Endereço Geral",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#cepTour",
            popover: {
                title: "Campo CEP",
                description: "Ao alterar esse campo, será feita uma pesquisa aos WebServices https://apps.correios.com.br/ e http://viacep.com.br/ws/, se houver retorno preencherá os campos de endereço.",
                position: "top",
            },
        },
        {
            element: "#entrega",
            popover: {
                title: "Aba Endereço de Entrega",
                description: "Nessa aba você informa o endereço de entrega do seu cliente/fornecedor.",
                position: "top",
            },
        },
        {
            element: "#endereco_entrega_geral",
            popover: {
                title: "Campos Endereço de Entrega",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#cobranca",
            popover: {
                title: "Aba Endereço de Cobrança",
                description: "Nessa aba você informa endereço de cobrança do seu cliente/fornecedor.",
                position: "top",
            },
        },
        {
            element: "#endereco_cobranca_geral",
            popover: {
                title: "Campos Endereço de Cobrança",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#venda",
            popover: {
                title: "Aba Cadastro de Venda",
                description: "Aqui você pode sugerir algumas informações que serão levadas em consideração no módulo de venda.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample4",
            popover: {
                title: "Campos de Cadastros de Venda",
                description: "Aqui ficam os dados da venda a serem informados.",
                position: "top",
            },
        },
        {
            element: "#adicional",
            popover: {
                title: "Aba Adicionais",
                description: "Aqui você pode sugerir algumas informações adicionais.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample5",
            popover: {
                title: "Campos de Cadastros Adicionais",
                description: "Aqui ficam os dados adicionais a serem informados.",
                position: "top",
            },
        },
        {
            element: "#btnGravar",
            popover: {
                title: "Botão Gravar",
                description: "Ao clicar nesse botão você grava os dados inseridos.",
                position: "left",
            },
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description: "Ao clicar nesse botão você retorna para a tela de consulta da Entidade.",
                position: "left",
            },
        },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });

    await permissoesTela();
});
