$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('solicitacao', true, true, 'Numero')
  componenteFiltro('funcionario', true, true, 'Solicitante')
  componenteFiltro('tipo', true, true)
  componenteFiltro('centroCusto', true, true)
  componenteFiltro('itemSolicitacao', true, true, 'Codigo')
  componenteFiltro('cor', true, true)
  componenteFiltro('tamanho2', true, true, 'Tamanho')
  componenteFiltro('usuario3', true, true, 'Usuario', ["ATIVO = 'S'", "NOME NOT LIKE '[PERCENTUAL]TODOS[PERCENTUAL]'"])
  componenteFiltro('grupoMA', true, true, 'GrupoMaterial', ["TIPO = 'M'"])
  componenteFiltro('grupoPA', true, true, 'GrupoProduto')
  componenteFiltro('grupoMA', true, true, 'GrupoServico', ["TIPO = 'S'"])
  componenteFiltro('subGrupo', true, true, 'SubgrupoMaterial')

  $('#btnConsultar').on('click', function () {
    ItensSolicitacaoCancelados.consultar()
    $('#modalFiltros').modal('hide')
  })

  $('#tabelaItens').on('click', '#btnInformacoesItem', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const { codigo, cor, tamanho, tipoItem } = datatableItens?.row($(this)?.parents('tr'))?.data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $('#tabelaItens').on('click', '#btnObsCancelamento', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const { observacaoRetorno } = datatableItens?.row($(this)?.parents('tr'))?.data()
    $('#txtObsCancelamento').val(observacaoRetorno)
    $('#modalObsCancelamento').modal('show')
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    const { codigo, cor, tamanho, tipoItem } = $('#tabelaItens').DataTable().row($(this)).data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  PerfilSolicitacoes.preencherFiltrosPerfilCompras().then((result) => {
    if (!result) {
      return
    }
    ItensSolicitacaoCancelados.consultar()
  })

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnLimparFiltros').on('click', function () {
    limparFiltros()
  })

  function limparFiltros() {
    $('#txtNumero').empty().trigger('change')
    $('#txtSolicitante').empty().trigger('change')
    if (!$('#txtTipo').prop('disabled')) {
      $('#txtTipo').empty().trigger('change')
    }
    if (!$('#txtCentroCusto').prop('disabled')) {
      $('#txtCentroCusto').empty().trigger('change')
    }
    $('#txtCodigo').empty().trigger('change')
    $('#txtCor').empty().trigger('change')
    $('#txtTamanho').empty().trigger('change')
    $('#txtUsuario').empty().trigger('change')
    if (!$('#txtGrupoMaterial').prop('disabled')) {
      $('#txtGrupoMaterial').empty().trigger('change')
    }
    if (!$('#txtGrupoProduto').prop('disabled')) {
      $('#txtGrupoProduto').empty().trigger('change')
    }
    if (!$('#txtGrupoServico').prop('disabled')) {
      $('#txtGrupoServico').empty().trigger('change')
    }
    if (!$('#txtSubgrupoMaterial').prop('disabled')) {
      $('#txtSubgrupoMaterial').empty().trigger('change')
    }
    $('#txtCadastroDe').val('1200-01-01')
    $('#txtCadastroAte').val('2500-12-31')
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensSolicitacaoCancelados = window.ItensSolicitacaoCancelados || {}

ItensSolicitacaoCancelados.criarTabelaItens = ({ filtros }) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Informações Item" id="btnInformacoesItem">Informações Item</button>     ' +
        '    <button class="dropdown-item" type="button" title="Observação Cancelamento" id="btnObsCancelamento">Observação Cancelamento</button>     ' +
        '</div>'
      )
    },
    {
      data: 'dataCadastro',
      title: 'Cadastro',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      },
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      },
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      },
    },
    {
      data: 'dataBaixa',
      title: 'Baixa',
      render(data) {
        try {
          const date = new Date(data)
          if (date.getFullYear() < 2000) {
            return ''
          }

          return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
        } catch (_) {
          return ''
        }
      },
    },
    {
      data: 'solicitante',
      title: 'Solicitante',
    },
    {
      data: 'descricaoSolicitante',
      title: 'Descrição Solicitante',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'codigo2',
      title: 'Código 2',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'ordem',
      title: 'Ordem',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'prazo',
      title: 'Prazo',
      visible: false,
    },
    {
      data: 'descricaoPrazo',
      title: 'Descrição Prazo',
      visible: false,
    },
    {
      data: 'colecao',
      title: 'Coleção',
      visible: false,
    },
    {
      data: 'descricaoColecao',
      title: 'Descrição Coleção',
      visible: false,
    },
    {
      data: 'motivo',
      title: 'Motivo',
      visible: false,
    },
    {
      data: 'descricaoMotivo',
      title: 'Descrição Motivo',
      visible: false,
    },
    {
      data: 'tipo',
      title: 'Tipo',
    },
    {
      data: 'descricaoTipo',
      title: 'Descrição Tipo',
    },
    {
      data: 'tabelaPreco',
      title: 'Tabela de Preço',
      visible: false,
    },
    {
      data: 'descricaoTabelaPreco',
      title: 'Descrição Tabela Preço',
      visible: false,
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'deposito',
      title: 'Depósito',
      visible: false,
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
      visible: false,
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
      visible: false,
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
      visible: false,
    },
    {
      data: 'especificacao',
      title: 'Especificação',
      visible: false,
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'status',
      title: 'Situação',
    },
    {
      data: 'nomeUltimoAprovador',
      title: 'Último Aprovador',
    },
    {
      data: 'aprovadoEm',
      title: 'Aprovado Em',
      render: function (data) {
        return retornarDataISOEmYMD({
          dataISO: new Date(data),
          incluirHora: true,
          reverso: true,
          usarUTC: true,
        })
      }
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'codigoUltimoFornecedor',
      title: 'Código Último Fornecedor',
    },
    {
      data: 'nomeUltimoFornecedor',
      title: 'Nome Último Fornecedor',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
    {
      data: 'observacaoRetorno',
      title: 'Observação Cancelamento',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 18,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/solicitacao/v1/itenscancelados`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          filtros,
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa'),
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
  })
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunasItensSolicitacao({
    tabela: 'tabelaItens',
    tela: 'itensSolicitacaoCancelados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'N',
    tipo: 'SOL',
    retornarFiltros: ItensSolicitacaoCancelados.retornarFiltros,
  })
}

ItensSolicitacaoCancelados.retornarFiltros = async function () {
  const cadastroDe = $('#txtCadastroDe').val() || '1200-01-01'
  const cadastroAte = $('#txtCadastroAte').val() || '1200-01-01'
  const numero = await formataListas($('#txtNumero').val().toString())
  const solicitante = await formataListas($('#txtSolicitante').val().toString())
  const tipo = await formataListas($('#txtTipo').val().toString(), true)
  const centroCusto = await formataListas($('#txtCentroCusto').val().toString())
  const codigo = await formataListas($('#txtCodigo').val().toString())
  const cor = await formataListas($('#txtCor').val().toString())
  const tamanho = await formataListas($('#txtTamanho').val().toString())
  const usuario = await formataListas($($('#txtUsuario')?.[0]?.innerHTML)?.toArray().map((it) => pegaDescricao($(it).text())).toString())
  const grupoMaterial = await formataListas($('#txtGrupoMaterial').val().toString())
  const grupoProduto = await formataListas($('#txtGrupoProduto').val().toString())
  const grupoServico = await formataListas($('#txtGrupoServico').val().toString())
  const subgrupoMaterial = await formataListas($('#txtSubgrupoMaterial').val().toString())

  return {
    cadastroDe,
    cadastroAte,
    numero,
    solicitante,
    tipo,
    centroCusto,
    codigo,
    cor,
    tamanho,
    usuario,
    grupoMaterial,
    grupoProduto,
    grupoServico,
    subgrupoMaterial,
  }
}

ItensSolicitacaoCancelados.consultar = function () {
  ItensSolicitacaoCancelados.retornarFiltros()
    .then((filtros) => {
      ItensSolicitacaoCancelados.criarTabelaItens({ filtros })
    })
}