window.PerfilCotacoes = window.PerfilCotacoes || {}

PerfilCotacoes.preencherFiltrosPerfilCompras = async function () {
  $.LoadingOverlay('show')
  try {
    const dados = await PerfilCotacoes.buscarFiltrosPerfilCompras()

    if (!dados) {
      msgErro(
        'Perfil de compras não cadastrado para o usuário logado, impossível continuar.',
        () => window.history.back(),
        () => window.history.back(),
      )
      return false
    }

    if (dados.centrosCusto) {
      dados.centrosCusto.forEach((item) => adicionaValorPadraoVarios('centroCusto', item?.codigo, item?.descricao))
      $('#txtCentroCusto').prop('disabled', true)
      $('#btnCentroCusto').prop('disabled', true)
      $('#btnLimpaCentroCusto').prop('disabled', true)
    }
    if (dados.tipos) {
      dados.tipos.forEach((item) => adicionaValorPadraoVarios('tipo', item?.codigo, item?.descricao))
      $('#txtTipo').prop('disabled', true)
      $('#btnTipo').prop('disabled', true)
      $('#btnLimpaTipo').prop('disabled', true)
    }
    if (dados.gruposMaterial) {
      dados.gruposMaterial.forEach((item) => adicionaValorPadraoVarios('grupoMaterial', item?.codigo, item?.descricao))
      $('#txtGrupoMaterial').prop('disabled', true)
      $('#btnGrupoMaterial').prop('disabled', true)
      $('#btnLimpaGrupoMaterial').prop('disabled', true)
    }
    if (dados.gruposProduto) {
      dados.gruposProduto.forEach((item) => adicionaValorPadraoVarios('grupoProduto', item?.codigo, item?.descricao))
      $('#txtGrupoProduto').prop('disabled', true)
      $('#btnGrupoProduto').prop('disabled', true)
      $('#btnLimpaGrupoProduto').prop('disabled', true)
    }
    if (dados.gruposServico) {
      dados.gruposServico.forEach((item) => adicionaValorPadraoVarios('grupoServico', item?.codigo, item?.descricao))
      $('#txtGrupoServico').prop('disabled', true)
      $('#btnGrupoServico').prop('disabled', true)
      $('#btnLimpaGrupoServico').prop('disabled', true)
    }
    if (dados.subgruposMaterial) {
      dados.subgruposMaterial.forEach((item) => adicionaValorPadraoVarios('subgrupoMaterial', item?.codigo, item?.descricao))
      $('#txtSubgrupoMaterial').prop('disabled', true)
      $('#btnSubgrupoMaterial').prop('disabled', true)
      $('#btnLimpaSubgrupoMaterial').prop('disabled', true)
    }

    return true
  } catch (error) {
    console.error(error)
    msgErro('Não foi possível preencher os filtros do perfil de compras.')
    return false
  } finally {
    $.LoadingOverlay('hide')
  }
}

PerfilCotacoes.buscarFiltrosPerfilCompras = async function () {
  const response = await requisicao(
    'GET',
    `/sisplan/centralcompras/solicitacao/v1/filtrosperfil?`,
    `ID=${getCookie('id_usuario')}`,
    '',
    3600000
  )

  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}

PerfilCotacoes.buscarFiltrosPerfilCompras = async function () {
  const response = await requisicao(
    'GET',
    `/sisplan/centralcompras/cotacao/v1/filtrosperfil?`,
    `ID=${getCookie('id_usuario')}`,
    '',
    3600000
  )

  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}