$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('ordemCompra', true, true, 'Numero')
  componenteFiltro('fornecedor', true, true)
  componenteFiltro('centroCusto', true, true)
  componenteFiltro('tipo', true, true)

  $('#btnConsultar').on('click', function () {
    ComprasDigitadas.idsSelecionados.clear()
    ComprasDigitadas.consultar()
    $('#modalFiltros').modal('hide')
  })

  $('#tabelaItens').on('click', '#btnAlterar', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const dadosEditar = datatableItens?.row($(this)?.parents('tr'))?.data()
    ModalManutencaoCompraCentralCompras.carregarModalManutencao(dadosEditar, 'D')
  })

  $('#tabelaItens').on('click', '#btnItens', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const dados = datatableItens?.row($(this)?.parents('tr'))?.data()
    window.location.href = `${BASE_URI}/itens_compra/ID=${dados?.id ?? 0}&STATUS=D`
  })

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const [data] = $('#tabelaItens').DataTable().rows(linha).data().toArray()
    const { id } = data
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)

    if (!isChecked) {
      ComprasDigitadas.idsSelecionados.delete(id)
      return
    }

    ComprasDigitadas.idsSelecionados.add(id)
  })

  PerfilCompras.preencherFiltrosPerfilCompras().then((result) => {
    if (!result) {
      return
    }
    ComprasDigitadas.consultar()
  })

  $('#btnEfetivar').on('click', () => efetivar())

  const efetivar = async () => {
    try {
      $.LoadingOverlay('show')
      const idsSelecionados = [...ComprasDigitadas.idsSelecionados]
      if (!idsSelecionados) return msgErro('Nenhum registro selecionado.')

      const response = await requisicao("POST", `/sisplan/centralcompras/compra/v1/efetivarvarias?`, '', JSON.stringify({ ids: idsSelecionados }), 3600000)

      const dados = await response.json()

      if (!dados) {
        return
      }

      const { mensagem, resultado } = dados
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      toastr.success("Dados gravados com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 1000,
        fadeOut: 1000,
        onShown() {
          ComprasDigitadas.idsSelecionados.clear()
          if (resultado?.length > 0) {
            resultado.forEach((id) => ComprasDigitadas.idsSelecionados.add(id))
            msgErro('As ordens de compra selecionadas não foram efetivadas pois suas informações não entraram nas condições de nenhum fluxo de aprovação cadastrado. Favor verificar.')
          }
          ComprasDigitadas.consultar()
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      })
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao efetivar as ordens de compra selecionadas.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnLimparFiltros').on('click', function () {
    limparFiltros()
  })

  function limparFiltros() {
    $('#txtNumero').empty().trigger('change')
    $('#txtFornecedor').empty().trigger('change')
    if (!$('#txtTipo').prop('disabled')) {
      $('#txtTipo').empty().trigger('change')
    }
    if (!$('#txtCentroCusto').prop('disabled')) {
      $('#txtCentroCusto').empty().trigger('change')
    }
    $('#txtEmissaoDe').val('1200-01-01')
    $('#txtEmissaoAte').val('2500-12-31')
    $('#txtEntregaDe').val('1200-01-01')
    $('#txtEntregaAte').val('2500-12-31')
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ComprasDigitadas = window.ComprasDigitadas || {}

ComprasDigitadas.idsSelecionados = new Set()

ComprasDigitadas.criarTabelaItens = ({ filtros }) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Alterar" id="btnAlterar">Alterar</button>     ' +
        '    <button class="dropdown-item" type="button" title="Itens" id="btnItens">Itens</button>     ' +
        '</div>'
      )
    },
    {
      data: 'status',
      title: 'Status',
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true, separadorData: '/' })
      }
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render: function (data) {
        return retornarDataISOEmYMD({ dataISO: data, usarUTC: true, reverso: true, separadorData: '/' })
      }
    },
    {
      data: 'fornecedor',
      title: 'Fornecedor',
    },
    {
      data: 'nomeFornecedor',
      title: 'Nome',
    },
    {
      data: 'colecao',
      title: 'Coleção',
    },
    {
      data: 'descricaoColecao',
      title: 'Desc. Coleção',
    },
    {
      data: 'motivo',
      title: 'Motivo',
    },
    {
      data: 'descricaoMotivo',
      title: 'Desc. Motivo',
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Desc. Centro de Custo',
    },
    {
      data: 'tipo',
      title: 'Tipo',
      render: function (data) {
        if (data === 0) {
          return ''
        }

        return data
      }
    },
    {
      data: 'descricaoTipo',
      title: 'Desc. Tipo',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 18,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/compra/v1/digitadas`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          filtros,
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa'),
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
    rowCallback: function (row, data) {
      const ids = [...ComprasDigitadas.idsSelecionados]
      const isChecked = ids?.some(item => item === data.id) ?? false
      $(row).toggleClass('selected', isChecked)
      const checkbox = $(row).find('.checkSel')
      $(checkbox).prop('checked', isChecked)
    },
  })
  ComprasDigitadas.adicionarEventoSelecionarTodos()
  // UtilsCentralCompras.criarContainerBotoes({
  //   tabela: 'tabelaItens',
  // })
  // UtilsCentralCompras.habilitarEsconderColunas({
  //   tabela: 'tabelaItens',
  //   tela: 'itensCompraDigitados',
  // })
  // UtilsCentralCompras.habilitarExportarCsv({
  //   tabela: 'tabelaItens',
  //   status: 'D',
  //   tipo: 'COM',
  // })
}

ComprasDigitadas.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', async function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    if (!isChecked) {
      ComprasDigitadas.idsSelecionados.clear()
      table.draw(false)
      return
    }

    const body = {
      filtros: await ComprasDigitadas.retornarFiltros(),
    }

    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/centralcompras/compra/v1/seltodasdigitadas?`,
      '',
      JSON.stringify(body),
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        if (!resultado) {
          msgErro('Nenhum registro a ser selecionado.')
          return
        }

        resultado.forEach(({ id }) => ComprasDigitadas.idsSelecionados.add(id))
      }
      table.draw(false)
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao selecionar todas as ordens de compra.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
}

ComprasDigitadas.retornarFiltros = async function () {
  const emissaoDe = $('#txtEmissaoDe').val() || '1200-01-01'
  const emissaoAte = $('#txtEmissaoAte').val() || '1200-01-01'
  const entregaDe = $('#txtEntregaDe').val() || '1200-01-01'
  const entregaAte = $('#txtEntregaAte').val() || '1200-01-01'
  const numero = await formataListas($('#txtNumero').val().toString())
  const fornecedor = await formataListas($('#txtFornecedor').val().toString())
  const tipo = await formataListas($('#txtTipo').val().toString(), true)
  const centroCusto = await formataListas($('#txtCentroCusto').val().toString())

  return {
    emissaoDe,
    emissaoAte,
    entregaDe,
    entregaAte,
    numero,
    fornecedor,
    tipo,
    centroCusto,
  }
}

ComprasDigitadas.consultar = function () {
  ComprasDigitadas.retornarFiltros()
    .then((filtros) => {
      ComprasDigitadas.criarTabelaItens({ filtros })
    })
}