function criaTabelaConsumosCaracteristicas(data) {
    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item" title="Alterar" id="btnAlterar">Alterar</button>     ' +
            '    <button type="button" class="dropdown-item" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    }

    if ($.fn.DataTable.isDataTable('#tabelaConsumosCaracteristicas')) {
        $('#tabelaConsumosCaracteristicas').DataTable().destroy();
        $('#tabelaConsumosCaracteristicas').empty();
    }

    const columns = [
        {
            data: 'COD_MAT',
            title: 'Código'
        },
        {
            data: 'DESC_MAT',
            title: 'Descrição'
        },
        {
            data: 'COD_COR',
            title: 'Cor'
        },
        {
            data: 'DESC_COR',
            title: 'Desc. Cor'
        },
        {
            data: 'QTDE',
            title: 'Quantidade'
        },
        {
            data: 'CUSTO',
            title: 'Custo'
        },
        {
            data: 'SETOR',
            title: 'Setor'
        },
        {
            data: 'DESC_SETOR',
            title: 'Desc. Setor'
        },
        {
            data: 'FAIXA',
            title: 'Faixa'
        },
        {
            data: 'DESC_FAIXA',
            title: 'Desc. Faixa'
        },
        {
            data: 'PRECO',
            title: 'Preço'
        },
        {
            data: 'COD_APL',
            title: 'Aplicação'
        },
        {
            data: 'COD_SUB',
            title: 'Subcaracterística'
        },
        {
            data: 'COD_SUBST',
            title: 'Código Subst.'
        },
        {
            data: 'DESC_SUBST',
            title: 'Desc. Subst.'
        },
        {
            data: 'ORDEM_SUBST',
            title: 'Ordem Subst.'
        },
    ]

    $("#tabelaConsumosCaracteristicas").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: true,
        info: false,
        columnDefs: [
            {
                targets: [0],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                }
            }
        ],
        autoWidth: true,
        data,
        columns
    }).draw(false);
}

function habilitaEdicaoConsumosCaracteristica() {
    $('.consumosCaracteristicaControl').prop('disabled', false)
    $('#btnIncluirConsumosCaracteristica').addClass('d-none')
    $('#btnConfirmarConsumosCaracteristica').removeClass('d-none')
    $('#btnDesistirConsumosCaracteristica').removeClass('d-none')
    $('#btnConfirmarSubcaracteristica').prop('disabled', true)
    $('#btnDesistirSubcaracteristica').prop('disabled', true)
}

function desabilitaEdicaoConsumosCaracteristica() {
    $('.consumosCaracteristicaControl').prop('disabled', true)
    $('#btnIncluirConsumosCaracteristica').removeClass('d-none')
    $('#btnConfirmarConsumosCaracteristica').addClass('d-none')
    $('#btnDesistirConsumosCaracteristica').addClass('d-none')
    $('#txtMaterialConsumosCaracteristica').val('')
    $('#txtCorConsumosCaracteristica').val('')
    $('#txtSetorConsumosCaracteristica').val('')
    $('#txtFaixaConsumosCaracteristica').val('')
    $('#txtQuantidadeConsumosCaracteristica').val('')
    $('#txtCustoUniFixoConsumosCaracteristica').val('')
    $('#selectSubstituirConsumosCaracteristica').val('')
    $('#cbPrecoConsumosCaracteristica').prop('checked', false)
    $("#tabelaConsumosCaracteristicas tr").removeClass("selected");
    if ($('#btnConfirmarAplicacoesCaracteristica').hasClass('d-none')) {
        $('#btnConfirmarSubcaracteristica').prop('disabled', false)
        $('#btnDesistirSubcaracteristica').prop('disabled', false)
    }
}

function insereValoresEdicaoConsumosCaracteristica(data) {
    insereValor('#txtMaterialConsumosCaracteristica', data.COD_MAT, data.DESC_MAT)
    insereValor('#txtCorConsumosCaracteristica', data.COD_COR, data.DESC_COR)
    insereValor('#txtSetorConsumosCaracteristica', data.SETOR, data.DESC_SETOR)
    insereValor('#txtFaixaConsumosCaracteristica', data.FAIXA, data.DESC_FAIXA)
    insereValor('#txtQuantidadeConsumosCaracteristica', data.QTDE)
    insereValor('#txtCustoUniFixoConsumosCaracteristica', data.CUSTO)
    $('#cbPrecoConsumosCaracteristica').prop('checked', data.PRECO === 'S')
    $('#selectSubstituirConsumosCaracteristica').val(data.ORDEM_SUBST)
}

function adicionaRegistroConsumosCaracteristica(data) {
    try {
        const datatable = $("#tabelaConsumosCaracteristicas").DataTable()
        const selectedRow = datatable.rows(".selected")
        const datatableData = datatable.rows({ search: 'applied' }).data().toArray()
        const editingRegister = selectedRow.data().toArray()

        if (!editingRegister || editingRegister.length === 0) {
            if (datatableData.find(e => e.COD_MAT === data.COD_MAT && e.COD_COR === data.COD_COR && e.SETOR === data.SETOR)) {
                msgErro('Esse registro já existe, impossível continuar.')
                return
            }

            datatable.row.add(data).draw(false)
        } else {
            const [index] = selectedRow.indexes().toArray()

            datatable.row(index).data(data).draw(false)
        }
        filtraConsumosSubcaracteristicas({ ...data, OPCIONAL: data.COD_SUB })
    } catch (e) {
        console.log(e)
        msgErro('Ocorreu um problema ao inserir/editar o registro, por favor tente novamente.')
    } finally {
        desabilitaEdicaoConsumosCaracteristica()
    }
}

function filtraConsumosSubcaracteristicas({ COD_APL: aplicacao, OPCIONAL: subcaracteristica }) {
    $('#tabelaConsumosCaracteristicas').DataTable().column(11).search(`^${aplicacao.trim()}$|^$`, true, false).column(12).search(`^${subcaracteristica.trim()}$|^$`, true, false).draw(false)
}

function preencheSelectSubstituirConsumosCaracteristica() {
    $('#selectSubstituirConsumosCaracteristica').empty()
    const data = $('#tabelaConsumos').DataTable().data().toArray()
    $('#selectSubstituirConsumosCaracteristica').append(`
        <option class="text-sm" value="" disabled selected data-codigo="" data-descricao=""></option>
    `)
    data.forEach((e) => {
        $('#selectSubstituirConsumosCaracteristica').append(`
            <option class="text-sm" value="${e.ORDEM}" data-codigo="${e.CODIGO}" data-descricao="${e.DESCRICAO}">${e.CODIGO} - ${e.DESCRICAO}</option>
        `)
    })
}

function removeConsumosSubcaracteristicas(data) {
    const { COD_APL: aplicacao, OPCIONAL: subcaracteristica } = data
    const datatableData = $('#tabelaConsumosCaracteristicas').DataTable().data().toArray()
    const dataFiltered = datatableData.filter(e => e.COD_APL !== aplicacao || e.COD_SUB !== subcaracteristica)
    criaTabelaConsumosCaracteristicas(dataFiltered)
}