$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#divCliente',
      popover: {
        title: 'Campo Cliente',
        description: 'Informe o campo cliente para mostrar o resumo dele.',
        position: 'bottom'
      }
    },
    {
      element: '#divBuscaGrupo',
      popover: {
        title: 'Buscar resumo pelo grupo do cliente.',
        description: 'Selecionando essa opção a consulta será realizada pelo grupo do cliente informado.',
        position: 'bottom'
      }
    },
    {
      element: '#btnConsultarCliente',
      popover: {
        title: 'Botão Consultar',
        description: 'Ao clicar nesse botão irá preencher os dados do resumo do cliente.',
        position: 'left'
      }
    },
    {
      element: '#btnImprimirCliente',
      popover: {
        title: 'Botão Imprimir',
        description: 'Ao clicar nesse botão você imprime os dados do resumo do cliente.',
        position: 'left'
      }
    },
    {
      element: "#abaGeral",
      popover: {
        title: "Abas de Consulta",
        description:
          "Ao clicar nessas abas você retorna pesquisa pelas informações do cliente Resumo/Estatística.",
        position: "bottom",
      },
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

   $("#txtAlterarLimiteCredito").maskMoney({
      decimal: ',',
      thousands: '.',
      precision: 2,
      allowZero: true,
      defaultZero: true,
      min: 0,
      max: 99
    });

  await verificaPermissoes('ANALISEFINAN');

  const acessoAbaSerasa = await buscaAcessoAbaSerasa()
  if (acessoAbaSerasa) {
    $('#tabSerasa').removeClass('d-none')
  } else {
    $('#tabSerasa').addClass('d-none')
  }

  /////COLUNAS INVISIVEIS
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.analiseDuplicatas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseDuplicatas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.analisePedidos == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analisePedidos: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.analiseVendas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseVendas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.analiseFaturas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseFaturas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (localStorage.getItem('analiseduplicatas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseDuplicatas: novasColunas }))
        $('#tabelaEstatisticasDuplicatas').DataTable().columns().visible(true);
        $('#tabelaEstatisticasDuplicatas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('analisepedidos') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analisePedidos: novasColunas }))
        $('#tabelaEstatisticasPedidos').DataTable().columns().visible(true);
        $('#tabelaEstatisticasPedidos').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('analisevendas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseVendas: novasColunas }))
        $('#tabelaEstatisticasVendas').DataTable().columns().visible(true);
        $('#tabelaEstatisticasVendas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (localStorage.getItem('analisefaturas') == 'true') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, analiseFaturas: novasColunas }))
        $('#tabelaEstatisticasFaturas').DataTable().columns().visible(true);
        $('#tabelaEstatisticasFaturas').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

      $('#modal-ColunasVisiveis').modal('hide');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (localStorage.getItem('analiseduplicatas') == 'true') {
      $('#tabelaEstatisticasDuplicatas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analiseDuplicatas ?? [], ['NUMERO'])
    } else if (localStorage.getItem('analisepedidos') == 'true') {
      $('#tabelaEstatisticasPedidos').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analisePedidos ?? [], [])
    } else if (localStorage.getItem('analisevendas') == 'true') {
      $('#tabelaEstatisticasVendas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analiseVendas ?? [], [])
    } else if (localStorage.getItem('analisefaturas') == 'true') {
      $('#tabelaEstatisticasFaturas').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.analiseFaturas ?? [], [])
    }
  })

  $('#modal-ColunasVisiveis').on('hide.bs.modal', function () {
    localStorage.removeItem('analiseduplicatas')
    localStorage.removeItem('analisepedidos')
    localStorage.removeItem('analisevendas')
    localStorage.removeItem('analisefiscais')
  })
  /////COLUNAS INVISIVEIS

  let cliente = ''

  const columnsObservacao = [
    { data: "ID", title: 'Id' },
    { data: "OBS", title: 'Observação', width: '600px !important' },
    { data: "MOTIVO", title: 'Motivo', width: '200px' },
    { data: "USUARIO", title: 'Usuário' },
    { data: "DATA", title: 'Dt.Cadastro' },
    { data: "EMP_ID", title: 'EmpId' },
  ]
  const columnsHistoricoReceber = [
    { data: "ID", title: 'Id' },
    { data: "NUMERO", title: 'Número', },
    { data: "DATA", title: 'Data', },
    { data: "USUARIO", title: 'Usuário' },
    { data: "OBS", title: 'Observação' },
  ]
  const columnsObservacaoCliente = [
    { data: "ID", title: 'Id' },
    { data: "ORDEM", title: 'Ordem' },
    { data: "OBSERVACAO", title: 'Observação', width: '600px !important' },
    { data: "MOTIVO", title: 'Motivo', width: '200px' },
    { data: "USUARIO", title: 'Usuário' },
    { data: "DATA", title: 'Dt.Cadastro' },
  ]
  const columnsEmpresasColigadasGrupoCliente = [
    { data: "CODCLI", title: 'Cod. Cliente' },
    { data: "CNPJ", title: 'CNPJ' },
    { data: "NOME", title: 'Nome' },
    { data: "VALOR_CONSUMO_CLIENTE", title: 'Valor Consumo Cliente' },
  ]

  const columnsSocios = [
    {
      data: "CNPJ_PARTICIPANTE",
      title: "CPF/CNPJ",
      render(data) {
        if (!data) return "";

        const cleaned = data.replace(/\D/g, "");

        if (cleaned.length === 11) {
          return cleaned.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        } else if (cleaned.length === 14) {
          return cleaned.replace(
            /(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
            "$1.$2.$3/$4-$5"
          );
        }
        return data;
      },
    },
    { data: "NOME_PARTICIPANTE", title: "Sócio / Acionista" },
    { data: "NACIONALIDADE_PARTICIPANTE", title: "Nacionalidade" },
    { data: "PERCTOTAL_PARTICIPANTE", title: "Total" },
    {
      data: "ENTRADA_PARTICIPANTE",
      title: "Entrada",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    { data: "VONTANTE_PARTICIPANTE", title: "Vontante" },
    {
      data: "ANOTACAO",
      title: "Anotações",
      render(data) {
        if (!data) return ""

        return data == 'S' ? 'Sim' : 'Não'
      }
    },
  ];

  const columnsDiretores = [
    {
      data: "CNPJ_PARTICIPANTE",
      title: "CPF/CNPJ",
      render(data) {
        if (!data) return "";

        const cleaned = data.replace(/\D/g, "");

        if (cleaned.length === 11) {
          return cleaned.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        } else if (cleaned.length === 14) {
          return cleaned.replace(
            /(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
            "$1.$2.$3/$4-$5"
          );
        }
        return data;
      },
    },
    { data: "NOME_PARTICIPANTE", title: "Administração" },
    { data: "CARGO_PARTICIPANTE", title: "Cargo" },
    { data: "NACIONALIDADE_PARTICIPANTE", title: "Nacionalidade" },
    { data: "ESTADOCIVIL_PARTICIPANTE", title: "Estado Civil" },
    {
      data: "ENTRADA_PARTICIPANTE",
      title: "Entrada",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "ANOTACAO",
      title: "Anotações",
      render(data) {
        if (!data) return ""

        return data == 'S' ? 'Sim' : 'Não'
      }
    },
  ];

  const columnsFornecedores = [
    {
      data: "CNPJ_PARTICIPANTE",
      title: "CPF/CNPJ",
      render(data) {
        if (!data) return "";

        const cleaned = data.replace(/\D/g, "");

        if (cleaned.length === 11) {
          return cleaned.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        } else if (cleaned.length === 14) {
          return cleaned.replace(
            /(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
            "$1.$2.$3/$4-$5"
          );
        }
        return data;
      },
    },
    { data: "NOME_PARTICIPANTE", title: "Nome" },
  ];

  const columnsUltimasConsultas = [
    {
      data: "DATA_CONSULTA",
      title: "Data Consulta",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "CNPJ_CONSULTANTE",
      title: "CNPJ Consultante",
      render(data) {
        if (!data) return "";

        const cleaned = data.replace(/\D/g, "");

        if (cleaned.length === 11) {
          return cleaned.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        } else if (cleaned.length === 14) {
          return cleaned.replace(
            /(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/,
            "$1.$2.$3/$4-$5"
          );
        }
        return data;
      },
    },
    { data: "NOME_CONSULTANTE", title: "Razao social Consultante" },
    { data: "QTDECONSULTAS", title: "Qtde" },
  ];

  const columnsHistoricoPagamento = [
    { data: "mesAno", title: "Mês / Ano" },
    { data: "aVista", title: "À vista" },
    { data: "pontual", title: "Pontual" },
    { data: "dias8_15", title: "8 a 15 dias" },
    { data: "dias16_30", title: "16 a 30 dias" },
    { data: "dias31_60", title: "31 a 60 dias" },
    { data: "mais60", title: "+ de 60 dias" },
    { data: "totalMes", title: "Total / Mês" },
  ];

  const columnsQuantidadeTitulos = [
    { data: "aVista", title: "À vista" },
    { data: "pontual", title: "Pontual" },
    { data: "dias8_15", title: "8 - 15" },
    { data: "dias16_30", title: "16 - 30" },
    { data: "dias31_60", title: "31 - 60" },
    { data: "mais60", title: "+60" }
  ];

  const columnsMediaValor = [
    { data: 'totalMes', title: 'Últimos 12 meses' },
    { data: 'pontual', title: 'Pontual' },
    { data: 'dias8_15', title: '8 a 15 dias' },
    { data: 'dias16_30', title: '16 a 30 dias' },
    { data: 'dias31_60', title: '31 a 60 dias' },
    { data: 'mais60', title: '> 60 dias' }
  ];

  const columnsEvolucao = [
    { data: "mesAno", title: "Mês / Ano" },
    { data: "aVencer", title: "À vencer" },
  ];

  const columnsRefNegocios = [
    { data: "tipo", title: "" },
    { data: "ultCompra", title: "Última Compra" },
    { data: "maiorFatura", title: "Maior Fatura" },
    { data: "maiorAcumulo", title: "Maior Acúmulo" },
  ];

  const columnsPefin = [
    {
      data: "DATA_REGISTRO",
      title: "Data",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "VALOR",
      title: "Valor",
      className: 'pr-4 text-right',
      render(data) {
        if (data) {
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });
        } else {
          return ''
        }
      },
    },
    { data: "MODALIDADE", title: "Modalidade" },
    { data: "CONTRATO", title: "Contrato" },
    { data: "ORIGEM", title: "Origem" },
    { data: "AVALISTA", title: "Avalista" },
  ];

  const columnsRefin = [
    {
      data: "DATA_REGISTRO",
      title: "Data",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "VALOR",
      title: "Valor",
      className: 'pr-4 text-right',
      render(data) {
        if (data) {
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });
        } else {
          return ''
        }
      },
    },
    { data: "MODALIDADE", title: "Modalidade" },
    { data: "CONTRATO", title: "Contrato" },
    { data: "ORIGEM", title: "Origem" },
    { data: "AVALISTA", title: "Avalista" },
  ];

  const columnsConvem = [
    {
      data: "DATA_REGISTRO",
      title: "Data",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "VALOR",
      title: "Valor",
      className: 'pr-4 text-right',
      render(data) {
        if (data) {
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });
        } else {
          return ''
        }
      },
    },
    { data: "MODALIDADE", title: "Modalidade" },
    { data: "CONTRATO", title: "Contrato" },
    { data: "ORIGEM", title: "Instituição Cobradora" },
    { data: "CIDADE", title: "Cidade" },
    { data: "UF", title: "UF" },
    { data: "AVALISTA", title: "Avalista" },
  ];

  const columnsProtestos = [
    {
      data: "DATA_REGISTRO",
      title: "Data",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "VALOR",
      title: "Valor",
      className: 'pr-4 text-right',
      render(data) {
        if (data) {
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });
        } else {
          return ''
        }
      },
    },
    { data: "CIDADE", title: "Cidade" },
    { data: "UF", title: "UF" },
    { data: "CARTORIO", title: "Num. Cartório" },
  ];

  const columnsAvaliacoesNegativas1 = [
    { data: 'refin', title: 'REFIN' },
    { data: 'pefin', title: 'PEFIN' },
    { data: 'dividasVencidas', title: 'Dívidas Vencidas' },
    { data: 'falencia', title: 'Falência/Rec. Judicial' }
  ]

  const columnsAvaliacoesNegativas2 = [
    { data: 'judiciais', title: 'Ações Judiciais' },
    { data: 'protestos', title: 'Protestos' },
    { data: 'cheques', title: 'Cheques Sem Fundo' }
  ]

  const columnsDadosEmpresaCapital = [
    { data: 'capital', title: 'Capital Social' },
    { data: 'realizado', title: 'Realizado' }
  ]

  const columnsDadosEmpresa = [
    { data: 'origem', title: 'Origem' },
    { data: 'controle', title: 'Controle' },
    { data: 'natureza', title: 'Natureza' }
  ]

  const columnsResumo = [
    { data: "tipo", title: "Discriminação" },
    { data: "qtde", title: "Qtde" },
    {
      data: "periodo",
      title: "Período",
      type: "date-br",
      render(data) {
        if (!data) return "";
        try {
          const d = new Date(data.split(" ")[0] + "T23:59:59");
          return new Intl.DateTimeFormat("pt-BR").format(d);
        } catch {
          return data;
        }
      },
    },
    {
      data: "valor",
      title: "Valor",
      render(data) {
        if (data) {
          return parseFloat(data).toLocaleString("pt-br", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2,
          });
        } else {
          return ''
        }
      },
    },
    { data: "origem", title: "Origem" },
  ]

  function retornaBotaoOpcoes(id) {
    const retorno = /*html*/`
        <div>
          <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> 
            ${id}  
          </button> 
          <div class="dropdown-menu dropdown" style="z-index:999999999"> 
            <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Visualizar</button>
          </div>
        </div>
  `
    return retorno;
  };

  function retornaBotaoOpcoesDuplicatasEstatisticas(id) {
    const retorno = /*html*/`
        <div>
          <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> 
            ${id}  
          </button> 
          <div class="dropdown-menu dropdown" style="z-index:999999999"> 
            <button class="dropdown-item" type="button" id="btnObservacao">Observação</button>
            <button class="dropdown-item" type="button" id="btnObservacaoSenior">Observação Senior</button>
            <button class="dropdown-item" type="button" id="btnHistoricoReceber">Histórico Receber</button>
            <button class="dropdown-item" type="button" id="btnVisualizar">Visualizar Dados</button>
          </div>
        </div>
  `
    return retorno;
  };

  $('#btnAbrirModalObs').on('click', function () {
    $('#modal_obs').modal('show');
  });

  async function preencheMotivo(motivo) {
    if (motivo !== '') {
      const json = await retornaJsonPesquisaPadrao(`{ "tabela":"MENSAGEM", "camposSelect":["CODMEN", "DESCRICAO"], "where": ["CODMEN = '${motivo}'"] }`);
      if (!json) {
        return;
      }

      if (json.length == 0) {
        return;
      }
      insereValor(`#txtMotivoObs`, json[0].CODMEN, json[0].DESCRICAO);
    }
  }

  $('#tabelaObsCliente').on('click', '#btn-editar', async function () {
    $.LoadingOverlay('show');
    const data = $('#tabelaObsCliente').DataTable().row($(this).parents('tr')).data();
    await preencheMotivo(data.MOTIVO)
    $('#txtNumeroObs').val(data.ID)
    $('#txtObs').val(data.OBSERVACAO)
    $('#txtDataObs').val(formataData(new Date(data.DATA)))
    $('#txtClienteObs').val(data.CODCLI)
    $('#txtUsuarioObs').val(data.USUARIO)
    $('#txtIdObs').val(data.ID)

    $('#txtNumeroObs').prop('disabled', true)
    $('#btnConfirmarObs').prop('disabled', true)
    $('#txtObs').prop('disabled', true)
    $('#txtMotivoObs').prop('disabled', true)
    $('#txtDataObs').prop('disabled', true)
    $('#txtClienteObs').prop('disabled', true)
    $('#txtUsuarioObs').prop('disabled', true)
    $('#txtIdObs').prop('disabled', true)
    $('#btnLimpaMotivoObs').prop('disabled', true)
    $('#btnMotivoObs').prop('disabled', true)

    $('#modal_obs').modal('show');
    $.LoadingOverlay('hide');

  });

  $('#lblLimiteDeCredito').on('click', function () {
      $('#modalAlterarLimiteCredito').modal('show');
  });

  $("#btnConfirmarLimiteCredito").on("click", async function (e) {
    e.preventDefault();
    $.LoadingOverlay("show");
    try {
      const limiteCredito = $('#txtAlterarLimiteCredito').val().replace('.', '');
      const codCli = pegaChave("#txtCliente");
      await alterarLimiteCredito(limiteCredito, codCli);
      criaMensagemSucesso("Limite de crédito alterado com sucesso.");
      $("#modalAlterarLimiteCredito").modal("hide");
      $("#btnConsultarCliente").trigger("click");
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $('#btnFecharObs').on('click', function () {
    $('#modalObservacao').modal('hide');
  })

  $('#btnGravarObs').on('click', function () {

    $('#txtNumeroObs').prop('disabled', true)
    $('#btnConfirmarObs').prop('disabled', false)
    $('#txtObs').prop('disabled', false)
    $('#txtMotivoObs').prop('disabled', false)
    $('#txtDataObs').prop('disabled', false)
    $('#txtClienteObs').prop('disabled', false)
    $('#txtUsuarioObs').prop('disabled', false)
    $('#txtIdObs').prop('disabled', false)
    $('#btnLimpaMotivoObs').prop('disabled', false)
    $('#btnMotivoObs').prop('disabled', false)
    $('#txtObs').val('')
    limpaValor('#txtMotivoObs')
    $('#txtDataObs').val(formataData(new Date()))
    $('#txtClienteObs').val($('#txtCodigo').val())
    $('#txtUsuarioObs').val(sessionStorage.getItem("g_usuario_logado"))
    $('#txtIdObs').val('')

    if ($('#txtCodigo').val() === '') {
      msgAlerta('Informe um cliente para gravar a observação!');
      return;
    }

    $('#modal_obs').modal('show');
  })

  $('#btnConfirmarObs').on('click', async function () {
    try {
      $('#btnConfirmarObs').prop('disabled', true);

      $.LoadingOverlay('show');
      const obj = {
        id: $('#txtIdObs').val(),
        codcli: $('#txtClienteObs').val(),
        data: new Date($('#txtDataObs').val()),
        numero: $('#txtNumeroObs').val(),
        usuario: $('#txtUsuarioObs').val(),
        observacao: $('#txtObs').val(),
        ordem: $.fn.DataTable.isDataTable('#tabelaObsCliente') ? $('#tabelaObsCliente').DataTable().rows().count() + 1 : 1,
        motivo: pegaChave('#txtMotivoObs')
      }
      const resp = await requisicao('POST', '/sisplan/analisefinanceira/v1/observacaocliente?', '', JSON.stringify(obj))

      if (resp.status === 200 || resp.status == 502) {
        if (resp.status == 502) {
          const json = await resp.json();
          await msgAguardaConfirmacao(json.mensagem, () => { }, () => { }, false, true, "Continuar");
        }
        await criaTabelaObs()
        toastr
          .success(`Nova observação cadastrada para o cliente: ${$('#txtClienteObs').val()}!`, "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal_obs').modal('hide');
      $('#btnConfirmarObs').prop('disabled', false);
    }
  })

  async function criaTabelaObs() {
    const pesquisa = {
      camposSelect: ['ID', 'ORDEM', 'CODCLI', 'DATA', 'USUARIO', 'OBSERVACAO', 'MOTIVO'],
      tabela: 'ENTID_OBS',
      where: [`CODCLI = '${$('#txtCodigo').val()}'`],
      orderBy: ['ORDEM DESC']
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if ($.fn.DataTable.isDataTable('#tabelaObsCliente')) {
      $('#tabelaObsCliente').DataTable().clear().draw(false);
      $("#tabelaObsCliente").DataTable().destroy();
      $("#tabelaObsCliente").empty();
    }

    if (jsonStr.length > 0) {

      $('#tabelaObsCliente').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        "data": jsonStr,
        "columns": columnsObservacaoCliente,
        "columnDefs": [
          {
            targets: [0],
            render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 5,
          }
        ]
      });
      $('#tabelaObsCliente').DataTable().columns.adjust().draw(false);
    }
  }

  function criaTabelaEmpresasColigadasGrupoCliente(dados) {
    if (dados.length === 0) {
      if ($.fn.DataTable.isDataTable('#tabelaEmpresasColigadasGrupoCliente')) {
        $('#tabelaEmpresasColigadasGrupoCliente').DataTable().clear().draw(false);
        $("#tabelaEmpresasColigadasGrupoCliente").DataTable().destroy();
        $("#tabelaEmpresasColigadasGrupoCliente").empty();
      }
    } else {

      const data = JSON.parse(dados);

      $('#tabelaEmpresasColigadasGrupoCliente').DataTable({
        paging: true,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        "data": data,
        "columns": columnsEmpresasColigadasGrupoCliente
      });
    }
  }

  $('#tabelaEmpresasColigadasGrupoCliente tbody').on('dblclick', 'tr', async function () {
    const data = $('#tabelaEmpresasColigadasGrupoCliente').DataTable().row($(this)).data();

    insereValor('#txtCliente', data.CODCLI, data.NOME);

    $('#btnConsultarCliente').trigger('click');
    // await consultaDadosAnaliseFinanceira(data.CODCLI)
  })

  async function consultaDadosAnaliseFinanceira(codcli) {
    try {
      $.LoadingOverlay('show');

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/consultaanalisefinanceira?codcli=${codcli}&GRUPO=${$('#cbGrupoClienteResumo').prop('checked') ? 'S' : ''}&`)

      $('#multiCollapseExample1').addClass('show')
      $('#multiCollapseExample2').addClass('show')
      $('#multiCollapseExample3').addClass('show')
      $('#multiCollapseExample4').addClass('show')
      $('#multiCollapseExample5').addClass('show')
      $('#multiCollapseExample6').addClass('show')
      $('#multiCollapseExample7').addClass('show')

      if (resp.status === 200 || resp.status == 502) {
        let jsonStr = await resp.json();
        if (resp.status == 502) {
          await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
          jsonStr = JSON.parse(jsonStr.json)
        }
        preencheValoresCampo(jsonStr.analise[0])
        await criaTabelaObs()
        await consultaSerasaExperian(true)
        await buscaOcorrencias(codcli)
        if (codcli == pegaChave('#txtCliente')) {
          const dados = await buscaReferencias(codcli)
          montaTabelaReferencias(dados)
          await buscaInfoMerc(codcli)
        }
      } else {
        $('#multiCollapseExample1').addClass('hide')
        $('#multiCollapseExample2').addClass('hide')
        $('#multiCollapseExample3').addClass('hide')
        $('#multiCollapseExample4').addClass('hide')
        $('#multiCollapseExample5').addClass('hide')
        $('#multiCollapseExample6').addClass('hide')
        $('#multiCollapseExample7').addClass('hide')
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $("#tabelaEstatisticasDuplicatas").on('click', "#btnObservacaoSenior", async function () {
    try {
      $.LoadingOverlay('show')

      const data = $('#tabelaEstatisticasDuplicatas').DataTable().row($(this).parents('tr')).data();

      await abreModalObservacao(data);

      $('#modalObservacao').modal('show')

    } catch (error) {
      await msgAguardaConfirmacao(error.message, () => { }, () => { }, false, true, "Continuar");
      console.error(error)

    } finally {
      $.LoadingOverlay('hide')
    }
  });

  $("#tabelaEstatisticasDuplicatas").on('click', "#btnVisualizar", async function () {
    $('#ModalVisualizarBaixa').modal('show')
    $('#tabHistorico').trigger('click')
    setTimeout(() => {
      $('#tabBaixas').trigger('click')
    }, 200)
    try {
      $.LoadingOverlay("show");
      let table = $("#tabelaEstatisticasDuplicatas").DataTable();
      let data = table.row($(this).parents("tr")).data();

      carregaTabelaBaixas(data)
      carregaTabelaHistorico(data)
      carregaTabelaAntecipacoes(data)
      carregaTabelaRelacionamentoCheques(data)
      carregaTabelaObservacoes(data)

    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function carregaTabelaBaixas(data) {
    try {
      let nsu = '';
      let codAutorizacao = ''
      let baixas = await buscaBaixas(data.NUMERO);

      $("#tabelaBaixar").DataTable({
        destroy: true,

        autoWidth: true,
        data: baixas,
        columns: [
          {
            data: "NUMERO",
          },
          {
            data: "LANCAMENTO",
          },
          {
            data: "DT_PAGTO",
          },
          {
            data: "VALOR2",
          },
          {
            data: "VALOR_PAGO",
          },
          {
            data: "MOEDA",
          },
          {
            data: "DESC_MOEDA",
          },
          {
            data: "DESCONTO",
          },
          {
            data: "JUROS",
          },
          {
            data: "VAL_DEV",
          },
          {
            data: "DESP_COBRANCA",
          }
        ],
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 2,
          },
          {
            targets: 3,
            visible: false,
          },
        ],
      });

      try {
        let response;
        response = await requisicao(
          "GET",
          "/sisplan/funcoes/v1/pesquisa?",
          `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.CODCLI", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = RECEBER.CODCLI"}], "where": ["RECEBER.NUMERO = '${data.NUMERO}'"]}`,
          null
        );

        if (!response) {
          cliente = "";
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          return;
        }

        cliente = `[${jsonStr.RESULT[0][0].CODCLI}] - ${jsonStr.RESULT[0][0].NOME}`;
      } catch (error) {
        console.error(error);
        cliente = "";
      }

      try {
        let response;
        response = await requisicao(
          "GET",
          "/sisplan/funcoes/v1/pesquisa?",
          `JSON={ "tabela":"RECEBER", "camposSelect":["CARTAO_NSU", "CODIGO_AUTORIZACAO"], "where": ["NUMERO = '${data.NUMERO}'"]}`,
          null
        );

        if (!response) {
          nsu = "";
          codAutorizacao = "";
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          return;
        }

        nsu = `${jsonStr.RESULT[0][0].CARTAO_NSU}`;
        codAutorizacao = `${jsonStr.RESULT[0][0].CODIGO_AUTORIZACAO}`;
      } catch (error) {
        console.error(error);
        nsu = "";
        codAutorizacao = "";
      }

      $("#txtClienteVisual").val(cliente);
      $("#txtDTemissaoVisual").val(data.DT_EMISSAO.slice(0, 10));
      $("#txtNotaFiscalVisual").val(data.FATURA);
      $("#txtSaldoVisual").val(data.SALDO);
      $("#txtValorPagoVisual").val(data.VALOR);
      $("#txtNsuVisual").val(nsu);
      $("#txtBandeiraVisual").val(data.BANDEIRA);
      $("#txtTaxaBandeiraVisual").val(data.TAXA_BANDEIRA);
      $("#txtCodigoAutorizacaoVisual").val(codAutorizacao);
    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaAntecipacoes(data) {
    try {
      const status = data.TIPO_DOC == 'DUPL' || data.TIPO_DOC == 'CHEQ' ? 'ANTE' : 'DUPL'
      const antecipacoes = await buscaAntecipacoes(data.NUMERO, status);

      const columns = [
        {
          data: "DT_PAGTO",
          title: 'Pagto',
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
        },
        { data: "NUMERO", title: 'Número' },
        {
          data: "VALOR_PAGO",
          title: 'Valor Pago',
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          className: 'pr-4 text-right'
        },
        { data: "BANCO", title: 'Banco' },
        { data: "TABELA", title: 'Tabela' },
      ]

      $("#tabelaAntecipacoes").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: antecipacoes,
        columns: columns,
        columnDefs: [],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaRelacionamentoCheques(data) {
    try {
      const relacionamentoCheques = await buscaRelacionamentoCheques(data.NUMERO, data.NUMERO_CH, data.AGENCIA_CH, data.BANCO_CH, data.CONTA_CH);

      const columns = [
        { data: "NUM_AP", title: 'Número' },
        {
          data: "VAL_BAIXADO",
          title: 'Valor Baixado',
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          className: 'pr-4 text-right'
        },
        { data: "EMP_DUPLI", title: 'Empresa' },
        { data: "CODCRE", title: 'Codcre' },
        { data: "NOME", title: 'Nome' },
        { data: "TIPO", title: 'Tipo' },
      ]

      $("#tabelaRelacionamentoCheques").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: relacionamentoCheques,
        columns: columns,
        columnDefs: [],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaHistorico(data) {
    try {
      let historico = await buscaHistorico(data.NUMERO);

      const columns = [
        { data: "ORDEM", title: 'Ordem' },
        { data: "DATA", title: 'Data' },
        { data: "TIPO", title: 'Tipo' },
        { data: "BANCO", title: 'Banco' },
        { data: "CONTA", title: 'Conta' },
        { data: "CARTEIRA", title: 'Carteira' },
        { data: "OCORRENCIA", title: 'Ocorrência' },
        { data: "VALOR", title: 'Valor' },
        { data: "DT_RETORNO", title: 'Data Retorno' }
      ]

      $("#tabelaHistorico").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: historico,
        columns: columns,
        columnDefs: [],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function carregaTabelaObservacoes(data) {
    try {
      let observacoes = await buscaObservacoesTitulo(data.NUMERO);

      $("#tabelaVisualizarObservacoes").DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: false,
        autoWidth: false,
        destroy: true,
        serverSide: false,
        processing: false,
        colReorder: false,
        autoWidth: true,
        data: observacoes,
        columns: columnsObservacao,
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 5,
          }
        ],
      });

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
  }

  async function buscaBaixas(numeroReceber) {
    let url = `/sisplan/Receber/v1/BaixaReceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `numero=${numeroReceber}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      jsonStr = jsonStr.map((retorno) => ({
        ...retorno,
        DT_PAGTO: retorno.DT_PAGTO.slice(0, 10),
      }));
      return jsonStr;
    } catch (error) {
      console.error(error);
      msgAlerta("Não Existem Baixas Cadastradas");
    }
  }

  async function buscaHistorico(numeroReceber) {
    let url = `/sisplan/receber/v1/historicoreceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `NUMERO=${numeroReceber}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      console.error(error);
      msgAlerta("Não Existem Baixas Cadastradas");
    }
  }

  async function buscaAntecipacoes(numeroReceber, status) {
    let url = `/sisplan/receber/v1/antecipacoesreceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `NUMERO=${numeroReceber}&STATUS=${status}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  async function buscaRelacionamentoCheques(numeroReceber, numCheq, AgenCheq, BancoCheq, ContaCheq) {
    let url = `/sisplan/receber/v1/relacionamentochequesreceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `NUMERO=${numeroReceber}&NUM_CH=${numCheq}&AGEN_CH=${AgenCheq}&BANCO_CH=${BancoCheq}&CONTA_CH=${ContaCheq}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      console.error(error);
    }
  }

  $('#btnImprimirBaixasVisual').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      const nBaixas = await pegaValoresModalBaixa();
      let numeros = [];
      for (let i = 0; i < nBaixas.length; i++) {
        numeros.push(nBaixas[i].NUMERO);
      }

      const listaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
      $('#ModalVisualizarBaixa').modal('hide');
    }
  });

  async function pegaValoresModalBaixa() {
    try {
      let table = $("#tabelaBaixar").DataTable();
      let rows = table.rows();
      let valores = [];
      let objeto = {};
      // pegar valor pago
      for (let i = 0; i < rows[0].length; i++) {
        objeto = {
          CODCLI: pegaChave("#txtClienteVisual"),
          NSU: $('#txtNsuVisual').val(),
          SALDO: $("#txtSaldoVisual", objeto.SALDO).val(),
          VALOR: $("#txtValorPagoVisual", objeto.VALOR).val(),
          DT_EMISSAO: `${$("#txtDTEmissaoVisual").val()}`,
          NOTAFISCAL: `${$("#txtNotaFiscalVisual").val()}`,
          NUMERO: rows.data()[i].NUMERO,
          LANCAMENTO: rows.data()[i].LANCAMENTO,
          DT_PAGTO: rows.data()[i].DT_PAGTO,
          VALOR_PAGO: rows.data()[i].VALOR_PAGO,
          MOEDA: rows.data()[i].MOEDA,
          DESC_MOEDA: rows.data()[i].DESC_MOEDA,
          DESCONTO: 0,
          JUROS: rows.data()[i].NUMERO,
        };

        valores.push(objeto);
        objeto = {};
      }

      return valores;

    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  $("#tabelaEstatisticasDuplicatas").on('click', "#btnHistoricoReceber", async function () {
    try {
      $.LoadingOverlay('show')

      const data = $('#tabelaEstatisticasDuplicatas').DataTable().row($(this).parents('tr')).data();

      abreModalHistoricoReceber(data);


      $('#modalHistoricoReceber').modal('show')

    } catch (error) {
      console.error(error)

    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function abreModalObservacao(data) {
    await buscaObservacoesTituloSenior(data.NUMERO, data.TIPO_DOC, data.EMP_PAT)
    const observacao = await buscaObservacoesTitulo(data.NUMERO);
    const ID = (observacao.length + 1)
    $('#txtIdObservacaoReceber').val(ID)
    $('#txtNumeroObservacaoReceber').val(data.NUMERO)
    $('#txtUsuarioObservacaoReceber').val(getCookie('g_usuario_logado'))
    await setarDataAtual("dtCadastroObservacaoReceber")

    if ($.fn.DataTable.isDataTable('#tabelaObservacoesReceber')) {
      $('#tabelaObservacoesReceber').DataTable().destroy();
      $('#tabelaObservacoesReceber').empty();
    }

    $("#tabelaObservacoesReceber").DataTable({
      paging: false,
      filter: false,
      destroy: true,
      ordering: false,
      autoWidth: true,
      data: observacao,
      columns: columnsObservacao,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
          targets: 4,
        }
      ],
    });
  }

  async function buscaObservacoesTitulo(numero) {
    const pesquisa = {
      camposSelect: ['HIST_FINAN.ID', 'HIST_FINAN.NUMERO', 'HIST_FINAN.USUARIO', 'HIST_FINAN.DATA', "(HIST_FINAN.MOTIVO || '-' || MENSAGEM.DESCRICAO) MOTIVO", 'HIST_FINAN.OBS', 'HIST_FINAN.EMP_ID'],
      tabela: 'HIST_FINAN',
      leftJoin: [{ tabela: "MENSAGEM", condicao: "HIST_FINAN.MOTIVO = MENSAGEM.CODMEN" }],
      where: [`HIST_FINAN.NUMERO = '${numero}'`, `HIST_FINAN.TIPO IN ('O', 'M')`],
      orderBy: [`HIST_FINAN.ID DESC`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if (!jsonStr.length) {
      return []
    } else {
      return jsonStr
    }
  }

  async function buscaObservacoesTituloSenior(numero, tipoTitulo, empPatTitulo) {
    const params = `NUMERO_TITULO=${numero}` +
      `&TIPO_TITULO=${tipoTitulo}` +
      `&EMP_ID_TITULO=${empPatTitulo.substring(1, 4)}`;

    const response = await requisicao("GET", `/sisplan/senior/v1/observacaoreceber?`, params, '', 30000);

    if (!response) {
      throw new Error("Não foi possível consultar as observações de título da Senior");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(json.mensagem);
    }
  }

  $("#tabelaEstatisticasDuplicatas").on('click', "#btnObservacao", async function () {
    try {
      $.LoadingOverlay('show')

      const data = $('#tabelaEstatisticasDuplicatas').DataTable().row($(this).parents('tr')).data();
      const index = $('#tabelaEstatisticasDuplicatas').DataTable().row($(this).parents('tr')).index()

      await abreModalObservacaoDuplicata(data, index)

    } catch (error) {
      await msgAguardaConfirmacao(error.message, () => { }, () => { }, false, true, "Continuar");
      console.error(error)

    } finally {
      $.LoadingOverlay('hide')
    }
  });

  function abreModalObservacaoDuplicata(data, indexLinha) {
    $('#txtObservacaoReceber').val(data.OBS)
    $('#txtNumeroObsReceber').val(data.NUMERO)
    $('#txtIndexLinhaTabela').val(indexLinha)

    $('#modal_observacao').modal('show')
  }

  async function buscaHistoricoReceber(numero) {
    const pesquisa = {
      camposSelect: ['HIST_FINAN.ID', 'HIST_FINAN.NUMERO', 'HIST_FINAN.USUARIO', 'HIST_FINAN.DATA', 'HIST_FINAN.OBS', 'HIST_FINAN.EMP_ID'],
      tabela: 'HIST_FINAN',
      leftJoin: [{ tabela: "MENSAGEM", condicao: "HIST_FINAN.MOTIVO = MENSAGEM.CODMEN" }],
      where: [`HIST_FINAN.NUMERO = '${numero}'`],
      orderBy: [`HIST_FINAN.ID DESC`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    if (jsonStr.length > 0) {
      return jsonStr
    }

    return []
  }

  async function abreModalHistoricoReceber(data) {
    const historicos = await buscaHistoricoReceber(data.NUMERO)

    if (historicos.length === 0) {
      msgAlerta('Nenhum histórico encontrado para este título!')
      return
    }

    if ($.fn.DataTable.isDataTable('#tabelaHistoricoReceber')) {
      $('#tabelaHistoricoReceber').DataTable().destroy();
      $('#tabelaHistoricoReceber').empty();
    }


    $("#tabelaHistoricoReceber").DataTable({
      paging: false,
      filter: false,
      destroy: true,
      ordering: true,
      autoWidth: true,
      data: historicos,
      columns: columnsHistoricoReceber,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.split(" ")[0]} 23:59:59`)
            );
          },
          targets: 2,
        }
      ],
    });
  }

  $('#btnConfirmarObsReceber').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const obs = $('#txtObservacaoReceber').val().trim();
      const numero = $('#txtNumeroObsReceber').val().trim();
      const index = parseInt($('#txtIndexLinhaTabela').val());

      await gravaObsReceber({ numero, obs })

      const data = $('#tabelaEstatisticasDuplicatas').DataTable().row(index).data();

      data.OBS = obs;
      data.POSSUI_OBS = obs ? "Sim" : "";

      $('#tabelaEstatisticasDuplicatas').DataTable().row(index).data(data).draw(false);

      const rowNode = $('#tabelaEstatisticasDuplicatas').DataTable().row(index).node();

      if (data.POSSUI_OBS != '') {
        $(rowNode).find('td').eq(5).css({
          'font-weight': 'bold',
          'color': 'green'
        });
      } else {
        $(rowNode).find('td').eq(5).css({
          'font-weight': '',
          'color': ''
        });
      }

      $('#modal_observacao').modal('hide');

    } catch (error) {
      msgAlerta(error)
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function gravaObsReceber(body) {
    let response = await requisicao("POST", `/sisplan/receber/v1/observacaoduplicata?`, '', JSON.stringify(body), 30000);

    if (!response) {
      return
    }

    criaMensagemSucesso('Observação salva com sucesso!')
  }

  $('#btnGravarObservacaoReceber').on('click', async function () {
    try {
      $.LoadingOverlay('show')
      if ($('#txtMotivoObservacaoReceber').val() === '') {
        throw msgAlerta('Necessário informar um motivo, verifique!')
      }
      if ($('#txtAreaObservacaoReceber').val() === '') {
        throw msgAlerta('Necessário informar uma observação, verifique!')
      }
      const body = {
        id: $('#txtIdObservacaoReceber').val(),
        numero: $('#txtNumeroObservacaoReceber').val(),
        usuario: $('#txtUsuarioObservacaoReceber').val(),
        data: $('#dtCadastroObservacaoReceber').val(),
        motivo: pegaChave('#txtMotivoObservacaoReceber'),
        tipo: 'O',
        observacao: $('#txtAreaObservacaoReceber').val(),
      }

      let response = await requisicao("POST", `/sisplan/receber/v1/observacao?`, '', JSON.stringify(body), 30000);

      if (!response) {
        return
      }

      const observacao = await buscaObservacoesTitulo($('#txtNumeroObservacaoReceber').val())
      $("#tabelaObservacoesReceber").DataTable({
        paging: false,
        filter: false,
        destroy: true,
        autoWidth: true,
        data: observacao,
        columns: columnsObservacao,
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 5,
          }
        ],
      });

      toastr
        .success(`Nova observação cadastrada para o título: ${$('#txtNumeroObservacaoReceber').val()}!`, "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      await limpaCamposModalObs()

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  })


  async function limpaCamposModalObs() {
    await setarDataAtual("dtObservacaoCadastro");
    $('#txtMotivoObservacaoReceber').val('')
    $('#txtAreaObservacaoReceber').val('')
  }

  function preencheValoresCampo(data) {
    // Dados do Cliente
    $('#txtCodigo').val(data.codcli);
    $('#txtInscricao').val(data.inscricao);
    $('#txtCNPJ').val(data.cnpj);
    $('#txtRazaoSocial').val(`${data.nome}`);
    $('#txtFantasia').val(data.fantasia);
    $('#txtRepresentante').val(`${data.codrep} - ${data.nomeRep}`);
    $('#txtEmail').val(data.email);
    $('#txtEndereco').val(data.endereco);
    $('#txtBairro').val(data.bairro);
    $('#txtNumero').val(data.numero);
    $('#txtRamoAtividade').val(data.ramoAtividade);
    $('#txtCidade').val(data.cidade);
    $('#txtUf').val(data.uF);
    $('#txtPais').val(data.pais);
    $('#txtSig').val(data.siglaPais);
    $('#txtTelefone').val(`(${data.ddd_fone}) - ${data.telefone}`);
    $('#txtFax').val(`${data.dddFax}`);
    $('#txtGrupo').val(`${data.grupo}`);
    $('#txtCadastro').val(data.dataCad.split('T')[0]);
    $('#txtFundacao').val(data.dataFund.split('T')[0]);
    $('#txtClassificacao').val(data.classifica);
    $('#txtSituacaoComercial').val(data.situacaoComercial);
    $('#txtLimiteGrupo').val(data.limiteGrupo);
    $('#txtDataValidadeLimite').val(data.dtValidaLimite.split('T')[0]);

    // Dados Comercial
    $('#txtNumeroUltimoPedido').val(data.numeroUltimoPedido);
    $('#txtValorUltimoPedido').val(formataValor(TruncaDecimaisNova(2, data.valorUltimoPedido)));
    $('#txtDataUltimoPedido').val(data.dataUltimoPedido.split('T')[0]);
    $('#txtNumeroUltimaVenda').val(data.numeroUltimaVenda);
    $('#txtValorUltimaVenda').val(formataValor(TruncaDecimaisNova(2, data.valorUltimaVenda)));
    $('#txtDataUltimaVenda').val(data.dataUltimaVenda.split('T')[0]);
    $('#txtSerieUltimaNFE').val(data.serieUltimaNFE);
    $('#txtValorUltimaNFE').val(formataValor(TruncaDecimaisNova(2, data.valorUltimaNFE)));
    $('#txtDataUltimaNFE').val(data.dataUltimaNFE.split('T')[0]);
    $('#txtValorMaiorFaturaNFE').val(formataValor(TruncaDecimaisNova(2, data.valorMaiorFaturaNFE)));
    $('#txtDataMaiorFaturaNFE').val(data.dataMaiorFaturaNFE.split('T')[0]);
    $('#txtSerieUltimaNFCE').val(data.serieUltimaNFCE);
    $('#txtValorUltimaNFCE').val(formataValor(TruncaDecimaisNova(2, data.valorUltimaNFCE)));
    $('#txtDataUltimaNFCE').val(data.dataUltimaNFCE.split('T')[0]);
    $('#txtValorMaiorFaturaNFCE').val(formataValor(TruncaDecimaisNova(2, data.valorMaiorFaturaNFCE)));
    $('#txtDataMaiorFaturaNFCE').val(data.dataMaiorFaturaNFCE.split('T')[0]);
    $('#txtValorMaiorAcumulo').val(formataValor(TruncaDecimaisNova(2, data.valorMaiorAcumulo)));
    $('#txtDataMaiorAcumulo').val(data.dataMaiorAcumulo.split('T')[0]);

    // Dados Financeiro
    // 1° coluna
    $('#txtAtrasoMedio').val(data.mediaAtraso);
    $('#txtDiasEmAtraso').val(TruncaDecimaisNova(0, data.diasAtraso));
    $('#txtDupEmAberto').val(formataValor(TruncaDecimaisNova(2, data.emAberto)));
    $('#txtDupEmAtraso').val(formataValor(TruncaDecimaisNova(2, data.emAtraso)));
    $('#txtAntecipacaoDevolucao').val(formataValor(TruncaDecimaisNova(2, data.antecipacaoDevolucao)));
    $('#txtTotalEmAberto').val(formataValor(TruncaDecimaisNova(2, data.emAberto)));
    $('#txtSituacaoCobranca').val(data.infCobranca); // falta
    $('#txtDataSituacaoCobranca').val(data.dtAnalise.split('T')[0]); // falta
    $('#txtDataProximaCobranca').val(data.dtPrev_analise.split('T')[0]); // falta

    if (data.historicos) {
      data.historicos.forEach((element, i) => {
        $(`#txtHistorico-${i}`).val(element);
      });
    }

    // 2° coluna

    $('#txtDuplicataPedidoVista').val(formataValor(TruncaDecimaisNova(2, data.dupPedAvista)));
    $('#txtVistaVencida').val(formataValor(TruncaDecimaisNova(2, data.avistaVencida)));
    $('#txtJuros').val(formataValor(TruncaDecimaisNova(2, data.juros))); // falta
    $('#txtPedidosEmAberto').val(formataValor(TruncaDecimaisNova(2, data.pedPend)));
    $('#txtSituacaoCredito').val(data.limiteSuspenso);
    $('#txtLimiteDeCredito').val(formataValor(TruncaDecimaisNova(2, data.credito)));
    $('#txtTitulosReceber').val(formataValor(TruncaDecimaisNova(2, data.titulos)));
    $('#txtTotalPedidosTitulos').val(formataValor(TruncaDecimaisNova(2, data.totalPedidosTitulos)));
    $('#txtSaldoLimiteCredito').val(formataValor(TruncaDecimaisNova(2, data.saldoLimiteCredito)));
    $('#txtSaldoLimiteGrupo').val(data.saldoLimiteGrupo); // falta
    $('#txtTotalPago').val(formataValor(TruncaDecimaisNova(2, data.valPagoPed)));
    $('#txtTotalDevolvido').val(formataValor(TruncaDecimaisNova(2, data.valDevPed)));
    $('#txtTotalFaturado').val(formataValor(TruncaDecimaisNova(2, data.valTotalFaturado)));
    $('#txtTotalReceber').val(formataValor(TruncaDecimaisNova(2, data.totalReceber)));

    //  3° coluna dados financeiro
    $('#txtUltimoParecer').val(data.ultimoParecer); // falta
    $('#txtSituacaoParecer').val(data.situacaoParecer); // fata
    $('#txtUltimaCompra').val(data.ultPedido.split('T')[0]); // falta
    $('#txtUltimaFatura').val(data.ultFatura.split('T')[0]); // falta
    $('#txtSintegra').val(data.sintegra); // falta
    $('#txtUltimaConsSerasa').val(data.ultCons.split('T')[0]);
    $('#txtUltimaAtualizacaoLimite').val(data.dtUltAtuaLimite.split('T')[0]); // falta
    $('#txtValidadeLimiteCredito').val(data.dtValidaLimiteCli.split('T')[0]);

    $('#txtPeriodoBaseDe').val(data.dtPeriodoDe.split('T')[0]);
    $('#txtPeriodoBaseAte').val(data.dtPeriodoAte.split('T')[0]);

    $('#cbAtivo').prop('checked', data.ativo === 'S');
    $('#cbBloqueado').prop('checked', data.bloqueado === 'S');

    criaTabelaEmpresasColigadasGrupoCliente(data.grupoColigados)

    $('#tabelaEmpresasColigadasGrupoCliente').DataTable().columns.adjust().draw(false);
  }
  function criaTabelaEstatisticasPedidos(dados) {
    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasPedidos')) {
      $('#tabelaEstatisticasPedidos').DataTable().clear().draw(false);
      $("#tabelaEstatisticasPedidos").DataTable().destroy();
      $("#tabelaEstatisticasPedidos").empty();
    }

    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasPedidos').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [2, 3],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [7, 9, 10, 22, 23, 24],
        },
        {
          className: 'pr-4 text-right',
          targets: [1, 4, 5, 6]
        },
        {
          render: function (data) {
            if (data.indexOf('/') == -1) {
              return data.match(/.{1,3}/g).join('/').replaceAll(' ', '')
            } else {
              return data
            }
          },
          targets: [11],
        },
      ],
    });

    $('#tabelaEstatisticasPedidos_length').prepend('<button class="buttonColVis" id="buttonColVisPedidos"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasPedidos_length').prepend('<button class="buttonExcel" id="buttonExcelPedidos"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisPedidos').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelPedidos').prop('title', 'Exportar')

    $('#buttonColVisPedidos').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analisepedidos', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelPedidos').on('click', async function () {
      let dados = $("#tabelaEstatisticasPedidos").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Pedidos', '#tabelaEstatisticasPedidos', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasPedidos').DataTable().columns(colunas.analisePedidos ?? []).visible(false);
    $('#tabelaEstatisticasPedidos').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analisePedidos).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function criaTabelaEstatisticasDuplicatas(dados) {

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasDuplicatas')) {
      $('#tabelaEstatisticasDuplicatas').DataTable().clear().draw(false);
      $("#tabelaEstatisticasDuplicatas").DataTable().destroy();
      $("#tabelaEstatisticasDuplicatas").empty();
    }

    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasDuplicatas').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      order: [1],
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          targets: [0],
          render: function (data, type, row) {
            return retornaBotaoOpcoesDuplicatasEstatisticas(data);
          }
        },
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [8, 10, 11],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [12, 13, 14, 15, 16],
        },
        {
          className: 'pr-4 text-right',
          targets: [4, 7]
        },
        {
          visible: false,
          targets: [29]
        },
      ],
      "createdRow": function (row, data) {
        if ((data.VALOR_PAGO < data.VALOR) && (new Date() > new Date(data.DT_VENCTO.split(" ")[0]))) {
          $(row).css('background-color', 'rgba(245, 81, 81, 1)');
        }
        if (data.POSSUI_OBS != '') {
          $('td', row).eq(5).css('font-weight', 'bold');
          $('td', row).eq(5).css('color', 'green');
        }
      }
    });

    $('#tabelaEstatisticasDuplicatas_length').prepend('<button class="buttonColVis" id="buttonColVisDuplicatas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasDuplicatas_length').prepend('<button class="buttonExcel" id="buttonExcelDuplicatas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisDuplicatas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelDuplicatas').prop('title', 'Exportar')

    $('#buttonColVisDuplicatas').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analiseduplicatas', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelDuplicatas').on('click', async function () {
      let dados = $("#tabelaEstatisticasDuplicatas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Duplicatas', '#tabelaEstatisticasDuplicatas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasDuplicatas').DataTable().columns(colunas.analiseDuplicatas ?? []).visible(false);
    $('#tabelaEstatisticasDuplicatas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analiseDuplicatas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }


  function criaTabelaEstatisticasVendas(dados) {
    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasVendas')) {
      $('#tabelaEstatisticasVendas').DataTable().clear().draw(false);
      $("#tabelaEstatisticasVendas").DataTable().destroy();
      $("#tabelaEstatisticasVendas").empty();
    }
    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    $('#tabelaEstatisticasVendas').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      order: [2],
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [5, 8, 10],
        },
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat(
                "pt-BR",
                {
                  year: "numeric",
                  month: "2-digit",
                  day: "2-digit",
                  hour: "numeric",
                  minute: "numeric",
                  second: "numeric"
                })
                .format(new Date(`${data.split(" ")[0]}T${data.split(" ")[1]}`))
                .replace(",", "");
            } else {
              return ''
            }
          },
          targets: [6],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [14],
        },
        {
          className: 'pr-4 text-right',
          targets: [4, 13]
        }
      ],
    });

    $('#tabelaEstatisticasVendas_length').prepend('<button class="buttonColVis" id="buttonColVisVendas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasVendas_length').prepend('<button class="buttonExcel" id="buttonExcelVendas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisVendas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelVendas').prop('title', 'Exportar')

    $('#buttonColVisVendas').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analisevendas', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelVendas').on('click', async function () {
      let dados = $("#tabelaEstatisticasVendas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Vendas', '#tabelaEstatisticasVendas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasVendas').DataTable().columns(colunas.analiseVendas ?? []).visible(false);
    $('#tabelaEstatisticasVendas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analiseVendas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  function criaTabelaEstatisticasFaturas(dados) {
    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasFaturas')) {
      $('#tabelaEstatisticasFaturas').DataTable().clear().draw(false);
      $("#tabelaEstatisticasFaturas").DataTable().destroy();
      $("#tabelaEstatisticasFaturas").empty();
    }
    if (dados.length === 0) {
      msgAlerta('Nenhum registro encontrato com esses filtros')
      return;
    }
    const keys = Object.keys(dados[0]);
    let dataSetCols = [];

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    };

    if (dados) { }

    $('#tabelaEstatisticasFaturas').DataTable({
      info: false,
      destroy: true,
      colReorder: true,
      order: [3],
      "data": dados,
      "columns": dataSetCols,
      "columnDefs": [
        {
          type: "date-br",
          render(data) {
            if (data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            } else {
              return ''
            }
          },
          targets: [14],
        },
        {
          render: function (data) {
            if (data) {
              return parseFloat(data).toLocaleString("pt-br", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2,
              });
            } else {
              return ''
            }
          },
          targets: [11, 12, 13],
        },
        {
          className: 'pr-4 text-right',
          targets: [5, 16]
        }
      ],
    });

    $('#tabelaEstatisticasFaturas_length').prepend('<button class="buttonColVis" id="buttonColVisFaturas"><i class="fas fa-cogs"></i></button>');
    $('#tabelaEstatisticasFaturas_length').prepend('<button class="buttonExcel" id="buttonExcelFaturas"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVisFaturas').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcelFaturas').prop('title', 'Exportar')

    $('#buttonColVisFaturas').on('click', async function () {
      $.LoadingOverlay('show');
      localStorage.setItem('analisefaturas', 'true')
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#buttonExcelFaturas').on('click', async function () {
      let dados = $("#tabelaEstatisticasFaturas").DataTable().data().toArray();
      await exportaCSV("", "", undefined, null, 'Analise Financeira - Faturas', '#tabelaEstatisticasFaturas', '', 999, false, false, dados);
    })

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    $('#tabelaEstatisticasFaturas').DataTable().columns(colunas.analiseFaturas ?? []).visible(false);
    $('#tabelaEstatisticasFaturas').DataTable().columns().every(
      function () {
        if ((colunasInvisiveis.analiseFaturas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      })
  }

  $('#btnConsultarDuplicatas').on('click', async function () {
    try {
      $.LoadingOverlay('show')

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DtVencimentoDe: $('#txtDataVencimentoDuplicatasDe').val(),
        DtVencimentoAte: $('#txtDataVencimentoDuplicatasAte').val(),
        DtEmissaoDe: $('#txtEmissaoDuplicatasDe').val(),
        DtEmissaoAte: $('#txtEmissaoDuplicatasAte').val(),
        DtRecebimentoDe: $('#txtRecebimentoDuplicatasDe').val(),
        Grupo: $('#cbGrupoClienteDuplicatas').prop('checked') ? $('#txtGrupo').val() : '',
        DtRecebimentoAte: $('#txtRecebimentoDuplicatasAte').val(),
        Situacao: $("input[name=radioSituacaoDup]:checked").val(),
        Listar: $("input[name=radioListarDup]:checked").val(),
        CodCli: pegaChave('#txtCliente'),
        OrdemOrdenacao: $('#txtOrdemDuplicatas').val()
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscaduplicatas?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();

        if (jsonStr.length === 0) {
          msgAlerta('Nenhum registro encontrato com esses filtros')
          return;
        }

        criaTabelaEstatisticasDuplicatas(jsonStr);

        const dados = $('#tabelaEstatisticasDuplicatas').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoAFDuplicatas',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Duplicatas',
          colunasAgrupamento: ['TIPO_DOC'],
          colunasValor: ['VALOR_PAGO']
        })
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  function formataValor(numero) {
    return numero.toFixed(2).replace('.', ',').replace(/\d(?=(\d{3})+,)/g, '$&.');
  }

  $('#btnConsultarVendas').on('click', async function () {
    try {
      $.LoadingOverlay('show')

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DataDe: $('#txtDtEmissaoVendaDe').val(),
        DataAte: $('#txtDtEmissaoVendaAte').val(),
        CodCli: pegaChave('#txtCliente'),
        Emitido: $('#cbEmitido').prop('checked'),
        Devolvido: $('#cbDevolvido').prop('checked'),
        Pendente: $('#cbPendente').prop('checked'),
        Grupo: $('#cbGrupoClienteVenda').prop('checked') ? $('#txtGrupo').val() : '',
        Agrupada: $('#cbAgrupada').prop('checked'),
        Canceladas: $('#checkCanceladas').prop('checked') ? '1' : '0'
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscavendas?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();

        if (jsonStr.length === 0) {
          msgAlerta('Nenhum registro encontrato com esses filtros')
          return;
        }

        criaTabelaEstatisticasVendas(jsonStr)

        const dados = $('#tabelaEstatisticasVendas').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoAFVendas',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Vendas',
          colunasAgrupamento: ['STATUS'],
          colunasValor: ['VALOR']
        })
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultarFaturas').on('click', async function () {
    try {
      $.LoadingOverlay('show')

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoFaturaDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoFaturaAte').val(),
        Grupo: $('#cbGrupoClienteFatura').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscafaturas?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();

        if (jsonStr.length === 0) {
          msgAlerta('Nenhum registro encontrato com esses filtros')
          return;
        }

        criaTabelaEstatisticasFaturas(jsonStr)

        const dados = $('#tabelaEstatisticasFaturas').DataTable().data().toArray();
        const legendaImpresso = {
          S: "Impresso",
          N: "Não impresso",
          C: "Cancelado",
          D: "Denegado"
        };
        const dadosFormatados = dados.map(item => ({
          ...item,
          IMPRESSO: legendaImpresso[item.IMPRESSO] || item.IMPRESSO
        }));

        Graficos.criarGrafico({
          container: 'graficoAFFaturas',
          tipo: 'donut',
          dados: dadosFormatados,
          nomeSerie: 'Faturas',
          colunasAgrupamento: ['IMPRESSO'],
          colunasValor: ['VALOR']
        })
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultarPedidos').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      if (pegaChave('#txtCliente') == '') {
        msgAlerta('Informe um cliente para consultar os dados!');
        return;
      }

      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoPedidoDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoPedidoAte').val(),
        DtPrevFaturamentoDe: $('#txtDtPrevFaturamentoPedidoDe').val(),
        DtPrevFaturamentoAte: $('#txtDtPrevFaturamentoPedidoAte').val(),
        Situacao: $("input[name=radioSituacaoPedido]:checked").val(),
        Grupo: $('#cbGrupoClientePedido').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }

      const resp = await requisicao('GET', `/sisplan/analisefinanceira/v1/buscapedidos?FILTROS=${encodeURIComponent(JSON.stringify(filtros))}&`)

      if (resp.status === 200) {
        const jsonStr = await resp.json();

        if (jsonStr.length === 0) {
          msgAlerta('Nenhum registro encontrato com esses filtros')
          return;
        }

        criaTabelaEstatisticasPedidos(jsonStr)

        const dados = $('#tabelaEstatisticasPedidos').DataTable().data().toArray();

        Graficos.criarGrafico({
          container: 'graficoAFPedidos',
          tipo: 'donut',
          dados: dados,
          nomeSerie: 'Pedidos',
          colunasAgrupamento: ['VAL_PEND', 'VAL_CANC', 'VAL_FAT'],
          colunasValor: ['VAL_PEND', 'VAL_CANC', 'VAL_FAT']
        })
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConsultarCliente').on('click', async function () {
    if (pegaChave('#txtCliente') == '') {
      msgAlerta('Informe um cliente para consultar os dados!');
      return;
    }
    cliente = $('#txtCliente').val()
    await consultaDadosAnaliseFinanceira(pegaChave('#txtCliente'));
    $('#modal_consulta').modal('hide')

    $('#txtUltimaConsultaSerasa').autocompleta(1, `JSON={ 
                                                  "tabela":"SERASAANALITICO", 
                                                  "camposSelect":["SERASAANALITICO.USR_CONSULTA CHAVE, SERASAANALITICO.ULTIMA_CONSULTA DESCRICAO"], 
                                                  "innerJoin":[{"tabela": "ENTIDADE", "condicao": "ENTIDADE.ID = SERASAANALITICO.ID_ENT"}], 
                                                  "where": ["ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'"], 
                                                  "groupBy": ["SERASAANALITICO.USR_CONSULTA, SERASAANALITICO.ULTIMA_CONSULTA"] 
                                                  }`);

    $('#btnUltimaConsultaSerasa').pesquisa_array(['#txtUltimaConsultaSerasa'], ['USR_CONSULTA'], ['ULTIMA_CONSULTA'],
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SERASAANALITICO", 
                                          "camposSelect":[ "SERASAANALITICO.USR_CONSULTA, SERASAANALITICO.ULTIMA_CONSULTA" ], 
                                          "innerJoin":[{"tabela": "ENTIDADE", "condicao": "ENTIDADE.ID = SERASAANALITICO.ID_ENT"}], 
                                          "where": ["ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'"], 
                                          "groupBy": ["SERASAANALITICO.USR_CONSULTA, SERASAANALITICO.ULTIMA_CONSULTA"]}`,
      'Pesquisa Ultima Consultas Serasa', 'SERASAANALITICO');
    $('#btn-limpa-UltimaConsultaSerasa').on('click', function () { $('#txtUltimaConsultaSerasa').val('') });
  })

  $('#txtUltimaConsultaSerasa').autocompleta(1, `JSON={ 
                                                  "tabela":"SERASAANALITICO", 
                                                  "camposSelect":["SERASAANALITICO.USR_CONSULTA CHAVE, SERASAANALITICO.ULTIMA_CONSULTA DESCRICAO"], 
                                                  "innerJoin":[{"tabela": "ENTIDADE", "condicao": "ENTIDADE.ID = SERASAANALITICO.ID_ENT"}], 
                                                  "where": ["ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'"], 
                                                  "groupBy": ["SERASAANALITICO.USR_CONSULTA, SERASAANALITICO.ULTIMA_CONSULTA"] 
                                                  }`);
  $('#btnUltimaConsultaSerasa').pesquisa_array(['#txtUltimaConsultaSerasa'], ['USR_CONSULTA'], ['ULTIMA_CONSULTA'],
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SERASAANALITICO", 
                                          "camposSelect":[ "SERASAANALITICO.USR_CONSULTA, SERASAANALITICO.ULTIMA_CONSULTA" ], 
                                          "innerJoin":[{"tabela": "ENTIDADE", "condicao": "ENTIDADE.ID = SERASAANALITICO.ID_ENT"}], 
                                          "where": ["ENTIDADE.CODCLI = '${pegaChave('#txtCliente')}'"], 
                                          "groupBy": ["SERASAANALITICO.USR_CONSULTA, SERASAANALITICO.ULTIMA_CONSULTA"]}`,
    'Pesquisa Ultima Consultas Serasa', 'SERASAANALITICO');
  $('#btn-limpa-UltimaConsultaSerasa').on('click', function () { $('#txtUltimaConsultaSerasa').val('') });

  const sWhere = []

  const selectTxtCliente = {
    tabela: "ENTIDADE",
    camposSelect: ["CODCLI CHAVE", "NOME ||' - '|| CNPJ DESCRICAO", "CNPJ"],
  }

  const selectBtnClienteLoja = {
    tabela: "ENTIDADE",
    camposSelect: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "ENTIDADE.COD_IMPORTADO", "CIDADE.NOME CIDADE", "CADCEP.ESTCEP", "ENTIDADE.GRUPO", "GRUPO_CLI.DESCRICAO DESC_GRUPO"],
    leftJoin: [{
      tabela: "CADCEP",
      condicao: "CADCEP.CEP = ENTIDADE.CEP"
    },
    {
      tabela: "CIDADE",
      condicao: "CIDADE.CODIGO = CADCEP.CODMUN"
    },
    {
      tabela: "GRUPO_CLI",
      condicao: "GRUPO_CLI.CODIGO = ENTIDADE.GRUPO"
    }],
    where: sWhere,
    camposWhereServerSide: ["ENTIDADE.CODCLI", "ENTIDADE.NOME", "ENTIDADE.CNPJ", "ENTIDADE.FANTASIA", "ENTIDADE.COD_IMPORTADO", "CIDADE.NOME", "CADCEP.ESTCEP", "ENTIDADE.GRUPO", "GRUPO_CLI.DESCRICAO"]
  }

  $('#txtMotivoObservacaoReceber').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnMotivoObservacaoReceber').pesquisa('#txtMotivoObservacaoReceber', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnLimpaMotivoObservacaoReceber').on('click', function () { $('#txtMotivoObservacaoReceber').val('') })

  $('#txtMotivoObs').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnMotivoObs').pesquisa('#txtMotivoObs', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnLimpaMotivoObs').on('click', function () { $('#txtMotivoObs').val('') })

  $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
  $('#btnCliente').pesquisa_serverside(
    ['#txtCliente', '#txtCNPJ'],
    ['ENTIDADE.CODCLI', 'ENTIDADE.CNPJ'],
    ['ENTIDADE.NOME', 'ENTIDADE.CNPJ'],
    JSON.stringify(selectBtnClienteLoja),
    'Pesquisa Cliente',
    undefined,
    undefined,
    '',
    'S');

  if (localStorage.getItem('clientesanalisefinanceira')) {
    $('#txtCliente').val(localStorage.getItem('clientesanalisefinanceira'))

    localStorage.removeItem('clientesanalisefinanceira')

    $('#btnConsultarCliente').trigger('click');
  } else {
    $('#btnCliente').trigger('click');
  }

  $('#btn-limpa-cliente').on('click', function () {
    limpaValor('#txtCliente')
  });

  $('#tabEstatisticas, #tabResumo, #tabInfoMerc, #tabSerasa').on('click', function () {
    if ($(this)[0].id == 'tabEstatisticas') {
      $('.clientFields').prop('disabled', true)
    } else {
      $('.clientFields').attr('disabled', false)
      limpaTabelasEstatisticas()
    }
  })

  function limpaTabelasEstatisticas() {


    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasDuplicatas')) {
      const existeDadosEstatisticasDuplicatas = $('#tabelaEstatisticasDuplicatas').DataTable().rows().data().length > 0
      if (existeDadosEstatisticasDuplicatas) {
        $("#tabelaEstatisticasDuplicatas").DataTable().destroy();
        $("#tabelaEstatisticasDuplicatas").empty();
      }
    }

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasPedidos')) {
      const existeDadosEstatisticasPedidos = $('#tabelaEstatisticasPedidos').DataTable().rows().data().length > 0
      if (existeDadosEstatisticasPedidos) {
        $("#tabelaEstatisticasPedidos").DataTable().destroy();
        $("#tabelaEstatisticasPedidos").empty();
      }
    }

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasVendas')) {
      const existeDadosEstatisticasVendas = $('#tabelaEstatisticasVendas').DataTable().rows().data().length > 0
      if (existeDadosEstatisticasVendas) {
        $("#tabelaEstatisticasVendas").DataTable().destroy();
        $("#tabelaEstatisticasVendas").empty();
      }
    }

    if ($.fn.DataTable.isDataTable('#tabelaEstatisticasFaturas')) {
      const existeDadosEstatisticasFaturas = $('#tabelaEstatisticasFaturas').DataTable().rows().data().length > 0
      if (existeDadosEstatisticasFaturas) {
        $("#tabelaEstatisticasFaturas").DataTable().destroy();
        $("#tabelaEstatisticasFaturas").empty();
      }
    }

    Graficos.limpaGrafico(['graficoAFPedidos', 'graficoAFVendas', 'graficoAFFaturas', 'graficoAFDuplicatas']);

  }

  retornaHintRelatorio('btnImprimirCliente', 'RelAnaliseFinanceiraCliente')

  $('#btnImprimirCliente').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimircliente?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraCliente');
      const arquivo = await GeraRelatorio(`${url}codcli=${pegaChave('#txtCliente')}&GRUPO=${$('#cbGrupoClienteResumo').prop('checked') ? 'S' : ''}&`, 'POST', 360000, false, 'RelAnaliseFinanceiraCliente');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirDuplicatas', 'RelAnaliseFinanceiraDuplicatas');
  preencheOrdenacaoTela('RelAnaliseFinanceiraDuplicatas', 'txtOrdemDuplicatas', 'divDuplicatas');

  $('#btnImprimirDuplicatas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirduplicatas?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraDuplicatas');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraDuplicatas&ORDEM_ORDENACAO=${$('#txtOrdemDuplicatas').val()}`;
      const filtros = {
        DtVencimentoDe: $('#txtDataVencimentoDuplicatasDe').val(),
        DtVencimentoAte: $('#txtDataVencimentoDuplicatasAte').val(),
        DtEmissaoDe: $('#txtEmissaoDuplicatasDe').val(),
        DtEmissaoAte: $('#txtEmissaoDuplicatasAte').val(),
        DtRecebimentoDe: $('#txtRecebimentoDuplicatasDe').val(),
        Grupo: $('#cbGrupoClienteDuplicatas').prop('checked') ? $('#txtGrupo').val() : '',
        DtRecebimentoAte: $('#txtRecebimentoDuplicatasAte').val(),
        Situacao: $("input[name=radioSituacaoDup]:checked").val(),
        Listar: $("input[name=radioListarDup]:checked").val(),
        CodCli: pegaChave('#txtCliente'),
        OrdemOrdenacao: $('#txtOrdemDuplicatas').val()
      }
      const arquivo = await GeraRelatorio(`${url}&FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraDuplicatas');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirPedidos', 'RelAnaliseFinanceiraPedidos');
  preencheOrdenacaoTela('RelAnaliseFinanceiraPedidos', 'txtOrdemPedidos', 'divPedidos');

  $('#btnImprimirPedidos').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirpedidos?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraPedidos');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraPedidos&ORDEM_ORDENACAO=${$('#txtOrdemPedidos').val()}`;
      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoPedidoDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoPedidoAte').val(),
        DtPrevFaturamentoDe: $('#txtDtPrevFaturamentoPedidoDe').val(),
        DtPrevFaturamentoAte: $('#txtDtPrevFaturamentoPedidoAte').val(),
        Situacao: $("input[name=radioSituacaoPedido]:checked").val(),
        Grupo: $('#cbGrupoClientePedido').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }
      const arquivo = await GeraRelatorio(`${url}FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraPedidos');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirVendas', 'RelAnaliseFinanceiraVendas');
  preencheOrdenacaoTela('RelAnaliseFinanceiraVendas', 'txtOrdemVendas', 'divVendas');

  $('#btnImprimirVendas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirvendas?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraVendas');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraVendas&ORDEM_ORDENACAO=${$('#txtOrdemVendas').val()}`;
      const filtros = {
        DataDe: $('#txtDtEmissaoVendaDe').val(),
        DataAte: $('#txtDtEmissaoVendaAte').val(),
        CodCli: pegaChave('#txtCliente'),
        Emitido: $('#cbEmitido').prop('checked'),
        Devolvido: $('#cbDevolvido').prop('checked'),
        Pendente: $('#cbPendente').prop('checked'),
        Grupo: $('#cbGrupoClienteVenda').prop('checked') ? $('#txtGrupo').val() : '',
        Agrupada: $('#cbAgrupada').prop('checked'),
        Canceladas: $('#checkCanceladas').prop('checked') ? '1' : '0'
      }
      const arquivo = await GeraRelatorio(`${url}FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraVendas');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  retornaHintRelatorio('btnImprimirFaturas', 'RelAnaliseFinanceiraFaturas');
  preencheOrdenacaoTela('RelAnaliseFinanceiraFaturas', 'txtOrdemFaturas', 'divFaturas');

  $('#btnImprimirFaturas').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const url = `/sisplan/analisefinanceira/v1/imprimirfaturas?`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelAnaliseFinanceiraFaturas');
      const ordem = `&TELA_ORDENACAO=RelAnaliseFinanceiraFaturas&ORDEM_ORDENACAO=${$('#txtOrdemFaturas').val()}`;
      const filtros = {
        DtEmissaoDe: $('#txtDtEmissaoFaturaDe').val(),
        DtEmissaoAte: $('#txtDtEmissaoFaturaAte').val(),
        Grupo: $('#cbGrupoClienteFatura').prop('checked') ? $('#txtGrupo').val() : '',
        CodCli: pegaChave('#txtCliente')
      }
      const arquivo = await GeraRelatorio(`${url}FILTROS=${encodeURIComponent(JSON.stringify(filtros))}${ordem}`, 'POST', 360000, false, 'RelAnaliseFinanceiraFaturas');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  async function buscaOcorrencias(cliente) {
    try {
      $.LoadingOverlay('show');
      try {
        if ($.fn.DataTable.isDataTable('#tabelaHistoricoOcorrencias')) {
          $('#tabelaHistoricoOcorrencias').DataTable().destroy();
          $('#tabelaHistoricoOcorrencias').empty();
        };


        const pesquisa = {
          tabela: "CLI_HISTORICO",
          camposSelect: ["*"
          ],
          where: [
            `1=1 AND CODCLI = '${cliente}'`,
          ],
          orderBy: [
            "NUMERO",
          ]

        };

        const ocorrencias = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        const dataSetCols = [
          {
            data: 'NUMERO',
            title: 'Número'
          },
          {
            data: 'ATIVO',
            title: 'Ativo'
          },
          {
            data: 'DATA',
            title: 'Data'
          },
          {
            data: 'DT_PREV_RETORNO',
            title: 'Previsão de Retorno'
          },
          {
            data: 'USUARIO',
            title: 'Usuário'
          },
          {
            data: 'OBS',
            title: 'Observação'
          },
          {
            data: 'TIPO_HISTORICO',
            title: 'Tipo',
          }
        ];

        $('#tabelaHistoricoOcorrencias').DataTable({
          bPaginate: false,
          destroy: true,
          search: false,
          filter: false,
          lengthChange: false,
          info: true,
          order: false,
          autoWidth: true,
          columns: dataSetCols,
          data: ocorrencias,
          columnDefs: [{
            type: 'date-br',
            targets: [2, 3],
            render(data) {
              if (data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              } else {
                return '';
              }
            }
          }, {
            targets: [-1],
            render(data) {
              if (data === 'F') {
                return 'Financeiro';
              } else if (data === 'C') {
                return 'Comercial';
              } else {
                return 'Geral';
              }
            }
          }]
        });

      } catch (e) {
        console.log(e);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#btnAlteraOcorrencias').on('click', function () {
    $('#modal-ocorrencias').modal('show');
    $('#tituloOcorrencias').html(`Cadastro de Histórico/Ocorrências | ${pegaChave(cliente)} - ${pegaDescricao(cliente)}`);
    $('#txtClienteOcorrencias').val(pegaChave(cliente));
  });

  $('#modal-ocorrencias').on('hide.bs.modal', async function () {
    await buscaOcorrencias(pegaChave(cliente));
  })

  function retornaOpcoes(sChave) {
    return `<div> 
                <button class="btn btn-info btn-sm dropdown-toggle btnOpcoesCliRef" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">${sChave}
                </button> 
                <div class="dropdown-menu">
                <button class="dropdown-item botoesTabela" id="btn-excluir-cliRef">Excluir</button>
                </div>`;
  };

  async function buscaReferencias(cliente) {
    try {
      $.LoadingOverlay('show');
      try {
        const pesquisa = {
          tabela: "ENTIDADEREF",
          camposSelect: ["'' AS SEL", "ENTIDADE_REF.CODCLI, ENTIDADE_REF.NOME"],
          leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.ID = ENTIDADEREF.ID_ENT' },
          { tabela: 'ENTIDADE', Alias: 'ENTIDADE_REF', condicao: 'ENTIDADE_REF.ID = ENTIDADEREF.ID_ENT_REF' }],
          where: [`1=1 AND ENTIDADE.CODCLI = '${cliente}'`],
        };

        return await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      } catch (e) {
        console.log(e);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function montaTabelaReferencias(dados) {
    if ($.fn.DataTable.isDataTable('#tabelaReferencias')) {
      $('#tabelaReferencias').DataTable().destroy();
      $('#tabelaReferencias').empty();
    };

    const dataSetCols = [
      {
        data: 'SEL',
        title: 'Consultar',
        render: function (data, type, row, meta) {
          return '<div class="form-check pl-0">' +
            '<div class="icheck-primary">' +
            `<input style="height:20px" type="checkbox" id="check_col_${meta.col}_row_${meta.row}" class="align-self-center campoCheck"><label for="check_col_${meta.col}_row_${meta.row}"></label>` +
            '</div>' +
            '</div>';
        }

      },
      {
        data: 'CODCLI',
        title: 'CodCli'
      },
      {
        data: 'NOME',
        title: 'Nome'
      },
    ];

    $('#tabelaReferencias').DataTable({
      bPaginate: false,
      destroy: true,
      search: false,
      filter: false,
      lengthChange: false,
      info: true,
      order: false,
      autoWidth: true,
      columns: dataSetCols,
      scrollX: true,
      data: dados,
    });

    $('.campoCheck').on('click', function (e) {
      e.stopPropagation();
      $(this).parents('tr').trigger('click');
    });
  }

  $('#tabelaReferencias').on('click', 'tr', async function () {
    $.LoadingOverlay('show')
    try {
      const $check = $(this).find('.campoCheck');

      const dataLinha = $('#tabelaReferencias').DataTable().row(this).data();

      if ($check.prop('checked')) {
        $check.prop('checked', false);
        $(this).removeClass('selected');
        $('.campoCheck').prop('disabled', false);
        await consultaDadosAnaliseFinanceira(pegaChave('#txtCliente'));
      } else {
        $('.campoCheck').prop('checked', false).prop('disabled', true);
        $('#tabelaReferencias tr').removeClass('selected');
        $check.prop('checked', true).prop('disabled', false);
        selecionarLinhaTabela('#tabelaReferencias', 'campoCheck', this);

        await consultaDadosAnaliseFinanceira(dataLinha.CODCLI);
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  });

  function montaTabelaCliRef(dados) {
    if ($.fn.DataTable.isDataTable('#tabelaCliRef')) {
      $('#tabelaCliRef').DataTable().destroy();
      $('#tabelaCliRef').empty();
    };

    const dataSetCols = [
      {
        data: 'CODCLI',
        title: 'CodCli'
      },
      {
        data: 'NOME',
        title: 'Nome'
      },
    ];

    $('#tabelaCliRef').DataTable({
      bPaginate: false,
      destroy: true,
      search: false,
      filter: false,
      lengthChange: false,
      info: true,
      order: false,
      autoWidth: true,
      columns: dataSetCols,
      data: dados,
      columnDefs: [{
        targets: [0],
        render: function (data, display, row) {
          return retornaOpcoes(data);
        }
      }]
    });
  }

  $('#btnAlteraReferencias').on('click', function () {
    $('#modal-referencias').modal('show');
    $('#tituloReferencias').html(`Referênciar Clientes`);
    $('#txtClienteReferencia').val(pegaChave(cliente));
  });

  $('#modal-referencias').on('show.bs.modal', async function () {
    componenteFiltro('cliente', false, false, 'ClienteRef')
    const dados = await buscaReferencias(pegaChave(cliente));
    montaTabelaCliRef(dados)
  })

  $('#modal-referencias').on('hide.bs.modal', async function () {
    const dados = await buscaReferencias(pegaChave(cliente));
    montaTabelaReferencias(dados)
  })

  $('#btnAdicionarClienteRef').on('click', function () {
    const codcli = pegaChave('#txtClienteRef');
    const nome = pegaDescricao('#txtClienteRef');

    if (codcli != '') {
      const tabela = $('#tabelaCliRef').DataTable();
      const existe = tabela.rows().data().toArray().some(row => row.CODCLI === codcli);
      const clienteIgual = codcli == pegaChave('#txtCliente')

      if (existe) {
        msgAlerta(`Cliente ${codcli} já existe na tabela!`);
      } else if (clienteIgual) {
        msgAlerta("Não é possível referenciar um cliente a ele mesmo!");
      } else {
        tabela.row.add({
          CODCLI: codcli,
          NOME: nome
        }).draw(false);
      }

      $('#txtClienteRef').val('');
    } else {
      msgAlerta('Cliente não informado!');
    }
  });

  $('#tabelaCliRef').on('click', '#btn-excluir-cliRef', async function () {
    $.LoadingOverlay('show');
    try {
      msgAlerta('Deseja realmente excluir a referência deste cliente?', async () => { }, null, async () => {
        $("#tabelaCliRef").DataTable().row($(this).parents("tr")).remove().draw(false)
      })
    } catch (e) {
      console.log(e);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConfirmarClienteRef').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      const referencias = [];

      const data = $('#tabelaCliRef').DataTable().data().toArray();

      for (let i = 0; i < data.length; i++) {
        const codcli = data[i].CODCLI;

        referencias.push({
          CODCLIREF: codcli
        })
      }

      const obj = {
        CODCLI: $('#txtClienteReferencia').val(),
        CLIENTES: referencias
      }

      const url = `/sisplan/cliente/v1/incluireferencia?`;
      const response = await requisicao("POST", url, '', JSON.stringify(obj), 60000);

      if (response.status != 200) {
        const jsonMsg = await response.json();
        msgAlerta(jsonMsg.mensagem);
        return;
      };

      criaMensagemSucesso('Referência inclusa com sucesso!');

      $('#modal-referencias').modal('hide');
    } catch (e) {
      console.log(e);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  async function buscaInfoMerc(codcli) {
    $.LoadingOverlay('show')
    try {
      const url = '/sisplan/analisefinanceira/v1/buscainfomerc?';
      const response = await requisicao('GET', url, `CODCLI=${codcli}`);

      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        montaInfoMerc(resultado)
      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function montaInfoMerc(dados) {
    $('#cbPredioProprio').prop('checked', dados.temPredio)
    $('#cbLibCanal').prop('checked', dados.canalLib)
    $('#txtInstagram').val(dados.instagram)
    $('#txtReferenciaCom').val(dados.refComerc)
    $('#txtQtdeFunc').val(dados.qtdeFunc)
    $('#txtParecer').val(dados.parecerLoja)
  }

  async function gravaInfoMerc() {
    $.LoadingOverlay('show')
    try {
      const obj = {
        CODCLI: pegaChave('#txtCliente'),
        TEMPREDIO: $('#cbPredioProprio').is(':checked') ? 'S' : 'N',
        CANALLIB: $('#cbLibCanal').is(':checked') ? 'S' : 'N',
        INSTAGRAM: $('#txtInstagram').val(),
        REFCOMERC: $('#txtReferenciaCom').val(),
        QTDEFUNC: $('#txtQtdeFunc').val(),
        OBSLOJA: $('#txtParecer').val(),
      }

      const url = `/sisplan/analisefinanceira/v1/incluirinfomerc?`;
      const response = await requisicao("POST", url, '', JSON.stringify(obj), 60000);

      if (response.status != 200) {
        const jsonMsg = await response.json();
        msgAlerta(jsonMsg.mensagem);
        return;
      };

      criaMensagemSucesso('Informação Mercadológica inclusa com sucesso!');
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function setCamposInfoMercDisabled(disabled) {
    $('.inputsInfoMerc').prop('disabled', disabled)

    if (disabled) {
      $('#btnAlterarInfoMerc').removeClass('d-none')
      $('#divBtnAcoesInfoMerc').addClass('d-none')
      $('.abaLink').prop('disabled', false)
      $('.abaLink').attr('title', '');
    } else {
      $('#btnAlterarInfoMerc').addClass('d-none')
      $('#divBtnAcoesInfoMerc').removeClass('d-none')
      $('.abaLink').prop('disabled', true)
      $('.abaLink').attr('title', 'Não é possível alterar entre as abas enquanto houver alterações em andamento');
    }
  }

  $('#btnAlterarInfoMerc').on('click', function () {
    setCamposInfoMercDisabled(false);
  });

  $('#btnAnexos').on('click', async function () {
    await abreModalAnexos(pegaChave('#txtCliente'), pegaDescricao('#txtCliente'), 'ANALISEFINAN');
  });

  $('#btnDesistirInfoMerc').on('click', function () {
    setCamposInfoMercDisabled(true);
  });

  $('#btnConfirmarInfoMerc').on('click', async function () {
    await gravaInfoMerc();
    setCamposInfoMercDisabled(true);
    await buscaInfoMerc(pegaChave('#txtCliente'));
  });

  async function retornaInfoCliente(codcli) {
    try {
      if (codcli) {
        const json = await retornaJsonPesquisaPadrao(`{ "tabela":"ENTIDADE", "camposSelect":["CNPJ", "ID"], "where": ["CODCLI = '${codcli}'"] }`);
        if (!json) {
          return { cnpj: '', id: '' };
        }

        if (json.length == 0) {
          return { cnpj: '', id: '' };
        }

        return { cnpj: json[0].CNPJ, id: json[0].ID }

      }

      return { cnpj: '', id: '' }
    } catch (e) {
      return { cnpj: '', id: '' }
    }
  }

  function escondeCamposSerasa() {
    $('#divEmpresa').addClass('d-none')
    $('#divSocios').addClass('d-none')
    $('#divDiretores').addClass('d-none')
    $('#divUltimasConsultas').addClass('d-none')
    $('#divPrincipaisFornecedores').addClass('d-none')
    $('#divQuantidadeTitulos').addClass('d-none')
    $('#divHistoricoPagamentos').addClass('d-none')
    $('#divAtraso').addClass('d-none')
    $('#divEvolucao').addClass('d-none')
    $('#divRefNegocios').addClass('d-none')
    $('#divNegativas').addClass('d-none')
    $('#divPefin').addClass('d-none')
    $('#divRefin').addClass('d-none')
    $('#divConvem').addClass('d-none')
    $('#divDividasProtestadas').addClass('d-none')
  }

  $('#txtUltimaConsultaSerasa').on('focusout', async function () {
    await consultaSerasaExperian(true)
  })

  async function consultaSerasaExperian(reutilizaDados = false) {
    $.LoadingOverlay('show')
    try {
      escondeCamposSerasa()
      const dadosCliente = await retornaInfoCliente(pegaChave('#txtCliente'))

      if (dadosCliente.cnpj == '') return

      const url = "/sisplan/serasaexperian/v1/consultapj?";
      const params = `&CNPJ=${dadosCliente.cnpj}` +
        `&REUTILIZA_DADOS=${reutilizaDados}` +
        `&ID_ENT=${dadosCliente.id}` +
        `&USR_CONSULTA=${pegaChave('#txtUltimaConsultaSerasa')}` +
        `&ULTIMA_CONSULTA=${pegaDescricao('#txtUltimaConsultaSerasa')}`;

      const response = await requisicao("GET", url, params, "", 120000);

      if (!response) {
        throw new Error("Não foi possível realizar a consulta Serasa Experian.");
      }

      const json = await response.json();

      if (response.status != 200) {
        throw new Error(json.mensagem);
      }

      const dadosEmpresa = json[0]
      const ultimasConsultas = json[1]
      const dadosPagamentos = json[2]
      const dadosNegativos = json[3]

      if (dadosEmpresa.length > 0) {
        preencheDadosEmpresaSerasa(dadosEmpresa[0])
        $('#divEmpresa').removeClass('d-none')

        if (dadosEmpresa.filter((item) => item.TIPOPARTICIPANTE == 'S').length > 0) {
          const socios = dadosEmpresa.filter((item) => item.TIPOPARTICIPANTE == 'S')
          criaTabelaSocios(socios)
          criaTabelaDadosEmpresa(socios[0])
          criaGraficoSocios(socios)
          $('#divSocios').removeClass('d-none')
        }

        if (dadosEmpresa.filter((item) => item.TIPOPARTICIPANTE == 'D').length > 0) {
          criaTabelaDiretores(dadosEmpresa.filter((item) => item.TIPOPARTICIPANTE == 'D'))
          $('#divDiretores').removeClass('d-none')
        }

        if (dadosEmpresa.filter((item) => item.TIPOPARTICIPANTE == 'F').length > 0) {
          criaTabelaFornecedores(dadosEmpresa.filter((item) => item.TIPOPARTICIPANTE == 'F'))
          $('#divPrincipaisFornecedores').removeClass('d-none')
        }
      }

      if (ultimasConsultas.length > 0) {
        if (ultimasConsultas.filter((item) => item.CNPJ_CONSULTANTE != '').length > 0) {
          criaTabelaUltimasConsultas(ultimasConsultas.filter((item) => item.CNPJ_CONSULTANTE != ''))
          criaGraficoConsultaSerasa(ultimasConsultas.filter((item) => item.CNPJ_CONSULTANTE == ''))
          $('#divUltimasConsultas').removeClass('d-none')
        }

      }

      if (dadosPagamentos.length > 0) {
        const dadosMes = ordenarDadosPorMesAnoDesc(dadosPagamentos.filter((item) => item.TIPO == 'MES'));
        const dadosMedia = dadosPagamentos.filter(item => item.TIPO == 'MEDIA');
        const dadosAtraso = ordenarDadosPorMesAnoDesc(dadosPagamentos.filter((item) => item.TIPO == 'ATRASO'));
        const dadosEvolucao = ordenarDadosPorMesAnoDesc(dadosPagamentos.filter((item) => item.TIPO == 'EVOLUCAO'));

        if (dadosMes.length > 0) {
          criaTabelaHistoricoPagamento(dadosMes, dadosMedia)
          $('#divHistoricoPagamentos').removeClass('d-none')
        }

        if (dadosAtraso.length > 0) {
          criaTabelaAtraso(dadosAtraso)
          $('#divAtraso').removeClass('d-none')
        }

        if (dadosEvolucao.length > 0) {
          criaTabelaEvolucao(dadosEvolucao)
          $('#divEvolucao').removeClass('d-none')
        }

        if (dadosPagamentos.filter((item) => item.TIPO == 'QTD_TITULOS').length > 0) {
          criaTabelaQuantidadeTitulos(dadosPagamentos.filter((item) => item.TIPO == 'QTD_TITULOS'))
          $('#divQuantidadeTitulos').removeClass('d-none')
        }

        if (dadosPagamentos.filter((item) => item.TIPO == 'MEDIA_VAL').length > 0) {
          criaTabelaMediaValores(dadosPagamentos.filter((item) => item.TIPO == 'MEDIA_VAL'))
          $('#divMediaValor').removeClass('d-none')
        }

        if (dadosPagamentos.filter((item) => item.TIPO == 'BUSINESS_REF').length > 0) {
          criaTabelaRefNegocios(dadosPagamentos.filter((item) => item.TIPO == 'BUSINESS_REF'))
          $('#divRefNegocios').removeClass('d-none')
        }

      }

      if (dadosNegativos.length > 0) {
        if (dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'PEFIN').length > 0) {
          criaTabelaPefin(dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'PEFIN'))
          $('#divPefin').removeClass('d-none')
        }

        if (dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'REFIN').length > 0) {
          criaTabelaRefin(dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'REFIN'))
          $('#divRefin').removeClass('d-none')
        }

        if (dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'CONVEM').length > 0) {
          criaTabelaConvem(dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'CONVEM'))
          $('#divConvem').removeClass('d-none')
        }

        if (dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'PROTESTOS').length > 0) {
          criaTabelaProtestos(dadosNegativos.filter((item) => item.TIPO_REGISTRO == 'PROTESTOS'))
          $('#divDividasProtestadas').removeClass('d-none')
        }

        if (dadosNegativos.length > 0) {
          criaTabelaAvaliacoesNegativas(dadosNegativos)
          montaValorResumoTabelaAnotacoes(dadosNegativos)
          criaTabelaResumo(dadosNegativos)
          $('#divNegativas').removeClass('d-none')
          $('#divDividasResumo').removeClass('d-none')
        }

      }
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  function ordenarDadosPorMesAnoDesc(dados) {
    const mesesMap = {
      'JAN': 0, 'FEV': 1, 'MAR': 2, 'ABR': 3, 'MAI': 4, 'JUN': 5,
      'JUL': 6, 'AGO': 7, 'SET': 8, 'OUT': 9, 'NOV': 10, 'DEZ': 11
    };

    return dados.sort((a, b) => {
      const [mesA, anoA] = a.MES_ANO.split('/');
      const [mesB, anoB] = b.MES_ANO.split('/');

      const dataA = new Date(2000 + parseInt(anoA), mesesMap[mesA]);
      const dataB = new Date(2000 + parseInt(anoB), mesesMap[mesB]);

      return dataB - dataA;
    });
  }

  $('#btnSerasa').on('click', async function () {
    await consultaSerasaExperian()
  })

  function preencheDadosEmpresaSerasa(dados) {
    Graficos.criarGraficoScore({
      container: 'graficoScore',
      score: parseInt(dados.SCORE || 0),
      title: 'Serasa Score'
    });

    insereValor('#txtUltimaConsultaSerasa', dados.USR_CONSULTA, dados.ULTIMA_CONSULTA)
    $('#txtRazaoSocialSerasa').val(dados.NOME || '');
    $('#txtFantasiaSerasa').val(dados.FANTASIA || '');
    $('#txtCNPJSerasa').val(dados.CNPJ || '');
    $('#txtSituacaoCNPJSerasa').val(dados.SITUACAOCNPJ || '');
    $('#txtEnderecoSerasa').val(dados.ENDERECO || '');
    $('#txtSiteSerasa').val(dados.SITE || '');
    $('#txtOpcaoTributariaSerasa').val(dados.OPCAOTRIBUTARIA || '');
    $('#txtDDDSerasa').val(dados.DDD_FONE || '');
    $('#txtTelefoneSerasa').val(dados.TELEFONE || '');
    $('#txtRamoAtividadeSerasa').val(dados.RAMOATIVIDADE || '');
    $('#txtRegistroSerasa').val(dados.REGISTRO || '');
    $('#txtRegistradoEmSerasa').val(dados.DT_REGISTRO || '');
    $('#txtInscricaoSerasa').val(dados.INSCRICAO || '');
    $('#txtFundacaoSerasa').val(dados.FUNDACAO || '');
    $('#txtNumFuncionariosSerasa').val(dados.QTDE_FUNC || 0);
    $('#txtNIRESerasa').val(dados.NIRE || '');
    $('#txtCodigoSerasa').val(dados.CODIGOSERASA || '');
    $('#txtCNAESerasa').val(dados.CNAE || '');
    $('#txtNumFiliaisSerasa').val(dados.NUMEROFILIAIS || 0);

    $('#txtDescricaoScoreSerasa').val(dados.OBSERVACAOSCORE || '');
    $('#txtProbabilidadeInadimplenciaSerasa').val(`${parseFloat(dados.INADIMPLENCIA) / 100 || 0}%`);
  }

  function criaTabelaSocios(data) {
    if ($.fn.DataTable.isDataTable('#tabelaSocios')) {
      $('#tabelaSocios').DataTable().clear().draw(false);
      $("#tabelaSocios").DataTable().destroy();
      $("#tabelaSocios").empty();
    }

    $('#tabelaSocios').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsSocios
    });
  }

  function criaTabelaDiretores(data) {
    if ($.fn.DataTable.isDataTable('#tabelaDiretores')) {
      $('#tabelaDiretores').DataTable().clear().draw(false);
      $("#tabelaDiretores").DataTable().destroy();
      $("#tabelaDiretores").empty();
    }

    $('#tabelaDiretores').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsDiretores
    });
  }

  function criaTabelaFornecedores(data) {
    if ($.fn.DataTable.isDataTable('#tabelaPrincipaisFornecedores')) {
      $('#tabelaPrincipaisFornecedores').DataTable().clear().draw(false);
      $("#tabelaPrincipaisFornecedores").DataTable().destroy();
      $("#tabelaPrincipaisFornecedores").empty();
    }

    $('#tabelaPrincipaisFornecedores').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsFornecedores
    });
  }

  function criaTabelaUltimasConsultas(data) {
    if ($.fn.DataTable.isDataTable('#tabelaUltimasConsultas')) {
      $('#tabelaUltimasConsultas').DataTable().clear().draw(false);
      $("#tabelaUltimasConsultas").DataTable().destroy();
      $("#tabelaUltimasConsultas").empty();
    }

    $('#tabelaUltimasConsultas').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsUltimasConsultas
    });
  }

  function criaGraficoConsultaSerasa(data) {
    const meses = ["JAN", "FEV", "MAR", "ABR", "MAI", "JUN", "JUL", "AGO", "SET", "OUT", "NOV", "DEZ"];

    const dadosFormatados = data.map(item => {
      const [ano, mes] = item.DATA_CONSULTA.split("-");
      const label = `${meses[parseInt(mes) - 1]}/${ano.slice(2)}`;

      return {
        QTDE: item.QTDECONSULTAS,
        DATA: label
      };
    });

    const dadosOrdenados = ordenarPorAnoMes(dadosFormatados);

    Graficos.criarGrafico({
      container: 'graficoUltimasConsultas',
      tipo: 'column',
      dados: dadosOrdenados,
      nomeSerie: 'Número de Consultas',
      colunasAgrupamento: ['DATA'],
      colunasValor: ['QTDE'],
      ordenacao: dadosOrdenados.map(d => d.DATA),
    });
  }

  const ordenarPorAnoMes = (dados) => {
    const mesesMap = {
      JAN: 1, FEV: 2, MAR: 3, ABR: 4, MAI: 5, JUN: 6,
      JUL: 7, AGO: 8, SET: 9, OUT: 10, NOV: 11, DEZ: 12
    };

    return dados.sort((a, b) => {
      const [mesA, anoA] = a.DATA.split('/');
      const [mesB, anoB] = b.DATA.split('/');

      const anoCompA = parseInt("20" + anoA);
      const anoCompB = parseInt("20" + anoB);

      if (anoCompA !== anoCompB) return anoCompA - anoCompB;

      return mesesMap[mesA] - mesesMap[mesB];
    });
  };

  function formataValorTabelas(valor) {
    return valor > 0 ? formataValor(TruncaDecimaisNova(2, valor)) : '-';
  }

  function montarLinha(v) {
    return v.valor_de > 0 ? `${formataValorTabelas(v.valor_de)} à ${formataValorTabelas(v.valor_ate)} <br> ${v.pct_de}% à ${v.pct_ate}%` : '-';
  }

  function montarLinhaValor(v) {
    return v.valor_de > 0 ? `${formataValorTabelas(v.valor_de)} à ${formataValorTabelas(v.valor_ate)}` : '-';
  }

  function montarLinhaPct(v) {
    return v.valor_de > 0 ? `${v.pct_de}% à ${v.pct_ate}%` : '-';
  }

  function gerarLinhas(dataMes, dataMedia) {
    const agrupado = {};

    dataMes.forEach(item => {
      const mesAno = item.MES_ANO;

      if (!agrupado[mesAno]) {
        agrupado[mesAno] = {};
      }

      agrupado[mesAno][item.PERIODO] = {
        valor_de: item.VALOR_DE,
        valor_ate: item.VALOR_ATE,
        pct_de: item.PCT_DE / 100,
        pct_ate: item.PCT_ATE / 100
      };
    });

    const linhas = Object.entries(agrupado).map(([mesAno, valores]) => ({
      mesAno,
      aVista: valores["A VISTA"] ? montarLinha(valores["A VISTA"]) : "-",
      pontual: valores["PONTUAL"] ? montarLinha(valores["PONTUAL"]) : "-",
      dias8_15: valores["8-15"] ? montarLinha(valores["8-15"]) : "-",
      dias16_30: valores["16-30"] ? montarLinha(valores["16-30"]) : "-",
      dias31_60: valores["31-60"] ? montarLinha(valores["31-60"]) : "-",
      mais60: valores["+60"] ? montarLinha(valores["+60"]) : "-",
      totalMes: valores["TOTAL MES"] ? montarLinhaValor(valores["TOTAL MES"]) : "-",
    }));

    if (dataMedia && dataMedia.length > 0) {
      const mediaValores = {};

      dataMedia.forEach(item => {
        mediaValores[item.PERIODO] = {
          valor_de: item.VALOR_DE,
          valor_ate: item.VALOR_ATE,
          pct_de: item.PCT_DE,
          pct_ate: item.PCT_ATE
        };
      });

      linhas.push({
        mesAno: "Média",
        aVista: mediaValores["A VISTA"] ? montarLinha(mediaValores["A VISTA"]) : "-",
        pontual: mediaValores["PONTUAL"] ? montarLinha(mediaValores["PONTUAL"]) : "-",
        dias8_15: mediaValores["8-15"] ? montarLinha(mediaValores["8-15"]) : "-",
        dias16_30: mediaValores["16-30"] ? montarLinha(mediaValores["16-30"]) : "-",
        dias31_60: mediaValores["31-60"] ? montarLinha(mediaValores["31-60"]) : "-",
        mais60: mediaValores["+60"] ? montarLinha(mediaValores["+60"]) : "-",
        totalMes: mediaValores["TOTAL MES"] ? montarLinhaValor(mediaValores["TOTAL MES"]) : "-",
      });
    }

    return linhas;
  }

  function criaTabelaHistoricoPagamento(dataMes, dataMedia) {
    if ($.fn.DataTable.isDataTable('#tabelaHistoricoPagamentos')) {
      $('#tabelaHistoricoPagamentos').DataTable().clear().draw(false);
      $("#tabelaHistoricoPagamentos").DataTable().destroy();
      $("#tabelaHistoricoPagamentos").empty();
    }

    const dados = gerarLinhas(dataMes, dataMedia);

    $('#tabelaHistoricoPagamentos').DataTable({
      paging: false,
      filter: false,
      info: false,
      lengthChange: false,
      pageLength: 12 + 1,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsHistoricoPagamento
    });
  }

  function gerarLinhaQuantidadeTitulos(data) {
    const valores = {};

    data.forEach(item => {
      valores[item.PERIODO] = {
        valor_de: item.VALOR_DE,
        valor_ate: item.VALOR_ATE,
        pct_de: item.PCT_DE / 100,
        pct_ate: item.PCT_ATE / 100
      };
    });

    return {
      aVista: valores["A VISTA"] ? montarLinha(valores["A VISTA"]) : '-',
      pontual: valores["PONTUAL"] ? montarLinha(valores["PONTUAL"]) : '-',
      dias8_15: valores["8-15"] ? montarLinha(valores["8-15"]) : '-',
      dias16_30: valores["16-30"] ? montarLinha(valores["16-30"]) : '-',
      dias31_60: valores["31-60"] ? montarLinha(valores["31-60"]) : '-',
      mais60: valores["+60"] ? montarLinha(valores["+60"]) : '-',
    };
  }

  function criaTabelaQuantidadeTitulos(data) {
    if ($.fn.DataTable.isDataTable('#tabelaQuantidadeTitulos')) {
      $('#tabelaQuantidadeTitulos').DataTable().clear().draw(false);
      $("#tabelaQuantidadeTitulos").DataTable().destroy();
      $("#tabelaQuantidadeTitulos").empty();
    }

    const dados = [gerarLinhaQuantidadeTitulos(data)];

    $('#tabelaQuantidadeTitulos').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsQuantidadeTitulos
    });
  }

  function gerarLinhaMediaValores(data) {
    const valores = {};

    data.forEach(item => {
      valores[item.PERIODO] = {
        valor_de: item.VALOR_DE,
        valor_ate: item.VALOR_ATE
      };
    });

    return {
      totalMes: valores["TOTAL MES"] ? montarLinhaValor(valores["TOTAL MES"]) : "-",
      pontual: valores["PONTUAL"] ? montarLinhaValor(valores["PONTUAL"]) : "-",
      dias8_15: valores["8-15"] ? montarLinhaValor(valores["8-15"]) : "-",
      dias16_30: valores["16-30"] ? montarLinhaValor(valores["16-30"]) : "-",
      dias31_60: valores["31-60"] ? montarLinhaValor(valores["31-60"]) : "-",
      mais60: valores["+60"] ? montarLinhaValor(valores["+60"]) : "-"
    };
  }


  function criaTabelaMediaValores(data) {
    if ($.fn.DataTable.isDataTable('#tabelaMediaValor')) {
      $('#tabelaMediaValor').DataTable().clear().draw(false);
      $("#tabelaMediaValor").DataTable().destroy();
      $("#tabelaMediaValor").empty();
    }

    const linha = [gerarLinhaMediaValores(data)];

    $('#tabelaMediaValor').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      searching: false,
      data: linha,
      columns: columnsMediaValor
    });
  }

  function gerarLinhaAtraso(data) {
    const linha = {};

    data.forEach(item => {
      if (item.VALOR_DE > 0 && item.VALOR_ATE > 0) {
        linha[item.MES_ANO] = `${item.VALOR_DE} a ${item.VALOR_ATE}`;
      } else {
        linha[item.MES_ANO] = "0 a 0";
      }
    });

    return linha;
  }

  function criaTabelaAtraso(data) {
    if ($.fn.DataTable.isDataTable('#tabelaAtraso')) {
      $('#tabelaAtraso').DataTable().clear().draw(false);
      $("#tabelaAtraso").DataTable().destroy();
      $("#tabelaAtraso").empty();
    }

    const linha = gerarLinhaAtraso(data);

    const meses = [...new Set(data.map(item => item.MES_ANO))];
    const mesesOrdenados = ordenarDadosPorMesAnoDesc(meses.map(mes => ({ MES_ANO: mes }))).map(item => item.MES_ANO);

    const columnsAtraso = mesesOrdenados.map(mes => ({
      data: mes,
      title: mes
    }));

    const dados = [linha];

    $('#tabelaAtraso').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsAtraso
    });
  }

  function gerarLinhasEvolucao(data) {
    return data.map(item => {
      return {
        mesAno: item.MES_ANO,
        aVencer: item.VALOR_DE > 0 ?
          `${formataValorTabelas(item.VALOR_DE)} a ${formataValorTabelas(item.VALOR_ATE)}` : '-'
      };
    });
  }

  function criaTabelaEvolucao(data) {
    if ($.fn.DataTable.isDataTable('#tabelaEvolucao')) {
      $('#tabelaEvolucao').DataTable().clear().draw(false);
      $("#tabelaEvolucao").DataTable().destroy();
      $("#tabelaEvolucao").empty();
    }

    const dados = gerarLinhasEvolucao(data)
    criaGraficoEvolucao(dados)

    $('#tabelaEvolucao').DataTable({
      paging: false,
      filter: false,
      info: false,
      lengthChange: false,
      pageLength: 12 + 1,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsEvolucao
    });
  }

  function criaGraficoEvolucao(data) {
    const dadosFormatados = data.map(item => {
      let valor = item.aVencer;

      if (valor == "-") {
        valor = 0;
      }
      else if (valor.includes(" a ")) {
        const primeiro = valor.split(" a ")[0];
        valor = parseFloat(primeiro.replace(/\./g, "").replace(",", "."));
      }
      else {
        valor = parseFloat(valor.replace(/\./g, "").replace(",", "."));
      }

      return {
        DATA: item.mesAno,
        QTDE: valor
      };
    });

    const ordenacao = dadosFormatados.map(d => d.DATA).reverse();

    Graficos.criarGrafico({
      container: 'graficoEvolucao',
      tipo: 'column',
      dados: dadosFormatados,
      nomeSerie: 'Valor',
      title: 'Mês / Ano e Valor',
      colunasAgrupamento: ['DATA'],
      colunasValor: ['QTDE'],
      ordenacao: ordenacao
    });
  }

  function gerarLinhasRefNegocios(data) {
    const valores = {};

    data.forEach(item => {
      valores[item.PERIODO] = {
        mes_ano: item.MES_ANO,
        valor_de: item.VALOR_DE,
        valor_ate: item.VALOR_ATE,
        pct_de: item.PCT_DE / 100,
        pct_ate: item.PCT_ATE / 100
      };
    });

    return [
      {
        tipo: "Data",
        ultCompra: valores["ULTIMA COMPRA"]?.mes_ano || "-",
        maiorFatura: valores["MAIOR FATURA"]?.mes_ano || "-",
        maiorAcumulo: valores["MAIOR ACUMULO"]?.mes_ano || "-"
      },
      {
        tipo: "Valor",
        ultCompra: valores["ULTIMA COMPRA"] ? montarLinhaValor(valores["ULTIMA COMPRA"]) : "-",
        maiorFatura: valores["MAIOR FATURA"] ? montarLinhaValor(valores["MAIOR FATURA"]) : "-",
        maiorAcumulo: valores["MAIOR ACUMULO"] ? montarLinhaValor(valores["MAIOR ACUMULO"]) : "-"
      },
      {
        tipo: "Média",
        ultCompra: valores["ULTIMA COMPRA"] ? montarLinhaPct(valores["ULTIMA COMPRA"]) : "-",
        maiorFatura: valores["MAIOR FATURA"] ? montarLinhaPct(valores["MAIOR FATURA"]) : "-",
        maiorAcumulo: valores["MAIOR ACUMULO"] ? montarLinhaPct(valores["MAIOR ACUMULO"]) : "-"
      }
    ];
  }

  function criaTabelaRefNegocios(data) {
    if ($.fn.DataTable.isDataTable('#tabelaRefNegocios')) {
      $('#tabelaRefNegocios').DataTable().clear().draw(false);
      $("#tabelaRefNegocios").DataTable().destroy();
      $("#tabelaRefNegocios").empty();
    }

    const dados = gerarLinhasRefNegocios(data);

    $('#tabelaRefNegocios').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsRefNegocios
    });
  }

  function criaTabelaPefin(data) {
    if ($.fn.DataTable.isDataTable('#tabelaPefin')) {
      $('#tabelaPefin').DataTable().clear().draw(false);
      $("#tabelaPefin").DataTable().destroy();
      $("#tabelaPefin").empty();
    }

    criaGraficoPefin(data)

    $('#tabelaPefin').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsPefin
    });
  }

  function criaGraficoPefin(data) {
    const dadosFormatados = data.map(item => {
      return {
        DATA: item.CONTRATO,
        QTDE: item.VALOR
      };
    });

    Graficos.criarGrafico({
      container: 'graficoPefin',
      tipo: 'pie',
      dados: dadosFormatados,
      nomeSerie: 'Valor',
      title: 'Contrato e Valor',
      colunasAgrupamento: ['DATA'],
      colunasValor: ['QTDE'],
    });
  }

  function criaTabelaRefin(data) {
    if ($.fn.DataTable.isDataTable('#tabelaRefin')) {
      $('#tabelaRefin').DataTable().clear().draw(false);
      $("#tabelaRefin").DataTable().destroy();
      $("#tabelaRefin").empty();
    }

    criaGraficoRefin(data)

    $('#tabelaRefin').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsRefin
    });
  }

  function criaGraficoRefin(data) {
    const dadosFormatados = data.map(item => {
      return {
        DATA: item.CONTRATO,
        QTDE: item.VALOR
      };
    });

    Graficos.criarGrafico({
      container: 'graficoRefin',
      tipo: 'pie',
      dados: dadosFormatados,
      nomeSerie: 'Valor',
      title: 'Contrato e Valor',
      colunasAgrupamento: ['DATA'],
      colunasValor: ['QTDE'],
    });
  }

  function criaTabelaConvem(data) {
    if ($.fn.DataTable.isDataTable('#tabelaConvem')) {
      $('#tabelaConvem').DataTable().clear().draw(false);
      $("#tabelaConvem").DataTable().destroy();
      $("#tabelaConvem").empty();
    }

    criaGraficoConvem(data)

    $('#tabelaConvem').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsConvem
    });
  }

  function criaGraficoConvem(data) {
    const dadosFormatados = data.map(item => {
      return {
        DATA: item.CONTRATO,
        QTDE: item.VALOR
      };
    });

    Graficos.criarGrafico({
      container: 'graficoConvem',
      tipo: 'pie',
      dados: dadosFormatados,
      nomeSerie: 'Valor',
      title: 'Contrato e Valor',
      colunasAgrupamento: ['DATA'],
      colunasValor: ['QTDE'],
    });
  }

  function criaTabelaProtestos(data) {
    if ($.fn.DataTable.isDataTable('#tabelaProtestos')) {
      $('#tabelaProtestos').DataTable().clear().draw(false);
      $("#tabelaProtestos").DataTable().destroy();
      $("#tabelaProtestos").empty();
    }

    criaGraficoProtestos(data)

    $('#tabelaProtestos').DataTable({
      paging: true,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: data,
      columns: columnsProtestos
    });
  }

  function criaGraficoProtestos(data) {
    const dadosFormatados = data.map(item => {
      let dataFormatada = item.DATA_REGISTRO

      if (!dataFormatada) return "";
      try {
        const d = new Date(dataFormatada.split(" ")[0] + "T23:59:59");
        dataFormatada = new Intl.DateTimeFormat("pt-BR").format(d);
      } catch {
        dataFormatada = dataFormatada;
      }

      return {
        DATA: dataFormatada,
        QTDE: item.VALOR
      };
    });

    Graficos.criarGrafico({
      container: 'graficoProtestos',
      tipo: 'pie',
      dados: dadosFormatados,
      title: 'Data e Valor',
      nomeSerie: 'Valor',
      colunasAgrupamento: ['DATA'],
      colunasValor: ['QTDE'],
    });
  }

  function gerarLinhaAvaliacoesNegativas1(data) {
    const valores = {};

    data.forEach(item => {
      const tipo = item.TIPO_REGISTRO?.toUpperCase() || "";
      if (["PEFIN_SUMMARY", "REFIN_SUMMARY", "CONVEM_SUMMARY", "FALENCIA_SUMMARY"].includes(tipo)) {
        valores[tipo] = {
          quantidade: item.DETALHE_EXTRA || 0,
          valor: item.VALOR || "-"
        };
      }
    });

    return {
      pefin: valores["PEFIN_SUMMARY"]
        ? `${valores["PEFIN_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["PEFIN_SUMMARY"].valor)}</b>`
        : "-",

      refin: valores["REFIN_SUMMARY"]
        ? `${valores["REFIN_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["REFIN_SUMMARY"].valor)}</b>`
        : "-",

      dividasVencidas: valores["CONVEM_SUMMARY"]
        ? `${valores["CONVEM_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["CONVEM_SUMMARY"].valor)}</b>`
        : "-",

      falencia: valores["FALENCIA_SUMMARY"]
        ? `${valores["FALENCIA_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["FALENCIA_SUMMARY"].valor)}</b>`
        : "-",

    };
  }

  function gerarLinhaAvaliacoesNegativas2(data) {
    const valores = {};

    data.forEach(item => {
      const tipo = item.TIPO_REGISTRO?.toUpperCase() || "";
      if (["JUDICIAIS_SUMMARY", "CHEQUE_SUMMARY", "PROTESTOS_SUMMARY"].includes(tipo)) {
        valores[tipo] = {
          quantidade: item.DETALHE_EXTRA || 0,
          valor: item.VALOR || "-"
        };
      }
    });

    return {
      judiciais: valores["JUDICIAIS_SUMMARY"]
        ? `${valores["JUDICIAIS_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["JUDICIAIS_SUMMARY"].valor)}</b>`
        : "-",

      protestos: valores["PROTESTOS_SUMMARY"]
        ? `${valores["PROTESTOS_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["PROTESTOS_SUMMARY"].valor)}</b>`
        : "-",

      cheques: valores["CHEQUE_SUMMARY"]
        ? `${valores["CHEQUE_SUMMARY"].quantidade} registros <br> <b>${formataValorTabelas(valores["CHEQUE_SUMMARY"].valor)}</b>`
        : "-",

    };
  }

  function criaTabelaAvaliacoesNegativas(data) {
    if ($.fn.DataTable.isDataTable('#tabelaAvaliacoesNegativas1')) {
      $('#tabelaAvaliacoesNegativas1').DataTable().clear().draw(false);
      $("#tabelaAvaliacoesNegativas1").DataTable().destroy();
      $("#tabelaAvaliacoesNegativas1").empty();
    }

    if ($.fn.DataTable.isDataTable('#tabelaAvaliacoesNegativas2')) {
      $('#tabelaAvaliacoesNegativas2').DataTable().clear().draw(false);
      $("#tabelaAvaliacoesNegativas2").DataTable().destroy();
      $("#tabelaAvaliacoesNegativas2").empty();
    }

    const dados1 = [gerarLinhaAvaliacoesNegativas1(data)];

    $('#tabelaAvaliacoesNegativas1').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados1,
      columns: columnsAvaliacoesNegativas1
    });

    const dados2 = [gerarLinhaAvaliacoesNegativas2(data)];

    $('#tabelaAvaliacoesNegativas2').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados2,
      columns: columnsAvaliacoesNegativas2
    });
  }

  function gerarResumoAvaliacoesNegativas(data) {
    const tiposMap = {
      "PEFIN_SUMMARY": "pefin",
      "REFIN_SUMMARY": "refin",
      "CONVEM_SUMMARY": "convem",
      "PROTESTOS_SUMMARY": "protestos"
    };

    const resultado = {
      pefin: { total: 0, valor: 0 },
      refin: { total: 0, valor: 0 },
      convem: { total: 0, valor: 0 },
      protestos: { total: 0, valor: 0 }
    };

    data.forEach(item => {
      const tipo = item.TIPO_REGISTRO?.toUpperCase() || "";

      if (tiposMap[tipo]) {
        const chave = tiposMap[tipo];

        resultado[chave].total = item.DETALHE_EXTRA || 0;
        resultado[chave].valor = item.VALOR || 0;
      }
    });

    return resultado;
  }

  function montaValorResumoTabelaAnotacoes(data) {
    const resumo = gerarResumoAvaliacoesNegativas(data);

    $('#totalRegPefin').html(`Total de ocorrências: <b>${resumo?.pefin?.total ?? 0}</b>`);
    $('#totalValorPefin').html(`Total das dívidas: <b>${formataValorTabelas(resumo?.pefin?.valor ?? 0)}</b>`);

    $('#totalRegRefin').html(`Total de ocorrências: <b>${resumo?.refin?.total ?? 0}</b>`);
    $('#totalValorRefin').html(`Total das dívidas: <b>${formataValorTabelas(resumo?.refin?.valor ?? 0)}</b>`);

    $('#totalRegConvem').html(`Total de ocorrências: <b>${resumo?.convem?.total ?? 0}</b>`);
    $('#totalValorConvem').html(`Total das dívidas: <b>${formataValorTabelas(resumo?.convem?.valor ?? 0)}</b>`);

    $('#totalRegProtestos').html(`Total de ocorrências: <b>${resumo?.protestos?.total ?? 0}</b>`);
    $('#totalValorProtestos').html(`Total das dívidas: <b>${formataValorTabelas(resumo?.protestos?.valor ?? 0)}</b>`);
  }

  function gerarLinhaDadosEmpresaCapital(data) {
    return {
      capital: formataValorTabelas(data.CAPITAL),
      realizado: formataValorTabelas(data.REALIZADO)
    };
  }

  function gerarLinhaDadosEmpresa(data) {
    return {
      origem: data.ORIGEM || "-",
      controle: data.CONTROLE || "-",
      natureza: data.NATUREZA || "-"
    };
  }

  function criaTabelaDadosEmpresa(data) {
    if ($.fn.DataTable.isDataTable('#tabelaDadosEmpresaCapital')) {
      $('#tabelaDadosEmpresaCapital').DataTable().clear().draw(false);
      $("#tabelaDadosEmpresaCapital").DataTable().destroy();
      $("#tabelaDadosEmpresaCapital").empty();
    }

    const dadosCapital = [gerarLinhaDadosEmpresaCapital(data)];

    $('#tabelaDadosEmpresaCapital').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dadosCapital,
      columns: columnsDadosEmpresaCapital
    });

    if ($.fn.DataTable.isDataTable('#tabelaDadosEmpresa')) {
      $('#tabelaDadosEmpresa').DataTable().clear().draw(false);
      $("#tabelaDadosEmpresa").DataTable().destroy();
      $("#tabelaDadosEmpresa").empty();
    }

    const dados = [gerarLinhaDadosEmpresa(data)];

    $('#tabelaDadosEmpresa').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsDadosEmpresa
    });
  }

  function criaGraficoSocios(data) {
    const dadosFormatados = data.map(item => {
      return {
        NOME: item.NOME_PARTICIPANTE || "",
        TOTAL: item.PERCTOTAL_PARTICIPANTE ?? 0
      };
    });

    Graficos.criarGrafico({
      container: "graficoSocios",
      tipo: "pie",
      dados: dadosFormatados,
      nomeSerie: "Total",
      colunasAgrupamento: ["NOME"],
      colunasValor: ["TOTAL"]
    });
  }

  function gerarResumoNegativos(dados) {
    const grupos = {};

    dados.forEach(item => {
      const tipo = item.TIPO_REGISTRO.replace("_SUMMARY", "");

      if (!grupos[tipo]) grupos[tipo] = { qtde: 0, registros: [] };

      if (item.TIPO_REGISTRO.endsWith("_SUMMARY")) {
        grupos[tipo].qtde = parseFloat(item.DETALHE_EXTRA) || 0;
      } else {
        grupos[tipo].registros.push(item);
      }
    });

    const resultado = [];

    for (const tipo in grupos) {

      const info = grupos[tipo];
      let maisRecente = null;

      info.registros.forEach(reg => {
        if (!maisRecente || new Date(reg.DATA_REGISTRO) > new Date(maisRecente.DATA_REGISTRO)) {
          maisRecente = reg;
        }
      });

      let tipoRetorno = tipo

      switch (tipoRetorno) {
        case 'CONVEM':
          tipoRetorno = 'DIVIDAS VENCIDAS';
          break;
        case 'REFIN':
          tipoRetorno = 'RESTRICOES FINANCEIRAS';
          break;
        case 'PEFIN':
          tipoRetorno = 'DIVIDAS COMERCIAIS';
          break;
        case 'PROTESTOS':
          tipoRetorno = 'DIVIDAS PROTESTADAS';
          break;
        default:
          break;
      }

      resultado.push({
        tipo: tipoRetorno,
        qtde: info.qtde || "-",
        periodo: maisRecente?.DATA_REGISTRO ?? "-",
        valor: maisRecente?.VALOR ?? "-",
        origem: maisRecente?.ORIGEM ?? "-"
      });
    }

    return resultado;
  }

  function criaTabelaResumo(data) {
    if ($.fn.DataTable.isDataTable('#tabelaResumo')) {
      $('#tabelaResumo').DataTable().clear().draw(false);
      $("#tabelaResumo").DataTable().destroy();
      $("#tabelaResumo").empty();
    }

    const dados = gerarResumoNegativos(data);

    $('#tabelaResumo').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      search: false,
      data: dados,
      columns: columnsResumo
    });
  }

  async function buscaAcessoAbaSerasa() {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela":"ACESSO_USUARIOS", "camposSelect":["CONSULTA_SERASA"], "where": ["CODIGO = '${getCookie('cod_usuario')}'"] }`);
    if (!json) {
      return false;
    }

    if (json.length == 0) {
      return false;
    }
    return json[0].CONSULTA_SERASA == 'S'
  }

  async function alterarLimiteCredito(limiteCredito, codCli) {
    const url = "/sisplan/cliente/v1/alterarlimitecredito?";
    const params = `LIMITE_CREDITO=${limiteCredito}`+
                   `&CODCLI=${codCli}`;
    
    const response = await requisicao("POST", url, params, "", 60000);
  
    if (!response) {
      throw new Error("Não foi possível atualizar o limite de crédito.");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(json.mensagem);
    }

  }

});
